/*
 * Decompiled with CFR 0.152.
 */
package com.stellarity.bamboo.repository;

import com.atlassian.bamboo.build.BuildLoggerManager;
import com.atlassian.bamboo.build.fileserver.BuildDirectoryManager;
import com.atlassian.bamboo.commit.CommitContext;
import com.atlassian.bamboo.commit.CommitContextImpl;
import com.atlassian.bamboo.commit.CommitFileImpl;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.branch.VcsBranch;
import com.atlassian.bamboo.plan.branch.VcsBranchImpl;
import com.atlassian.bamboo.repository.AbstractStandaloneRepository;
import com.atlassian.bamboo.repository.BranchDetectionCapableRepository;
import com.atlassian.bamboo.repository.CacheId;
import com.atlassian.bamboo.repository.CachingAwareRepository;
import com.atlassian.bamboo.repository.CustomVariableProviderRepository;
import com.atlassian.bamboo.repository.DeploymentAwareRepository;
import com.atlassian.bamboo.repository.Repository;
import com.atlassian.bamboo.repository.RepositoryException;
import com.atlassian.bamboo.security.EncryptionService;
import com.atlassian.bamboo.template.TemplateRenderer;
import com.atlassian.bamboo.util.BambooStringUtils;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.atlassian.bamboo.utils.i18n.I18nBean;
import com.atlassian.bamboo.utils.i18n.I18nBeanFactory;
import com.atlassian.bamboo.v2.build.BuildContext;
import com.atlassian.bamboo.v2.build.BuildRepositoryChanges;
import com.atlassian.bamboo.v2.build.BuildRepositoryChangesImpl;
import com.atlassian.bamboo.v2.build.agent.remote.RemoteBuildDirectoryManager;
import com.atlassian.bamboo.v2.build.repository.CustomSourceDirectoryAwareRepository;
import com.atlassian.bamboo.variable.CustomVariableContext;
import com.atlassian.bamboo.vcs.configuration.PlanRepositoryDefinition;
import com.atlassian.bamboo.ww2.actions.build.admin.create.BuildConfiguration;
import com.ctc.wstx.exc.WstxIOException;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.microsoft.tfs.core.TFSConfigurationServer;
import com.microsoft.tfs.core.TFSTeamProjectCollection;
import com.microsoft.tfs.core.clients.versioncontrol.GetOptions;
import com.microsoft.tfs.core.clients.versioncontrol.VersionControlClient;
import com.microsoft.tfs.core.clients.versioncontrol.WebServiceLevel;
import com.microsoft.tfs.core.clients.versioncontrol.WorkspaceLocation;
import com.microsoft.tfs.core.clients.versioncontrol.Workstation;
import com.microsoft.tfs.core.clients.versioncontrol.exceptions.VersionControlException;
import com.microsoft.tfs.core.clients.versioncontrol.path.ServerPath;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.BranchObject;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.Change;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.Changeset;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.DeletedState;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.GetRequest;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.Item;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.ItemIdentifier;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.ItemSet;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.ItemType;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.RecursionType;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.WorkingFolder;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.Workspace;
import com.microsoft.tfs.core.clients.versioncontrol.specs.LabelSpec;
import com.microsoft.tfs.core.clients.versioncontrol.specs.version.ChangesetVersionSpec;
import com.microsoft.tfs.core.clients.versioncontrol.specs.version.LabelVersionSpec;
import com.microsoft.tfs.core.clients.versioncontrol.specs.version.LatestVersionSpec;
import com.microsoft.tfs.core.clients.versioncontrol.specs.version.VersionSpec;
import com.microsoft.tfs.core.config.persistence.PersistenceStoreProvider;
import com.microsoft.tfs.core.exceptions.TECoreException;
import com.microsoft.tfs.core.httpclient.Credentials;
import com.microsoft.tfs.core.httpclient.UsernamePasswordCredentials;
import com.microsoft.tfs.core.util.URIUtils;
import com.microsoft.tfs.core.ws.runtime.exceptions.InvalidServerResponseException;
import com.microsoft.tfs.jni.helpers.LocalHost;
import com.stellarity.bamboo.utils.ComponentGetter;
import com.stellarity.bamboo.utils.LicenseChecker;
import com.stellarity.tfs.TfsJniLoader;
import com.stellarity.tfs.TfsUtils;
import com.stellarity.tfs.optimizator.RequestOptimizator;
import com.stellarity.util.EventSuppressor;
import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TfsRepository
extends AbstractStandaloneRepository
implements CustomSourceDirectoryAwareRepository,
BranchDetectionCapableRepository,
DeploymentAwareRepository,
CustomVariableProviderRepository,
CachingAwareRepository {
    private static final long SOCKET_ERROR_SUPPRESS_MAX_PERIOD = 3600000L;
    private static final int SOCKET_ERROR_SUPPRESS_MIN_COUNT = 3;
    private static final int SOCKET_ERROR_SUPPRESS_MAX_COUNT = 20;
    private static final int TIMEOUT = 3000;
    private static final String URL_KEY = "stellarity.tfs.repository.url";
    private static final String PATH_KEY = "stellarity.tfs.repository.path";
    private static final String USERNAME_KEY = "stellarity.tfs.repository.username";
    private static final String PASSWORD_KEY = "stellarity.tfs.repository.password";
    private static final String TMP_PASSWORD_KEY = "stellarity.tfs.temporary.password";
    private static final String TMP_PASSWORD_CHANGE_KEY = "stellarity.tfs.temporary.passwordChange";
    private static final String TMP_LICENSE_ERROR_KEY = "stellarity.tfs.temporary.licenseError";
    private static final String FILTER_OPTION_KEY = "stellarity.tfs.repository.filter.option";
    private static final String FILTER_PATTERN_KEY = "stellarity.tfs.repository.filter.pattern";
    private static final String VERSION_SPEC_KEY = "stellarity.tfs.repository.versionspec";
    private static final String REMOVE_WORKSPACE_KEY = "stellarity.tfs.repository.removeworkspace";
    private static final String WORKSPACE_PREFIX = "Bamboo_";
    private static final String PLUGIN_NAME = "Stellarity Software - TFS Repository";
    private static final String VERSION_SPEC_VAR = "${bamboo.TFS_VERSION_SPEC}";
    private static final Logger m_log = Logger.getLogger(TfsRepository.class);
    private String m_url;
    private String m_path;
    private String m_username;
    private String m_password;
    private FilterType m_filterType;
    private String m_filterPattern;
    private String m_versionSpec;
    private boolean m_removeWorkspace;
    private String m_substitutedUrl;
    private String m_substitutedPath;
    private String m_substitutedVersionSpec;
    private String m_branchName;
    private String m_projectGuid = "";
    private boolean m_pre2010 = false;
    private final EncryptionService m_encryptionService;
    private final I18nBean m_i18nBean;
    private final ComponentGetter m_componentGetter;
    private final LicenseChecker m_licenseChecker;
    private final EventSuppressor m_socketErrorSuppressor = new EventSuppressor(3600000L, 3, 20);

    public TfsRepository() throws IOException, InterruptedException {
        this.m_componentGetter = new ComponentGetter(((Object)((Object)this)).getClass());
        this.m_licenseChecker = new LicenseChecker(((Object)((Object)this)).getClass(), PLUGIN_NAME);
        this.m_i18nBean = ((I18nBeanFactory)this.m_componentGetter.getComponent(I18nBeanFactory.class)).getI18nBean();
        this.m_encryptionService = (EncryptionService)this.m_componentGetter.getComponent(EncryptionService.class);
        this.setBuildLoggerManager((BuildLoggerManager)this.m_componentGetter.getComponent(BuildLoggerManager.class));
        this.setBuildDirectoryManager((BuildDirectoryManager)this.m_componentGetter.getComponent(BuildDirectoryManager.class));
        this.setCustomVariableContext((CustomVariableContext)this.m_componentGetter.getComponent(CustomVariableContext.class));
        this.setTemplateRenderer((TemplateRenderer)this.m_componentGetter.getComponentSilent(TemplateRenderer.class));
        try {
            TfsJniLoader.initialize(this.buildDirectoryManager.getApplicationHome());
        }
        catch (InterruptedException e) {
            m_log.fatal((Object)"Caught an exception: ", (Throwable)e);
        }
        catch (IOException e) {
            m_log.fatal((Object)"Caught an exception: ", (Throwable)e);
        }
        catch (UnsatisfiedLinkError e) {
            m_log.fatal((Object)"Caught an exception: ", (Throwable)e);
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.m_componentGetter.releaseAllComponents();
    }

    @NotNull
    public Map<String, String> getPlanRepositoryVariables() {
        HashMap variables = Maps.newHashMap();
        variables.put("repositoryUrl", this.m_substitutedUrl);
        variables.put("path", this.m_substitutedPath);
        if (StringUtils.isNotEmpty((String)this.m_projectGuid)) {
            variables.put("guid", this.m_projectGuid);
        }
        if (this.m_pre2010) {
            variables.put("pre2010", "1");
        }
        return variables;
    }

    @NotNull
    public Map<String, String> getCustomVariables() {
        HashMap variables = Maps.newHashMap();
        variables.put("repository.tfs.repositoryUrl", this.m_substitutedUrl);
        variables.put("repository.tfs.path", this.m_substitutedPath);
        variables.put("repository.tfs.branch", this.m_branchName);
        if (StringUtils.isNotEmpty((String)this.m_projectGuid)) {
            variables.put("repository.tfs.guid", this.m_projectGuid);
        }
        if (this.m_pre2010) {
            variables.put("repository.tfs.pre2010", "1");
        }
        return variables;
    }

    public String getHost() {
        String host = "unknown-host";
        if (null != this.m_substitutedUrl) {
            try {
                host = new URL(this.m_substitutedUrl).getHost();
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return host;
    }

    @NotNull
    public String getName() {
        return "TFS";
    }

    @NotNull
    public BuildRepositoryChanges collectChangesForRevision(@NotNull PlanKey planKey, @NotNull String targetRevision) throws RepositoryException {
        return this.collectChanges(targetRevision, true);
    }

    @NotNull
    public BuildRepositoryChanges collectChangesSinceLastBuild(@NotNull String planKey, @Nullable String lastVcsRevisionKey) throws RepositoryException {
        return this.collectChanges(lastVcsRevisionKey, false);
    }

    @NotNull
    public BuildRepositoryChanges collectChanges(@Nullable String revision, boolean onceOff) throws RepositoryException {
        this.substituteRepositorySettings();
        TFSTeamProjectCollection tpc = null;
        TFSConfigurationServer cs = null;
        VersionControlClient vcc = null;
        String licenseError = this.getLicenseError();
        if (null != licenseError) {
            throw new RepositoryException(licenseError);
        }
        try {
            m_log.info((Object)("Collecting changes from revision: " + String.valueOf(revision) + ", onceOff: " + onceOff + ", path: " + this.m_substitutedPath));
            String versionSpecString = this.getVersionSpecString();
            if (versionSpecString != null) {
                m_log.info((Object)("Version specifier is set: " + versionSpecString));
                BuildRepositoryChangesImpl buildRepositoryChangesImpl = new BuildRepositoryChangesImpl(versionSpecString);
                return buildRepositoryChangesImpl;
            }
            VersionSpec versionSpec = TfsRepository.parseVersionString(revision);
            String returnedRevision = revision;
            ArrayList<CommitContextImpl> commitContexts = new ArrayList<CommitContextImpl>();
            try {
                tpc = this.getTeamProjectCollection();
                cs = tpc.getConfigurationServer();
                vcc = tpc.getVersionControlClient();
                this.m_socketErrorSuppressor.reset();
                Changeset[] changesets = null == revision ? TfsUtils.queryReverseHistory(vcc, this.m_substitutedPath, null, null, null, 1, true) : (onceOff ? TfsUtils.queryReverseHistory(vcc, this.m_substitutedPath, versionSpec, versionSpec, versionSpec, 1, true) : TfsUtils.queryHistory(vcc, this.m_substitutedPath, null, versionSpec, null, Integer.MAX_VALUE, true));
                m_log.debug((Object)("Changesets count: " + changesets.length));
                if (changesets.length > 0) {
                    int i;
                    boolean skipFirstChangeset = null != revision && !onceOff;
                    int n = i = skipFirstChangeset ? 1 : 0;
                    while (i < changesets.length) {
                        Changeset changeset = changesets[i];
                        m_log.debug((Object)("Changeset revision: " + changeset.getChangesetID()));
                        ArrayList<CommitFileImpl> commitFiles = new ArrayList<CommitFileImpl>();
                        for (Change change : changeset.getChanges()) {
                            Item item = change.getItem();
                            if (this.isItemFilteredOut(item)) continue;
                            commitFiles.add(new CommitFileImpl(String.valueOf(item.getChangeSetID()), item.getServerItem()));
                        }
                        if (!commitFiles.isEmpty()) {
                            String authorName = changeset.getOwnerDisplayName();
                            String comment = changeset.getComment();
                            if (null == comment) {
                                comment = "";
                            }
                            commitContexts.add(CommitContextImpl.builder().author(TfsRepository.stripDomainName(authorName)).files(commitFiles).comment(comment).date(changeset.getDate().getTime()).changesetId(String.valueOf(changeset.getChangesetID())).build());
                        }
                        ++i;
                    }
                    returnedRevision = String.valueOf(changesets[changesets.length - 1].getChangesetID());
                    m_log.info((Object)("Latest revision: " + returnedRevision));
                }
            }
            catch (TECoreException e) {
                m_log.warn((Object)"Ignoring exception: ", (Throwable)e);
            }
            catch (SocketTimeoutException e) {
                if (this.m_socketErrorSuppressor.reportEvent()) {
                    throw e;
                }
                m_log.debug((Object)"Ignoring exception: ", (Throwable)e);
            }
            BuildRepositoryChangesImpl buildRepositoryChangesImpl = new BuildRepositoryChangesImpl(returnedRevision, commitContexts);
            return buildRepositoryChangesImpl;
        }
        catch (Exception e) {
            m_log.error((Object)"Caught an exception: ", (Throwable)e);
            throw new RepositoryException((Throwable)e);
        }
        finally {
            if (vcc != null) {
                vcc.close();
            }
            if (cs != null) {
                cs.close();
            }
            if (tpc != null) {
                tpc.close();
            }
        }
    }

    public boolean isRepositoryDifferent(Repository repository) {
        if (repository instanceof TfsRepository) {
            TfsRepository other = (TfsRepository)repository;
            return !new EqualsBuilder().append((Object)this.m_url, (Object)other.m_url).append((Object)this.m_path, (Object)other.m_path).append((Object)this.m_username, (Object)other.m_username).append((Object)this.m_password, (Object)other.m_password).isEquals();
        }
        return true;
    }

    public boolean isAdvancedOptionEnabled(@NotNull BuildConfiguration buildConfiguration) {
        return !StringUtils.equals((String)FilterType.ALL.toString(), (String)buildConfiguration.getString(FILTER_OPTION_KEY)) || StringUtils.isNotEmpty((String)buildConfiguration.getString(VERSION_SPEC_KEY)) || StringUtils.isNotEmpty((String)buildConfiguration.getString(REMOVE_WORKSPACE_KEY));
    }

    @NotNull
    public String retrieveSourceCode(@NotNull BuildContext buildContext, @Nullable String vcsRevisionKey, @NotNull File sourceDirectory) throws RepositoryException {
        this.substituteRepositorySettings();
        int kRetryMax = 5;
        int kRetryTimeout = 2000;
        int retry = 1;
        while (true) {
            try {
                return this.tryToRetrieveSourceCode(buildContext, vcsRevisionKey, sourceDirectory);
            }
            catch (Exception e) {
                m_log.error((Object)"Caught an exception: ", (Throwable)e);
                if ((e instanceof InvalidServerResponseException || e instanceof WstxIOException) && retry <= 5) {
                    m_log.warn((Object)("Retrying " + retry + " from " + 5));
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (InterruptedException ie) {
                        throw new RepositoryException((Throwable)ie);
                    }
                } else {
                    throw new RepositoryException((Throwable)e);
                }
                ++retry;
                continue;
            }
            break;
        }
    }

    public void addDefaultValues(@NotNull BuildConfiguration config) {
        super.addDefaultValues(config);
        String licenseError = this.getLicenseError();
        if (null != licenseError) {
            config.setProperty(TMP_LICENSE_ERROR_KEY, (Object)licenseError);
        }
    }

    public void prepareConfigObject(@NotNull BuildConfiguration config) {
        config.setProperty(URL_KEY, (Object)config.getString(URL_KEY).trim());
        config.setProperty(PATH_KEY, (Object)config.getString(PATH_KEY).trim());
        config.setProperty(USERNAME_KEY, (Object)config.getString(USERNAME_KEY).trim());
        if (config.getBoolean(TMP_PASSWORD_CHANGE_KEY)) {
            config.setProperty(PASSWORD_KEY, (Object)this.m_encryptionService.encrypt(config.getString(TMP_PASSWORD_KEY)));
        }
        config.setProperty(VERSION_SPEC_KEY, (Object)config.getString(VERSION_SPEC_KEY, "").trim());
        config.setProperty(FILTER_PATTERN_KEY, (Object)config.getString(FILTER_PATTERN_KEY, "").trim());
        if (StringUtils.isBlank((String)config.getString("selectedWebRepositoryViewer"))) {
            config.addProperty("selectedWebRepositoryViewer", (Object)"com.stellarity.bamboo.tfs-repository-plugin:tfsViewer");
        }
    }

    public void populateFromConfig(@NotNull HierarchicalConfiguration config) {
        super.populateFromConfig(config);
        this.m_url = config.getString(URL_KEY);
        this.m_path = config.getString(PATH_KEY);
        this.m_username = config.getString(USERNAME_KEY);
        this.m_password = config.getString(PASSWORD_KEY);
        this.m_versionSpec = config.getString(VERSION_SPEC_KEY);
        this.m_filterPattern = config.getString(FILTER_PATTERN_KEY);
        this.m_filterType = FilterType.valueOf(config.getString(FILTER_OPTION_KEY, FilterType.ALL.toString()));
        this.m_removeWorkspace = config.getBoolean(REMOVE_WORKSPACE_KEY);
    }

    @NotNull
    public HierarchicalConfiguration toConfiguration() {
        HierarchicalConfiguration config = super.toConfiguration();
        config.setProperty(URL_KEY, (Object)this.m_url);
        config.setProperty(PATH_KEY, (Object)this.m_path);
        config.setProperty(USERNAME_KEY, (Object)this.m_username);
        config.setProperty(PASSWORD_KEY, (Object)this.m_password);
        config.setProperty(VERSION_SPEC_KEY, (Object)this.m_versionSpec);
        config.setProperty(FILTER_PATTERN_KEY, (Object)this.m_filterPattern);
        config.setProperty(FILTER_OPTION_KEY, (Object)this.m_filterType.toString());
        config.setProperty(REMOVE_WORKSPACE_KEY, (Object)this.m_removeWorkspace);
        return config;
    }

    public Map getFilterTypes() {
        return ImmutableMap.of((Object)FilterType.ALL.toString(), (Object)this.m_i18nBean.getText(FilterType.ALL.getI18n()), (Object)FilterType.INCLUDE.toString(), (Object)this.m_i18nBean.getText(FilterType.INCLUDE.getI18n()), (Object)FilterType.EXCLUDE.toString(), (Object)this.m_i18nBean.getText(FilterType.EXCLUDE.getI18n()));
    }

    @NotNull
    public ErrorCollection validate(@NotNull BuildConfiguration buildConfiguration) {
        String path;
        String url;
        ErrorCollection errorCollection = super.validate(buildConfiguration);
        if (this.validateField(buildConfiguration, errorCollection, URL_KEY, false) && !TfsRepository.needsSubstitution(url = buildConfiguration.getString(URL_KEY))) {
            try {
                TfsRepository.validateUrl(url);
            }
            catch (Exception e) {
                errorCollection.addError(URL_KEY, this.m_i18nBean.getText("stellarity.tfs.repository.url.error"));
            }
        }
        if (this.validateField(buildConfiguration, errorCollection, PATH_KEY, false) && !TfsRepository.needsSubstitution(path = this.substituteString(buildConfiguration.getString(PATH_KEY))) && !path.startsWith("$/")) {
            errorCollection.addError(PATH_KEY, this.m_i18nBean.getText("stellarity.tfs.repository.path.error"));
        }
        this.validateField(buildConfiguration, errorCollection, USERNAME_KEY, false);
        this.validateField(buildConfiguration, errorCollection, PASSWORD_KEY, true);
        return errorCollection;
    }

    private boolean validateField(@NotNull BuildConfiguration buildConfiguration, @NotNull ErrorCollection errorCollection, @NotNull String key, boolean canBeEmpty) {
        String value = buildConfiguration.getString(key);
        if (!canBeEmpty && StringUtils.isBlank((String)value)) {
            errorCollection.addError(key, this.m_i18nBean.getText(key + ".error"));
            return false;
        }
        return !this.findFieldRelaxedXssViolation(errorCollection, key, value);
    }

    private boolean findFieldRelaxedXssViolation(@NotNull ErrorCollection errorCollection, @NotNull String fieldName, @NotNull String fieldValue) {
        if (BambooStringUtils.containsRelaxedXssRelatedCharacters((String)fieldValue)) {
            errorCollection.addError(fieldName, this.m_i18nBean.getText("error.string.unsafe", null, BambooStringUtils.getFirstRelaxedXssRelatedCharacter((String)fieldValue)));
            return true;
        }
        return false;
    }

    private static void validateUrl(@NotNull String url) throws IOException {
        URL u = new URL(url);
        Socket socket = new Socket();
        socket.connect(new InetSocketAddress(u.getHost(), u.getPort() > 0 ? u.getPort() : u.getDefaultPort()), 3000);
        socket.close();
    }

    private TFSTeamProjectCollection getTeamProjectCollection() throws IOException {
        TfsRepository.validateUrl(this.m_substitutedUrl);
        UsernamePasswordCredentials cred = new UsernamePasswordCredentials(this.m_username, this.m_encryptionService.decrypt(this.m_password));
        return new TFSTeamProjectCollection(URIUtils.newURI((String)this.m_substitutedUrl), (Credentials)cred);
    }

    @NotNull
    private String getWorkspaceName(@NotNull BuildContext buildContext, @NotNull String localPath) {
        String hashString = String.valueOf(this.getRepositoryId(buildContext)) + localPath;
        String hostName = LocalHost.getShortName();
        int dotIndex = hostName.indexOf(46);
        if (dotIndex > 0) {
            hostName = hostName.substring(0, dotIndex);
        }
        return WORKSPACE_PREFIX + buildContext.getEntityKey().getKey() + "_" + Long.toString((long)hashString.hashCode() & 0xFFFFFFFFL, 16) + "_" + hostName;
    }

    private static boolean isOurWorkspace(@NotNull String workspaceName) {
        return StringUtils.startsWithIgnoreCase((String)workspaceName, (String)WORKSPACE_PREFIX);
    }

    private long getRepositoryId(@NotNull BuildContext buildContext) {
        for (PlanRepositoryDefinition definition : buildContext.getVcsRepositories()) {
            try {
                if (!definition.isLegacyRepository() || this != definition.asLegacyData().getRepository()) continue;
                return definition.getId();
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
            }
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    private Workspace getWorkspace(@NotNull BuildContext buildContext, @NotNull VersionControlClient vcc, @NotNull String localPath) throws RepositoryException {
        block22: {
            workspaces = vcc.getRepositoryWorkspaces(null, null, LocalHost.getShortName());
            try {
                workspaceName = this.getWorkspaceName(buildContext, localPath);
                closestWorkspaces = this.findClosestWorkspaceByPath((Workspace[])workspaces, localPath);
lbl5:
                // 2 sources

                for (Workspace closestWorkspace : closestWorkspaces) {
                    workingFolder = closestWorkspace.getExactMappingForLocalPath(localPath);
                    if (null == workingFolder) ** GOTO lbl-1000
                    serverPath = workingFolder.translateLocalItemToServerItem(localPath);
                    if (TfsRepository.isOurWorkspace(closestWorkspace.getName())) ** GOTO lbl38
                    if (0 == serverPath.compareToIgnoreCase(this.m_substitutedPath)) {
                        TfsRepository.m_log.debug((Object)("Using an external workspace: " + closestWorkspace.getDisplayName()));
                        TfsRepository.m_log.debug((Object)("Using mapping: " + this.m_substitutedPath + " -> " + localPath));
                        var11_13 = closestWorkspace;
                        isCleanup = false;
                        break block22;
                    }
                    ** GOTO lbl-1000
                }
                ** GOTO lbl55
            }
            catch (Throwable var14_21) {
                isCleanup = false;
                try {
                    isCleanup = 0 == buildContext.getBuildNumber() % 10;
                }
                catch (UnsupportedOperationException var16_23) {
                    // empty catch block
                }
                if (isCleanup) {
                    this.cleanupOldWorkspaces(vcc, (Workspace[])workspaces);
                }
                throw var14_21;
            }
        }
        try {
            isCleanup = 0 == buildContext.getBuildNumber() % 10;
        }
        catch (UnsupportedOperationException var13_19) {
            // empty catch block
        }
        if (isCleanup) {
            this.cleanupOldWorkspaces(vcc, (Workspace[])workspaces);
        }
        return var11_13;
lbl-1000:
        // 1 sources

        {
            throw new RepositoryException("Existing workspace mapping doesn't match, expecting: " + this.m_substitutedPath + ", found: " + serverPath + ".");
lbl38:
            // 1 sources

            if (0 != serverPath.compareToIgnoreCase(this.m_substitutedPath) || 0 != workspaceName.compareToIgnoreCase(closestWorkspace.getName())) ** GOTO lbl-1000
            TfsRepository.m_log.debug((Object)("Using an existing workspace: " + closestWorkspace.getDisplayName()));
            TfsRepository.m_log.debug((Object)("Using mapping: " + this.m_substitutedPath + " -> " + localPath));
            var11_14 = closestWorkspace;
            isCleanup = false;
        }
        try {
            isCleanup = 0 == buildContext.getBuildNumber() % 10;
        }
        catch (UnsupportedOperationException var13_20) {
            // empty catch block
        }
        if (isCleanup) {
            this.cleanupOldWorkspaces(vcc, (Workspace[])workspaces);
        }
        return var11_14;
lbl-1000:
        // 2 sources

        {
            TfsRepository.m_log.debug((Object)("Removing workspace: " + closestWorkspace.toString()));
            workspaces = (Workspace[])ArrayUtils.removeElement((Object[])workspaces, (Object)closestWorkspace);
            vcc.deleteWorkspace(closestWorkspace);
            ** GOTO lbl5
lbl55:
            // 1 sources

            returnedWorkspace = this.findWorkspaceByName((Workspace[])workspaces, workspaceName);
            if (null == returnedWorkspace) {
                TfsRepository.m_log.debug((Object)("Creating a new workspace: " + workspaceName));
                returnedWorkspace = vcc.createWorkspace(null, workspaceName, "Bamboo workspace", WorkspaceLocation.SERVER, null);
            }
            TfsRepository.m_log.debug((Object)("Creating a new mapping: " + this.m_substitutedPath + " -> " + localPath));
            newWorkingFolder = new WorkingFolder(this.m_substitutedPath, localPath);
            try {
                returnedWorkspace.createWorkingFolder(newWorkingFolder, true);
            }
            catch (Exception e) {
                workstation = Workstation.getCurrent((PersistenceStoreProvider)vcc.getConnection().getPersistenceStoreProvider());
                workspaceInfo = workstation.getLocalWorkspaceInfo(localPath);
                if (null != workspaceInfo) {
                    workstation.getCache().removeWorkspace(workspaceInfo);
                    workstation.saveConfigIfDirty();
                }
                returnedWorkspace.createWorkingFolder(newWorkingFolder, true);
            }
            var9_9 = returnedWorkspace;
            isCleanup = false;
        }
        try {
            isCleanup = 0 == buildContext.getBuildNumber() % 10;
        }
        catch (UnsupportedOperationException var11_16) {
            // empty catch block
        }
        if (isCleanup) {
            this.cleanupOldWorkspaces(vcc, (Workspace[])workspaces);
        }
        return var9_9;
    }

    private List<Workspace> findClosestWorkspaceByPath(@NotNull Workspace[] workspaces, @NotNull String localPath) {
        ArrayList<Workspace> closestWorkspaces = new ArrayList<Workspace>();
        for (Workspace workspace : workspaces) {
            for (WorkingFolder workingFolder : workspace.getFolders()) {
                if (!TfsRepository.isOverlappedPath(workingFolder.getLocalItem(), localPath)) continue;
                closestWorkspaces.add(workspace);
            }
        }
        return closestWorkspaces;
    }

    @Nullable
    private Workspace findWorkspaceByName(@NotNull Workspace[] workspaces, @NotNull String name) {
        for (Workspace workspace : workspaces) {
            if (0 != name.compareToIgnoreCase(workspace.getName())) continue;
            return workspace;
        }
        return null;
    }

    private void cleanupOldWorkspaces(@NotNull VersionControlClient vcc, @NotNull Workspace[] workspaces) {
        for (Workspace workspace : workspaces) {
            if (!TfsRepository.isOurWorkspace(workspace.getName())) continue;
            boolean deleteWorkspace = true;
            for (WorkingFolder workingFolder : workspace.getFolders()) {
                if (!new File(workingFolder.getLocalItem()).exists()) continue;
                deleteWorkspace = false;
                break;
            }
            if (!deleteWorkspace) continue;
            m_log.debug((Object)("Deleting old workspace: " + workspace.getName()));
            try {
                vcc.deleteWorkspace(workspace);
            }
            catch (VersionControlException e) {
                m_log.error((Object)"Exception during cleaning old workspaces: ", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private String tryToRetrieveSourceCode(@NotNull BuildContext buildContext, @Nullable String vcsRevisionKey, @NotNull File sourceDirectory) throws Exception {
        TFSTeamProjectCollection tpc = null;
        TFSConfigurationServer cs = null;
        VersionControlClient vcc = null;
        try {
            String string;
            block14: {
                String versionString = this.getVersionString(buildContext, vcsRevisionKey);
                m_log.info((Object)("Checking out revision: " + (null == versionString ? "null" : versionString) + ", path: " + this.m_substitutedPath));
                tpc = this.getTeamProjectCollection();
                cs = tpc.getConfigurationServer();
                vcc = tpc.getVersionControlClient();
                this.m_projectGuid = tpc.getInstanceID().toString();
                this.m_pre2010 = vcc.getServiceLevel() == WebServiceLevel.PRE_TFS_2010;
                Workspace workspace = this.getWorkspace(buildContext, vcc, sourceDirectory.getPath());
                try {
                    VersionSpec version = TfsRepository.parseVersionString(versionString);
                    if (0 == sourceDirectory.listFiles().length && FilterType.ALL == this.m_filterType) {
                        m_log.debug((Object)"Performing a simple checkout");
                        this.checkoutFilesSimple(workspace, version);
                    } else {
                        m_log.debug((Object)"Performing a normal checkout");
                        this.checkoutFiles(vcc, workspace, version, sourceDirectory.getPath());
                    }
                    Changeset[] changesets = TfsUtils.queryReverseHistory(vcc, this.m_substitutedPath, version, null, version, 1, false);
                    m_log.debug((Object)("Changesets count: " + changesets.length));
                    if (0 == changesets.length) {
                        throw new RepositoryException("There is no history for the path " + this.m_substitutedPath + ". Probably it doesn't exist.");
                    }
                    String checkedVcsRevisionKey = String.valueOf(changesets[0].getChangesetID());
                    m_log.info((Object)("Checked out revision: " + checkedVcsRevisionKey));
                    Map<String, String> branchesInfo = this.getBranchesInfo(vcc, false);
                    if (!branchesInfo.isEmpty()) {
                        this.m_branchName = branchesInfo.keySet().iterator().next();
                    }
                    string = checkedVcsRevisionKey;
                    if (!this.m_removeWorkspace) break block14;
                }
                catch (Throwable throwable) {
                    if (this.m_removeWorkspace) {
                        vcc.deleteWorkspace(workspace);
                    }
                    throw throwable;
                }
                vcc.deleteWorkspace(workspace);
            }
            return string;
        }
        finally {
            if (vcc != null) {
                vcc.close();
            }
            if (cs != null) {
                cs.close();
            }
            if (tpc != null) {
                tpc.close();
            }
        }
    }

    private void checkoutFilesSimple(@NotNull Workspace workspace, @NotNull VersionSpec version) {
        workspace.get(version, GetOptions.GET_ALL);
    }

    private void checkoutFiles(@NotNull VersionControlClient vc, @NotNull Workspace workspace, @NotNull VersionSpec version, @NotNull String localPath) {
        WorkingFolder workingFolder = workspace.getExactMappingForLocalPath(localPath);
        ItemSet itemSet = vc.getItems(this.m_substitutedPath, version, RecursionType.FULL, DeletedState.NON_DELETED, ItemType.FILE);
        RequestOptimizator getRequestOptimizator = new RequestOptimizator(this.m_substitutedPath);
        for (Item item : itemSet.getItems()) {
            String serverItem = item.getServerItem();
            if (this.isItemFilteredOut(item)) {
                getRequestOptimizator.addExcludedFile(serverItem);
                continue;
            }
            getRequestOptimizator.addIncludedFile(serverItem);
        }
        GetRequest[] getRequests = getRequestOptimizator.createOptimizedRequests(version);
        if (getRequests.length > 0) {
            m_log.debug((Object)("Get requests count: " + getRequests.length));
            workspace.get(getRequests, GetOptions.OVERWRITE);
        }
        RequestOptimizator overwriteRequestOptimizator = new RequestOptimizator(this.m_substitutedPath);
        for (Item item : itemSet.getItems()) {
            String serverItem = item.getServerItem();
            if (this.isItemFilteredOut(item)) {
                overwriteRequestOptimizator.addExcludedFile(serverItem);
                continue;
            }
            String localItem = workingFolder.translateServerItemToLocalItem(serverItem);
            File file = new File(localItem);
            if (file.exists() && !file.canWrite()) {
                overwriteRequestOptimizator.addExcludedFile(serverItem);
                continue;
            }
            overwriteRequestOptimizator.addIncludedFile(serverItem);
        }
        GetRequest[] overwriteRequests = overwriteRequestOptimizator.createOptimizedRequests(version);
        if (overwriteRequests.length > 0) {
            m_log.debug((Object)("Overwrite requests count: " + overwriteRequests.length));
            workspace.get(overwriteRequests, GetOptions.OVERWRITE.combine(GetOptions.GET_ALL));
        }
    }

    private boolean isItemFilteredOut(@NotNull Item item) {
        switch (this.m_filterType) {
            case EXCLUDE: {
                return this.isItemMatched(item);
            }
            case INCLUDE: {
                return !this.isItemMatched(item);
            }
        }
        return false;
    }

    private boolean isItemMatched(@NotNull Item item) {
        String serverItem = item.getServerItem();
        String subPath = serverItem.substring(this.m_substitutedPath.length());
        if (subPath.startsWith("/")) {
            subPath = subPath.substring(1);
        }
        return subPath.matches(this.m_filterPattern);
    }

    @NotNull
    private static VersionSpec parseVersionString(@Nullable String versionString) {
        if (null == versionString) {
            return LatestVersionSpec.INSTANCE;
        }
        if (versionString.matches("\\d+")) {
            return new ChangesetVersionSpec(Integer.parseInt(versionString));
        }
        return new LabelVersionSpec(LabelSpec.parse((String)versionString, null, (boolean)false));
    }

    @Nullable
    private String getVersionString(@NotNull BuildContext buildContext, @Nullable String vcsRevisionKey) {
        try {
            if (buildContext.isOnceOff()) {
                return vcsRevisionKey;
            }
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        String versionSpecString = this.getVersionSpecString();
        return versionSpecString != null ? versionSpecString : vcsRevisionKey;
    }

    @Nullable
    private String getVersionSpecString() {
        if (!StringUtils.isEmpty((String)this.m_substitutedVersionSpec)) {
            return this.m_substitutedVersionSpec;
        }
        String versionSpecVariable = this.substituteString(VERSION_SPEC_VAR);
        return StringUtils.equals((String)versionSpecVariable, (String)VERSION_SPEC_VAR) ? null : versionSpecVariable;
    }

    @NotNull
    private static String stripDomainName(@NotNull String fullUsername) {
        int i = fullUsername.indexOf(92);
        return i < 0 ? fullUsername : fullUsername.substring(i + 1);
    }

    private static boolean isOverlappedPath(@Nullable String path1, @Nullable String path2) {
        if (path1 == null || path2 == null) {
            return false;
        }
        return (path1 = path1.replace('\\', '/') + '/').startsWith(path2 = path2.replace('\\', '/') + '/') || path2.startsWith(path1);
    }

    private boolean isOnRemoteAgent() {
        return this.buildDirectoryManager instanceof RemoteBuildDirectoryManager;
    }

    private void substituteRepositorySettings() {
        this.m_substitutedPath = this.substituteString(this.m_path);
        this.m_substitutedUrl = this.substituteString(this.m_url);
        this.m_substitutedVersionSpec = this.substituteString(this.m_versionSpec);
    }

    private static boolean needsSubstitution(@NotNull String s) {
        return s.contains("${bamboo.");
    }

    @Nullable
    private String getLicenseError() {
        if (this.isOnRemoteAgent()) {
            return null;
        }
        return this.m_licenseChecker.getLicenseError();
    }

    @NotNull
    public VcsBranch getVcsBranch() {
        if (null == this.m_branchName) {
            Map<String, String> branchesInfo = this.getBranchesInfo(false);
            this.m_branchName = branchesInfo.isEmpty() ? "" : branchesInfo.keySet().iterator().next();
        }
        return new VcsBranchImpl(this.m_branchName);
    }

    public void setVcsBranch(@NotNull VcsBranch vcsBranch) {
        Map<String, String> branchesInfo = this.getBranchesInfo(true);
        String newPath = branchesInfo.get(vcsBranch.getName());
        if (null != newPath) {
            this.m_path = newPath;
        } else {
            m_log.error((Object)("Cannot find src path for the branch: " + vcsBranch.getName() + "."));
        }
        this.m_branchName = vcsBranch.getName();
    }

    @NotNull
    private Map<String, String> getBranchesInfo(@NotNull VersionControlClient vcc, boolean all) {
        HashMap branchesInfo = Maps.newHashMap();
        String fullPath = this.m_substitutedPath.endsWith("/") ? this.m_substitutedPath : this.m_substitutedPath + "/";
        try {
            int idx = fullPath.indexOf(47, 2);
            while (idx > 0) {
                String path = this.m_substitutedPath.substring(0, idx);
                BranchObject[] branchObjects = vcc.queryBranchObjects(new ItemIdentifier(path), all ? RecursionType.FULL : RecursionType.NONE);
                if (branchObjects.length > 0) {
                    String innerSrcPart = this.m_path.startsWith(path) ? this.m_path.substring(path.length()) : this.m_substitutedPath.substring(path.length());
                    for (BranchObject branchObject : branchObjects) {
                        if (branchObject.isDeleted()) continue;
                        String branchPath = branchObject.getProperties().getRootItem().getItem();
                        if (all && path.equals(branchPath)) continue;
                        String branchName = ServerPath.getFileName((String)branchPath);
                        String srcPath = branchPath + innerSrcPart;
                        branchesInfo.put(branchName, srcPath);
                    }
                    break;
                }
                idx = fullPath.indexOf(47, idx + 1);
            }
        }
        catch (TECoreException e) {
            m_log.debug((Object)"Branch objects are not supported.");
        }
        return branchesInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private Map<String, String> getBranchesInfo(boolean all) {
        this.substituteRepositorySettings();
        TFSTeamProjectCollection tpc = null;
        TFSConfigurationServer cs = null;
        VersionControlClient vcc = null;
        try {
            tpc = this.getTeamProjectCollection();
            cs = tpc.getConfigurationServer();
            vcc = tpc.getVersionControlClient();
            Map<String, String> map = this.getBranchesInfo(vcc, all);
            return map;
        }
        catch (Exception e) {
            m_log.error((Object)e);
            HashMap hashMap = Maps.newHashMap();
            return hashMap;
        }
        finally {
            if (vcc != null) {
                vcc.close();
            }
            if (cs != null) {
                cs.close();
            }
            if (tpc != null) {
                tpc.close();
            }
        }
    }

    @NotNull
    public List<VcsBranch> getOpenBranches(String string) throws RepositoryException {
        ArrayList<VcsBranch> branches = new ArrayList<VcsBranch>();
        for (String branchName : this.getBranchesInfo(true).keySet()) {
            branches.add((VcsBranch)new VcsBranchImpl(branchName));
        }
        return branches;
    }

    @Nullable
    public CommitContext getLastCommit() throws RepositoryException {
        return null;
    }

    @Nullable
    public CommitContext getFirstCommit() throws RepositoryException {
        return null;
    }

    @Nullable
    public CacheId getCacheId(@NotNull CachingAwareRepository.CachableOperation cachableOperation) {
        switch (cachableOperation) {
            case BRANCH_DETECTION: {
                this.substituteRepositorySettings();
                return new CacheId((Repository)this, new String[]{this.m_substitutedUrl, this.m_substitutedPath, this.m_username, this.m_password});
            }
        }
        return null;
    }

    public boolean isCachingSupportedFor(@NotNull CachingAwareRepository.CachableOperation cachableOperation) {
        return cachableOperation == CachingAwareRepository.CachableOperation.BRANCH_DETECTION;
    }

    static {
        m_log.setLevel(Level.WARN);
        Logger.getLogger((String)"com.microsoft.tfs").setLevel(Level.WARN);
    }

    private static enum FilterType {
        ALL("ALL", "stellarity.tfs.repository.filter.type.all"),
        INCLUDE("INCLUDE", "stellarity.tfs.repository.filter.type.include"),
        EXCLUDE("EXCLUDE", "stellarity.tfs.repository.filter.type.exclude");

        private final String name;
        private final String i18n;

        private FilterType(String name, String i18n) {
            this.name = name;
            this.i18n = i18n;
        }

        public String toString() {
            return this.name;
        }

        public String getI18n() {
            return this.i18n;
        }
    }
}

