/*
 * Decompiled with CFR 0.152.
 */
package com.stellarity.tfs;

import com.microsoft.tfs.jni.FileSystemUtils;
import com.microsoft.tfs.jni.PlatformMiscUtils;
import com.microsoft.tfs.jni.loader.NativeLoader;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.util.Date;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;

public class TfsJniLoader {
    private static final String TMP_TFS_SDK_PREFIX = "bamboo-tfs-sdk-native";
    private static final Logger LOG = Logger.getLogger(TfsJniLoader.class);
    private static volatile TfsJniLoader m_instance;
    private Closeable m_directoryLock;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initialize(File homePath) throws IOException, InterruptedException {
        TfsJniLoader instance = m_instance;
        if (instance != null) {
            return;
        }
        Class<TfsJniLoader> clazz = TfsJniLoader.class;
        synchronized (TfsJniLoader.class) {
            instance = m_instance;
            if (instance != null) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            m_instance = new TfsJniLoader(homePath);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    private TfsJniLoader(File homePath) throws IOException, InterruptedException {
        File[] tmpDirs;
        LOG.debug((Object)("homePath: " + homePath));
        for (File tmpDir : tmpDirs = new File[]{new File(System.getProperty("java.io.tmpdir")), new File(homePath + File.separator + "temp")}) {
            TfsJniLoader.cleanNativeLibs(tmpDir);
        }
        try {
            this.m_directoryLock = TfsJniLoader.prepareNativeLibs(tmpDirs[0]);
        }
        catch (UnsatisfiedLinkError e) {
            LOG.debug((Object)"going to use a fallback location", (Throwable)e);
            this.m_directoryLock = TfsJniLoader.prepareNativeLibs(tmpDirs[1]);
        }
    }

    private static Closeable lockDirectory(File dir) throws IOException {
        FileOutputStream lockStream = new FileOutputStream(dir + File.separator + "lock");
        try {
            FileChannel lockChannel = lockStream.getChannel();
            if (lockChannel.tryLock() == null) {
                throw new IOException("Couldn't acquire a file lock");
            }
            return lockChannel;
        }
        catch (IOException e) {
            lockStream.close();
            throw e;
        }
    }

    private static void cleanNativeLibs(File tmpDir) {
        LOG.debug((Object)("cleaning native libs directories in temp path: " + tmpDir));
        try {
            FileUtils.deleteDirectory((File)new File(tmpDir + File.separator + TMP_TFS_SDK_PREFIX));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        String[] outputNames = tmpDir.list(new FilenameFilter(){

            @Override
            public boolean accept(File file, String string) {
                return string.startsWith(TfsJniLoader.TMP_TFS_SDK_PREFIX);
            }
        });
        if (outputNames != null) {
            for (String outputName : outputNames) {
                try {
                    int LOCK_HOLD_DELAY = 750;
                    File outputDirectory = new File(tmpDir + File.separator + outputName);
                    Closeable lock = TfsJniLoader.lockDirectory(outputDirectory);
                    Thread.sleep(750L);
                    lock.close();
                    FileUtils.deleteDirectory((File)outputDirectory);
                }
                catch (IOException iOException) {
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    private static Closeable prepareNativeLibs(File tmpDir) throws IOException, InterruptedException {
        LOG.debug((Object)("preparing a native lib directory in temp path: " + tmpDir));
        int RETRY_COUNT = 100;
        int RETRY_DELAY = 10;
        File outputDirectory = null;
        Closeable outputDirectoryLock = null;
        for (int retry = 0; retry < 100; ++retry) {
            outputDirectory = new File(tmpDir + File.separator + TMP_TFS_SDK_PREFIX + new Date().getTime());
            outputDirectory.mkdirs();
            try {
                outputDirectoryLock = TfsJniLoader.lockDirectory(outputDirectory);
                break;
            }
            catch (IOException iOException) {
                outputDirectory = null;
                Thread.sleep(10L);
                continue;
            }
        }
        if (outputDirectory == null || outputDirectoryLock == null) {
            throw new IOException("Failed to lock tmp directory");
        }
        ZipInputStream zis = new ZipInputStream(TfsJniLoader.class.getResourceAsStream("/resources/tfs-sdk-native.zip"));
        ZipEntry ze = zis.getNextEntry();
        byte[] buffer = new byte[131072];
        while (ze != null) {
            File newFile = new File(outputDirectory + File.separator + ze.getName());
            if (ze.isDirectory()) {
                newFile.mkdir();
            } else {
                int len;
                FileOutputStream fos = new FileOutputStream(newFile);
                while ((len = zis.read(buffer)) > 0) {
                    fos.write(buffer, 0, len);
                }
                fos.close();
            }
            ze = zis.getNextEntry();
        }
        zis.closeEntry();
        zis.close();
        FileUtils.forceDeleteOnExit((File)outputDirectory);
        System.setProperty("com.microsoft.tfs.jni.native.base-directory", outputDirectory.toString());
        NativeLoader.loadLibrary((String)"native_misc");
        FileSystemUtils.getInstance();
        PlatformMiscUtils.getInstance();
        return outputDirectoryLock;
    }
}

