/*
 * Decompiled with CFR 0.152.
 */
package com.stellarity.bamboo.task.config;

import com.atlassian.bamboo.crypto.instance.SecretEncryptionService;
import com.atlassian.bamboo.process.EnvironmentVariableAccessor;
import com.atlassian.bamboo.process.ProcessService;
import com.atlassian.bamboo.security.EncryptionService;
import com.atlassian.bamboo.utils.i18n.I18nBeanFactory;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilitySetManager;
import com.atlassian.bamboo.variable.CustomVariableContext;
import com.atlassian.bamboo.variable.VariableDefinitionFactory;
import com.atlassian.bamboo.variable.VariableDefinitionManager;
import com.atlassian.plugins.osgi.javaconfig.ImportOptions;
import com.atlassian.plugins.osgi.javaconfig.OsgiServices;
import com.stellarity.bamboo.task.PowerShellCapabilityTrigger;
import com.stellarity.bamboo.task.config.NotRemoteAgentCondition;
import java.time.Duration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;

@Configuration
public class MyJavaConfig {
    private static final Duration OPTIONAL_TIMEOUT = Duration.ofSeconds(2L);

    @Bean
    public SecretEncryptionService secretEncryptionService() {
        return (SecretEncryptionService)OsgiServices.importOsgiService(SecretEncryptionService.class, (ImportOptions)ImportOptions.defaultOptions().optional().withTimeout(OPTIONAL_TIMEOUT));
    }

    @Bean
    public EnvironmentVariableAccessor environmentVariableAccessor() {
        return (EnvironmentVariableAccessor)OsgiServices.importOsgiService(EnvironmentVariableAccessor.class);
    }

    @Bean
    public ProcessService processService() {
        return (ProcessService)OsgiServices.importOsgiService(ProcessService.class);
    }

    @Bean
    public EncryptionService encryptionService() {
        return (EncryptionService)OsgiServices.importOsgiService(EncryptionService.class, (ImportOptions)ImportOptions.defaultOptions().optional().withTimeout(OPTIONAL_TIMEOUT));
    }

    @Bean
    public I18nBeanFactory i18nBeanFactory() {
        return (I18nBeanFactory)OsgiServices.importOsgiService(I18nBeanFactory.class);
    }

    @Bean
    public CapabilitySetManager capabilitySetManager() {
        return (CapabilitySetManager)OsgiServices.importOsgiService(CapabilitySetManager.class, (ImportOptions)ImportOptions.defaultOptions().optional().withTimeout(OPTIONAL_TIMEOUT));
    }

    @Bean
    public CustomVariableContext customVariableContext() {
        return (CustomVariableContext)OsgiServices.importOsgiService(CustomVariableContext.class);
    }

    @Bean
    public VariableDefinitionFactory variableDefinitionFactory() {
        return (VariableDefinitionFactory)OsgiServices.importOsgiService(VariableDefinitionFactory.class, (ImportOptions)ImportOptions.defaultOptions().optional().withTimeout(OPTIONAL_TIMEOUT));
    }

    @Bean
    public VariableDefinitionManager variableDefinitionManager() {
        return (VariableDefinitionManager)OsgiServices.importOsgiService(VariableDefinitionManager.class, (ImportOptions)ImportOptions.defaultOptions().optional().withTimeout(OPTIONAL_TIMEOUT));
    }

    @Conditional(value={NotRemoteAgentCondition.class})
    @Bean
    public PowerShellCapabilityTrigger powerShellCapabilityTrigger(CapabilitySetManager capabilitySetManager) {
        return new PowerShellCapabilityTrigger(capabilitySetManager);
    }
}

