/*
 * Decompiled with CFR 0.152.
 */
package com.stellarity.bamboo.task;

import com.atlassian.bamboo.collections.ActionParametersMap;
import com.atlassian.bamboo.crypto.instance.SecretEncryptionService;
import com.atlassian.bamboo.security.EncryptionService;
import com.atlassian.bamboo.task.AbstractTaskConfigurator;
import com.atlassian.bamboo.task.TaskDefinition;
import com.atlassian.bamboo.task.TaskRequirementSupport;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.atlassian.bamboo.utils.i18n.I18nBean;
import com.atlassian.bamboo.utils.i18n.I18nBeanFactory;
import com.atlassian.bamboo.v2.build.agent.capability.Requirement;
import com.atlassian.bamboo.v2.build.agent.capability.RequirementImpl;
import com.stellarity.bamboo.task.PowerShellTaskData;
import com.stellarity.bamboo.utils.LicenseChecker;
import com.stellarity.bamboo.utils.MigratingEncryptor;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nullable;

public class PowerShellTaskConfigurator
extends AbstractTaskConfigurator
implements TaskRequirementSupport {
    private static final String LOCATION_LIST_KEY = "psLocationList";
    private static final String LOAD_PROFILE_LIST_KEY = "psLoadProfileList";
    private static final String BITNESS_LIST_KEY = "psBitnessList";
    private final I18nBean i18nBean;
    private final LicenseChecker licenseChecker = new LicenseChecker(((Object)((Object)this)).getClass(), "Stellarity Software - PowerShell Task");
    private final MigratingEncryptor migratingEncryptor;

    public PowerShellTaskConfigurator(I18nBeanFactory i18nBeanFactory, EncryptionService encryptionService, SecretEncryptionService secretEncryptionService) {
        this.i18nBean = i18nBeanFactory.getI18nBean();
        this.migratingEncryptor = new MigratingEncryptor(secretEncryptionService, encryptionService);
    }

    public Map<String, String> generateTaskConfigMap(ActionParametersMap params, @Nullable TaskDefinition previousTaskDefinition) {
        Map config = super.generateTaskConfigMap(params, previousTaskDefinition);
        PowerShellTaskData data = new PowerShellTaskData(params, previousTaskDefinition, this.migratingEncryptor);
        data.populateTaskConfigMap(config);
        return config;
    }

    public void populateContextForCreate(Map<String, Object> context) {
        PowerShellTaskData.populateTaskConfigMapDefaut(context);
        context.put(LOCATION_LIST_KEY, this.getLocations());
        context.put(LOAD_PROFILE_LIST_KEY, this.getLoadProfiles());
        context.put(BITNESS_LIST_KEY, this.getBitnessList());
    }

    public void populateContextForEdit(Map<String, Object> context, TaskDefinition taskDefinition) {
        PowerShellTaskData taskData = new PowerShellTaskData(taskDefinition.getConfiguration());
        taskData.populateTaskConfigMap(context);
        context.put(LOCATION_LIST_KEY, this.getLocations());
        context.put(LOAD_PROFILE_LIST_KEY, this.getLoadProfiles());
        context.put(BITNESS_LIST_KEY, this.getBitnessList());
    }

    public void validate(ActionParametersMap params, ErrorCollection errorCollection) {
        super.validate(params, errorCollection);
        new PowerShellTaskData(params, null, this.migratingEncryptor).validate(errorCollection, this.i18nBean);
        String licenseError = this.licenseChecker.getLicenseError();
        if (null != licenseError) {
            errorCollection.addErrorMessage(licenseError);
        }
    }

    private List<Map.Entry<String, String>> getLocations() {
        return Arrays.stream(PowerShellTaskData.ScriptLocation.values()).map(x -> new AbstractMap.SimpleImmutableEntry<String, String>(x.toString(), this.i18nBean.getText(x.i18n()))).map(x -> x).collect(Collectors.toList());
    }

    private List<Map.Entry<String, String>> getLoadProfiles() {
        return Arrays.stream(PowerShellTaskData.LoadProfile.values()).map(x -> new AbstractMap.SimpleImmutableEntry<String, String>(x.toString(), this.i18nBean.getText(x.i18n()))).map(x -> x).collect(Collectors.toList());
    }

    private List<Map.Entry<String, String>> getBitnessList() {
        return Arrays.stream(PowerShellTaskData.Bitness.values()).map(x -> new AbstractMap.SimpleImmutableEntry<String, String>(x.toString(), this.i18nBean.getText(x.i18n()))).map(x -> x).collect(Collectors.toList());
    }

    public Set<Requirement> calculateRequirements(TaskDefinition taskDefinition) {
        PowerShellTaskData taskData = new PowerShellTaskData(taskDefinition.getConfiguration());
        String requirement = "";
        switch (taskData.getBitness()) {
            case ANY: {
                requirement = "system.builder.stellarity-powershell.PowerShell";
                break;
            }
            case X86: {
                requirement = "system.builder.stellarity-powershell.PowerShell (32-bit)";
                break;
            }
            case X64: {
                requirement = "system.builder.stellarity-powershell.PowerShell (64-bit)";
            }
        }
        return Collections.singleton(new RequirementImpl(requirement, true, ".*"));
    }
}

