/*
 * Decompiled with CFR 0.152.
 */
package com.stellarity.bamboo.task;

import com.stellarity.bamboo.task.PowerShellTaskData;
import com.stellarity.bamboo.utils.MigratingEncryptor;
import java.util.Collections;
import java.util.Map;

public class PowerShellRuntimeData {
    private static final String PASSWORD_KEY = "PowerShellRuntimeData.password";
    private final String password;

    private PowerShellRuntimeData(String password) {
        this.password = password;
    }

    public PowerShellRuntimeData(PowerShellTaskData data, MigratingEncryptor encryptionService) {
        this.password = encryptionService.decrypt(data.getEncryptedPassword());
    }

    public String getPassword() {
        return this.password;
    }

    public Map<String, String> toMap() {
        return Collections.singletonMap(PASSWORD_KEY, this.password);
    }

    public static PowerShellRuntimeData fromMap(Map<String, String> map) {
        return new PowerShellRuntimeData(map.getOrDefault(PASSWORD_KEY, ""));
    }
}

