/*
 * Decompiled with CFR 0.152.
 */
package com.stellarity.bamboo.task;

import com.atlassian.bamboo.v2.build.agent.capability.Capability;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilityDefaultsHelper;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilityImpl;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilitySet;
import com.stellarity.bamboo.task.PowerShellLocator;
import java.io.File;
import java.io.IOException;
import org.apache.commons.lang3.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PowerShellCapabilityDefaultsHelper
implements CapabilityDefaultsHelper {
    private static final Logger LOG = LoggerFactory.getLogger(PowerShellCapabilityDefaultsHelper.class);
    private static final String EXECUTABLE_KEY = ".stellarity-powershell.";
    public static final String POWERSHELL_CAPABILITY_ANY = "system.builder.stellarity-powershell.PowerShell";
    public static final String POWERSHELL_CAPABILITY_X86 = "system.builder.stellarity-powershell.PowerShell (32-bit)";
    public static final String POWERSHELL_CAPABILITY_X64 = "system.builder.stellarity-powershell.PowerShell (64-bit)";

    public CapabilitySet addDefaultCapabilities(CapabilitySet capabilitySet) {
        capabilitySet.removeCapability(POWERSHELL_CAPABILITY_ANY);
        capabilitySet.removeCapability(POWERSHELL_CAPABILITY_X86);
        capabilitySet.removeCapability(POWERSHELL_CAPABILITY_X64);
        if (SystemUtils.IS_OS_WINDOWS) {
            if (PowerShellCapabilityDefaultsHelper.detectExecutable(PowerShellLocator.getWinPath(PowerShellLocator.Bitness.ANY))) {
                capabilitySet.addCapability((Capability)new CapabilityImpl(POWERSHELL_CAPABILITY_ANY, "<yes>"));
            }
            if (PowerShellCapabilityDefaultsHelper.detectExecutable(PowerShellLocator.getWinPath(PowerShellLocator.Bitness.X86))) {
                capabilitySet.addCapability((Capability)new CapabilityImpl(POWERSHELL_CAPABILITY_X86, "<yes>"));
            }
            if (PowerShellCapabilityDefaultsHelper.detectExecutable(PowerShellLocator.getWinPath(PowerShellLocator.Bitness.X64))) {
                capabilitySet.addCapability((Capability)new CapabilityImpl(POWERSHELL_CAPABILITY_X64, "<yes>"));
            }
        } else {
            try {
                boolean powershellExists;
                boolean bl = powershellExists = !PowerShellLocator.getNixPath().isEmpty();
                if (powershellExists) {
                    capabilitySet.addCapability((Capability)new CapabilityImpl(POWERSHELL_CAPABILITY_ANY, "<yes>"));
                    if (PowerShellCapabilityDefaultsHelper.isX64()) {
                        capabilitySet.addCapability((Capability)new CapabilityImpl(POWERSHELL_CAPABILITY_X64, "<yes>"));
                    } else {
                        capabilitySet.addCapability((Capability)new CapabilityImpl(POWERSHELL_CAPABILITY_X86, "<yes>"));
                    }
                }
            }
            catch (IOException | InterruptedException exception) {
                // empty catch block
            }
        }
        return capabilitySet;
    }

    private static boolean detectExecutable(String path) {
        return new File(path).canExecute();
    }

    private static boolean isX64() {
        return System.getProperty("os.arch").contains("64");
    }
}

