[#import "/lib/ace.ftl" as ace]

[@ww.select
        labelKey='powershell.script.location'
        listKey='key'
        listValue='value'
        list='psLocationList'
        name='psLocation'
        toggle=true /]

[@ui.bambooSection dependsOn='psLocation' showOn='FILE']
    [@ww.textfield labelKey='powershell.script.file' name='psFile' required=true cssClass='long-field' /]
[/@ui.bambooSection]

[@ui.bambooSection dependsOn='psLocation' showOn='BODY']
    [@ace.textarea labelKey='powershell.script.body' name='psBody' required=true /]

    [#assign resourcePath=webResourceManager.getStaticPluginResource("com.stellarity.bamboo.powershell-task:powerShellAce", "") /]
    [#if resourcePath?ends_with("/")]
        [#assign resourcePath=resourcePath?substring(0, resourcePath?length - 1) /]
    [/#if]

    <script src=${"${resourcePath}/ace-extras.js"}></script>

    <script>
        ace.config.set("modePath", "${resourcePath}");
        psBody_ref.getSession().setMode("ace/mode/powershell-stellarity");
    </script>
[/@ui.bambooSection]

[@ww.textfield labelKey='powershell.arguments' name='psArguments' cssClass='long-field' /]
[@ww.textfield labelKey='powershell.environment' name='psEnvironment' cssClass='long-field' /]
[@ww.textfield labelKey='powershell.subdirectory' name='psSubdirectory' cssClass='long-field' /]
    
[@ui.bambooSection titleKey='powershell.advancedOptions' collapsible=true]
    [@ww.select labelKey='powershell.bitness' name='psBitness' listKey='key' listValue='value' list='psBitnessList' /]
    [@ww.select labelKey='powershell.loadProfile' name='psLoadProfile' listKey='key' listValue='value' list='psLoadProfileList' /]    

    [@ww.checkbox labelKey='powershell.runAsUser' name='psRunAsUser' toggle=true /]

    [@ui.bambooSection dependsOn='psRunAsUser' showOn='true']
        [@ww.textfield labelKey='powershell.username' name='psUsername' autocomplete='new-password' /]
        [#if psPassword?has_content]
            [@ww.checkbox labelKey='powershell.passwordChange' name='psPasswordChange' toggle=true /]
            [@ui.bambooSection dependsOn='psPasswordChange' showOn='true']
                [@ww.password labelKey='powershell.password' name='psPlainPassword' autocomplete='new-password' /]
            [/@ui.bambooSection]
        [#else]
            [@ww.hidden name='psPasswordChange' value='true' /]            
            [@ww.password labelKey='powershell.password' name='psPlainPassword' autocomplete='new-password' /]
        [/#if]
    [/@ui.bambooSection]
[/@ui.bambooSection]