/*
 * Decompiled with CFR 0.152.
 */
package com.stellarity.bamboo.task;

import com.atlassian.bamboo.collections.ActionParametersMap;
import com.atlassian.bamboo.task.TaskDefinition;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.atlassian.bamboo.utils.i18n.I18nBean;
import com.stellarity.bamboo.utils.MigratingEncryptor;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;

public class PowerShellTaskData {
    private static final String SCRIPT_FILE_ERROR_I18N = "powershell.script.file.error";
    private static final String SCRIPT_BODY_ERROR_I18N = "powershell.script.body.error";
    private final String arguments;
    private final String environment;
    private final String subdirectory;
    private final String body;
    private final String file;
    private final ScriptLocation location;
    private final LoadProfile loadProfile;
    private final Bitness bitness;
    private final String runAsUser;
    private final String username;
    private final String encryptedPassword;

    public PowerShellTaskData(ActionParametersMap params, @Nullable TaskDefinition previousTaskDefinition, MigratingEncryptor encryptionService) {
        if (params.containsKey((Object)"psLocation")) {
            this.arguments = params.getString("psArguments");
            this.environment = params.getString("psEnvironment");
            this.subdirectory = params.getString("psSubdirectory");
            this.body = params.getString("psBody");
            this.file = params.getString("psFile");
            this.location = ScriptLocation.valueOf(params.getString("psLocation"));
            this.loadProfile = LoadProfile.valueOf(params.getString("psLoadProfile", LoadProfile.DEFAULT.toString()));
            this.bitness = Bitness.valueOf(params.getString("psBitness", Bitness.ANY.toString()));
            this.runAsUser = params.getString("psRunAsUser");
            this.username = params.getString("psUsername");
            this.encryptedPassword = !params.getBoolean("psPasswordChange") && null != previousTaskDefinition ? (String)previousTaskDefinition.getConfiguration().get("psPassword") : encryptionService.encrypt(params.getString("psPlainPassword", ""));
        } else {
            this.arguments = params.getString("arguments");
            this.environment = params.getString("environment");
            this.subdirectory = params.getString("subdirectory");
            this.body = params.getString("body");
            this.file = params.getString("file");
            this.location = ScriptLocation.valueOf(params.getString("location"));
            this.loadProfile = LoadProfile.DEFAULT;
            this.bitness = Bitness.ANY;
            this.runAsUser = "";
            this.username = "";
            this.encryptedPassword = "";
        }
    }

    public PowerShellTaskData(Map<String, String> configurationMap) {
        if (configurationMap.containsKey("psLocation")) {
            this.arguments = configurationMap.get("psArguments");
            this.environment = configurationMap.get("psEnvironment");
            this.subdirectory = configurationMap.get("psSubdirectory");
            this.body = configurationMap.get("psBody");
            this.file = configurationMap.get("psFile");
            this.location = ScriptLocation.valueOf(configurationMap.get("psLocation"));
        } else {
            this.arguments = configurationMap.get("arguments");
            this.environment = configurationMap.get("environment");
            this.subdirectory = configurationMap.get("subdirectory");
            this.body = configurationMap.get("body");
            this.file = configurationMap.get("file");
            this.location = ScriptLocation.valueOf(configurationMap.get("location"));
        }
        this.loadProfile = configurationMap.get("psLoadProfile") != null ? LoadProfile.valueOf(configurationMap.get("psLoadProfile")) : LoadProfile.DEFAULT;
        this.bitness = configurationMap.get("psBitness") != null ? Bitness.valueOf(configurationMap.get("psBitness")) : Bitness.ANY;
        this.runAsUser = configurationMap.get("psRunAsUser") != null ? configurationMap.get("psRunAsUser") : "";
        this.username = configurationMap.get("psUsername") != null ? configurationMap.get("psUsername") : "";
        this.encryptedPassword = configurationMap.get("psPassword") != null ? configurationMap.get("psPassword") : "";
    }

    public String getArguments() {
        return StringUtils.defaultString((String)this.arguments);
    }

    public String getEnvironment() {
        return StringUtils.defaultString((String)this.environment);
    }

    public String getSubdirectory() {
        return StringUtils.defaultString((String)this.subdirectory);
    }

    public String getBody() {
        return this.body;
    }

    public String getFile() {
        return this.file;
    }

    public ScriptLocation getLocation() {
        return this.location;
    }

    public LoadProfile getLoadProfile() {
        return this.loadProfile;
    }

    public Bitness getBitness() {
        return this.bitness;
    }

    public boolean getRunAsUser() {
        return Boolean.parseBoolean(this.runAsUser);
    }

    public String getUsername() {
        return this.username;
    }

    public String getEncryptedPassword() {
        return this.encryptedPassword;
    }

    public void validate(ErrorCollection errorCollection, I18nBean i18nBean) {
        String stringToCheck = null;
        String key = null;
        String error = null;
        switch (this.location) {
            case FILE: {
                stringToCheck = this.file;
                key = "psFile";
                error = SCRIPT_FILE_ERROR_I18N;
                break;
            }
            case BODY: {
                stringToCheck = this.body;
                key = "psBody";
                error = SCRIPT_BODY_ERROR_I18N;
            }
        }
        if (StringUtils.isEmpty(stringToCheck) && null != key) {
            errorCollection.addError(key, i18nBean.getText(error));
        }
    }

    public void populateTaskConfigMap(Map<String, ? super String> map) {
        map.put("psArguments", this.arguments);
        map.put("psEnvironment", this.environment);
        map.put("psSubdirectory", this.subdirectory);
        map.put("psBody", this.body);
        map.put("psFile", this.file);
        map.put("psLocation", this.location.toString());
        map.put("psLoadProfile", this.loadProfile.toString());
        map.put("psBitness", this.bitness.toString());
        map.put("psRunAsUser", this.runAsUser);
        map.put("psUsername", this.username);
        map.put("psPassword", this.encryptedPassword);
        for (String legacyKey : LEGACY.KEYS) {
            map.remove(legacyKey);
        }
    }

    public static void populateTaskConfigMapDefaut(Map<String, ? super String> map) {
        map.put("psLocation", ScriptLocation.BODY.toString());
    }

    public static enum Bitness {
        ANY("ANY", "powershell.bitness.any"),
        X86("X86", "powershell.bitness.x86"),
        X64("X64", "powershell.bitness.x64");

        private final String name;
        private final String i18n;

        private Bitness(String name, String i18n) {
            this.name = name;
            this.i18n = i18n;
        }

        public String toString() {
            return this.name;
        }

        public String i18n() {
            return this.i18n;
        }
    }

    public static enum LoadProfile {
        DEFAULT("DEFAULT", "powershell.loadProfile.default"),
        YES("YES", "powershell.loadProfile.yes"),
        NO("NO", "powershell.loadProfile.no");

        private final String name;
        private final String i18n;

        private LoadProfile(String name, String i18n) {
            this.name = name;
            this.i18n = i18n;
        }

        public String toString() {
            return this.name;
        }

        public String i18n() {
            return this.i18n;
        }
    }

    public static enum ScriptLocation {
        FILE("FILE", "powershell.script.location.file"),
        BODY("BODY", "powershell.script.location.body");

        private final String name;
        private final String i18n;

        private ScriptLocation(String name, String i18n) {
            this.name = name;
            this.i18n = i18n;
        }

        public String toString() {
            return this.name;
        }

        public String i18n() {
            return this.i18n;
        }
    }

    private static final class NOW {
        public static final String ARGUMENTS_KEY = "psArguments";
        public static final String ENVIRONMENT_KEY = "psEnvironment";
        public static final String SUBDIRECTORY_KEY = "psSubdirectory";
        public static final String SCRIPT_BODY_KEY = "psBody";
        public static final String SCRIPT_FILE_KEY = "psFile";
        public static final String SCRIPT_LOCATION_KEY = "psLocation";
        public static final String LOAD_PROFILE_KEY = "psLoadProfile";
        public static final String BITNESS_KEY = "psBitness";
        public static final String RUN_AS_USER_KEY = "psRunAsUser";
        public static final String USERNAME_KEY = "psUsername";
        public static final String PASSWORD_KEY = "psPassword";
        public static final String PLAIN_PASSWORD_KEY = "psPlainPassword";
        public static final String PASSWORD_CHANGE_KEY = "psPasswordChange";

        private NOW() {
        }
    }

    private static final class LEGACY {
        public static final String ARGUMENTS_KEY = "arguments";
        public static final String ENVIRONMENT_KEY = "environment";
        public static final String SUBDIRECTORY_KEY = "subdirectory";
        public static final String SCRIPT_BODY_KEY = "body";
        public static final String SCRIPT_FILE_KEY = "file";
        public static final String SCRIPT_LOCATION_KEY = "location";
        public static final List<String> KEYS = Arrays.asList("arguments", "environment", "subdirectory", "body", "file", "location");

        private LEGACY() {
        }
    }
}

