/*
 * Decompiled with CFR 0.152.
 */
package com.stellarity.bamboo.task;

import com.atlassian.bamboo.build.logger.BuildLogger;
import com.atlassian.bamboo.build.logger.LogInterceptor;
import com.atlassian.bamboo.build.logger.interceptors.ErrorMemorisingInterceptor;
import com.atlassian.bamboo.process.EnvironmentVariableAccessor;
import com.atlassian.bamboo.process.ExternalProcessBuilder;
import com.atlassian.bamboo.process.ProcessService;
import com.atlassian.bamboo.task.CommonTaskContext;
import com.atlassian.bamboo.task.CommonTaskType;
import com.atlassian.bamboo.task.TaskException;
import com.atlassian.bamboo.task.TaskResult;
import com.atlassian.bamboo.task.TaskResultBuilder;
import com.atlassian.bamboo.v2.build.CommonContext;
import com.atlassian.bamboo.variable.CustomVariableContext;
import com.atlassian.bamboo.variable.VariableDefinitionContext;
import com.atlassian.utils.process.ExternalProcess;
import com.stellarity.bamboo.task.BitnessUtils;
import com.stellarity.bamboo.task.PowerShellLocator;
import com.stellarity.bamboo.task.PowerShellRuntimeData;
import com.stellarity.bamboo.task.PowerShellSettings;
import com.stellarity.bamboo.task.PowerShellTaskData;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PowerShellTask
implements CommonTaskType {
    private static final String POWERSHELL_EXTENSION = ".ps1";
    private static final String CMD_EXTENSION = ".cmd";
    private static final String SHELL_EXTENSION = ".sh";
    private static final Logger LOG = LoggerFactory.getLogger(PowerShellTask.class);
    private final EnvironmentVariableAccessor environmentVariableAccessor;
    private final ProcessService processService;
    private final CustomVariableContext customVariableContext;

    public PowerShellTask(EnvironmentVariableAccessor environmentVariableAccessor, ProcessService processService, CustomVariableContext customVariableContext) {
        this.environmentVariableAccessor = environmentVariableAccessor;
        this.processService = processService;
        this.customVariableContext = customVariableContext;
    }

    public TaskResult execute(CommonTaskContext taskContext) throws TaskException {
        BuildLogger buildLogger = taskContext.getBuildLogger();
        PowerShellTaskData data = new PowerShellTaskData((Map<String, String>)taskContext.getConfigurationMap());
        PowerShellRuntimeData rdata = PowerShellRuntimeData.fromMap(taskContext.getRuntimeTaskContext());
        File workDir = new File(taskContext.getWorkingDirectory().getPath() + File.separator + data.getSubdirectory());
        Map environment = this.environmentVariableAccessor.getEnvironment(taskContext);
        environment.putAll(this.environmentVariableAccessor.splitEnvironmentAssignments(data.getEnvironment(), false));
        ArrayList<File> fileCleanupList = new ArrayList<File>();
        ErrorMemorisingInterceptor errorLines = new ErrorMemorisingInterceptor();
        buildLogger.getInterceptorStack().add((LogInterceptor)errorLines);
        CommonContext context = taskContext.getCommonContext();
        File tmpDir = data.getRunAsUser() ? taskContext.getRootDirectory().getParentFile() : null;
        try {
            List<String> commands;
            File cmdFile;
            String cmdFileContent;
            String powerShellPath;
            Validate.isTrue((boolean)workDir.isDirectory(), (String)("Working directory (" + workDir.getAbsolutePath() + ") doesn't exist."), (Object[])new Object[0]);
            File powershellFile = null;
            switch (data.getLocation()) {
                case FILE: {
                    powershellFile = new File(data.getFile());
                    if (!powershellFile.isAbsolute()) {
                        powershellFile = new File(workDir, data.getFile());
                    }
                    if (StringUtils.endsWithIgnoreCase((CharSequence)powershellFile.getName(), (CharSequence)POWERSHELL_EXTENSION)) break;
                    throw new Exception("Wrong script extension (expecting *.ps1).");
                }
                case BODY: {
                    powershellFile = this.createTempFile(context, data.getBody(), POWERSHELL_EXTENSION, tmpDir, "UTF-16");
                    fileCleanupList.add(powershellFile);
                }
            }
            Validate.notNull(powershellFile, (String)"Internal error, powershell script file is null.", (Object[])new Object[0]);
            Validate.isTrue((boolean)powershellFile.isFile(), (String)("Powershell script file doesn't exist (" + powershellFile.getAbsolutePath() + ")."), (Object[])new Object[0]);
            String variablesFileContent = this.createPowerShellVariables(environment);
            File variablesFile = this.createTempFile(context, variablesFileContent, POWERSHELL_EXTENSION, tmpDir, "UTF-16");
            fileCleanupList.add(variablesFile);
            boolean isToLoadProfile = this.isToLoadProfile(data);
            buildLogger.addBuildLogEntry("Loading the current user profile: " + (isToLoadProfile ? "YES" : "NO"));
            String string = powerShellPath = SystemUtils.IS_OS_WINDOWS ? PowerShellLocator.getWinPath(PowerShellLocator.Bitness.valueOf(data.getBitness().toString())) : PowerShellLocator.getNixPath();
            if (powerShellPath.isEmpty()) {
                throw new TaskException("Cannot locate PowerShell executable.");
            }
            buildLogger.addBuildLogEntry("Requested bitness: " + data.getBitness().toString());
            if (!SystemUtils.IS_OS_WINDOWS && data.getBitness() != PowerShellTaskData.Bitness.ANY) {
                buildLogger.addBuildLogEntry("Warning: bitness is ignored on non-Windows OS");
            }
            String loadProfileSwitch = isToLoadProfile ? "" : " -NoProfile";
            String arguments = this.escapeCommandLine(data.getArguments());
            if (SystemUtils.IS_OS_WINDOWS) {
                cmdFileContent = "@" + powerShellPath + " " + loadProfileSwitch + " -NoLogo -NonInteractive -ExecutionPolicy Bypass \"&{$ErrorActionPreference=1;. '" + variablesFile.getAbsolutePath() + "';&'" + powershellFile.getAbsolutePath() + "' " + arguments + ";exit $LASTEXITCODE}\" < NUL";
                cmdFile = this.createTempFile(context, cmdFileContent, CMD_EXTENSION, tmpDir, null);
                fileCleanupList.add(cmdFile);
                commands = Arrays.asList(cmdFile.getAbsolutePath());
                if (data.getRunAsUser()) {
                    buildLogger.addBuildLogEntry("Starting PowerShell as user: " + this.customVariableContext.substituteString(data.getUsername()));
                    File runAsFile = this.createTempFile(context, this.getRunAsResourcePath(), tmpDir);
                    fileCleanupList.add(runAsFile);
                    String runAsConfigContent = "user = " + this.customVariableContext.substituteString(data.getUsername()) + "\npassword = " + this.customVariableContext.substituteString(rdata.getPassword()) + "\ncommand = cmd.exe /c " + cmdFile.getAbsolutePath();
                    File runAsConfigFile = this.createTempFile(context, runAsConfigContent, null, tmpDir, "UTF-8");
                    fileCleanupList.add(runAsConfigFile);
                    commands = Arrays.asList(runAsFile.getAbsolutePath(), "runconfig", runAsConfigFile.getAbsolutePath());
                }
            } else {
                if (data.getRunAsUser()) {
                    buildLogger.addBuildLogEntry("Warning: run as user is ignored on non-Windows OS");
                }
                cmdFileContent = powerShellPath + " " + loadProfileSwitch + " -NoLogo -NonInteractive -ExecutionPolicy Bypass -Command \"&{\\$ErrorActionPreference=1;. '" + variablesFile.getAbsolutePath() + "';&'" + powershellFile.getAbsolutePath() + "' " + arguments + ";exit \\$LASTEXITCODE}\"";
                cmdFile = this.createTempFile(context, cmdFileContent, SHELL_EXTENSION, tmpDir, null);
                fileCleanupList.add(cmdFile);
                cmdFile.setExecutable(true);
                commands = Arrays.asList(cmdFile.getAbsolutePath());
            }
            ExternalProcess process = this.processService.executeExternalProcess(taskContext, new ExternalProcessBuilder().command(commands).workingDirectory(workDir));
            if (process.getHandler().isComplete()) {
                TaskResultBuilder taskResultBuilder = TaskResultBuilder.newBuilder((CommonTaskContext)taskContext).checkReturnCode(process);
                TaskResult taskResult = taskResultBuilder.build();
                return taskResult;
            }
            try {
                throw new TaskException("Failed to execute the command (external process not completed?).");
            }
            catch (Exception e) {
                throw new TaskException(e.getMessage(), (Throwable)e);
            }
        }
        finally {
            for (File file : fileCleanupList) {
                FileUtils.deleteQuietly((File)file);
            }
            context.getCurrentResult().addBuildErrors(errorLines.getErrorStringList());
        }
    }

    private File createTempFile(CommonContext commonContext, String body, String extension, @Nullable File directory, @Nullable String encoding) throws IOException {
        String prefix = commonContext.getResultKey().getKey() + "-" + this.getClass().getSimpleName() + "-";
        File file = File.createTempFile(prefix, extension, directory);
        FileUtils.writeStringToFile((File)file, (String)body, (String)encoding);
        return file;
    }

    private File createTempFile(CommonContext commonContext, String resourcePath, @Nullable File directory) throws IOException {
        String prefix = commonContext.getResultKey().getKey() + "-" + this.getClass().getSimpleName() + "-";
        File file = File.createTempFile(prefix, "." + FilenameUtils.getExtension((String)resourcePath), directory);
        FileUtils.copyURLToFile((URL)this.getClass().getResource(resourcePath), (File)file);
        return file;
    }

    private String createPowerShellVariables(Map<String, String> environment) {
        StringBuilder result = new StringBuilder();
        Map bambooVariables = this.customVariableContext.getVariableContexts();
        for (Map.Entry entry : bambooVariables.entrySet()) {
            result.append("${bamboo.").append(((String)entry.getKey()).replace(":", ".")).append("}='").append(this.escapePowerShell(((VariableDefinitionContext)entry.getValue()).getValue())).append("';");
        }
        for (Map.Entry<Object, Object> entry : environment.entrySet()) {
            result.append("[System.Environment]::SetEnvironmentVariable('").append((String)entry.getKey()).append("','").append(this.escapePowerShell((String)entry.getValue())).append("');");
        }
        return result.toString();
    }

    private boolean isToLoadProfile(PowerShellTaskData data) {
        switch (data.getLoadProfile()) {
            case DEFAULT: {
                return PowerShellSettings.getLoadProfile(this.customVariableContext.getVariableContexts());
            }
            case YES: {
                return true;
            }
        }
        return false;
    }

    private String getRunAsResourcePath() {
        return BitnessUtils.isX64() ? "/com/stellarity/bamboo/task/powershell/runAs/x64/Stellarity.runAs.exe" : "/com/stellarity/bamboo/task/powershell/runAs/x86/Stellarity.runAs.exe";
    }

    private String escapeCommandLine(String str) {
        return SystemUtils.IS_OS_WINDOWS ? str.replace("\"", "\\\"") : str.replace("\\", "\\\\").replace("\"", "\\\"");
    }

    private String escapePowerShell(String str) {
        return str.replace("'", "''").replace("\"", "\"\"");
    }
}

