/*
 * Decompiled with CFR 0.152.
 */
package com.stellarity.bamboo.task;

import com.atlassian.bamboo.variable.VariableDefinition;
import com.atlassian.bamboo.variable.VariableDefinitionContext;
import com.atlassian.bamboo.variable.VariableDefinitionFactory;
import com.atlassian.bamboo.variable.VariableDefinitionManager;
import java.util.Map;

public class PowerShellSettings {
    private static final String LOAD_PROFILE_KEY = "com.stellarity.PowerShellTask:LoadProfile";
    private final VariableDefinitionManager variableDefinitionManager;
    private final VariableDefinitionFactory variableDefinitionFactory;

    public PowerShellSettings(VariableDefinitionManager variableDefinitionManager, VariableDefinitionFactory variableDefinitionFactory) {
        this.variableDefinitionManager = variableDefinitionManager;
        this.variableDefinitionFactory = variableDefinitionFactory;
    }

    public void setLoadProfile(boolean value) {
        VariableDefinition vd = this.variableDefinitionManager.getGlobalVariableByKey(LOAD_PROFILE_KEY);
        if (value) {
            if (null == vd) {
                vd = this.variableDefinitionFactory.createGlobalVariable(LOAD_PROFILE_KEY, Boolean.toString(value));
            }
            this.variableDefinitionManager.saveVariableDefinition(vd);
        } else if (null != vd) {
            this.variableDefinitionManager.deleteVariableDefinition(vd);
        }
    }

    public boolean getLoadProfile() {
        VariableDefinition vd = this.variableDefinitionManager.getGlobalVariableByKey(LOAD_PROFILE_KEY);
        return vd != null ? Boolean.parseBoolean(vd.getValue()) : false;
    }

    public static boolean getLoadProfile(Map<String, VariableDefinitionContext> bambooVariables) {
        VariableDefinitionContext variableDefinitionCtx = bambooVariables.get(LOAD_PROFILE_KEY);
        return null == variableDefinitionCtx ? false : Boolean.parseBoolean(variableDefinitionCtx.getValue());
    }
}

