/*
 * Decompiled with CFR 0.152.
 */
package com.stellarity.bamboo.task;

import com.atlassian.bamboo.build.test.TestCollectionResult;
import com.atlassian.bamboo.build.test.TestCollectionResultBuilder;
import com.atlassian.bamboo.build.test.TestReportProvider;
import com.stellarity.bamboo.task.GoogleTestParser;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.ParserConfigurationException;
import org.jetbrains.annotations.Nullable;
import org.xml.sax.SAXException;

public class GoogleTestReportProvider
implements TestReportProvider {
    private final GoogleTestParser parser = new GoogleTestParser();
    private Throwable exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    GoogleTestReportProvider(File data, String suffix) {
        FileInputStream is = null;
        try {
            is = new FileInputStream(data);
            this.parser.parse(is, suffix);
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            this.exception = e;
        }
        finally {
            if (is != null) {
                try {
                    ((InputStream)is).close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public TestCollectionResult getTestCollectionResult() {
        TestCollectionResultBuilder builder = new TestCollectionResultBuilder();
        return builder.addSuccessfulTestResults(this.parser.getPassedTests()).addFailedTestResults(this.parser.getFailedTests()).addSkippedTestResults(this.parser.getSkippedTests()).build();
    }

    @Nullable
    public Throwable getException() {
        return this.exception;
    }
}

