/*
 * Decompiled with CFR 0.152.
 */
package com.stellarity.bamboo.task;

import com.atlassian.bamboo.configuration.DefaultContentHandler;
import com.atlassian.bamboo.configuration.DefaultElementParser;
import com.atlassian.bamboo.configuration.ElementParser;
import com.atlassian.bamboo.results.tests.TestResults;
import com.atlassian.bamboo.resultsummary.tests.TestCaseResultError;
import com.atlassian.bamboo.resultsummary.tests.TestCaseResultErrorImpl;
import com.atlassian.bamboo.resultsummary.tests.TestState;
import com.atlassian.bamboo.util.NumberUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class GoogleTestParser
extends DefaultContentHandler {
    private static final ElementParser DO_NOTHING_PARSER = new DefaultElementParser();
    private static final String PARSER_CLASS = "org.apache.xerces.parsers.SAXParser";
    private final Set<TestResults> failedTests = new LinkedHashSet<TestResults>();
    private final Set<TestResults> passedTests = new LinkedHashSet<TestResults>();
    private final Set<TestResults> skippedTests = new LinkedHashSet<TestResults>();
    private final StringBuilder modifiedTestSuiteName = new StringBuilder();
    private String testSuiteName;
    private String testCaseName;
    private String testCaseTime;
    private String testCaseStatus;
    private final List<String> testCaseMessages = new ArrayList<String>();
    private String suffix;

    public GoogleTestParser() {
        this.registerElementParser("testsuite", (ElementParser)new TestSuiteParser());
        this.registerElementParser("testcase", (ElementParser)new TestCaseParser());
        this.registerElementParser("failure", (ElementParser)new FailureParser());
    }

    public void parse(InputStream stream, String suffix) throws IOException, SAXException {
        this.failedTests.clear();
        this.passedTests.clear();
        this.skippedTests.clear();
        this.suffix = suffix.replace('.', '_');
        XMLReader reader = XMLReaderFactory.createXMLReader(PARSER_CLASS);
        reader.setContentHandler((ContentHandler)((Object)this));
        reader.parse(new InputSource(stream));
    }

    public Set<TestResults> getFailedTests() {
        return this.failedTests;
    }

    public Set<TestResults> getPassedTests() {
        return this.passedTests;
    }

    public Set<TestResults> getSkippedTests() {
        return this.skippedTests;
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (!this.hasParserFor(localName)) {
            this.registerElementParser(localName, DO_NOTHING_PARSER);
        }
        super.startElement(uri, localName, qName, attributes);
    }

    @Nullable
    private static Long toMilliseconds(@Nullable String durationInSeconds) {
        Double seconds = NumberUtils.createDoubleQuietly((String)durationInSeconds);
        return seconds == null ? null : Long.valueOf((long)(seconds * 1000.0));
    }

    class TestSuiteParser
    extends DefaultElementParser {
        TestSuiteParser() {
        }

        public void startElement(Attributes attributes) {
            GoogleTestParser.this.testSuiteName = attributes.getValue("name");
        }
    }

    class TestCaseParser
    extends DefaultElementParser {
        TestCaseParser() {
        }

        public void startElement(Attributes attributes) {
            GoogleTestParser.this.testCaseName = attributes.getValue("name").replaceFirst("^DISABLED_", "");
            GoogleTestParser.this.testCaseTime = attributes.getValue("time");
            GoogleTestParser.this.testCaseStatus = attributes.getValue("status");
            String testCaseValueParam = attributes.getValue("value_param");
            String testCaseTypeParam = attributes.getValue("type_param");
            if (null != testCaseValueParam) {
                GoogleTestParser.this.testCaseName = GoogleTestParser.this.testCaseName + (" [" + testCaseValueParam + "]");
            }
            GoogleTestParser.this.modifiedTestSuiteName.setLength(0);
            GoogleTestParser.this.modifiedTestSuiteName.append(GoogleTestParser.this.testSuiteName);
            if (null != testCaseTypeParam) {
                GoogleTestParser.this.modifiedTestSuiteName.append(" [");
                GoogleTestParser.this.modifiedTestSuiteName.append(testCaseTypeParam);
                GoogleTestParser.this.modifiedTestSuiteName.append("]");
            }
            if (!GoogleTestParser.this.suffix.isEmpty()) {
                GoogleTestParser.this.modifiedTestSuiteName.append(" {");
                GoogleTestParser.this.modifiedTestSuiteName.append(GoogleTestParser.this.suffix);
                GoogleTestParser.this.modifiedTestSuiteName.append("}");
            }
        }

        public void endElement() {
            TestResults results = new TestResults(GoogleTestParser.this.modifiedTestSuiteName.toString(), GoogleTestParser.this.testCaseName, GoogleTestParser.toMilliseconds(GoogleTestParser.this.testCaseTime));
            if (StringUtils.equals((CharSequence)GoogleTestParser.this.testCaseStatus, (CharSequence)"notrun")) {
                results.setState(TestState.SKIPPED);
                GoogleTestParser.this.skippedTests.add(results);
            } else if (!GoogleTestParser.this.testCaseMessages.isEmpty()) {
                for (String message : GoogleTestParser.this.testCaseMessages) {
                    results.addError((TestCaseResultError)new TestCaseResultErrorImpl(message + "\r"));
                }
                results.setState(TestState.FAILED);
                GoogleTestParser.this.failedTests.add(results);
            } else {
                results.setState(TestState.SUCCESS);
                GoogleTestParser.this.passedTests.add(results);
            }
            GoogleTestParser.this.testCaseName = null;
            GoogleTestParser.this.testCaseTime = null;
            GoogleTestParser.this.testCaseStatus = null;
            GoogleTestParser.this.testCaseMessages.clear();
            GoogleTestParser.this.modifiedTestSuiteName.setLength(0);
        }
    }

    class FailureParser
    extends DefaultElementParser {
        FailureParser() {
        }

        public void startElement(Attributes attributes) {
            GoogleTestParser.this.testCaseMessages.add(attributes.getValue("message"));
        }
    }
}

