/*
 * Decompiled with CFR 0.152.
 */
package com.stellarity.bamboo.task;

import com.atlassian.bamboo.build.BuildOutputLogEntry;
import com.atlassian.bamboo.build.LogEntry;
import com.atlassian.bamboo.build.logger.BuildLogger;
import com.atlassian.bamboo.build.logger.LogInterceptor;
import com.atlassian.bamboo.build.logger.interceptors.ErrorMemorisingInterceptor;
import com.atlassian.bamboo.build.test.TestCollationService;
import com.atlassian.bamboo.build.test.TestReportProvider;
import com.atlassian.bamboo.process.EnvironmentVariableAccessor;
import com.atlassian.bamboo.task.TaskContext;
import com.atlassian.bamboo.task.TaskException;
import com.atlassian.bamboo.task.TaskResult;
import com.atlassian.bamboo.task.TaskResultBuilder;
import com.atlassian.bamboo.task.TaskType;
import com.atlassian.bamboo.utils.SystemProperty;
import com.atlassian.bamboo.v2.build.CurrentBuildResult;
import com.atlassian.utils.process.ExternalProcess;
import com.atlassian.utils.process.ExternalProcessBuilder;
import com.atlassian.utils.process.ProcessException;
import com.atlassian.utils.process.ProcessHandler;
import com.atlassian.utils.process.ProcessTimeoutException;
import com.atlassian.utils.process.StringProcessHandler;
import com.stellarity.bamboo.task.GoogleTestReportProvider;
import com.stellarity.bamboo.task.GoogleTestTaskData;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FilenameUtils;
import org.apache.tools.ant.DirectoryScanner;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GoogleTestTask
implements TaskType {
    private static final Logger LOG = LoggerFactory.getLogger(GoogleTestTask.class);
    private final EnvironmentVariableAccessor environmentVariableAccessor;
    private final TestCollationService testCollationService;
    private final Object testCollationServiceLock = new Object();

    public GoogleTestTask(EnvironmentVariableAccessor environmentVariableAccessor, TestCollationService testCollationService) {
        this.environmentVariableAccessor = environmentVariableAccessor;
        this.testCollationService = testCollationService;
    }

    public TaskResult execute(TaskContext taskContext) throws TaskException {
        return new Executor(taskContext).execute();
    }

    private static String[] findFiles(File workDir, String includePattern, String excludePattern) {
        String[] includes = includePattern.split(",");
        String[] excludes = excludePattern.split(",");
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setBasedir(workDir);
        scanner.setIncludes(includes);
        scanner.setExcludes(excludes);
        scanner.scan();
        return scanner.getIncludedFiles();
    }

    private static String[] removeOldTestFiles(File workDir, String[] tests, Date startDate) {
        long startTime = startDate.getTime() - SystemProperty.FS_TIMESTAMP_RESOLUTION_MS.getTypedValue();
        ArrayList<String> out = new ArrayList<String>();
        for (String test : tests) {
            File file = new File(workDir, test);
            if (file.lastModified() < startTime) continue;
            out.add(test);
        }
        return out.toArray(new String[0]);
    }

    private static String convertNewLines(String str) {
        if (str.contains("\r\n")) {
            return str.replace("\n", "");
        }
        return str.replace("\n", "\r");
    }

    class Executor {
        private final BuildLogger buildLogger;
        private final GoogleTestTaskData taskData;
        private final TaskContext taskContext;
        private final File workDir;

        public Executor(TaskContext taskContext) {
            this.taskContext = taskContext;
            this.buildLogger = taskContext.getBuildLogger();
            this.taskData = new GoogleTestTaskData((Map<String, String>)taskContext.getConfigurationMap());
            this.workDir = new File(taskContext.getWorkingDirectory(), this.taskData.getSubdirectory());
        }

        public TaskResult execute() throws TaskException {
            String pattern = this.taskData.getParseOnly() ? this.taskData.getOutputs() : this.taskData.getExecutables();
            LOG.info(this.buildLogger.addBuildLogEntry((LogEntry)new BuildOutputLogEntry("Searching '" + pattern + "' in '" + this.workDir.getAbsolutePath() + "'")));
            CurrentBuildResult buildResult = this.taskContext.getBuildContext().getBuildResult();
            String[] allTests = GoogleTestTask.findFiles(this.workDir, pattern, this.taskData.getParseOnly() ? "" : "**/*.xml");
            String[] validTests = this.taskData.getParseOnly() && !this.taskData.getPickupOutdatedFiles() ? GoogleTestTask.removeOldTestFiles(this.workDir, allTests, buildResult.getTasksStartDate()) : allTests;
            LOG.info(this.buildLogger.addBuildLogEntry((LogEntry)new BuildOutputLogEntry("Number of test files found: " + validTests.length)));
            if (allTests.length != validTests.length) {
                LOG.info(this.buildLogger.addBuildLogEntry((LogEntry)new BuildOutputLogEntry("Number of test files found (including outdated): " + allTests.length)));
            }
            if (validTests.length > 0) {
                ErrorMemorisingInterceptor errorLines = new ErrorMemorisingInterceptor();
                this.buildLogger.getInterceptorStack().add((LogInterceptor)errorLines);
                try {
                    this.executeTestsInParallel(validTests);
                }
                catch (InterruptedException e) {
                    LOG.error(this.buildLogger.addErrorLogEntry("Task execution was interrupted."), (Throwable)e);
                    return TaskResultBuilder.create((TaskContext)this.taskContext).failed().build();
                }
                if (!errorLines.getErrorStringList().isEmpty()) {
                    buildResult.addBuildErrors(errorLines.getErrorStringList());
                    throw new TaskException("Failing the task due to errors:\r----------BEGIN----------\r" + String.join((CharSequence)"\r", errorLines.getErrorStringList()) + "\r-----------END-----------");
                }
            }
            return TaskResultBuilder.create((TaskContext)this.taskContext).checkTestFailures().build();
        }

        void executeTestsInParallel(String[] tests) throws InterruptedException {
            Map environment;
            Map map = environment = this.taskData.getParseOnly() ? null : GoogleTestTask.this.environmentVariableAccessor.splitEnvironmentAssignments(this.taskData.getEnvironment(), false);
            if (null != environment && !environment.isEmpty()) {
                LOG.info(this.buildLogger.addBuildLogEntry("Using extra environment: " + this.taskData.getEnvironment()));
            }
            ExecutorService executorService = Executors.newFixedThreadPool(Math.min(Runtime.getRuntime().availableProcessors(), tests.length));
            ArrayList futures = new ArrayList(tests.length);
            for (String test : tests) {
                String fullTestPath = this.workDir.getAbsolutePath() + File.separator + test;
                Future<?> future = executorService.submit(() -> {
                    if (this.taskData.getParseOnly()) {
                        this.parseOutputFile(test, new File(fullTestPath), null);
                    } else {
                        this.runExecutable(test, fullTestPath, environment);
                    }
                });
                futures.add(future);
            }
            for (Future future : futures) {
                try {
                    future.get();
                }
                catch (ExecutionException e) {
                    this.buildLogger.addErrorLogEntry("Test execution thread caught an exception:", (Throwable)e);
                    LOG.error("Test execution thread caught an exception:", (Throwable)e);
                }
            }
            executorService.shutdown();
            executorService.awaitTermination(Long.MAX_VALUE, TimeUnit.DAYS);
        }

        void runExecutable(String test, String fullTestPath, Map<String, String> environment) {
            LOG.info(this.buildLogger.addBuildLogEntry((LogEntry)new BuildOutputLogEntry("Started test: " + test)));
            String outputFileName = FilenameUtils.removeExtension((String)test).concat(".xml");
            File outputFile = new File(this.workDir, outputFileName);
            outputFile.delete();
            List<String> commands = Arrays.asList(fullTestPath, "--gtest_output=xml:./" + outputFileName);
            StringProcessHandler processHandler = new StringProcessHandler();
            processHandler.setThrowOnNonZeroExit(false);
            ExternalProcessBuilder processBuilder = new ExternalProcessBuilder().command(commands, this.workDir, TimeUnit.MINUTES.toMillis(this.taskData.getTimeout())).env(environment).handler((ProcessHandler)processHandler);
            ExternalProcess process = processBuilder.build();
            process.execute();
            ProcessException processException = process.getHandler().getException();
            if (null != processException) {
                if (processException instanceof ProcessTimeoutException) {
                    LOG.error(this.buildLogger.addErrorLogEntry("Test is timeouted (no output for " + this.taskData.getTimeout() + " minutes) : " + test));
                } else {
                    LOG.error(this.buildLogger.addErrorLogEntry("Failed running test: " + test + ", " + processHandler.getException()));
                }
                return;
            }
            LOG.info(this.buildLogger.addBuildLogEntry((LogEntry)new BuildOutputLogEntry("Finished test: " + test)));
            this.parseOutputFile(test, outputFile, processHandler.getOutput());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void parseOutputFile(String test, File outputFile, @Nullable String outputString) {
            GoogleTestReportProvider provider;
            if (null != outputString) {
                StringBuilder testResultsLog = new StringBuilder();
                testResultsLog.append("Begin of test results for: ").append(test).append("\r");
                testResultsLog.append(GoogleTestTask.convertNewLines(outputString));
                testResultsLog.append("End of test results for: ").append(test);
                LOG.info(this.buildLogger.addBuildLogEntry(testResultsLog.toString()));
            }
            StringBuilder suffix = new StringBuilder();
            if (this.taskData.getUseFileName()) {
                suffix.append(FilenameUtils.removeExtension((String)test));
            }
            if (this.taskData.getUseTaskName()) {
                if (0 != suffix.length()) {
                    suffix.append(",");
                }
                suffix.append(this.taskContext.getUserDescription());
            }
            if (null != (provider = new GoogleTestReportProvider(outputFile, suffix.toString())).getException()) {
                LOG.error(this.buildLogger.addErrorLogEntry("Failed to parse test results for: " + test + ", " + provider.getException()));
                return;
            }
            Object object = GoogleTestTask.this.testCollationServiceLock;
            synchronized (object) {
                GoogleTestTask.this.testCollationService.collateTestResults(this.taskContext, (TestReportProvider)provider);
            }
        }
    }
}

