/*
 * Decompiled with CFR 0.152.
 */
package com.stellarity.bamboo.task;

import com.atlassian.bamboo.collections.ActionParametersMap;
import com.atlassian.bamboo.credentials.CredentialsAccessor;
import com.atlassian.bamboo.security.EncryptionService;
import com.atlassian.bamboo.task.TaskDefinition;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.atlassian.bamboo.utils.i18n.I18nBean;
import com.stellarity.ftp.SshKeyValidator;
import com.stellarity.ftp.providers.FtpProvider;
import com.stellarity.ftp.providers.SftpProvider;
import io.mikael.urlbuilder.UrlBuilder;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;

public class FtpTaskData {
    private static final String URL_KEY = "ftpTaskUrl";
    private static final String USERNAME_KEY = "ftpTaskUsername";
    private static final String KEY_USERNAME_KEY = "ftpTaskKeyUsername";
    private static final String PASSWORD_CHANGE_KEY = "ftpTaskPasswordChange";
    private static final String PLAIN_PASSWORD_KEY = "ftpTaskPlainPassword";
    private static final String PASSWORD_KEY = "ftpTaskPassword";
    private static final String INCLUDE_PATTERN_KEY = "ftpTaskIncludePattern";
    private static final String EXCLUDE_PATTERN_KEY = "ftpTaskExcludePattern";
    private static final String SUBDIRECTORY_KEY = "ftpTaskSubdirectory";
    private static final String RETRY_COUNT_KEY = "ftpTaskRetryCount";
    private static final String RETRY_DELAY_KEY = "ftpTaskRetryDelay";
    private static final String CLEANUP_KEY = "ftpTaskCleanup";
    private static final String USE_SHARED_CREDENTIALS_KEY = "ftpTaskUseSharedCredentials";
    private static final String SHARED_CREDENTIALS_KEY = "ftpTaskSharedCredentials";
    private static final String SHARED_PASSWORD_CREDENTIALS_KEY = "ftpTaskSharedPasswordCredentials";
    private static final String SHARED_KEY_CREDENTIALS_KEY = "ftpTaskSharedKeyCredentials";
    private static final String AUTH_TYPE_KEY = "ftpTaskAuthType";
    private static final String KEY_KEY = "ftpTaskKey";
    private static final String PLAIN_KEY_KEY = "ftpTaskPlainKey";
    private static final String KEY_CHANGE_KEY = "ftpTaskKeyChange";
    private static final String PLAIN_PASSPHRASE_KEY = "ftpTaskPlainPassphrase";
    private static final String PASSPHRASE_KEY = "ftpTaskPassphrase";
    private static final String AUTH_TYPE_KEY_UNSUPPORTED_ERROR_I18N = "ftpTask.authType.key.error.unsupported";
    private static final String KEY_ERROR_I18N = "ftpTask.key.error";
    private static final String URL_ERROR_I18N = "ftpTask.url.error";
    private static final String SHARED_CREDENTIALS_ERROR_I18N = "ftpTask.useSharedCredentials.error";
    private static final String NUMBER_ERROR_I18N = "ftpTask.number.error";
    private static final String RETRY_COUNT_DEFAULT = "5";
    private static final String RETRY_DELAY_DEFAULT = "60";
    private final String url;
    private final String username;
    private final String keyUsername;
    private final String password;
    private final String includePattern;
    private final String excludePattern;
    private final String subdirectory;
    private final String retryCount;
    private final String retryDelay;
    private final String cleanup;
    private final String useSharedCredentials;
    private final String sharedCredentials;
    private final String key;
    private final String passphrase;
    private final AuthType authType;
    private final boolean keyChange;

    public FtpTaskData(ActionParametersMap params, @Nullable TaskDefinition previousTaskDefinition, EncryptionService encryptionService) {
        this.url = params.getString(URL_KEY);
        this.username = params.getString(USERNAME_KEY);
        this.keyUsername = params.getString(KEY_USERNAME_KEY);
        this.password = !params.getBoolean(PASSWORD_CHANGE_KEY) && null != previousTaskDefinition ? (String)previousTaskDefinition.getConfiguration().get(PASSWORD_KEY) : encryptionService.encrypt(params.getString(PLAIN_PASSWORD_KEY));
        this.includePattern = params.getString(INCLUDE_PATTERN_KEY);
        this.excludePattern = params.getString(EXCLUDE_PATTERN_KEY);
        this.subdirectory = params.getString(SUBDIRECTORY_KEY);
        this.retryCount = params.getString(RETRY_COUNT_KEY);
        this.retryDelay = params.getString(RETRY_DELAY_KEY);
        this.cleanup = params.getString(CLEANUP_KEY, "");
        this.useSharedCredentials = params.getString(USE_SHARED_CREDENTIALS_KEY, "");
        this.authType = AuthType.valueOf(params.getString(AUTH_TYPE_KEY, AuthType.PASSWORD.toString()));
        this.sharedCredentials = params.getString(AuthType.PASSWORD == this.authType ? SHARED_PASSWORD_CREDENTIALS_KEY : SHARED_KEY_CREDENTIALS_KEY, "");
        this.keyChange = params.getBoolean(KEY_CHANGE_KEY);
        if (!this.keyChange && null != previousTaskDefinition) {
            this.passphrase = previousTaskDefinition.getConfiguration().getOrDefault(PASSPHRASE_KEY, "");
            this.key = previousTaskDefinition.getConfiguration().getOrDefault(KEY_KEY, "");
        } else {
            this.passphrase = encryptionService.encrypt(params.getString(PLAIN_PASSPHRASE_KEY));
            this.key = encryptionService.encrypt(params.getString(PLAIN_KEY_KEY));
        }
    }

    public FtpTaskData(Map<String, String> map) {
        this.url = map.get(URL_KEY);
        this.username = map.get(USERNAME_KEY);
        this.keyUsername = map.getOrDefault(KEY_USERNAME_KEY, this.username);
        this.password = map.get(PASSWORD_KEY);
        this.includePattern = map.get(INCLUDE_PATTERN_KEY);
        this.excludePattern = map.get(EXCLUDE_PATTERN_KEY);
        this.subdirectory = map.get(SUBDIRECTORY_KEY);
        this.retryCount = map.get(RETRY_COUNT_KEY);
        this.retryDelay = map.get(RETRY_DELAY_KEY);
        this.cleanup = map.getOrDefault(CLEANUP_KEY, "");
        this.useSharedCredentials = map.getOrDefault(USE_SHARED_CREDENTIALS_KEY, "");
        this.sharedCredentials = map.getOrDefault(SHARED_CREDENTIALS_KEY, "");
        this.authType = AuthType.valueOf(map.getOrDefault(AUTH_TYPE_KEY, AuthType.PASSWORD.toString()));
        this.key = map.getOrDefault(KEY_KEY, "");
        this.passphrase = map.getOrDefault(PASSPHRASE_KEY, "");
        this.keyChange = false;
    }

    public String getUrl() {
        return this.url;
    }

    public String getUsername() {
        return this.username;
    }

    public String getKeyUsername() {
        return this.keyUsername;
    }

    public AuthType getAuthType() {
        return this.authType;
    }

    public String getPassword(EncryptionService encryptionService) {
        return encryptionService.decrypt(this.password);
    }

    public String getKey(EncryptionService encryptionService) {
        return encryptionService.decrypt(this.key);
    }

    public String getPassphrase(EncryptionService encryptionService) {
        return encryptionService.decrypt(this.passphrase);
    }

    public String getIncludePattern() {
        return this.includePattern;
    }

    public String getExcludePattern() {
        return this.excludePattern;
    }

    public String getSubdirectory() {
        return this.subdirectory;
    }

    public int getRetryCount() {
        return FtpTaskData.parseUnsignedInt(this.retryCount);
    }

    public int getRetryDelay() {
        return FtpTaskData.parseUnsignedInt(this.retryDelay);
    }

    public boolean getCleanup() {
        return Boolean.parseBoolean(this.cleanup);
    }

    public boolean getUseSharedCredentials() {
        return Boolean.parseBoolean(this.useSharedCredentials);
    }

    public long getSharedCredentials() {
        return Long.parseLong(this.sharedCredentials);
    }

    public void validate(ErrorCollection errorCollection, I18nBean i18nBean, CredentialsAccessor credentialsAccessor, EncryptionService encryptionService) {
        if (StringUtils.isEmpty((CharSequence)this.url)) {
            errorCollection.addError(URL_KEY, i18nBean.getText(URL_ERROR_I18N));
        } else {
            try {
                URI uri = UrlBuilder.fromString((String)this.url).toUriWithException();
                if (!FtpProvider.isSupportedUri(uri) && !SftpProvider.isSupportedUri(uri)) {
                    errorCollection.addError(URL_KEY, i18nBean.getText(URL_ERROR_I18N));
                }
            }
            catch (URISyntaxException uri) {
                // empty catch block
            }
        }
        if (this.getUseSharedCredentials()) {
            boolean error;
            try {
                error = credentialsAccessor.getCredentials(this.getSharedCredentials()) == null;
            }
            catch (NumberFormatException e) {
                error = true;
            }
            if (error) {
                errorCollection.addError(USE_SHARED_CREDENTIALS_KEY, i18nBean.getText(SHARED_CREDENTIALS_ERROR_I18N));
            }
        } else if (AuthType.KEY == this.authType && this.keyChange && (StringUtils.isEmpty((CharSequence)this.key) || !SshKeyValidator.validate(this.getKey(encryptionService), this.getPassphrase(encryptionService)))) {
            errorCollection.addError(PLAIN_KEY_KEY, i18nBean.getText(KEY_ERROR_I18N));
        }
        if (AuthType.KEY == this.authType) {
            try {
                if (StringUtils.isNotEmpty((CharSequence)this.url) && FtpProvider.isSupportedUri(UrlBuilder.fromString((String)this.url).toUriWithException())) {
                    errorCollection.addError(AUTH_TYPE_KEY, i18nBean.getText(AUTH_TYPE_KEY_UNSUPPORTED_ERROR_I18N));
                }
            }
            catch (URISyntaxException error) {
                // empty catch block
            }
        }
        try {
            this.getRetryCount();
        }
        catch (NumberFormatException e) {
            errorCollection.addError(RETRY_COUNT_KEY, i18nBean.getText(NUMBER_ERROR_I18N));
        }
        try {
            this.getRetryDelay();
        }
        catch (NumberFormatException e) {
            errorCollection.addError(RETRY_DELAY_KEY, i18nBean.getText(NUMBER_ERROR_I18N));
        }
    }

    public void populateTaskConfigMap(Map<String, ? super String> map, boolean save) {
        map.put(URL_KEY, this.url);
        map.put(USERNAME_KEY, this.username);
        map.put(KEY_USERNAME_KEY, this.keyUsername);
        map.put(PASSWORD_KEY, this.password);
        map.put(INCLUDE_PATTERN_KEY, this.includePattern);
        map.put(EXCLUDE_PATTERN_KEY, this.excludePattern);
        map.put(SUBDIRECTORY_KEY, this.subdirectory);
        map.put(RETRY_COUNT_KEY, this.retryCount);
        map.put(RETRY_DELAY_KEY, this.retryDelay);
        map.put(CLEANUP_KEY, (String)StringUtils.defaultIfEmpty((CharSequence)this.cleanup, (CharSequence)""));
        map.put(USE_SHARED_CREDENTIALS_KEY, (String)StringUtils.defaultIfEmpty((CharSequence)this.useSharedCredentials, (CharSequence)""));
        map.put(AUTH_TYPE_KEY, this.authType.toString());
        map.put(KEY_KEY, (String)StringUtils.defaultIfEmpty((CharSequence)this.key, (CharSequence)""));
        map.put(PASSPHRASE_KEY, (String)StringUtils.defaultIfEmpty((CharSequence)this.passphrase, (CharSequence)""));
        if (save) {
            map.put(SHARED_CREDENTIALS_KEY, (String)StringUtils.defaultIfEmpty((CharSequence)this.sharedCredentials, (CharSequence)""));
        } else {
            map.put(AuthType.PASSWORD == this.authType ? SHARED_PASSWORD_CREDENTIALS_KEY : SHARED_KEY_CREDENTIALS_KEY, (String)StringUtils.defaultIfEmpty((CharSequence)this.sharedCredentials, (CharSequence)""));
        }
    }

    public static void populateTaskConfigMapDefaut(Map<String, ? super String> map) {
        map.put(RETRY_COUNT_KEY, RETRY_COUNT_DEFAULT);
        map.put(RETRY_DELAY_KEY, RETRY_DELAY_DEFAULT);
        map.put(AUTH_TYPE_KEY, AuthType.PASSWORD.toString());
    }

    private static int parseUnsignedInt(String str) {
        int val = Integer.parseInt(str);
        if (val < 0) {
            throw new NumberFormatException("Invalid postitive number string");
        }
        return val;
    }

    public static enum AuthType {
        PASSWORD("PASSWORD", "ftpTask.authType.password"),
        KEY("KEY", "ftpTask.authType.key");

        private final String name;
        private final String i18n;

        private AuthType(String name, String i18n) {
            this.name = name;
            this.i18n = i18n;
        }

        public String toString() {
            return this.name;
        }

        public String i18n() {
            return this.i18n;
        }
    }
}

