/*
 * Decompiled with CFR 0.152.
 */
package com.stellarity.bamboo.task;

import com.atlassian.bamboo.build.logger.BuildLogger;
import com.atlassian.bamboo.build.logger.LogInterceptor;
import com.atlassian.bamboo.build.logger.interceptors.ErrorMemorisingInterceptor;
import com.atlassian.bamboo.credentials.CredentialsAccessor;
import com.atlassian.bamboo.credentials.CredentialsData;
import com.atlassian.bamboo.security.EncryptionService;
import com.atlassian.bamboo.task.CommonTaskContext;
import com.atlassian.bamboo.task.CommonTaskType;
import com.atlassian.bamboo.task.TaskException;
import com.atlassian.bamboo.task.TaskResult;
import com.atlassian.bamboo.task.TaskResultBuilder;
import com.atlassian.bamboo.v2.build.CurrentResult;
import com.stellarity.bamboo.task.FtpTaskData;
import com.stellarity.bamboo.task.FtpTaskType;
import com.stellarity.ftp.Engine;
import com.stellarity.ftp.ServerException;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FtpTask
implements CommonTaskType {
    private static final Logger LOG = LoggerFactory.getLogger(FtpTask.class);
    private EncryptionService encryptionService;
    private CredentialsAccessor credentialsAccessor;
    protected FtpTaskType taskType;

    public void setEncryptionService(EncryptionService encryptionService) {
        this.encryptionService = encryptionService;
    }

    public void setCredentialsAccessor(CredentialsAccessor credentialsAccessor) {
        this.credentialsAccessor = credentialsAccessor;
    }

    public TaskResult execute(CommonTaskContext taskContext) throws TaskException {
        String key;
        String password;
        String username;
        CredentialsData credentials;
        BuildLogger buildLogger = taskContext.getBuildLogger();
        ErrorMemorisingInterceptor errorLines = new ErrorMemorisingInterceptor();
        buildLogger.getInterceptorStack().add((LogInterceptor)errorLines);
        FtpTaskData data = new FtpTaskData((Map<String, String>)taskContext.getConfigurationMap());
        File workDir = new File(taskContext.getWorkingDirectory().getPath() + File.separator + data.getSubdirectory());
        CredentialsData credentialsData = credentials = data.getUseSharedCredentials() ? this.credentialsAccessor.getCredentials(data.getSharedCredentials()) : null;
        if (data.getUseSharedCredentials() && credentials == null) {
            throw new IllegalStateException("Can't find shared credentails with id " + data.getSharedCredentials());
        }
        switch (data.getAuthType()) {
            case PASSWORD: {
                username = credentials != null ? (String)credentials.getConfiguration().get("username") : data.getUsername();
                password = credentials != null ? (String)credentials.getConfiguration().get("password") : data.getPassword(this.encryptionService);
                key = null;
                break;
            }
            case KEY: {
                username = data.getKeyUsername();
                password = credentials != null ? (String)credentials.getConfiguration().get("sshPassphrase") : data.getPassphrase(this.encryptionService);
                key = credentials != null ? (String)credentials.getConfiguration().get("sshKey") : data.getKey(this.encryptionService);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown auth type");
            }
        }
        try {
            Engine engine = new Engine(buildLogger, data.getUrl(), username.isEmpty() ? "anonymous" : username, password, key, data.getIncludePattern(), data.getExcludePattern(), workDir, data.getRetryCount(), data.getRetryDelay());
            switch (this.taskType) {
                case UPLOAD: {
                    engine.uploadFiles(data.getCleanup());
                    break;
                }
                case DOWNLOAD: {
                    engine.downloadFiles();
                }
            }
            return TaskResultBuilder.newBuilder((CommonTaskContext)taskContext).success().build();
        }
        catch (InterruptedException e) {
            LOG.error(buildLogger.addErrorLogEntry("Task execution was interrupted: " + e), (Throwable)e);
        }
        catch (URISyntaxException e) {
            LOG.error(buildLogger.addErrorLogEntry("Failed to parse URI: " + e.getMessage()), (Throwable)e);
        }
        catch (ServerException e) {
            LOG.error(buildLogger.addErrorLogEntry("Server replied: " + e.getMessage()), (Throwable)e);
        }
        catch (IOException e) {
            LOG.error(buildLogger.addErrorLogEntry("Exception occuried: " + e), (Throwable)e);
        }
        CurrentResult result = taskContext.getCommonContext().getCurrentResult();
        result.addBuildErrors(errorLines.getErrorStringList());
        return TaskResultBuilder.newBuilder((CommonTaskContext)taskContext).failed().build();
    }
}

