/*
 * Decompiled with CFR 0.152.
 */
package com.stellarity.ftp.providers;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpException;
import com.stellarity.ftp.PathUtils;
import com.stellarity.ftp.ServerException;
import com.stellarity.ftp.providers.Provider;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Vector;
import org.apache.commons.io.FileUtils;

public class SftpProvider
implements Provider {
    private static final int KEEP_ALIVE_TIMEOUT = 300000;
    private static final int SOCKET_TIMEOUT = 30000;
    private final URI uri;
    private final String username;
    private final String password;
    private final String key;
    private Session session;
    private ChannelSftp sftpChannel;

    public static boolean isSupportedUri(URI uri) {
        return uri.getScheme().equalsIgnoreCase("sftp");
    }

    public SftpProvider(URI uri, String username, String password, String key) throws URISyntaxException {
        if (!uri.getScheme().equalsIgnoreCase("sftp")) {
            throw new URISyntaxException(uri.toString(), "Unsupported protocol, use sftp");
        }
        this.uri = uri;
        this.username = username;
        this.password = password;
        this.key = key;
    }

    @Override
    public boolean isConnected() {
        return this.sftpChannel != null ? this.sftpChannel.isConnected() : false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void connect() throws ServerException, IOException {
        JSch jsch = new JSch();
        File keyFile = null;
        try {
            this.session = this.uri.getPort() > 0 ? jsch.getSession(this.username, this.uri.getHost(), this.uri.getPort()) : jsch.getSession(this.username, this.uri.getHost());
            if (this.key != null) {
                keyFile = File.createTempFile("ftpTask-", ".tmp");
                FileUtils.writeStringToFile((File)keyFile, (String)this.key);
                jsch.addIdentity(keyFile.getAbsolutePath(), this.password);
            } else {
                this.session.setPassword(this.password);
            }
            this.session.setConfig("StrictHostKeyChecking", "no");
            this.session.setServerAliveInterval(300000);
            this.session.setTimeout(30000);
            this.session.connect();
            Channel channel = this.session.openChannel("sftp");
            channel.connect();
            this.sftpChannel = (ChannelSftp)channel;
            if (keyFile == null) return;
        }
        catch (JSchException e) {
            try {
                if (!(e.getCause() instanceof IOException)) throw new ServerException(e.getMessage() + " [while connecting to " + this.uri.toString() + "]");
                throw (IOException)e.getCause();
            }
            catch (Throwable throwable) {
                if (keyFile == null) throw throwable;
                FileUtils.deleteQuietly(keyFile);
                throw throwable;
            }
        }
        FileUtils.deleteQuietly((File)keyFile);
        return;
    }

    @Override
    public void disconnect() {
        if (this.sftpChannel != null) {
            this.sftpChannel.exit();
            this.sftpChannel.disconnect();
            this.sftpChannel = null;
        }
        if (this.session != null) {
            this.session.disconnect();
            this.session = null;
        }
    }

    @Override
    public void storeFile(InputStream src, String dst) throws ServerException, IOException {
        try {
            this.sftpChannel.put(src, dst, 0);
        }
        catch (SftpException e) {
            throw new ServerException(e.getMessage() + " [while storing file " + dst + "]");
        }
    }

    @Override
    public void retrieveFile(String src, OutputStream dst) throws ServerException, IOException {
        try {
            this.sftpChannel.get(src, dst);
        }
        catch (SftpException e) {
            throw new ServerException(e.getMessage() + " [while retrieving file " + src + "]");
        }
    }

    @Override
    public boolean changeDirectory(String path) throws ServerException, IOException {
        try {
            this.sftpChannel.cd(path);
            return true;
        }
        catch (SftpException e) {
            if (2 == e.id || 3 == e.id || 4 == e.id) {
                return false;
            }
            throw new ServerException(e.getMessage() + " [while changing directory to " + path + "]");
        }
    }

    @Override
    public void makeDirectory(String path) throws ServerException, IOException {
        if (this.changeDirectory(path)) {
            return;
        }
        try {
            this.sftpChannel.mkdir(path);
        }
        catch (SftpException e) {
            throw new ServerException(e.getMessage() + " [while creating directory " + path + "]");
        }
    }

    @Override
    public void listFilesRecursive(String path, String[] includes, String[] excludes, List<String> files) throws ServerException, IOException {
        Vector ftpFiles;
        String absoluteDirPath = PathUtils.concat(this.uri.getPath(), path);
        try {
            ftpFiles = this.sftpChannel.ls(absoluteDirPath);
        }
        catch (SftpException e) {
            throw new ServerException(e.getMessage() + " [while listing directory " + absoluteDirPath + "]");
        }
        for (ChannelSftp.LsEntry ftpFile : ftpFiles) {
            if (ftpFile.getFilename().equals(".") || ftpFile.getFilename().equals("..")) continue;
            String relativeFileOrDirPath = PathUtils.concat(path, ftpFile.getFilename());
            if (ftpFile.getAttrs().isDir()) {
                this.listFilesRecursive(relativeFileOrDirPath, includes, excludes, files);
                continue;
            }
            if (ftpFile.getAttrs().isLink() || !PathUtils.filterPath(relativeFileOrDirPath, includes, excludes)) continue;
            files.add(relativeFileOrDirPath);
        }
    }

    @Override
    public void removeDirectoryRecursive(String path) throws ServerException, IOException {
        Vector ftpFiles;
        String absoluteDirPath = PathUtils.concat(this.uri.getPath(), path);
        try {
            ftpFiles = this.sftpChannel.ls(absoluteDirPath);
        }
        catch (SftpException e) {
            throw new ServerException(e.getMessage() + " [while listing directory " + absoluteDirPath + "]");
        }
        for (ChannelSftp.LsEntry ftpFile : ftpFiles) {
            if (ftpFile.getFilename().equals(".") || ftpFile.getFilename().equals("..")) continue;
            String relativeFileOrDirPath = PathUtils.concat(path, ftpFile.getFilename());
            if (ftpFile.getAttrs().isDir()) {
                this.removeDirectoryRecursive(relativeFileOrDirPath);
                continue;
            }
            String absoluteFilePath = PathUtils.concat(this.uri.getPath(), relativeFileOrDirPath);
            try {
                this.sftpChannel.rm(absoluteFilePath);
            }
            catch (SftpException e) {
                throw new ServerException(e.getMessage() + " [while deleting file " + absoluteDirPath + "]");
            }
        }
        if (path.isEmpty()) {
            return;
        }
        try {
            this.sftpChannel.rmdir(absoluteDirPath);
        }
        catch (SftpException e) {
            throw new ServerException(e.getMessage() + " [while deleting directory " + absoluteDirPath + "]");
        }
    }
}

