/*
 * Decompiled with CFR 0.152.
 */
package com.stellarity.bamboo.task;

import com.atlassian.bamboo.collections.ActionParametersMap;
import com.atlassian.bamboo.credentials.ConfigurableSharedCredentialDepender;
import com.atlassian.bamboo.credentials.CredentialsAccessor;
import com.atlassian.bamboo.security.EncryptionService;
import com.atlassian.bamboo.task.AbstractTaskConfigurator;
import com.atlassian.bamboo.task.TaskDefinition;
import com.atlassian.bamboo.util.BambooIterables;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.atlassian.bamboo.utils.i18n.I18nBean;
import com.atlassian.bamboo.utils.i18n.I18nBeanFactory;
import com.atlassian.core.util.PairType;
import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.google.common.collect.Lists;
import com.stellarity.bamboo.task.FtpTaskData;
import com.stellarity.bamboo.utils.LicenseChecker;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.jetbrains.annotations.Nullable;

@Scanned
public class FtpTaskConfigurator
extends AbstractTaskConfigurator
implements ConfigurableSharedCredentialDepender {
    private static final String SHARED_PASSWORD_CREDENTIALS_LIST_KEY = "ftpTaskSharedPasswordCredentialsList";
    private static final String SHARED_KEY_CREDENTIALS_LIST_KEY = "ftpTaskSharedKeyCredentialsList";
    private static final String AUTH_TYPE_LIST_KEY = "ftpTaskAuthTypeList";
    private final EncryptionService encryptionService;
    private final CredentialsAccessor credentialsAccessor;
    private final I18nBean i18nBean;
    private final LicenseChecker licenseChecker;

    @Inject
    public FtpTaskConfigurator(@ComponentImport I18nBeanFactory i18nBeanFactory, @ComponentImport EncryptionService encryptionService, @ComponentImport CredentialsAccessor credentialsAccessor) {
        this.encryptionService = encryptionService;
        this.credentialsAccessor = credentialsAccessor;
        this.i18nBean = i18nBeanFactory.getI18nBean();
        this.licenseChecker = new LicenseChecker(((Object)((Object)this)).getClass(), "Stellarity Software - FTP Task");
    }

    public Map<String, String> generateTaskConfigMap(ActionParametersMap params, @Nullable TaskDefinition previousTaskDefinition) {
        Map config = super.generateTaskConfigMap(params, previousTaskDefinition);
        FtpTaskData data = new FtpTaskData(params, previousTaskDefinition, this.encryptionService);
        data.populateTaskConfigMap(config, true);
        return config;
    }

    public void populateContextForCreate(Map<String, Object> context) {
        FtpTaskData.populateTaskConfigMapDefaut(context);
        context.put(SHARED_PASSWORD_CREDENTIALS_LIST_KEY, this.getSharedPasswordCredentialsList());
        context.put(SHARED_KEY_CREDENTIALS_LIST_KEY, this.getSharedKeyCredentialsList());
        context.put(AUTH_TYPE_LIST_KEY, this.getAuthTypeList());
    }

    public void populateContextForEdit(Map<String, Object> context, TaskDefinition taskDefinition) {
        FtpTaskData data = new FtpTaskData(taskDefinition.getConfiguration());
        data.populateTaskConfigMap(context, false);
        context.put(SHARED_PASSWORD_CREDENTIALS_LIST_KEY, this.getSharedPasswordCredentialsList());
        context.put(SHARED_KEY_CREDENTIALS_LIST_KEY, this.getSharedKeyCredentialsList());
        context.put(AUTH_TYPE_LIST_KEY, this.getAuthTypeList());
    }

    public void populateContextForView(Map<String, Object> context, TaskDefinition taskDefinition) {
        this.populateContextForEdit(context, taskDefinition);
    }

    public void validate(ActionParametersMap params, ErrorCollection errorCollection) {
        new FtpTaskData(params, null, this.encryptionService).validate(errorCollection, this.i18nBean, this.credentialsAccessor, this.encryptionService);
        String licenseError = this.licenseChecker.getLicenseError();
        if (null != licenseError) {
            errorCollection.addErrorMessage(licenseError);
        }
    }

    public Iterable<Long> getSharedCredentialIds(Map<String, String> map) {
        FtpTaskData data = new FtpTaskData(map);
        return data.getUseSharedCredentials() ? Collections.singleton(data.getSharedCredentials()) : Collections.EMPTY_LIST;
    }

    private List<PairType> getSharedPasswordCredentialsList() {
        return BambooIterables.stream((Iterable)this.credentialsAccessor.getAllCredentials()).filter(credentials -> "com.atlassian.bamboo.plugin.sharedCredentials:usernamePasswordCredentials".equals(credentials.getPluginKey())).map(credentials -> new PairType((Serializable)((Object)String.valueOf(credentials.getId())), (Serializable)((Object)credentials.getName()))).collect(Collectors.toList());
    }

    private List<PairType> getSharedKeyCredentialsList() {
        return BambooIterables.stream((Iterable)this.credentialsAccessor.getAllCredentials()).filter(credentials -> "com.atlassian.bamboo.plugin.sharedCredentials:sshCredentials".equals(credentials.getPluginKey())).map(credentials -> new PairType((Serializable)((Object)String.valueOf(credentials.getId())), (Serializable)((Object)credentials.getName()))).collect(Collectors.toList());
    }

    private List<PairType> getAuthTypeList() {
        ArrayList list = Lists.newArrayList();
        for (FtpTaskData.AuthType item : FtpTaskData.AuthType.values()) {
            list.add(new PairType((Serializable)((Object)item.toString()), (Serializable)((Object)this.i18nBean.getText(item.i18n()))));
        }
        return list;
    }
}

