/*
 * Decompiled with CFR 0.152.
 */
package com.stellarity.ftp.providers;

import com.stellarity.ftp.PathUtils;
import com.stellarity.ftp.ServerException;
import com.stellarity.ftp.providers.Provider;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.ftp.FTPReply;
import org.apache.commons.net.ftp.FTPSClient;

public class FtpProvider
implements Provider {
    private static final int KEEP_ALIVE_TIMEOUT = 300;
    private final URI uri;
    private final String username;
    private final String password;
    private final FTPClient client;

    public static boolean isSupportedUri(URI uri) {
        String scheme = uri.getScheme();
        return scheme.equalsIgnoreCase("ftp") || scheme.equalsIgnoreCase("ftps") || scheme.equalsIgnoreCase("ftpes");
    }

    public FtpProvider(URI uri, String username, String password) throws URISyntaxException {
        String scheme = uri.getScheme();
        if (scheme.equalsIgnoreCase("ftp")) {
            this.client = new FTPClient();
        } else if (scheme.equalsIgnoreCase("ftps")) {
            this.client = new FTPSClient(true);
        } else if (scheme.equalsIgnoreCase("ftpes")) {
            this.client = new FTPSClient(false);
        } else {
            throw new URISyntaxException(uri.toString(), "Unsupported protocol, use ftp, ftps or ftpes");
        }
        this.uri = uri;
        this.username = username;
        this.password = password;
    }

    @Override
    public boolean isConnected() {
        return this.client.isConnected();
    }

    @Override
    public void connect() throws ServerException, IOException {
        this.client.setControlEncoding("UTF-8");
        if (this.uri.getPort() > 0) {
            this.client.connect(this.uri.getHost(), this.uri.getPort());
        } else {
            this.client.connect(this.uri.getHost());
        }
        if (!FTPReply.isPositiveCompletion((int)this.client.getReplyCode())) {
            throw new ServerException(this.client.getReplyString() + " [while connecting to " + this.uri.toString() + "]");
        }
        this.client.login(this.username, this.password);
        if (!FTPReply.isPositiveCompletion((int)this.client.getReplyCode())) {
            throw new ServerException(this.client.getReplyString() + " [while connecting to " + this.uri.toString() + "]");
        }
        this.client.enterLocalPassiveMode();
        this.client.setFileType(2);
        this.client.setControlKeepAliveTimeout(300L);
        if (this.client instanceof FTPSClient) {
            FTPSClient secureClient = (FTPSClient)this.client;
            secureClient.execPBSZ(0L);
            secureClient.execPROT("P");
        }
    }

    @Override
    public void disconnect() {
        if (!this.client.isConnected()) {
            return;
        }
        try {
            this.client.logout();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            this.client.disconnect();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void storeFile(InputStream src, String dst) throws ServerException, IOException {
        this.client.storeFile(dst, src);
        if (!FTPReply.isPositiveCompletion((int)this.client.getReplyCode())) {
            throw new ServerException(this.client.getReplyString() + " [while storing file " + dst + "]");
        }
    }

    @Override
    public void retrieveFile(String src, OutputStream dst) throws ServerException, IOException {
        this.client.retrieveFile(src, dst);
        if (!FTPReply.isPositiveCompletion((int)this.client.getReplyCode())) {
            throw new ServerException(this.client.getReplyString() + " [while retrieving file " + src + "]");
        }
    }

    @Override
    public boolean changeDirectory(String path) throws ServerException, IOException {
        return this.client.changeWorkingDirectory(path);
    }

    @Override
    public void makeDirectory(String path) throws ServerException, IOException {
        this.client.makeDirectory(path);
    }

    @Override
    public void listFilesRecursive(String path, String[] includes, String[] excludes, List<String> files) throws ServerException, IOException {
        String absoluteDirPath = PathUtils.concat(this.uri.getPath(), path);
        FTPFile[] ftpFiles = this.client.listFiles(absoluteDirPath);
        if (!FTPReply.isPositiveCompletion((int)this.client.getReplyCode())) {
            throw new ServerException(this.client.getReplyString() + " [while listing directory " + absoluteDirPath + "]");
        }
        for (FTPFile ftpFile : ftpFiles) {
            if (ftpFile.getName().equals(".") || ftpFile.getName().equals("..")) continue;
            String relativeFileOrDirPath = PathUtils.concat(path, ftpFile.getName());
            if (ftpFile.isDirectory()) {
                this.listFilesRecursive(relativeFileOrDirPath, includes, excludes, files);
                continue;
            }
            if (!ftpFile.isFile() || !PathUtils.filterPath(relativeFileOrDirPath, includes, excludes)) continue;
            files.add(relativeFileOrDirPath);
        }
    }

    @Override
    public void removeDirectoryRecursive(String path) throws ServerException, IOException {
        String absoluteDirPath = PathUtils.concat(this.uri.getPath(), path);
        FTPFile[] ftpFiles = this.client.listFiles(absoluteDirPath);
        if (!FTPReply.isPositiveCompletion((int)this.client.getReplyCode())) {
            throw new ServerException(this.client.getReplyString() + " [while listing directory " + absoluteDirPath + "]");
        }
        for (FTPFile ftpFile : ftpFiles) {
            if (ftpFile.getName().equals(".") || ftpFile.getName().equals("..")) continue;
            String relativeFileOrDirPath = PathUtils.concat(path, ftpFile.getName());
            if (ftpFile.isDirectory()) {
                this.removeDirectoryRecursive(relativeFileOrDirPath);
                continue;
            }
            String absoluteFilePath = PathUtils.concat(this.uri.getPath(), relativeFileOrDirPath);
            this.client.deleteFile(absoluteFilePath);
            if (FTPReply.isPositiveCompletion((int)this.client.getReplyCode())) continue;
            throw new ServerException(this.client.getReplyString() + " [while deleting file " + absoluteFilePath + "]");
        }
        if (path.isEmpty()) {
            return;
        }
        this.client.removeDirectory(absoluteDirPath);
        if (!FTPReply.isPositiveCompletion((int)this.client.getReplyCode())) {
            throw new ServerException(this.client.getReplyString() + " [while deleting directory " + absoluteDirPath + "]");
        }
    }
}

