/*
 * Decompiled with CFR 0.152.
 */
package com.stellarity.ftp;

import org.apache.commons.io.FilenameUtils;
import org.apache.tools.ant.types.selectors.SelectorUtils;

public class PathUtils {
    public static String removeLastSlash(String path) {
        return path.endsWith("/") ? path.substring(0, path.length() - 1) : path;
    }

    public static String removeFirstSlash(String path) {
        return path.startsWith("/") ? path.substring(1) : path;
    }

    public static String concat(String base, String path) {
        return PathUtils.removeLastSlash(base) + "/" + PathUtils.removeFirstSlash(path);
    }

    public static boolean filterPath(String path, String[] includes, String[] excludes) {
        return PathUtils.matchPath(path = FilenameUtils.separatorsToSystem((String)path), includes) && !PathUtils.matchPath(path, excludes);
    }

    private static boolean matchPath(String path, String[] patterns) {
        for (String pattern : patterns) {
            if (!SelectorUtils.matchPath((String)pattern, (String)path)) continue;
            return true;
        }
        return false;
    }
}

