/*
 * Decompiled with CFR 0.152.
 */
package com.stellarity.ftp;

import com.atlassian.bamboo.build.logger.BuildLogger;
import com.stellarity.ftp.EngineOperation;
import com.stellarity.ftp.PathUtils;
import com.stellarity.ftp.ServerException;
import com.stellarity.ftp.providers.FtpProvider;
import com.stellarity.ftp.providers.Provider;
import com.stellarity.ftp.providers.SftpProvider;
import io.mikael.urlbuilder.UrlBuilder;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import org.apache.log4j.Logger;
import org.apache.tools.ant.DirectoryScanner;

public class Engine {
    private static final Logger LOG = Logger.getLogger(Engine.class);
    private static final int PROGRESS_POINTS = 8;
    private final BuildLogger buildLogger;
    private final URI uri;
    private final String[] includes;
    private final String[] excludes;
    private final File workDir;
    private final int retryCount;
    private final int retryDelay;
    private final Provider provider;

    public Engine(BuildLogger buildLogger, String url, String username, String password, String key, String includePattern, String excludePattern, File workDir, int retryCount, int retryDelay) throws URISyntaxException {
        String[] stringArray;
        this.buildLogger = buildLogger;
        this.uri = UrlBuilder.fromString((String)url).toUriWithException();
        if (includePattern.isEmpty()) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "**";
        } else {
            stringArray = FilenameUtils.separatorsToSystem((String)includePattern).split(",");
        }
        this.includes = stringArray;
        this.excludes = FilenameUtils.separatorsToSystem((String)excludePattern).split(",");
        this.workDir = workDir;
        this.retryCount = retryCount;
        this.retryDelay = retryDelay;
        if (FtpProvider.isSupportedUri(this.uri)) {
            this.provider = new FtpProvider(this.uri, username, password);
        } else if (SftpProvider.isSupportedUri(this.uri)) {
            this.provider = new SftpProvider(this.uri, username, password, key);
        } else {
            throw new URISyntaxException(url, "Unsupported protocol, use ftp, ftps, ftpes or sftp");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void uploadFiles(boolean cleanup) throws ServerException, IOException, InterruptedException {
        try {
            if (cleanup) {
                LOG.info((Object)this.buildLogger.addBuildLogEntry("Cleaning up remote directory before upload"));
                this.doWithRetry(new EngineOperation(){

                    @Override
                    public void execute() throws ServerException, IOException {
                        Engine.this.removeDirectory();
                    }
                });
            }
            LOG.info((Object)this.buildLogger.addBuildLogEntry("Discovering files to upload"));
            String[] files = this.findLocalFiles();
            LOG.info((Object)this.buildLogger.addBuildLogEntry("Uploading " + files.length + " files to " + this.uri));
            int current = 0;
            for (final String file : files) {
                this.doWithRetry(new EngineOperation(){

                    @Override
                    public void execute() throws ServerException, IOException {
                        Engine.this.uploadFile(file);
                    }
                });
                this.logProgress(++current, files.length);
            }
        }
        finally {
            this.provider.disconnect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void downloadFiles() throws ServerException, IOException, InterruptedException {
        try {
            final ArrayList files = new ArrayList();
            LOG.info((Object)this.buildLogger.addBuildLogEntry("Discovering files to download"));
            this.doWithRetry(new EngineOperation(){

                @Override
                public void execute() throws ServerException, IOException {
                    Engine.this.findRemoteFiles(files);
                }
            });
            LOG.info((Object)this.buildLogger.addBuildLogEntry("Downloading " + files.size() + " files from " + this.uri));
            int current = 0;
            for (final String file : files) {
                this.doWithRetry(new EngineOperation(){

                    @Override
                    public void execute() throws ServerException, IOException {
                        Engine.this.downloadFile(file);
                    }
                });
                this.logProgress(++current, files.size());
            }
        }
        finally {
            this.provider.disconnect();
        }
    }

    private void doWithRetry(EngineOperation operation) throws ServerException, IOException, InterruptedException {
        int retry = 0;
        while (true) {
            try {
                operation.execute();
            }
            catch (IOException e) {
                if (retry >= this.retryCount) {
                    throw e;
                }
                this.provider.disconnect();
                LOG.info((Object)this.buildLogger.addBuildLogEntry("Waiting before a retry attempt..."));
                Thread.sleep(this.retryDelay * 1000);
                ++retry;
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void uploadFile(String file) throws ServerException, IOException {
        if (!this.provider.isConnected()) {
            this.provider.connect();
            this.makeRemoteDirTree("", this.uri.getPath());
        }
        File localPath = new File(this.workDir, FilenameUtils.separatorsToSystem((String)file));
        String unixFile = FilenameUtils.separatorsToUnix((String)file);
        String remotePath = PathUtils.concat(this.uri.getPath(), unixFile);
        this.makeRemoteDirTree(this.uri.getPath(), FilenameUtils.getFullPath((String)unixFile));
        try (FileInputStream localStream = new FileInputStream(localPath);){
            this.provider.storeFile(localStream, remotePath);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void downloadFile(String file) throws ServerException, IOException {
        if (!this.provider.isConnected()) {
            this.provider.connect();
        }
        File localPath = new File(this.workDir, FilenameUtils.separatorsToSystem((String)file));
        String remotePath = PathUtils.concat(this.uri.getPath(), FilenameUtils.separatorsToUnix((String)file));
        localPath.getParentFile().mkdirs();
        try (FileOutputStream localStream = new FileOutputStream(localPath);){
            this.provider.retrieveFile(remotePath, localStream);
        }
    }

    private void removeDirectory() throws ServerException, IOException {
        if (!this.provider.isConnected()) {
            this.provider.connect();
            this.makeRemoteDirTree("", this.uri.getPath());
        }
        this.provider.removeDirectoryRecursive("");
    }

    private void makeRemoteDirTree(String base, String path) throws ServerException, IOException {
        base = PathUtils.removeLastSlash(base);
        if ((path = PathUtils.removeLastSlash(path)).isEmpty()) {
            return;
        }
        if (this.provider.changeDirectory(PathUtils.concat(base, path))) {
            return;
        }
        String[] dirs = path.split("/");
        StringBuilder remotePath = new StringBuilder(base);
        for (String dir : dirs) {
            if (dir.isEmpty()) continue;
            remotePath.append("/").append(dir);
            this.provider.makeDirectory(remotePath.toString());
        }
    }

    private String[] findLocalFiles() {
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setIncludes(this.includes);
        scanner.setExcludes(this.excludes);
        scanner.setBasedir(this.workDir);
        scanner.scan();
        return scanner.getIncludedFiles();
    }

    private void findRemoteFiles(List<String> files) throws ServerException, IOException {
        files.clear();
        if (!this.provider.isConnected()) {
            this.provider.connect();
        }
        this.provider.listFilesRecursive("", this.includes, this.excludes, files);
    }

    private void logProgress(int current, int total) {
        if (total < 8 || 0 == current % (total / 8)) {
            LOG.info((Object)this.buildLogger.addBuildLogEntry("Progress: " + current * 100 / total + "% (" + current + " from " + total + ")"));
        }
    }
}

