/*
 * Decompiled with CFR 0.152.
 */
package com.stellarity.bamboo.task;

import com.atlassian.bamboo.collections.ActionParametersMap;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.atlassian.bamboo.utils.i18n.I18nBean;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class BoostTestTaskData {
    private static final String EXECUTABLES_KEY = "boosttestExecutables";
    private static final String SUBDIRECTORY_KEY = "boosttestSubdirectory";
    private static final String ENVIRONMENT_KEY = "boosttestEnvironment";
    private static final String OUTPUTS_KEY = "boosttestOutputFiles";
    private static final String PICKOUTDATEDFILES_KEY = "boosttestPickOutdatedFiles";
    private static final String PARSEONLY_KEY = "boosttestParseOnly";
    private static final String USE_TASK_NAME_KEY = "boosttestUseTaskName";
    private static final String USE_FILE_NAME_KEY = "boosttestUseFileName";
    private static final String TIMEOUT_KEY = "boosttestTimeout";
    private static final String EXECUTABLES_ERROR_I18N = "boosttest.executables.error";
    private static final String OUTPUTS_ERROR_I18N = "boosttest.outputFiles.error";
    private static final String NUMBER_ERROR_I18N = "boosttest.number.error";
    private static final String ZERO_ERROR_I18N = "boosttest.zero.error";
    private static final String TIMEOUT_DEFAULT = "10";
    private final String executables;
    private final String subdirectory;
    private final String environment;
    private final String outputs;
    private final String pickupOutdatedFiles;
    private final String parseOnly;
    private final String useTaskName;
    private final String useFileName;
    private final String timeout;

    public BoostTestTaskData(ActionParametersMap params) {
        this.executables = params.getString(EXECUTABLES_KEY);
        this.subdirectory = params.getString(SUBDIRECTORY_KEY);
        this.environment = params.getString(ENVIRONMENT_KEY);
        this.outputs = params.getString(OUTPUTS_KEY);
        this.pickupOutdatedFiles = params.getString(PICKOUTDATEDFILES_KEY);
        this.parseOnly = params.getString(PARSEONLY_KEY);
        this.useTaskName = params.getString(USE_TASK_NAME_KEY);
        this.useFileName = params.getString(USE_FILE_NAME_KEY);
        this.timeout = params.getString(TIMEOUT_KEY, TIMEOUT_DEFAULT);
    }

    public BoostTestTaskData(Map<String, String> configurationMap) {
        this.executables = configurationMap.get(EXECUTABLES_KEY);
        this.subdirectory = configurationMap.get(SUBDIRECTORY_KEY);
        this.environment = configurationMap.get(ENVIRONMENT_KEY);
        this.outputs = configurationMap.get(OUTPUTS_KEY);
        this.pickupOutdatedFiles = configurationMap.get(PICKOUTDATEDFILES_KEY);
        this.parseOnly = configurationMap.get(PARSEONLY_KEY);
        this.useTaskName = configurationMap.get(USE_TASK_NAME_KEY);
        this.useFileName = configurationMap.get(USE_FILE_NAME_KEY);
        this.timeout = configurationMap.containsKey(TIMEOUT_KEY) ? configurationMap.get(TIMEOUT_KEY) : TIMEOUT_DEFAULT;
    }

    public String getExecutables() {
        return this.executables;
    }

    public String getSubdirectory() {
        return this.subdirectory;
    }

    public String getEnvironment() {
        return this.environment;
    }

    public String getOutputs() {
        return this.outputs;
    }

    public boolean getPickupOutdatedFiles() {
        return Boolean.parseBoolean(this.pickupOutdatedFiles);
    }

    public boolean getParseOnly() {
        return Boolean.parseBoolean(this.parseOnly);
    }

    public boolean getUseTaskName() {
        return Boolean.parseBoolean(this.useTaskName);
    }

    public boolean getUseFileName() {
        return Boolean.parseBoolean(this.useFileName);
    }

    public long getTimeout() {
        return BoostTestTaskData.parseUnsignedInt(this.timeout);
    }

    public void validate(ErrorCollection errorCollection, I18nBean i18nBean) {
        if (this.getParseOnly()) {
            if (StringUtils.isEmpty((CharSequence)this.outputs)) {
                errorCollection.addError(OUTPUTS_KEY, i18nBean.getText(OUTPUTS_ERROR_I18N));
            }
        } else {
            if (StringUtils.isEmpty((CharSequence)this.executables)) {
                errorCollection.addError(EXECUTABLES_KEY, i18nBean.getText(EXECUTABLES_ERROR_I18N));
            }
            try {
                if (this.getTimeout() == 0L) {
                    errorCollection.addError(TIMEOUT_KEY, i18nBean.getText(ZERO_ERROR_I18N));
                }
            }
            catch (NumberFormatException e) {
                errorCollection.addError(TIMEOUT_KEY, i18nBean.getText(NUMBER_ERROR_I18N));
            }
        }
    }

    public void populateTaskConfigMap(Map<String, ? super String> config) {
        config.put(EXECUTABLES_KEY, this.executables);
        config.put(SUBDIRECTORY_KEY, this.subdirectory);
        config.put(ENVIRONMENT_KEY, this.environment);
        config.put(OUTPUTS_KEY, this.outputs);
        config.put(PICKOUTDATEDFILES_KEY, this.pickupOutdatedFiles);
        config.put(PARSEONLY_KEY, this.parseOnly);
        config.put(USE_TASK_NAME_KEY, this.useTaskName);
        config.put(USE_FILE_NAME_KEY, this.useFileName);
        config.put(TIMEOUT_KEY, StringUtils.isEmpty((CharSequence)this.timeout) ? TIMEOUT_DEFAULT : this.timeout);
    }

    public static void populateTaskConfigMapDefaut(Map<String, ? super String> map) {
        map.put(TIMEOUT_KEY, TIMEOUT_DEFAULT);
    }

    private static int parseUnsignedInt(String str) {
        int val = Integer.parseInt(str);
        if (val < 0) {
            throw new NumberFormatException("Invalid postitive number string");
        }
        return val;
    }
}

