/*
 * Decompiled with CFR 0.152.
 */
package com.stellarity.bamboo.task;

import com.atlassian.bamboo.build.BuildOutputLogEntry;
import com.atlassian.bamboo.build.LogEntry;
import com.atlassian.bamboo.build.logger.BuildLogger;
import com.atlassian.bamboo.build.logger.LogInterceptor;
import com.atlassian.bamboo.build.logger.interceptors.ErrorMemorisingInterceptor;
import com.atlassian.bamboo.build.test.TestCollationService;
import com.atlassian.bamboo.build.test.TestReportProvider;
import com.atlassian.bamboo.process.EnvironmentVariableAccessor;
import com.atlassian.bamboo.task.CommonTaskContext;
import com.atlassian.bamboo.task.TaskContext;
import com.atlassian.bamboo.task.TaskException;
import com.atlassian.bamboo.task.TaskResult;
import com.atlassian.bamboo.task.TaskResultBuilder;
import com.atlassian.bamboo.task.TaskType;
import com.atlassian.bamboo.utils.SystemProperty;
import com.atlassian.bamboo.v2.build.CurrentBuildResult;
import com.atlassian.utils.process.ExternalProcess;
import com.atlassian.utils.process.ExternalProcessBuilder;
import com.atlassian.utils.process.ProcessException;
import com.atlassian.utils.process.ProcessHandler;
import com.atlassian.utils.process.ProcessTimeoutException;
import com.atlassian.utils.process.StringProcessHandler;
import com.stellarity.bamboo.task.BoostTestReportProvider;
import com.stellarity.bamboo.task.BoostTestTaskData;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.tools.ant.DirectoryScanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BoostTestTask
implements TaskType {
    private static final Logger LOG = LoggerFactory.getLogger(BoostTestTask.class);
    private final EnvironmentVariableAccessor environmentVariableAccessor;
    private final TestCollationService testCollationService;
    private final Object testCollationServiceLock = new Object();

    public BoostTestTask(EnvironmentVariableAccessor environmentVariableAccessor, TestCollationService testCollationService) {
        this.environmentVariableAccessor = environmentVariableAccessor;
        this.testCollationService = testCollationService;
    }

    public TaskResult execute(TaskContext taskContext) throws TaskException {
        return new Executor(taskContext).execute();
    }

    private static String[] findFiles(String pattern, File workDir) {
        String[] includes = pattern.split(",");
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setBasedir(workDir);
        scanner.setIncludes(includes);
        scanner.scan();
        return scanner.getIncludedFiles();
    }

    private static String[] removeOldTestFiles(String[] tests, File workDir, Date startDate) {
        long startTime = startDate.getTime() - SystemProperty.FS_TIMESTAMP_RESOLUTION_MS.getTypedValue();
        ArrayList<String> out = new ArrayList<String>();
        for (String test : tests) {
            File file = new File(workDir, test);
            if (file.lastModified() < startTime) continue;
            out.add(test);
        }
        return out.toArray(new String[0]);
    }

    private static String convertNewLines(String str) {
        if (str.contains("\r\n")) {
            return str.replace("\n", "");
        }
        return str.replace("\n", "\r");
    }

    private static String removeExtraNewLines(String str) {
        return str.replace("\r\r\r", "\r\r").trim() + "\r";
    }

    class Executor {
        private final BuildLogger buildLogger;
        private final BoostTestTaskData taskData;
        private final TaskContext taskContext;
        private final File workDir;

        public Executor(TaskContext taskContext) {
            this.taskContext = taskContext;
            this.buildLogger = taskContext.getBuildLogger();
            this.taskData = new BoostTestTaskData((Map<String, String>)taskContext.getConfigurationMap());
            this.workDir = new File(taskContext.getWorkingDirectory().getPath() + File.separator + this.taskData.getSubdirectory());
        }

        public TaskResult execute() throws TaskException {
            String pattern = this.taskData.getParseOnly() ? this.taskData.getOutputs() : this.taskData.getExecutables();
            LOG.info(this.buildLogger.addBuildLogEntry((LogEntry)new BuildOutputLogEntry("Searching '" + pattern + "' in '" + this.workDir.getAbsolutePath() + "'")));
            CurrentBuildResult buildResult = this.taskContext.getBuildContext().getBuildResult();
            String[] allTests = BoostTestTask.findFiles(pattern, this.workDir);
            String[] validTests = !this.taskData.getParseOnly() || this.taskData.getPickupOutdatedFiles() ? allTests : BoostTestTask.removeOldTestFiles(allTests, this.workDir, buildResult.getTasksStartDate());
            LOG.info(this.buildLogger.addBuildLogEntry((LogEntry)new BuildOutputLogEntry("Number of test files found: " + validTests.length)));
            if (allTests.length != validTests.length) {
                LOG.info(this.buildLogger.addBuildLogEntry((LogEntry)new BuildOutputLogEntry("Number of test files found (including outdated): " + allTests.length)));
            }
            if (validTests.length > 0) {
                ErrorMemorisingInterceptor errorLines = new ErrorMemorisingInterceptor();
                this.buildLogger.getInterceptorStack().add((LogInterceptor)errorLines);
                try {
                    this.executeTestsInParallel(validTests);
                }
                catch (InterruptedException e) {
                    LOG.error(this.buildLogger.addErrorLogEntry("Task execution was interrupted."), (Throwable)e);
                    return TaskResultBuilder.newBuilder((CommonTaskContext)this.taskContext).failed().build();
                }
                if (!errorLines.getErrorStringList().isEmpty()) {
                    buildResult.addBuildErrors(errorLines.getErrorStringList());
                    throw new TaskException("Failing the task due to errors. See the build log.");
                }
            }
            return TaskResultBuilder.newBuilder((CommonTaskContext)this.taskContext).checkTestFailures().build();
        }

        void executeTestsInParallel(String[] tests) throws InterruptedException {
            Map environment;
            Map map = environment = this.taskData.getParseOnly() ? null : BoostTestTask.this.environmentVariableAccessor.splitEnvironmentAssignments(this.taskData.getEnvironment(), false);
            if (null != environment && !environment.isEmpty()) {
                LOG.info(this.buildLogger.addBuildLogEntry("Using extra environment: " + this.taskData.getEnvironment()));
            }
            ExecutorService executorService = Executors.newFixedThreadPool(Math.min(Runtime.getRuntime().availableProcessors(), tests.length));
            ArrayList futures = new ArrayList(tests.length);
            for (String test : tests) {
                String fullTestPath = this.workDir.getAbsolutePath() + File.separator + test;
                Future<?> future = executorService.submit(() -> {
                    if (this.taskData.getParseOnly()) {
                        this.parseOutputFile(test, fullTestPath);
                    } else {
                        this.runExecutable(test, fullTestPath, environment);
                    }
                });
                futures.add(future);
            }
            for (Future future : futures) {
                try {
                    future.get();
                }
                catch (ExecutionException e) {
                    LOG.error(this.buildLogger.addErrorLogEntry("Test execution thread caught an exception."), (Throwable)e);
                }
            }
            executorService.shutdown();
            executorService.awaitTermination(Long.MAX_VALUE, TimeUnit.DAYS);
        }

        void runExecutable(String test, String fullTestPath, Map<String, String> environment) {
            LOG.info(this.buildLogger.addBuildLogEntry((LogEntry)new BuildOutputLogEntry("Started test: " + test)));
            List<String> commandsJunit = Arrays.asList(fullTestPath, "--log_format=JUNIT", "--log_level=message", "--report_level=no", "--result_code=no");
            List<String> commandsXml = Arrays.asList(fullTestPath, "--output_format=XML", "--log_level=test_suite", "--report_level=no", "--result_code=no");
            for (List commands : Arrays.asList(commandsJunit, commandsXml)) {
                StringProcessHandler processHandler = new StringProcessHandler();
                ExternalProcess process = new ExternalProcessBuilder().command(commands, this.workDir, TimeUnit.MINUTES.toMillis(this.taskData.getTimeout())).env(environment).handler((ProcessHandler)processHandler).build();
                process.execute();
                ProcessException processException = process.getHandler().getException();
                if (null != processException) {
                    if (processException instanceof ProcessTimeoutException) {
                        LOG.error(this.buildLogger.addErrorLogEntry("Test is timeouted (no output for " + this.taskData.getTimeout() + " minutes) : " + test));
                        break;
                    }
                    if (commands == commandsJunit) continue;
                    LOG.error(this.buildLogger.addErrorLogEntry("Failed running test: " + test + ", " + String.valueOf(processHandler.getException())));
                    break;
                }
                LOG.info(this.buildLogger.addBuildLogEntry((LogEntry)new BuildOutputLogEntry("Finished test: " + test)));
                this.parseOutputString(test, processHandler.getOutput());
                break;
            }
        }

        void parseOutputFile(String test, String fullTestPath) {
            try {
                String outputString = FileUtils.readFileToString((File)new File(fullTestPath), (String)"UTF-8");
                this.parseOutputString(test, outputString);
            }
            catch (IOException e) {
                LOG.error(this.buildLogger.addErrorLogEntry("Failed to read the test output file: " + test + ", " + String.valueOf(e)));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void parseOutputString(String test, String outputString) {
            BoostTestReportProvider provider;
            StringBuilder suffix = new StringBuilder();
            if (this.taskData.getUseFileName()) {
                suffix.append(FilenameUtils.removeExtension((String)test));
            }
            if (this.taskData.getUseTaskName()) {
                if (0 != suffix.length()) {
                    suffix.append(",");
                }
                suffix.append(this.taskContext.getUserDescription());
            }
            if (null == (provider = new BoostTestReportProvider(outputString, suffix.toString())).getException()) {
                StringBuilder testResultsLog = new StringBuilder();
                testResultsLog.append("Begin of test results for: ").append(test).append("\r\r");
                testResultsLog.append(BoostTestTask.removeExtraNewLines(BoostTestTask.convertNewLines(provider.getTestLog().toString())));
                int failures = provider.getTestCollectionResult().getFailedTestResults().size();
                if (0 == failures) {
                    testResultsLog.append("\r*** No failures are detected.\r\r");
                } else {
                    testResultsLog.append("\r*** ").append(failures).append(" failures are detected.\r\r");
                }
                testResultsLog.append("End of test results for: ").append(test);
                LOG.info(this.buildLogger.addBuildLogEntry(testResultsLog.toString()));
                Object object = BoostTestTask.this.testCollationServiceLock;
                synchronized (object) {
                    BoostTestTask.this.testCollationService.collateTestResults(this.taskContext, (TestReportProvider)provider);
                }
            } else {
                LOG.error(this.buildLogger.addErrorLogEntry("Failed to parse test results for: " + test + ", " + String.valueOf(provider.getException())));
            }
        }
    }
}

