/*
 * Decompiled with CFR 0.152.
 */
package com.stellarity.bamboo.task;

import com.atlassian.bamboo.configuration.DefaultElementParser;
import com.atlassian.bamboo.configuration.ElementContentElementParser;
import com.atlassian.bamboo.configuration.ElementParser;
import com.atlassian.bamboo.results.tests.TestResults;
import com.atlassian.bamboo.resultsummary.tests.TestCaseResultError;
import com.atlassian.bamboo.resultsummary.tests.TestCaseResultErrorImpl;
import com.atlassian.bamboo.resultsummary.tests.TestState;
import com.stellarity.bamboo.task.BoostTestParser;
import java.util.Iterator;
import java.util.Stack;
import org.xml.sax.Attributes;

public class BoostTestParserXml
extends BoostTestParser {
    private final StringBuilder testCaseErrors = new StringBuilder();
    private final Stack<String> testSuiteStack = new Stack();
    private String testCaseTime;
    private String testCaseName;

    public BoostTestParserXml() {
        this.startMarker = "<TestLog>";
        this.registerElementParser("TestSuite", (ElementParser)new TestSuiteParser());
        this.registerElementParser("TestCase", (ElementParser)new TestCaseParser());
        this.registerElementParser("Error", (ElementParser)new ErrorParser());
        this.registerElementParser("FatalError", (ElementParser)new FatalErrorParser());
        this.registerElementParser("Exception", (ElementParser)new FatalErrorParser());
        this.registerElementParser("Warning", (ElementParser)new WarningParser());
        this.registerElementParser("Message", (ElementParser)new MessageParser());
        this.registerElementParser("TestingTime", (ElementParser)new TestingTimeParser());
    }

    private String getTestSuiteName() {
        StringBuilder testSuiteName = new StringBuilder();
        Iterator it = this.testSuiteStack.iterator();
        while (it.hasNext()) {
            testSuiteName.append((String)it.next());
            if (!it.hasNext()) continue;
            testSuiteName.append(".");
        }
        if (!this.suffix.isEmpty()) {
            testSuiteName.append(" {");
            testSuiteName.append(this.suffix);
            testSuiteName.append("}");
        }
        return testSuiteName.toString();
    }

    class TestSuiteParser
    extends DefaultElementParser {
        TestSuiteParser() {
        }

        public void startElement(Attributes attributes) {
            BoostTestParserXml.this.testSuiteStack.push(attributes.getValue("name"));
            BoostTestParserXml.this.valid = true;
        }

        public void endElement() {
            BoostTestParserXml.this.testSuiteStack.pop();
        }
    }

    class TestCaseParser
    extends DefaultElementParser {
        TestCaseParser() {
        }

        public void startElement(Attributes attributes) {
            BoostTestParserXml.this.testCaseName = attributes.getValue("name");
        }

        public void endElement() {
            Double duration = Double.parseDouble(BoostTestParserXml.this.testCaseTime) / 1000000.0;
            TestResults results = new TestResults(BoostTestParserXml.this.getTestSuiteName(), BoostTestParserXml.this.testCaseName, BoostTestParser.toMilliseconds(duration.toString()));
            String errors = BoostTestParserXml.this.testCaseErrors.toString();
            if (!errors.isEmpty()) {
                results.addError((TestCaseResultError)new TestCaseResultErrorImpl(errors));
                results.setState(TestState.FAILED);
                BoostTestParserXml.this.failedTests.add(results);
            } else {
                results.setState(TestState.SUCCESS);
                BoostTestParserXml.this.passedTests.add(results);
            }
            BoostTestParserXml.this.testCaseName = null;
            BoostTestParserXml.this.testCaseTime = null;
            BoostTestParserXml.this.testCaseErrors.setLength(0);
        }
    }

    class ErrorParser
    extends MessageParser {
        ErrorParser() {
        }

        @Override
        public void endElement() {
            String logLine = this.file + "(" + this.line + "): error in \"" + BoostTestParserXml.this.testCaseName + "\": " + String.valueOf(this.message) + "\r";
            BoostTestParserXml.this.testLog.append(logLine);
            BoostTestParserXml.this.testCaseErrors.append(logLine);
        }
    }

    class FatalErrorParser
    extends MessageParser {
        FatalErrorParser() {
        }

        @Override
        public void endElement() {
            String logLine = this.file + "(" + this.line + "): fatal error in \"" + BoostTestParserXml.this.testCaseName + "\": " + String.valueOf(this.message) + "\r";
            BoostTestParserXml.this.testLog.append(logLine);
            BoostTestParserXml.this.testCaseErrors.append(logLine);
        }
    }

    class WarningParser
    extends MessageParser {
        WarningParser() {
        }

        @Override
        public void endElement() {
            String logLine = this.file + "(" + this.line + "): warning in \"" + BoostTestParserXml.this.testCaseName + "\": " + String.valueOf(this.message) + "\r";
            BoostTestParserXml.this.testLog.append(logLine);
        }
    }

    class MessageParser
    extends DefaultElementParser {
        protected String file;
        protected String line;
        protected StringBuilder message;

        MessageParser() {
        }

        public void startElement(Attributes attributes) {
            this.file = attributes.getValue("file");
            this.line = attributes.getValue("line");
            this.message = new StringBuilder();
        }

        public void characters(char[] chars, int offset, int length) {
            this.message.append(chars, offset, length);
        }

        public void endElement() {
            String logLine = this.file + "(" + this.line + "): " + String.valueOf(this.message) + "\r";
            BoostTestParserXml.this.testLog.append(logLine);
        }
    }

    class TestingTimeParser
    extends ElementContentElementParser {
        TestingTimeParser() {
        }

        public void endElement() {
            BoostTestParserXml.this.testCaseTime = this.getElementContent();
        }
    }
}

