/*
 * Decompiled with CFR 0.152.
 */
package com.stellarity.bamboo.task;

import com.atlassian.bamboo.configuration.DefaultContentHandler;
import com.atlassian.bamboo.configuration.DefaultElementParser;
import com.atlassian.bamboo.configuration.ElementParser;
import com.atlassian.bamboo.results.tests.TestResults;
import com.atlassian.bamboo.util.NumberUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.jetbrains.annotations.Nullable;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public abstract class BoostTestParser
extends DefaultContentHandler {
    private static final ElementParser DO_NOTHING_PARSER = new DefaultElementParser();
    protected final StringBuilder testLog = new StringBuilder();
    protected final Set<TestResults> failedTests = new LinkedHashSet<TestResults>();
    protected final Set<TestResults> passedTests = new LinkedHashSet<TestResults>();
    protected final Set<TestResults> skippedTests = new LinkedHashSet<TestResults>();
    protected String suffix;
    protected boolean valid = false;
    protected String startMarker;

    public void parse(String data, String suffix) throws IOException, SAXException, ParserConfigurationException {
        this.suffix = suffix.replace('.', '_');
        int idx = data.indexOf(this.startMarker);
        if (idx < 0) {
            throw new SAXException("XML schema mismatch");
        }
        this.testLog.append(data.substring(0, idx));
        SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();
        saxParserFactory.setNamespaceAware(true);
        XMLReader reader = saxParserFactory.newSAXParser().getXMLReader();
        reader.setContentHandler((ContentHandler)((Object)this));
        reader.parse(new InputSource(new ByteArrayInputStream(data.substring(idx).getBytes("UTF-8"))));
        if (!this.valid) {
            throw new SAXException("XML schema mismatch");
        }
    }

    public Set<TestResults> getFailedTests() {
        return this.failedTests;
    }

    public Set<TestResults> getPassedTests() {
        return this.passedTests;
    }

    public Set<TestResults> getSkippedTests() {
        return this.skippedTests;
    }

    public StringBuilder getTestLog() {
        return this.testLog;
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (!this.hasParserFor(localName)) {
            this.registerElementParser(localName, DO_NOTHING_PARSER);
        }
        super.startElement(uri, localName, qName, attributes);
    }

    @Nullable
    protected static Long toMilliseconds(@Nullable String durationInSeconds) {
        Double seconds = NumberUtils.createDoubleQuietly((String)durationInSeconds);
        return seconds == null ? null : Long.valueOf((long)(seconds * 1000.0));
    }
}

