/*
 * Decompiled with CFR 0.152.
 */
package com.stellarity.bamboo.task;

import com.atlassian.bamboo.collections.ActionParametersMap;
import com.atlassian.bamboo.task.AbstractTaskConfigurator;
import com.atlassian.bamboo.task.TaskDefinition;
import com.atlassian.bamboo.task.TaskTestResultsSupport;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.atlassian.bamboo.utils.i18n.I18nBean;
import com.atlassian.bamboo.utils.i18n.I18nBeanFactory;
import com.stellarity.bamboo.task.BoostTestTaskData;
import com.stellarity.bamboo.utils.LicenseChecker;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public class BoostTestTaskConfigurator
extends AbstractTaskConfigurator
implements TaskTestResultsSupport {
    private final I18nBean i18nBean;
    private final LicenseChecker licenseChecker;

    public BoostTestTaskConfigurator(I18nBeanFactory i18nBeanFactory) {
        this.i18nBean = i18nBeanFactory.getI18nBean();
        this.licenseChecker = new LicenseChecker(((Object)((Object)this)).getClass(), "Stellarity Software - Boost::Test Task");
    }

    public Map<String, String> generateTaskConfigMap(ActionParametersMap params, @Nullable TaskDefinition previousTaskDefinition) {
        Map config = super.generateTaskConfigMap(params, previousTaskDefinition);
        this.populateTaskConfigMapWithActionParameters(config, params);
        return config;
    }

    public void populateContextForCreate(Map<String, Object> context) {
        BoostTestTaskData.populateTaskConfigMapDefaut(context);
    }

    public void populateContextForEdit(Map<String, Object> context, TaskDefinition taskDefinition) {
        this.populateContextWithTaskDefinition(context, taskDefinition);
    }

    public void populateContextForView(Map<String, Object> context, TaskDefinition taskDefinition) {
        this.populateContextForEdit(context, taskDefinition);
    }

    public void validate(ActionParametersMap params, ErrorCollection errorCollection) {
        super.validate(params, errorCollection);
        new BoostTestTaskData(params).validate(errorCollection, this.i18nBean);
        String licenseError = this.licenseChecker.getLicenseError();
        if (null != licenseError) {
            errorCollection.addErrorMessage(licenseError);
        }
    }

    private void populateContextWithTaskDefinition(Map<String, Object> context, TaskDefinition taskDefinition) {
        BoostTestTaskData taskData = new BoostTestTaskData(taskDefinition.getConfiguration());
        taskData.populateTaskConfigMap(context);
    }

    private void populateTaskConfigMapWithActionParameters(Map<String, String> config, ActionParametersMap params) {
        BoostTestTaskData taskData = new BoostTestTaskData(params);
        taskData.populateTaskConfigMap(config);
    }

    public boolean taskProducesTestResults(TaskDefinition taskDefinition) {
        return true;
    }
}

