/*
 * Decompiled with CFR 0.152.
 */
package com.stellarity.bamboo.task;

import com.atlassian.bamboo.configuration.DefaultElementParser;
import com.atlassian.bamboo.configuration.ElementParser;
import com.atlassian.bamboo.results.tests.TestResults;
import com.atlassian.bamboo.resultsummary.tests.TestCaseResultError;
import com.atlassian.bamboo.resultsummary.tests.TestCaseResultErrorImpl;
import com.atlassian.bamboo.resultsummary.tests.TestState;
import com.stellarity.bamboo.task.BoostTestParser;
import org.xml.sax.Attributes;

public class BoostTestParserJunit
extends BoostTestParser {
    private String testSuiteName;
    private final StringBuilder testCaseErrors = new StringBuilder();
    private String testClassName;
    private String testCaseName;
    private String testCaseTime;
    private boolean testSkipped = false;

    public BoostTestParserJunit() {
        this.startMarker = "<?xml";
        this.registerElementParser("testsuite", (ElementParser)new TestSuiteParser());
        this.registerElementParser("testcase", (ElementParser)new TestCaseParser());
        this.registerElementParser("error", (ElementParser)new ErrorFailureParser());
        this.registerElementParser("failure", (ElementParser)new ErrorFailureParser());
        this.registerElementParser("system-out", (ElementParser)new SystemOutParser());
        this.registerElementParser("skipped", (ElementParser)new SkippedParser());
    }

    private String getTestClassFullName() {
        StringBuilder testClassFullName = new StringBuilder();
        testClassFullName.append(this.testSuiteName);
        testClassFullName.append(".");
        testClassFullName.append(this.testClassName);
        if (!this.suffix.isEmpty()) {
            testClassFullName.append(" {");
            testClassFullName.append(this.suffix);
            testClassFullName.append("}");
        }
        return testClassFullName.toString();
    }

    class SkippedParser
    extends DefaultElementParser {
        SkippedParser() {
        }

        public void startElement(Attributes attributes) {
            BoostTestParserJunit.this.testSkipped = true;
        }
    }

    class SystemOutParser
    extends DefaultElementParser {
        protected StringBuilder message;

        SystemOutParser() {
        }

        public void startElement(Attributes attributes) {
            this.message = new StringBuilder();
        }

        public void characters(char[] chars, int offset, int length) {
            this.message.append(chars, offset, length);
        }

        public void endElement() {
            BoostTestParserJunit.this.testLog.append((CharSequence)this.message);
        }
    }

    class ErrorFailureParser
    extends DefaultElementParser {
        protected StringBuilder message;

        ErrorFailureParser() {
        }

        public void startElement(Attributes attributes) {
            this.message = new StringBuilder();
        }

        public void characters(char[] chars, int offset, int length) {
            this.message.append(chars, offset, length);
        }

        public void endElement() {
            BoostTestParserJunit.this.testLog.append((CharSequence)this.message);
            BoostTestParserJunit.this.testCaseErrors.append((CharSequence)this.message);
        }
    }

    class TestCaseParser
    extends DefaultElementParser {
        TestCaseParser() {
        }

        public void startElement(Attributes attributes) {
            BoostTestParserJunit.this.testClassName = attributes.getValue("classname");
            BoostTestParserJunit.this.testCaseName = attributes.getValue("name");
            BoostTestParserJunit.this.testCaseTime = attributes.getValue("time");
        }

        public void endElement() {
            TestResults results = new TestResults(BoostTestParserJunit.this.getTestClassFullName(), BoostTestParserJunit.this.testCaseName, BoostTestParserJunit.this.testCaseTime);
            String errors = BoostTestParserJunit.this.testCaseErrors.toString();
            if (BoostTestParserJunit.this.testSkipped) {
                results.setState(TestState.SKIPPED);
                BoostTestParserJunit.this.skippedTests.add(results);
            } else if (!errors.isEmpty()) {
                results.addError((TestCaseResultError)new TestCaseResultErrorImpl(errors));
                results.setState(TestState.FAILED);
                BoostTestParserJunit.this.failedTests.add(results);
            } else {
                results.setState(TestState.SUCCESS);
                BoostTestParserJunit.this.passedTests.add(results);
            }
            BoostTestParserJunit.this.testClassName = null;
            BoostTestParserJunit.this.testCaseName = null;
            BoostTestParserJunit.this.testCaseTime = null;
            BoostTestParserJunit.this.testSkipped = false;
            BoostTestParserJunit.this.testCaseErrors.setLength(0);
        }
    }

    class TestSuiteParser
    extends DefaultElementParser {
        TestSuiteParser() {
        }

        public void startElement(Attributes attributes) {
            BoostTestParserJunit.this.testSuiteName = attributes.getValue("name");
            BoostTestParserJunit.this.valid = true;
        }
    }
}

