/*
 * Decompiled with CFR 0.152.
 */
package com.secsign.bamboo.util;

import com.atlassian.bamboo.user.BambooUserManager;
import com.atlassian.user.User;
import com.atlassian.user.search.page.Pager;
import com.secsign.bamboo.accessor.SecSignIDStaticAccessor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecSignIDUserManager {
    private static final Logger logger = LoggerFactory.getLogger(SecSignIDUserManager.class);

    public static User getBambooUser(String userKeyOrName) {
        return SecSignIDUserManager.getBambooUser(null, userKeyOrName);
    }

    public static User getBambooUser(BambooUserManager umgr, String userKeyOrName) {
        String userKeyLowerCase;
        User bambooUser;
        if (umgr == null) {
            umgr = SecSignIDStaticAccessor.getBambooUserManager();
        }
        if ((bambooUser = umgr.getUser(userKeyLowerCase = userKeyOrName.toLowerCase())) == null) {
            logger.warn("did not find an application user with key and username '" + userKeyOrName + "'.");
            return null;
        }
        return bambooUser;
    }

    public static String getBambooUserKeyOrName(User bambooUser) {
        if (bambooUser == null) {
            logger.error("cannot get application user key, given application user is null");
            return null;
        }
        return bambooUser.getName();
    }

    public static Collection<User> getAllBambooUserSorted() {
        BambooUserManager bum = SecSignIDStaticAccessor.getBambooUserManager();
        Pager users = bum.getUsers();
        ArrayList<User> bambooUsers = new ArrayList<User>();
        for (User u : users) {
            bambooUsers.add((User)bum.getBambooUser(u));
        }
        Collections.sort(bambooUsers, new Comparator<User>(){

            @Override
            public int compare(User u1, User u2) {
                if (u1 == null) {
                    return 1;
                }
                if (u2 == null) {
                    return -1;
                }
                return u1.getName().compareTo(u2.getName());
            }
        });
        return bambooUsers;
    }
}

