/*
 * Decompiled with CFR 0.152.
 */
package com.secsign.bamboo.servlet.filter;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.exception.ApplicationPermissionException;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.exception.InvalidAuthenticationException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.exception.PermissionException;
import com.atlassian.crowd.exception.UserNotFoundException;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.secsign.atlassian.common.accessor.SecSignIDCommonStaticAccessor;
import com.secsign.atlassian.common.data.SecSignID2FAActivatedSettings;
import com.secsign.atlassian.common.data.SecSignID2FASettings;
import com.secsign.atlassian.common.data.SecSignIDTrustDeviceToken;
import com.secsign.atlassian.common.interfaces.SecSignIDDataAccessor;
import com.secsign.atlassian.common.util.SecSignIDCharArrayWriter;
import com.secsign.atlassian.common.util.SecSignIDCommonConstants;
import com.secsign.atlassian.common.util.SecSignIDServletResponseWrapper;
import com.secsign.atlassian.common.util.SecSignIDTemplateHelper;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecSignIDViewUserFilter
implements Filter {
    private static final Logger logger = LoggerFactory.getLogger(SecSignIDViewUserFilter.class);
    private final TemplateRenderer templateRenderer;
    private final SecSignIDDataAccessor dataAccessor;
    private String viewUserTemplate = "/templates/secsignid-viewuser.vm";

    public SecSignIDViewUserFilter(TemplateRenderer templateRenderer, SecSignIDDataAccessor dataAccessor) {
        this.templateRenderer = templateRenderer;
        this.dataAccessor = dataAccessor;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (request.getParameter("username") != null) {
            SecSignIDServletResponseWrapper responseWrapper = new SecSignIDServletResponseWrapper((HttpServletResponse)response);
            try {
                Integer fidoAllowed;
                Integer totpAllowed;
                Integer mailotpAllowed;
                Integer twoStepAllowed;
                Integer passwordlessAllowed;
                Integer pwdAllowed;
                HttpServletRequest httpServletReq = (HttpServletRequest)request;
                chain.doFilter(request, (ServletResponse)responseWrapper);
                HashMap<String, Object> context = new HashMap<String, Object>();
                context.put("contextPath", ((HttpServletRequest)request).getContextPath());
                String username = httpServletReq.getParameter("username");
                String userKey = this.dataAccessor.getUserKeyForUsername(username);
                User user = this.dataAccessor.getUserForKeyFirst(userKey);
                HashMap<String, SecSignID2FASettings> mappings = null;
                try {
                    List<String> groupNames = this.dataAccessor.getGroupMappingKeysForUserKey(userKey, user.getDirectoryId());
                    mappings = this.dataAccessor.get2FASettingsForGroups(groupNames);
                }
                catch (OperationFailedException e) {
                    logger.error("OperationFailedException on ViewUserfilter");
                }
                catch (InvalidAuthenticationException e) {
                    logger.error("InvalidAuthenticationException on ViewUserfilter");
                }
                catch (ApplicationPermissionException e) {
                    logger.error("ApplicationPermissionException on ViewUserfilter");
                }
                catch (DirectoryNotFoundException e) {
                    logger.error("DirectoryNotFoundException on ViewUserfilter");
                }
                String secSignIdsStr = null;
                boolean fidoSupported = SecSignIDCommonStaticAccessor.isFIDOSupported();
                SecSignID2FASettings settingsForUser = null;
                SecSignID2FAActivatedSettings activatedSettingsForUser = null;
                try {
                    settingsForUser = this.dataAccessor.get2FASettingsFromUserKey(userKey, user.getDirectoryId());
                    activatedSettingsForUser = this.dataAccessor.get2FAActivatedSettingsFromUserKey(userKey, user.getDirectoryId());
                    pwdAllowed = settingsForUser.getPwdAllowed();
                    passwordlessAllowed = settingsForUser.getPasswordlessAllowed();
                    twoStepAllowed = settingsForUser.getTwoStepAllowed();
                    mailotpAllowed = settingsForUser.getMailOtpAllowed();
                    totpAllowed = settingsForUser.getTotpAllowed();
                    fidoAllowed = settingsForUser.getFidoAllowed();
                    if (!fidoSupported) {
                        fidoAllowed = SecSignIDCommonConstants.AuthIsNotAllowed;
                    }
                }
                catch (Exception e) {
                    pwdAllowed = SecSignIDCommonConstants.PasswordLoginIsAllowed;
                    passwordlessAllowed = SecSignIDCommonConstants.AuthIsNotAllowed;
                    twoStepAllowed = SecSignIDCommonConstants.AuthIsNotAllowed;
                    mailotpAllowed = SecSignIDCommonConstants.AuthIsNotAllowed;
                    totpAllowed = SecSignIDCommonConstants.AuthIsNotAllowed;
                    fidoAllowed = SecSignIDCommonConstants.AuthIsNotAllowed;
                }
                User loggedInUser = this.dataAccessor.getUserCurrentlyLoggedIn();
                boolean isAdmin = this.dataAccessor.isUserAdmin(loggedInUser);
                try {
                    secSignIdsStr = this.dataAccessor.getSecSignIdStringForApplicationUserKey(userKey, user.getDirectoryId());
                }
                catch (Exception e) {
                    secSignIdsStr = "";
                }
                context.put("groupMappingsOfUser", mappings);
                context.put("filterObject", this);
                context.put("passwordlessAuthEnabled", SecSignIDCommonStaticAccessor.getPasswordlessAuthEnabled());
                context.put("twoStepAuthEnabled", SecSignIDCommonStaticAccessor.getTwoStepAuthEnabled());
                context.put("mailotpAuthEnabled", SecSignIDCommonStaticAccessor.getMailotpAuthEnabled());
                context.put("totpAuthEnabled", SecSignIDCommonStaticAccessor.getTotpAuthEnabled());
                context.put("fidoAuthEnabled", SecSignIDCommonStaticAccessor.getFidoAuthEnabled());
                context.put("authIsAllowedValue", SecSignIDCommonConstants.AuthIsAllowed);
                context.put("user2FASettings", settingsForUser);
                context.put("user2FAActivatedSettings", activatedSettingsForUser);
                context.put("PASSWORDLESSGROUPNAME", "PasswordlessAllowed".toLowerCase());
                context.put("TWOSTEPGROUPNAME", "2SASecSignIDAllowed".toLowerCase());
                context.put("MAILOTPGROUPNAME", "2SAMailOTPAllowed".toLowerCase());
                context.put("TOTPGROUPNAME", "2SATOTPAllowed".toLowerCase());
                context.put("FIDOGROUPNAME", "2SAFIDOAllowed".toLowerCase());
                context.put("userName", user.getName());
                context.put("userKey", user.getName());
                context.put("userDirID", user.getDirectoryId());
                context.put("templateHelper", new SecSignIDTemplateHelper());
                context.put("req", httpServletReq);
                context.put("directoryID", user.getDirectoryId());
                boolean ownProfile = user.equals((Object)loggedInUser);
                context.put("ownProfile", String.valueOf(ownProfile));
                context.put("secsignidstr", secSignIdsStr);
                context.put("pwdAllowed", pwdAllowed);
                context.put("passwordlessAllowed", passwordlessAllowed);
                context.put("twoStepAllowed", twoStepAllowed);
                context.put("mailotpAllowed", mailotpAllowed);
                context.put("totpAllowed", totpAllowed);
                context.put("fidoAllowed", fidoAllowed);
                context.put("is-pwdallowed-value", SecSignIDCommonConstants.PasswordLoginIsAllowed);
                context.put("logged-in-isadmin", String.valueOf(isAdmin));
                context.put("groupsCreated", SecSignIDCommonStaticAccessor.getGroupsCreated());
                SecSignIDCharArrayWriter renderedTemplate = new SecSignIDCharArrayWriter();
                this.templateRenderer.render(this.viewUserTemplate, context, (Writer)renderedTemplate);
                responseWrapper.inject(renderedTemplate);
                PrintWriter responseOutput = response.getWriter();
                response.setContentLength(responseWrapper.length());
                responseOutput.write(responseWrapper.toString());
                responseOutput.close();
            }
            catch (Exception e) {
                PrintWriter responseOutput = response.getWriter();
                response.setContentLength(responseWrapper.length());
                responseOutput.write(responseWrapper.toString());
                responseOutput.close();
            }
        } else {
            chain.doFilter(request, response);
        }
    }

    private SecSignIDTrustDeviceToken getTrustDeviceTokenFromRequest(String userKey, long dirId, HttpServletRequest request) {
        Cookie[] cookies = request.getCookies();
        if (cookies == null) {
            return null;
        }
        String tokenValue = null;
        for (Cookie cookie : cookies) {
            if (!cookie.getName().equals("secsignid_trustdevicetoken_" + this.dataAccessor.getApplication().toLowerCase())) continue;
            tokenValue = cookie.getValue();
            break;
        }
        if (tokenValue == null) {
            return null;
        }
        String userAgent = request.getHeader("User-Agent");
        if (userAgent == null || userAgent.equals("")) {
            userAgent = "empty";
        }
        try {
            return this.dataAccessor.getTrustDeviceToken(userKey, dirId, tokenValue, userAgent);
        }
        catch (UserNotFoundException e) {
            logger.error(SecSignIDCommonStaticAccessor.getStackTraceOfError((Exception)((Object)e)));
            logger.error("UserNotFoundException on getTrustDeviceToken");
            return null;
        }
        catch (InvalidAuthenticationException e) {
            logger.error(SecSignIDCommonStaticAccessor.getStackTraceOfError((Exception)((Object)e)));
            logger.error("InvalidAuthenticationException on getTrustDeviceToken");
            return null;
        }
        catch (ApplicationPermissionException e) {
            logger.error(SecSignIDCommonStaticAccessor.getStackTraceOfError((Exception)((Object)e)));
            logger.error("ApplicationPermissionException on getTrustDeviceToken");
            return null;
        }
        catch (DirectoryNotFoundException e) {
            logger.error(SecSignIDCommonStaticAccessor.getStackTraceOfError((Exception)((Object)e)));
            logger.error("DirectoryNotFoundException on getTrustDeviceToken");
            return null;
        }
        catch (PermissionException e) {
            logger.error(SecSignIDCommonStaticAccessor.getStackTraceOfError((Exception)((Object)e)));
            logger.error("PermissionException on getTrustDeviceToken");
            return null;
        }
        catch (OperationFailedException e) {
            logger.error(SecSignIDCommonStaticAccessor.getStackTraceOfError((Exception)((Object)e)));
            logger.error("OperationFailedException on getTrustDeviceToken");
            return null;
        }
    }
}

