/*
 * Decompiled with CFR 0.152.
 */
package com.secsign.bamboo.servlet.filter;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.secsign.atlassian.common.contextprovider.SecSignIDUserInfoProvider;
import com.secsign.atlassian.common.interfaces.SecSignIDDataAccessor;
import com.secsign.atlassian.common.util.SecSignIDCharArrayWriter;
import com.secsign.atlassian.common.util.SecSignIDServletResponseWrapper;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.HashMap;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecSignIDViewProfileFilter
implements Filter {
    private static final Logger logger = LoggerFactory.getLogger(SecSignIDViewProfileFilter.class);
    private final TemplateRenderer templateRenderer;
    private final ActiveObjects ao;
    private final PluginSettingsFactory pluginSettingsFactory;
    private final SecSignIDDataAccessor dataAccessor;
    private String viewProfileTemplate = "/templates/secsignid-viewprofile.vm";

    public SecSignIDViewProfileFilter(TemplateRenderer templateRenderer, ActiveObjects ao, PluginSettingsFactory pluginSettingsFactory, SecSignIDDataAccessor dataAccessor) {
        this.templateRenderer = templateRenderer;
        this.ao = ao;
        this.pluginSettingsFactory = pluginSettingsFactory;
        this.dataAccessor = dataAccessor;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        SecSignIDServletResponseWrapper responseWrapper = new SecSignIDServletResponseWrapper((HttpServletResponse)response);
        HttpServletRequest httpServletReq = (HttpServletRequest)request;
        chain.doFilter(request, (ServletResponse)responseWrapper);
        User user = this.dataAccessor.getUserCurrentlyLoggedIn();
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("name", user.getName());
        context.put("dirid", String.valueOf(user.getDirectoryId()));
        context.put("req", request);
        SecSignIDUserInfoProvider infoProvider = new SecSignIDUserInfoProvider();
        context.putAll(infoProvider.getContextMap(context));
        SecSignIDCharArrayWriter renderedTemplate = new SecSignIDCharArrayWriter();
        this.templateRenderer.render(this.viewProfileTemplate, context, (Writer)renderedTemplate);
        responseWrapper.inject(renderedTemplate);
        PrintWriter responseOutput = response.getWriter();
        response.setContentLength(responseWrapper.length());
        responseOutput.write(responseWrapper.toString());
        responseOutput.close();
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void destroy() {
    }
}

