/*
 * Decompiled with CFR 0.152.
 */
package com.secsign.bamboo.servlet.filter;

import com.atlassian.crowd.directory.ssl.LdapHostnameVerificationSSLSocketFactory;
import com.atlassian.seraph.auth.AuthenticatorException;
import com.atlassian.seraph.config.SecurityConfig;
import com.atlassian.seraph.filter.BaseLoginFilter;
import com.atlassian.seraph.filter.PasswordBasedLoginFilter;
import com.atlassian.seraph.interceptor.LoginInterceptor;
import com.secsign.bamboo.accessor.SecSignIDStaticAccessor;
import com.secsign.bamboo.util.SecSignIDUserManager;
import java.util.List;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecSignIDPasswordLoginFilter
extends BaseLoginFilter {
    private static final Logger logger = LoggerFactory.getLogger(SecSignIDPasswordLoginFilter.class);
    private ServletContext servletContext;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String login(HttpServletRequest request, HttpServletResponse response) {
        Thread currentThread = Thread.currentThread();
        ClassLoader classLoader = currentThread.getContextClassLoader();
        currentThread.setContextClassLoader(LdapHostnameVerificationSSLSocketFactory.class.getClassLoader());
        SecSignIDUserPwdPair userPair = this.extractBambooUserPasswordPair(request);
        String status = "noattempt";
        if (userPair != null && userPair.userName != null && userPair.password != null) {
            List interceptors = this.getSecurityConfig().getInterceptors(LoginInterceptor.class);
            try {
                for (LoginInterceptor loginInterceptor : interceptors) {
                    loginInterceptor.beforeLogin(request, response, userPair.userName, userPair.password, userPair.persistent);
                }
                if (this.getElevatedSecurityGuard().performElevatedSecurityCheck(request, userPair.userName)) {
                    boolean loggedIn = this.getAuthenticator().login(request, response, userPair.userName, userPair.password, userPair.persistent);
                    String string = status = loggedIn ? "success" : "failed";
                    if (!loggedIn) {
                        this.getElevatedSecurityGuard().onFailedLoginAttempt(request, userPair.userName);
                    } else {
                        this.getElevatedSecurityGuard().onSuccessfulLoginAttempt(request, userPair.userName);
                    }
                } else {
                    this.getElevatedSecurityGuard().onFailedLoginAttempt(request, userPair.userName);
                    status = "failed";
                }
            }
            catch (Exception ex) {
                logger.error(ex.getMessage(), (Throwable)ex);
                status = "failed";
                return status;
            }
            finally {
                for (LoginInterceptor loginInterceptor : interceptors) {
                    loginInterceptor.afterLogin(request, response, userPair.userName, userPair.password, userPair.persistent, status);
                }
            }
        }
        return status;
    }

    public boolean logout(HttpServletRequest request, HttpServletResponse response) throws AuthenticatorException {
        return this.getAuthenticator().logout(request, response);
    }

    public boolean checkLogin(HttpServletRequest request, HttpServletResponse response) throws AuthenticatorException {
        Thread currentThread = Thread.currentThread();
        ClassLoader classLoader = currentThread.getContextClassLoader();
        currentThread.setContextClassLoader(LdapHostnameVerificationSSLSocketFactory.class.getClassLoader());
        SecSignIDUserPwdPair userPair = this.extractBambooUserPasswordPair(request);
        if (SecSignIDUserManager.getBambooUser(userPair.userName) == null) {
            return false;
        }
        boolean success = this.getElevatedSecurityGuard().performElevatedSecurityCheck(request, userPair.userName);
        if (!success) {
            this.getElevatedSecurityGuard().onFailedLoginAttempt(request, userPair.userName);
            return false;
        }
        boolean successFull = SecSignIDStaticAccessor.getBambooUserManager().authenticate(userPair.userName, userPair.password);
        if (successFull) {
            this.getElevatedSecurityGuard().onSuccessfulLoginAttempt(request, userPair.userName);
            return true;
        }
        this.getElevatedSecurityGuard().onFailedLoginAttempt(request, userPair.userName);
        return false;
    }

    protected SecSignIDUserPwdPair extractBambooUserPasswordPair(HttpServletRequest httpServletReq) {
        String userName = httpServletReq.getParameter("os_username");
        String password = httpServletReq.getParameter("os_password");
        boolean persistent = Boolean.getBoolean(httpServletReq.getParameter("os_cookie"));
        if (userName == null && password == null) {
            userName = httpServletReq.getParameter("secsign_os_username");
            password = httpServletReq.getParameter("secsign_os_password");
        }
        if (userName != null) {
            userName = userName.toLowerCase();
        }
        return new SecSignIDUserPwdPair(userName, password, persistent);
    }

    PasswordBasedLoginFilter.UserPasswordPair extractUserPasswordPair(HttpServletRequest request) {
        return null;
    }

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    protected SecurityConfig getSecurityConfig() {
        if (this.servletContext != null) {
            return (SecurityConfig)this.servletContext.getAttribute("seraph_config");
        }
        try {
            return super.getSecurityConfig();
        }
        catch (Exception ex) {
            logger.error("Could not get filter config or servlet context");
            return null;
        }
    }

    private class SecSignIDUserPwdPair {
        final String userName;
        final String password;
        final boolean persistent;

        public SecSignIDUserPwdPair(String user, String password, boolean persistent) {
            this.userName = user;
            this.password = password;
            this.persistent = persistent;
        }
    }
}

