/*
 * Decompiled with CFR 0.152.
 */
package com.secsign.bamboo.servlet.filter;

import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.seraph.auth.Authenticator;
import com.atlassian.seraph.auth.AuthenticatorException;
import com.atlassian.seraph.config.SecurityConfigFactory;
import com.secsign.atlassian.common.accessor.SecSignIDCommonStaticAccessor;
import com.secsign.atlassian.common.accessor.SecSignIDSessionManager;
import com.secsign.atlassian.common.interfaces.SecSignIDDataAccessor;
import com.secsign.atlassian.common.util.SecSignIDMappingUtils;
import com.secsign.bamboo.accessor.SecSignIDStaticAccessor;
import java.io.IOException;
import java.net.URLEncoder;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecSignIDAuthenticationFilter
implements Filter {
    private static final Logger logger = LoggerFactory.getLogger(SecSignIDAuthenticationFilter.class);
    private final SecSignIDDataAccessor dataAccessor;
    private final SecSignIDSessionManager sessionManager;

    public SecSignIDAuthenticationFilter(SecSignIDDataAccessor dataAccessor, SecSignIDSessionManager sessionManager) {
        this.dataAccessor = dataAccessor;
        this.sessionManager = sessionManager;
    }

    public void init(FilterConfig fc) throws ServletException {
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        boolean sessionExpired;
        Authenticator authenticator;
        String username;
        HttpServletRequest httpServletReq = (HttpServletRequest)request;
        HttpServletResponse httpServletResp = (HttpServletResponse)response;
        String requestUri = httpServletReq.getRequestURI();
        logger.debug("Filtering request url '" + requestUri + "': request parameter map: " + SecSignIDMappingUtils.toString(request.getParameterMap()));
        if (SecSignIDCommonStaticAccessor.getSessionTimeoutEnabled() && (username = (authenticator = SecurityConfigFactory.getInstance().getAuthenticator()).getRemoteUser(httpServletReq)) != null && (sessionExpired = this.sessionManager.updateSession(httpServletReq, httpServletResp))) {
            String baseUrl = this.dataAccessor.getBaseUrl();
            httpServletResp.sendRedirect(baseUrl + "/plugins/servlet/secsignid");
            return;
        }
        HttpSession session = httpServletReq.getSession();
        logger.debug(String.valueOf("Session timeout is: " + session.getMaxInactiveInterval() + " seconds"));
        boolean appliedFilterAndSentRedirect = this.filterUrlAndSendRedirect(requestUri, httpServletReq, httpServletResp);
        if (appliedFilterAndSentRedirect) {
            return;
        }
        logger.debug("Not filtered the request uri '" + requestUri + "' as login page.");
        filterChain.doFilter(request, (ServletResponse)httpServletResp);
    }

    private boolean filterUrlAndSendRedirect(String requestUri, HttpServletRequest httpServletReq, HttpServletResponse httpServletResp) throws IOException {
        if (requestUri.contains("/start.action") || requestUri.contains("/projects") || requestUri.contains("userlogin") || this.isRequestUriBambooBaseUrl(httpServletReq)) {
            boolean bambooLoginRequested;
            if (this.logoutAfterCreate(requestUri, httpServletReq, httpServletResp)) {
                String servletPath = httpServletReq.getContextPath() + "/plugins/servlet/secsignid";
                httpServletResp.sendRedirect(servletPath);
                return true;
            }
            String bambooBaseUrl = SecSignIDAuthenticationFilter.getBambooBaseUrl();
            String appUserObject = SecSignIDStaticAccessor.getUserManager().getRemoteUsername(httpServletReq);
            logger.debug("Assumed request url '" + requestUri + "' is login url. Possibly logged in users: appUserObject=" + appUserObject);
            if (appUserObject != null) {
                String osDestination = httpServletReq.getParameter("os_destination");
                if (osDestination == null) {
                    return false;
                }
                Cookie[] cookies = httpServletReq.getCookies();
                boolean login = false;
                for (Cookie cookie : cookies) {
                    if (!cookie.getName().equals("atlassian.xsrf.token") || !cookie.getValue().contains("lin")) continue;
                    login = true;
                }
                if (!login && requestUri.contains("/start.action")) {
                    httpServletReq.getSession().invalidate();
                    httpServletResp.sendRedirect(bambooBaseUrl + "/plugins/servlet/secsignid");
                    return true;
                }
                return false;
            }
            boolean bl = bambooLoginRequested = httpServletReq.getParameter("standard-login") != null;
            if (bambooLoginRequested) {
                return false;
            }
            if (httpServletReq.getParameter("login") != null && httpServletReq.getParameter("os_username") != null && httpServletReq.getParameter("os_password") != null) {
                return false;
            }
            String osDestination = httpServletReq.getParameter("os_destination");
            if (osDestination == null && (osDestination = httpServletReq.getParameter("returnUrl")) == null) {
                String requestUriFromRequestObj = httpServletReq.getRequestURI();
                try {
                    if (!this.isRequestUriBambooBaseUrl(httpServletReq) && requestUriFromRequestObj.indexOf("/start.action") < 0) {
                        osDestination = requestUriFromRequestObj;
                    }
                    if (!requestUriFromRequestObj.startsWith(requestUri) && this.isRequestUriBambooBaseUrl(httpServletReq)) {
                        osDestination = requestUri;
                    }
                }
                catch (Exception ex) {
                    logger.error("Cannot compare request uri '" + requestUriFromRequestObj + "'with base url ' " + bambooBaseUrl + "' : " + ex.getMessage());
                }
            }
            if (bambooBaseUrl.length() > 0 && bambooBaseUrl.endsWith("/")) {
                bambooBaseUrl = bambooBaseUrl.substring(0, bambooBaseUrl.length() - 1);
            }
            logger.debug("Send redirect to secsign id authentication servlet: " + bambooBaseUrl + "/plugins/servlet/secsignid");
            if (osDestination != null && osDestination.length() > 0) {
                httpServletResp.sendRedirect(bambooBaseUrl + "/plugins/servlet/secsignid" + "?" + "returnUrl" + "=" + URLEncoder.encode(osDestination));
            } else {
                httpServletResp.sendRedirect(bambooBaseUrl + "/plugins/servlet/secsignid");
            }
            return true;
        }
        return false;
    }

    private boolean isRequestUriBambooBaseUrl(HttpServletRequest httpServletReq) {
        String requestUri = httpServletReq.getRequestURI();
        String contextPath = httpServletReq.getContextPath() + "/";
        return requestUri.equals(contextPath);
    }

    public static String getBambooBaseUrl() {
        ApplicationProperties properties = SecSignIDStaticAccessor.getApplicationProperties();
        String baseUrlString = properties.getBaseUrl();
        return baseUrlString;
    }

    private boolean logoutAfterCreate(String requestUri, HttpServletRequest httpServletReq, HttpServletResponse httpServletResp) {
        Authenticator authenticator = SecurityConfigFactory.getInstance().getAuthenticator();
        String username = authenticator.getRemoteUser(httpServletReq);
        if (username == null) {
            return false;
        }
        if (this.dataAccessor.getUsersCreated().contains(username)) {
            try {
                authenticator.logout(httpServletReq, httpServletResp);
                this.dataAccessor.deleteUserCreated(username);
                return true;
            }
            catch (AuthenticatorException e) {
                return true;
            }
        }
        return false;
    }
}

