/*
 * Decompiled with CFR 0.152.
 */
package com.secsign.bamboo.servlet;

import com.atlassian.crowd.embedded.api.SearchRestriction;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.builder.Restriction;
import com.atlassian.crowd.search.query.entity.EntityQuery;
import com.atlassian.crowd.search.query.entity.restriction.Property;
import com.atlassian.crowd.search.query.entity.restriction.constants.UserTermKeys;
import com.secsign.bamboo.accessor.SecSignIDStaticAccessor;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecSignIDUserPicker
extends HttpServlet {
    private static final long serialVersionUID = 6842235411471448500L;
    private static final Logger logger = LoggerFactory.getLogger(SecSignIDUserPicker.class);

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        HashMap<String, com.atlassian.crowd.model.user.User> _searchUsersSet = new HashMap<String, com.atlassian.crowd.model.user.User>();
        String searchString = req.getParameter("username");
        List dirs = SecSignIDStaticAccessor.getDirectoryManager().findAllDirectories();
        EntityQuery query = QueryBuilder.queryFor(com.atlassian.crowd.model.user.User.class, (EntityDescriptor)EntityDescriptor.user()).with((SearchRestriction)Restriction.on((Property)UserTermKeys.USERNAME).containing((Object)searchString)).startingAt(0).returningAtMost(-1);
        for (Object dir : dirs) {
            try {
                List foundUsers = SecSignIDStaticAccessor.getDirectoryManager().searchUsers(dir.getId().longValue(), query);
                for (com.atlassian.crowd.model.user.User user : foundUsers) {
                    if (_searchUsersSet.containsKey(user.getName())) continue;
                    _searchUsersSet.put(user.getName(), user);
                }
            }
            catch (DirectoryNotFoundException foundUsers) {
            }
            catch (OperationFailedException foundUsers) {
            }
        }
        JSONArray json = new JSONArray();
        try {
            for (User userObject : _searchUsersSet.values()) {
                JSONObject user = new JSONObject();
                user.put("id", (Object)userObject.getName());
                user.put("text", (Object)userObject.getDisplayName());
                json.put((Object)user);
            }
            String jsonString = json.toString();
            resp.setContentType("application/json");
            resp.getWriter().write(json.toString());
        }
        catch (JSONException e) {
            logger.debug("JSON Exception on UserPicker-Request");
        }
    }
}

