/*
 * Decompiled with CFR 0.152.
 */
package com.secsign.bamboo.listener;

import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.event.events.PluginEnabledEvent;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.secsign.atlassian.common.accessor.SecSignIDCommonStaticAccessor;
import com.secsign.atlassian.common.interfaces.SecSignIDDataAccessor;
import com.secsign.atlassian.common.rest.SecSignIDRESTPluginRegistrationResponse;
import com.secsign.atlassian.common.rest.SecSignIDServerRESTConnector;
import com.secsign.bamboo.accessor.SecSignIDStaticAccessor;
import com.secsign.bamboo.ao.SecSignIDAOToCommonConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

public class SecSignIDPluginInstalledListener
implements InitializingBean,
DisposableBean {
    private static final Logger logger = LoggerFactory.getLogger(SecSignIDPluginInstalledListener.class);
    private final EventPublisher eventPublisher;
    private final PluginSettingsFactory pluginSettingsFactory;
    private final SecSignIDDataAccessor dataAccessor;

    public SecSignIDPluginInstalledListener(EventPublisher eventPublisher, PluginSettingsFactory pluginSettingsFactory, SecSignIDDataAccessor dataAccessor) {
        this.eventPublisher = eventPublisher;
        this.pluginSettingsFactory = pluginSettingsFactory;
        this.dataAccessor = dataAccessor;
    }

    @EventListener
    public void onPluginEnabled(PluginEnabledEvent event) {
        try {
            if ("com.secsign.secsignid-bamboo".equals(event.getPlugin().getKey())) {
                PluginSettings globalPluginSettings = this.pluginSettingsFactory.createGlobalSettings();
                Object value = globalPluginSettings.get("allToGlobal");
                if (value == null) {
                    logger.warn("change of Settings needed");
                    this.changeToGlobalSettings();
                    globalPluginSettings.put("allToGlobal", (Object)String.valueOf(true));
                    logger.warn("Wrote Settings to globalSettings");
                }
                if ((value = globalPluginSettings.get("toDirIDMappingsWithPatternFixed")) == null) {
                    logger.warn("change to dirid needed");
                    this.changeToDirID();
                    globalPluginSettings.put("toDirIDMappingsWithPatternFixed", (Object)String.valueOf(true));
                    logger.warn("Wrote Mappings with dirid");
                }
                if ((value = globalPluginSettings.get("toAllSettingsAsOne")) == null) {
                    logger.warn("Change To One Attribute needed");
                    this.dataAccessor.changeToOneAttribute();
                    globalPluginSettings.put("toAllSettingsAsOne", (Object)String.valueOf(true));
                    logger.warn("Change To One Attribute done");
                }
                if ((value = globalPluginSettings.get("convertToCommon")) == null) {
                    logger.warn("Change To Common needed");
                    SecSignIDAOToCommonConverter.convertSecSignIDIPsToCommon();
                    logger.warn("Convert of IPs Done");
                    SecSignIDAOToCommonConverter.convertSecSignIDLoginOptionsToCommon();
                    logger.warn("Convert of LoginOptions Done");
                    SecSignIDAOToCommonConverter.convertSecSignIDLoginTokensToCommon();
                    logger.warn("Convert of LoginTokens Done");
                    SecSignIDAOToCommonConverter.convertSecSignIDQRToCommon();
                    logger.warn("Convert of QRCodes Done");
                    SecSignIDAOToCommonConverter.convertSecSignTrustDeviceTokensToCommon();
                    logger.warn("Convert of TrustDeviceTokens Done");
                    SecSignIDAOToCommonConverter.convertSecSignIDUsersToCommon();
                    logger.warn("Convert of User Done");
                    globalPluginSettings.put("convertToCommon", (Object)String.valueOf(true));
                    logger.warn("Change To Common done");
                }
                SecSignIDCommonStaticAccessor.getIPRanges();
                value = globalPluginSettings.get("updateUseFallback");
                if (value == null) {
                    boolean valueAsBoolean = SecSignIDCommonStaticAccessor.getNoFallback();
                    SecSignIDCommonStaticAccessor.saveUseFallback(!valueAsBoolean);
                    globalPluginSettings.put("updateUseFallback", (Object)String.valueOf(true));
                }
                this.dataAccessor.checkGroupsCreated();
                if (!SecSignIDCommonStaticAccessor.getFirstStart() && SecSignIDCommonStaticAccessor.isUsingCloudServer()) {
                    if (!SecSignIDCommonStaticAccessor.hasPluginPinAccount()) {
                        logger.info("Trying to create a plugin PIN account.");
                        try {
                            SecSignIDRESTPluginRegistrationResponse pluginRegisterResponse = SecSignIDServerRESTConnector.registerPlugin();
                            SecSignIDCommonStaticAccessor.savePinAccount(new String[]{pluginRegisterResponse.getAccountName(), pluginRegisterResponse.getPassword()});
                            logger.info("Successfully created a plugin PIN account.");
                        }
                        catch (Exception e) {
                            logger.error("Plugin PIN-Account couldn't be created.");
                            logger.error(e.getMessage(), (Throwable)e);
                        }
                    } else {
                        String baseUrl = this.dataAccessor.getBaseUrl();
                        SecSignIDCommonStaticAccessor.updateBaseUrl(baseUrl);
                    }
                }
            }
        }
        catch (Exception e) {
            logger.error("Error on installtion of SecSign Plugin:" + e.getMessage(), (Throwable)e);
        }
    }

    private void changeToDirID() {
        new Thread(){

            @Override
            public void run() {
                SecSignIDPluginInstalledListener.this.dataAccessor.changeToDirID();
            }
        }.start();
    }

    private void changeToGlobalSettings() {
        Object value = null;
        PluginSettings globalPluginSettings = this.pluginSettingsFactory.createGlobalSettings();
        PluginSettings localpluginSettings = SecSignIDStaticAccessor.getPluginSettingsFactory().createGlobalSettings();
        value = localpluginSettings.get("com.secsign.bamboo.idserverurl");
        if (value != null) {
            logger.debug("Saved ID Server Url on new position: " + (String)value);
            globalPluginSettings.put("com.secsign.idserverurl", value);
        }
        if ((value = localpluginSettings.get("com.secsign.bamboo.idserverurl.fallback")) != null) {
            logger.debug("Saved Fallback ID Server Url on new position: " + (String)value);
            globalPluginSettings.put("com.secsign.idserverurl.fallback", value);
        }
        if ((value = localpluginSettings.get("com.secsign.bamboo.servicename")) != null) {
            logger.debug("Saved ServiceName on new position: " + (String)value);
            globalPluginSettings.put("com.secsign.servicename", value);
        }
        if ((value = localpluginSettings.get("com.secsign.bamboo.nofallback")) != null) {
            logger.debug("Saved NoFallback Setting on new position: " + (String)value);
            globalPluginSettings.put("com.secsign.usefallback", value);
        }
        if ((value = localpluginSettings.get("com.secsign.bamboo.firststart")) != null) {
            logger.debug("Saved FirstStart on new position: " + (String)value);
            globalPluginSettings.put("com.secsign.firststart", value);
        }
        if ((value = localpluginSettings.get("com.secsign.bamboo.companyname")) != null) {
            logger.debug("Saved CompanyName on new position: " + (String)value);
            globalPluginSettings.put("com.secsign.companyname", value);
        }
        if ((value = localpluginSettings.get("com.secsign.bamboo.userchange")) != null) {
            logger.debug("Saved UserChange  on new position: " + (String)value);
            globalPluginSettings.put("com.secsign.userchange", value);
        }
        if ((value = localpluginSettings.get("com.secsign.bamboo.userestore")) != null) {
            logger.debug("Saved UseRestore on new position: " + (String)value);
            globalPluginSettings.put("com.secsign.userestore", value);
        }
        if ((value = localpluginSettings.get("com.secsign.bamboo.autofillusername")) != null) {
            logger.debug("Saved AutoFillUsername on new position: " + (String)value);
            globalPluginSettings.put("com.secsign.autofillusername", value);
        }
        if ((value = localpluginSettings.get("com.secsign.bamboo.autofillusernamecompany")) != null) {
            logger.debug("Saved AutoFillUsernameCompany on new position: " + (String)value);
            globalPluginSettings.put("com.secsign.autofillusernamecompany", value);
        }
        if ((value = localpluginSettings.get("com.secsign.bamboo.autofillmaill")) != null) {
            logger.debug("Saved AutoFillMail on new position: " + (String)value);
            globalPluginSettings.put("com.secsign.autofillusername", value);
        }
        if ((value = localpluginSettings.get("com.secsign.bamboo.basicauth")) != null) {
            logger.debug("Saved BasicAuth on new position: " + (String)value);
            globalPluginSettings.put("com.secsign.basicauth", value);
        }
        if ((value = localpluginSettings.get("com.secsign.bamboo.synchid")) != null) {
            logger.debug("Saved Synchronizable on new position: " + (String)value);
            globalPluginSettings.put("com.secsign.synchid", value);
        }
        if ((value = localpluginSettings.get("com.secsign.bamboo.synchwrite")) != null) {
            logger.debug("Saved SynchronizableWrite on new position: " + (String)value);
            globalPluginSettings.put("com.secsign.synchwrite", value);
        }
        if ((value = localpluginSettings.get("com.secsign.bamboo.safezone")) != null) {
            logger.debug("Saved SafeZone on new position: " + (String)value);
            globalPluginSettings.put("com.secsign.safezone", value);
        }
        if ((value = localpluginSettings.get("com.secsign.bamboo.safezoneraange")) != null) {
            logger.debug("Saved SafeZone Range on new position: " + (String)value);
            globalPluginSettings.put("com.secsign.safezonerange", value);
        }
        if ((value = localpluginSettings.get("com.secsign.bamboo.noaccesspass")) != null) {
            logger.debug("Saved NoAccesspass on new position: " + (String)value);
            globalPluginSettings.put("com.secsign.noaccesspass", value);
        }
        if ((value = localpluginSettings.get("com.secsign.bamboo.customlogin")) != null) {
            logger.debug("Saved CustomLogin on new position: " + (String)value);
            globalPluginSettings.put("com.secsign.customlogin", value);
        }
        if ((value = localpluginSettings.get("com.secsign.bamboo.logincolor")) != null) {
            logger.debug("Saved Login Color on new position: " + (String)value);
            globalPluginSettings.put("com.secsign.logincolor", value);
        }
        if ((value = localpluginSettings.get("com.secsign.bamboo.pinuser")) != null) {
            logger.debug("Saved PinUser on new position: " + (String)value);
            globalPluginSettings.put("com.secsign.pinuser", value);
        }
        if ((value = localpluginSettings.get("com.secsign.bamboo.pinpassword")) != null) {
            logger.debug("Saved PinUserPassword on new position: ***");
            globalPluginSettings.put("com.secsign.pinpassword", value);
        }
        if ((value = localpluginSettings.get("com.secsign.bamboo.patternmapping")) != null) {
            logger.debug("Saved PatternMappings on new position: " + (String)value);
            globalPluginSettings.put("com.secsign.bamboo.patternmapping", value);
        }
    }

    public void afterPropertiesSet() throws Exception {
        this.eventPublisher.register((Object)this);
    }

    public void destroy() throws Exception {
        this.eventPublisher.unregister((Object)this);
    }
}

