/*
 * Decompiled with CFR 0.152.
 */
package com.secsign.bamboo.conditions;

import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.web.Condition;
import com.atlassian.user.User;
import com.secsign.bamboo.accessor.SecSignIDStaticAccessor;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.struts2.ServletActionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserIsAdminCondition
implements Condition {
    private static final Logger logger = LoggerFactory.getLogger(UserIsAdminCondition.class);

    public void init(Map<String, String> params) throws PluginParseException {
    }

    public boolean shouldDisplay(Map<String, Object> context) {
        User loggedInUser = null;
        if (context != null && context.get("user") != null) {
            loggedInUser = (User)context.get("user");
        } else {
            HttpServletRequest req = ServletActionContext.getRequest();
            HttpSession session = req.getSession();
            Object sessionUserObject = session.getAttribute("seraph_defaultauthenticator_user");
            if (sessionUserObject != null) {
                loggedInUser = (User)sessionUserObject;
            }
        }
        if (loggedInUser != null) {
            boolean isAdmin = SecSignIDStaticAccessor.getBambooPermissionManager().isAdmin(loggedInUser.getName());
            boolean isSystemAdmin = SecSignIDStaticAccessor.getBambooPermissionManager().isSystemAdmin(loggedInUser.getName());
            logger.debug("Logged in user '" + loggedInUser + "' is admin:" + (isAdmin || isSystemAdmin));
            return isAdmin || isSystemAdmin;
        }
        return false;
    }
}

