/*
 * Decompiled with CFR 0.152.
 */
package com.secsign.bamboo.ao;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.sal.api.transaction.TransactionCallback;
import com.secsign.atlassian.common.ao.SecSignIDCIPs;
import com.secsign.atlassian.common.ao.SecSignIDCLoginOptions;
import com.secsign.atlassian.common.ao.SecSignIDCLoginTokens;
import com.secsign.atlassian.common.ao.SecSignIDCQR;
import com.secsign.atlassian.common.ao.SecSignIDCTrustDeviceTokens;
import com.secsign.atlassian.common.ao.SecSignIDCUsers;
import com.secsign.bamboo.accessor.SecSignIDStaticAccessor;
import com.secsign.bamboo.ao.SecSignIDIPs;
import com.secsign.bamboo.ao.SecSignIDLoginOptions;
import com.secsign.bamboo.ao.SecSignIDLoginTokens;
import com.secsign.bamboo.ao.SecSignIDQR;
import com.secsign.bamboo.ao.SecSignIDTrustDeviceTokens;
import com.secsign.bamboo.ao.SecSignIDUsers;
import net.java.ao.DBParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecSignIDAOToCommonConverter {
    private static final Logger logger = LoggerFactory.getLogger(SecSignIDAOToCommonConverter.class);

    public static void convertSecSignIDIPsToCommon() {
        final ActiveObjects ao = SecSignIDStaticAccessor.getActiveObjects();
        if (ao != null) {
            ao.executeInTransaction((TransactionCallback)new TransactionCallback<SecSignIDIPs>(){

                public SecSignIDIPs doInTransaction() {
                    for (SecSignIDIPs foundAOObject : (SecSignIDIPs[])ao.find(SecSignIDIPs.class)) {
                        try {
                            logger.debug(foundAOObject.getBambooUserName() + " : " + foundAOObject.getIP());
                            SecSignIDCIPs commonObject = (SecSignIDCIPs)ao.create(SecSignIDCIPs.class, new DBParam[]{new DBParam("USER_NAME", (Object)foundAOObject.getBambooUserName()), new DBParam("IP", (Object)foundAOObject.getIP())});
                            commonObject.save();
                        }
                        catch (Exception e) {
                            logger.error("Exception on saving new Object " + e.getMessage());
                        }
                    }
                    return null;
                }
            });
        }
    }

    public static void convertSecSignIDLoginOptionsToCommon() {
        final ActiveObjects ao = SecSignIDStaticAccessor.getActiveObjects();
        if (ao != null) {
            ao.executeInTransaction((TransactionCallback)new TransactionCallback<SecSignIDLoginOptions>(){

                public SecSignIDLoginOptions doInTransaction() {
                    for (SecSignIDLoginOptions foundAOObject : (SecSignIDLoginOptions[])ao.find(SecSignIDLoginOptions.class)) {
                        try {
                            logger.debug(foundAOObject.getBambooUserName() + " : " + foundAOObject.getMethodToActivate() + " : " + foundAOObject.getLastMethodUsed() + " : " + foundAOObject.getTOTPActive() + " : " + foundAOObject.getMailOTPActive());
                            SecSignIDCLoginOptions commonObject = (SecSignIDCLoginOptions)ao.create(SecSignIDCLoginOptions.class, new DBParam[]{new DBParam("USER_NAME", (Object)foundAOObject.getBambooUserName()), new DBParam("METHOD_TO_ACTIVATE", (Object)foundAOObject.getMethodToActivate()), new DBParam("LAST_METHOD_USED", (Object)foundAOObject.getLastMethodUsed()), new DBParam("TOTPACTIVE", (Object)foundAOObject.getTOTPActive()), new DBParam("FIDOACTIVE", (Object)Boolean.FALSE), new DBParam("SEC_SIGN_IDACTIVE", (Object)Boolean.FALSE), new DBParam("MAIL_OTPACTIVE", (Object)foundAOObject.getMailOTPActive())});
                            commonObject.save();
                        }
                        catch (Exception e) {
                            logger.error("Exception on saving new Object " + e.getMessage());
                        }
                    }
                    return null;
                }
            });
        }
    }

    public static void convertSecSignIDLoginTokensToCommon() {
        final ActiveObjects ao = SecSignIDStaticAccessor.getActiveObjects();
        if (ao != null) {
            ao.executeInTransaction((TransactionCallback)new TransactionCallback<SecSignIDLoginTokens>(){

                public SecSignIDLoginTokens doInTransaction() {
                    for (SecSignIDLoginTokens foundAOObject : (SecSignIDLoginTokens[])ao.find(SecSignIDLoginTokens.class)) {
                        try {
                            logger.debug(foundAOObject.getBambooUserName() + " : " + foundAOObject.getLoginToken() + " : " + foundAOObject.getTwoStepToken());
                            SecSignIDCLoginTokens commonObject = (SecSignIDCLoginTokens)ao.create(SecSignIDCLoginTokens.class, new DBParam[]{new DBParam("USER_NAME", (Object)foundAOObject.getBambooUserName()), new DBParam("LOGIN_TOKEN", (Object)foundAOObject.getLoginToken()), new DBParam("TWO_STEP_TOKEN", (Object)foundAOObject.getTwoStepToken()), new DBParam("TOTPACTIVE", (Object)Boolean.FALSE), new DBParam("MAIL_OTPACTIVE", (Object)Boolean.FALSE)});
                            commonObject.save();
                        }
                        catch (Exception e) {
                            logger.error("Exception on saving new Object " + e.getMessage());
                        }
                    }
                    return null;
                }
            });
        }
    }

    public static void convertSecSignIDQRToCommon() {
        final ActiveObjects ao = SecSignIDStaticAccessor.getActiveObjects();
        if (ao != null) {
            ao.executeInTransaction((TransactionCallback)new TransactionCallback<SecSignIDQR>(){

                public SecSignIDQR doInTransaction() {
                    for (SecSignIDQR foundAOObject : (SecSignIDQR[])ao.find(SecSignIDQR.class)) {
                        try {
                            logger.debug(foundAOObject.getBambooUserName() + " : " + foundAOObject.getQrCode() + " : " + foundAOObject.getIdForQr() + " : " + foundAOObject.getUrlForQR());
                            SecSignIDCQR commonObject = (SecSignIDCQR)ao.create(SecSignIDCQR.class, new DBParam[]{new DBParam("USER_NAME", (Object)foundAOObject.getBambooUserName()), new DBParam("QR_CODE", (Object)foundAOObject.getQrCode()), new DBParam("ID_FOR_QR", (Object)foundAOObject.getIdForQr()), new DBParam("URL_FOR_QR", (Object)foundAOObject.getUrlForQR())});
                            commonObject.save();
                        }
                        catch (Exception e) {
                            logger.error("Exception on saving new Object " + e.getMessage());
                        }
                    }
                    return null;
                }
            });
        }
    }

    public static void convertSecSignTrustDeviceTokensToCommon() {
        final ActiveObjects ao = SecSignIDStaticAccessor.getActiveObjects();
        if (ao != null) {
            ao.executeInTransaction((TransactionCallback)new TransactionCallback<SecSignIDTrustDeviceTokens>(){

                public SecSignIDTrustDeviceTokens doInTransaction() {
                    for (SecSignIDTrustDeviceTokens foundAOObject : (SecSignIDTrustDeviceTokens[])ao.find(SecSignIDTrustDeviceTokens.class)) {
                        try {
                            logger.debug(foundAOObject.getId() + " : " + foundAOObject.getBambooUserName() + " : " + foundAOObject.getUserAgent() + " : " + foundAOObject.getCreation());
                            SecSignIDCTrustDeviceTokens commonObject = (SecSignIDCTrustDeviceTokens)ao.create(SecSignIDCTrustDeviceTokens.class, new DBParam[]{new DBParam("ID", (Object)foundAOObject.getId()), new DBParam("USER_NAME", (Object)foundAOObject.getBambooUserName()), new DBParam("USER_AGENT", (Object)foundAOObject.getUserAgent()), new DBParam("CREATION", (Object)foundAOObject.getCreation())});
                            commonObject.save();
                        }
                        catch (Exception e) {
                            logger.error("Exception on saving new Object " + e.getMessage());
                        }
                    }
                    return null;
                }
            });
        }
    }

    public static void convertSecSignIDUsersToCommon() {
        final ActiveObjects ao = SecSignIDStaticAccessor.getActiveObjects();
        if (ao != null) {
            ao.executeInTransaction((TransactionCallback)new TransactionCallback<SecSignIDUsers>(){

                public SecSignIDUsers doInTransaction() {
                    for (SecSignIDUsers foundAOObject : (SecSignIDUsers[])ao.find(SecSignIDUsers.class)) {
                        try {
                            logger.debug(foundAOObject.getBambooUserName() + " : " + foundAOObject.getSecSignId());
                            SecSignIDCUsers commonObject = (SecSignIDCUsers)ao.create(SecSignIDCUsers.class, new DBParam[]{new DBParam("USER_NAME", (Object)foundAOObject.getBambooUserName()), new DBParam("SEC_SIGN_ID", (Object)foundAOObject.getSecSignId())});
                            commonObject.save();
                        }
                        catch (Exception e) {
                            logger.error("Exception on saving new Object " + e.getMessage());
                        }
                    }
                    return null;
                }
            });
        }
    }
}

