/*
 * Decompiled with CFR 0.152.
 */
package com.secsign.bamboo.accessor;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.bamboo.configuration.AdministrationConfiguration;
import com.atlassian.bamboo.exception.NotFoundException;
import com.atlassian.bamboo.exception.UnauthorisedException;
import com.atlassian.bamboo.persister.AuditLogMessage;
import com.atlassian.bamboo.persister.AuditLogService;
import com.atlassian.bamboo.security.BambooPermissionManager;
import com.atlassian.bamboo.spring.ComponentAccessor;
import com.atlassian.bamboo.user.BambooUserManager;
import com.atlassian.bamboo.user.authentication.BambooElevatedSecurityGuard;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.DirectoryType;
import com.atlassian.crowd.embedded.api.GroupWithAttributes;
import com.atlassian.crowd.embedded.api.SearchRestriction;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.embedded.core.util.ConversionUtils;
import com.atlassian.crowd.exception.ApplicationNotFoundException;
import com.atlassian.crowd.exception.ApplicationPermissionException;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.exception.GroupNotFoundException;
import com.atlassian.crowd.exception.InvalidAuthenticationException;
import com.atlassian.crowd.exception.InvalidGroupException;
import com.atlassian.crowd.exception.MembershipAlreadyExistsException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.exception.ReadOnlyGroupException;
import com.atlassian.crowd.exception.UserNotFoundException;
import com.atlassian.crowd.integration.rest.service.factory.RestCrowdClientFactory;
import com.atlassian.crowd.integration.rest.service.factory.RestCrowdHttpAuthenticationFactory;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.crowd.manager.directory.DirectoryPermissionException;
import com.atlassian.crowd.model.group.Group;
import com.atlassian.crowd.model.group.GroupTemplate;
import com.atlassian.crowd.model.user.UserWithAttributes;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.builder.Restriction;
import com.atlassian.crowd.search.query.entity.EntityQuery;
import com.atlassian.crowd.search.query.entity.restriction.MatchMode;
import com.atlassian.crowd.search.query.entity.restriction.Property;
import com.atlassian.crowd.search.query.entity.restriction.PropertyUtils;
import com.atlassian.crowd.search.query.entity.restriction.TermRestriction;
import com.atlassian.crowd.search.query.entity.restriction.constants.GroupTermKeys;
import com.atlassian.crowd.search.query.entity.restriction.constants.UserTermKeys;
import com.atlassian.crowd.search.query.membership.MembershipQuery;
import com.atlassian.crowd.service.client.CrowdClient;
import com.atlassian.mail.Email;
import com.atlassian.mail.MailException;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.transaction.TransactionCallback;
import com.atlassian.seraph.auth.Authenticator;
import com.atlassian.seraph.auth.AuthenticatorException;
import com.atlassian.seraph.config.SecurityConfigFactory;
import com.atlassian.spring.container.ContainerManager;
import com.atlassian.user.search.page.Pager;
import com.octo.captcha.service.image.ImageCaptchaService;
import com.secsign.atlassian.common.accessor.SecSignIDCommonStaticAccessor;
import com.secsign.atlassian.common.accessor.SecSignIDMappingExtractor;
import com.secsign.atlassian.common.ao.SecSignIDGroup;
import com.secsign.atlassian.common.ao.SecSignIDUsersActiveObject;
import com.secsign.atlassian.common.data.SecSignID2FAActivatedSettings;
import com.secsign.atlassian.common.data.SecSignID2FASettings;
import com.secsign.atlassian.common.rest.SecSignIDRESTException;
import com.secsign.atlassian.common.util.SecSignIDCommonConstants;
import com.secsign.atlassian.common.util.SecSignIDMappingUtils;
import com.secsign.bamboo.accessor.SecSignIDStaticAccessor;
import com.secsign.bamboo.ao.SecSignIDUsers;
import com.secsign.bamboo.servlet.filter.SecSignIDAuthenticationFilter;
import com.secsign.bamboo.servlet.filter.SecSignIDPasswordLoginFilter;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import javax.imageio.ImageIO;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import net.java.ao.RawEntity;
import org.apache.commons.codec.binary.Base64OutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecSignIDDataAccessor
extends com.secsign.atlassian.common.interfaces.SecSignIDDataAccessor {
    private static final Logger logger = LoggerFactory.getLogger(SecSignIDDataAccessor.class);
    private static final Supplier<ImageCaptchaService> IMAGE_CAPTCHA_SERVICE = ComponentAccessor.newLazyComponentReference((String)"imageCaptchaService");

    @Override
    public List<Directory> getAllDirectories() {
        ArrayList<Directory> activatedDirs = new ArrayList<Directory>();
        List allDirs = SecSignIDStaticAccessor.getDirectoryManager().findAllDirectories();
        for (Directory directory : allDirs) {
            if (!directory.isActive()) continue;
            activatedDirs.add(directory);
        }
        return activatedDirs;
    }

    @Override
    public Collection<String> findGroupMembersUsernames(long dirid, String groupname) throws DirectoryNotFoundException, OperationFailedException {
        MembershipQuery query = QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.user()).childrenOf(EntityDescriptor.group()).withName(groupname).startingAt(0).returningAtMost(-1);
        return SecSignIDStaticAccessor.getDirectoryManager().searchNestedGroupRelationships(dirid, query);
    }

    @Override
    public Collection<String> findAllUsernames(long dirid) throws DirectoryNotFoundException, OperationFailedException {
        EntityQuery query = QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.user()).startingAt(0).returningAtMost(-1);
        return SecSignIDStaticAccessor.getDirectoryManager().searchUsers(dirid, query);
    }

    @Override
    public void deleteAllOptionsAndMappings() throws com.atlassian.crowd.exception.runtime.OperationFailedException, InvalidAuthenticationException, ApplicationPermissionException {
        PluginSettings globalPluginSettings = SecSignIDCommonStaticAccessor.getPluginSettingsFactory().createGlobalSettings();
        globalPluginSettings.remove("com.secsign.allow.user.create");
        globalPluginSettings.remove("com.secsign.allow.user.existing");
        globalPluginSettings.remove("com.secsign.androidUrl");
        globalPluginSettings.remove("com.secsign.cachedbaseurl");
        globalPluginSettings.remove("com.secsign.crowdurl");
        globalPluginSettings.remove("com.secsign.companyname");
        globalPluginSettings.remove("com.secsign.customlogin");
        globalPluginSettings.remove("com.secsign.customlogo");
        globalPluginSettings.remove("com.secsign.accesstoken");
        globalPluginSettings.remove("com.secsign.basicauth");
        globalPluginSettings.remove("com.secsign.idserverurl.fallback");
        globalPluginSettings.remove("com.secsign.fido.enabled");
        globalPluginSettings.remove("com.secsign.autofillusername");
        globalPluginSettings.remove("com.secsign.autofillmail");
        globalPluginSettings.remove("com.secsign.autofillusernamecompany");
        globalPluginSettings.remove("com.secsign.autofillpattern");
        globalPluginSettings.remove("com.secsign.autofillpatternpattern");
        globalPluginSettings.remove("com.secsign.firststart");
        globalPluginSettings.remove("com.secsign.fromotp");
        globalPluginSettings.remove("com.secsign.gitaccess.2fa.enabled");
        globalPluginSettings.remove("com.secsign.gitaccess.block.user.without.secsignid");
        globalPluginSettings.remove("com.secsign.gitaccess.enabled.for.group");
        globalPluginSettings.remove("com.secsign.gitaccess.ipsafezone.enabled");
        globalPluginSettings.remove("com.secsign.gitaccess.new2fa.required.after.hours");
        globalPluginSettings.remove("com.secsign.gitaccess.protect.read.commands");
        globalPluginSettings.remove("com.secsign.groups.created");
        globalPluginSettings.remove("com.secsign.hidepasswordlesslink");
        globalPluginSettings.remove("com.secsign.idserverurl");
        globalPluginSettings.remove("com.secsign.inform.admin");
        globalPluginSettings.remove("com.secsign.inform.group");
        globalPluginSettings.remove("com.secsign.inform.user");
        globalPluginSettings.remove("com.secsign.iOSUrl");
        globalPluginSettings.remove("com.secsign.ldapattr");
        globalPluginSettings.remove("com.secsign.ldapenable");
        globalPluginSettings.remove("com.secsign.localenable");
        globalPluginSettings.remove("com.secsign.logincolor");
        globalPluginSettings.remove("com.secsign.logintitle");
        globalPluginSettings.remove("com.secsign.loginsubtitle");
        globalPluginSettings.remove("com.secsign.macOSUrl");
        globalPluginSettings.remove("com.secsign.mailotp.enabled");
        globalPluginSettings.remove("com.secsign.noaccesspass");
        globalPluginSettings.remove("com.secsign.usefallback");
        globalPluginSettings.remove("com.secsign.observe.group");
        globalPluginSettings.remove("com.secsign.otpauth");
        globalPluginSettings.remove("com.secsign.passwordless");
        globalPluginSettings.remove("com.secsign.passwordless.enabled");
        globalPluginSettings.remove("com.secsign.pinuser");
        globalPluginSettings.remove("com.secsign.pinpassword");
        globalPluginSettings.remove("com.secsign.resetcrowd");
        globalPluginSettings.remove("com.secsign.safezone");
        globalPluginSettings.remove("com.secsign.safezonerange");
        globalPluginSettings.remove("com.secsign.secsignauth");
        globalPluginSettings.remove("com.secsign.secsign.enabled");
        globalPluginSettings.remove("com.secsign.secsignid");
        globalPluginSettings.remove("com.secsign.servicedesk");
        globalPluginSettings.remove("com.secsign.servicedesk.2fa");
        globalPluginSettings.remove("com.secsign.servicedeskgroup");
        globalPluginSettings.remove("com.secsign.servicename");
        globalPluginSettings.remove("com.secsign.sessiontimeout");
        globalPluginSettings.remove("com.secsign.sessiontimeout.duration");
        globalPluginSettings.remove("com.secsign.synchid");
        globalPluginSettings.remove("com.secsign.synchwrite");
        globalPluginSettings.remove("com.secsign.telemetry");
        globalPluginSettings.remove("com.secsign.totp");
        globalPluginSettings.remove("com.secsign.totp.enabled");
        globalPluginSettings.remove("com.secsign.trustdevice");
        globalPluginSettings.remove("com.secsign.trustdevice.duration");
        globalPluginSettings.remove("com.secsign.twostep");
        globalPluginSettings.remove("com.secsign.usefallback");
        globalPluginSettings.remove("com.secsign.crowdnewlogin");
        globalPluginSettings.remove("com.secsign.userchange");
        globalPluginSettings.remove("com.secsign.userestore");
        globalPluginSettings.remove("com.secsign.whitelist");
        globalPluginSettings.remove("com.secsign.windowsUrl");
        globalPluginSettings.remove("com.secsign.writeldap");
        globalPluginSettings.remove("fixFor4_5_0_groups_started");
        globalPluginSettings.remove("fixFor4_5_0_groups_done");
        try {
            List<Directory> dirs = this.getAllDirectories();
            for (Directory directory : dirs) {
                try {
                    SecSignIDStaticAccessor.getDirectoryManager().removeGroup(directory.getId().longValue(), "PasswordlessAllowed");
                }
                catch (DirectoryPermissionException directoryPermissionException) {
                }
                catch (OperationFailedException operationFailedException) {
                }
                catch (GroupNotFoundException groupNotFoundException) {
                }
                catch (DirectoryNotFoundException directoryNotFoundException) {
                }
                catch (ReadOnlyGroupException readOnlyGroupException) {
                    // empty catch block
                }
                try {
                    SecSignIDStaticAccessor.getDirectoryManager().removeGroup(directory.getId().longValue(), "2SASecSignIDAllowed");
                }
                catch (DirectoryPermissionException directoryPermissionException) {
                }
                catch (OperationFailedException operationFailedException) {
                }
                catch (GroupNotFoundException groupNotFoundException) {
                }
                catch (DirectoryNotFoundException directoryNotFoundException) {
                }
                catch (ReadOnlyGroupException readOnlyGroupException) {
                    // empty catch block
                }
                try {
                    SecSignIDStaticAccessor.getDirectoryManager().removeGroup(directory.getId().longValue(), "2SAMailOTPAllowed");
                }
                catch (DirectoryPermissionException directoryPermissionException) {
                }
                catch (OperationFailedException operationFailedException) {
                }
                catch (GroupNotFoundException groupNotFoundException) {
                }
                catch (DirectoryNotFoundException directoryNotFoundException) {
                }
                catch (ReadOnlyGroupException readOnlyGroupException) {
                    // empty catch block
                }
                try {
                    SecSignIDStaticAccessor.getDirectoryManager().removeGroup(directory.getId().longValue(), "2SATOTPAllowed");
                }
                catch (DirectoryPermissionException directoryPermissionException) {
                }
                catch (OperationFailedException operationFailedException) {
                }
                catch (GroupNotFoundException groupNotFoundException) {
                }
                catch (DirectoryNotFoundException directoryNotFoundException) {
                }
                catch (ReadOnlyGroupException readOnlyGroupException) {}
            }
            SecSignIDMappingExtractor.deleteAllUser2FASettings();
            SecSignIDMappingExtractor.deleteLocalMappings();
            SecSignIDMappingExtractor.deleteAllOldGroup2FASettings();
            SecSignIDUsersActiveObject.deleteLocalMappings();
            SecSignIDUsersActiveObject.deleteAllGroup2FASettings();
        }
        catch (DirectoryPermissionException e) {
            logger.error("DirectoryPermissionException on deleteAllOptionsAndMappings");
            logger.error(SecSignIDCommonStaticAccessor.getStackTraceOfError((Exception)((Object)e)));
        }
        catch (OperationFailedException e) {
            logger.error("OperationFailedException on deleteAllOptionsAndMappings");
            logger.error(SecSignIDCommonStaticAccessor.getStackTraceOfError((Exception)((Object)e)));
        }
        catch (InvalidAuthenticationException e) {
            logger.error("InvalidAuthenticationException on deleteAllOptionsAndMappings");
            logger.error(SecSignIDCommonStaticAccessor.getStackTraceOfError((Exception)((Object)e)));
        }
        catch (ApplicationPermissionException e) {
            logger.error("ApplicationPermissionException on deleteAllOptionsAndMappings");
            logger.error(SecSignIDCommonStaticAccessor.getStackTraceOfError((Exception)((Object)e)));
        }
        catch (com.atlassian.crowd.exception.runtime.UserNotFoundException e) {
            logger.error("UserNotFoundException on deleteAllOptionsAndMappings");
            logger.error(SecSignIDCommonStaticAccessor.getStackTraceOfError((Exception)((Object)e)));
        }
        catch (DirectoryNotFoundException e) {
            logger.error("DirectoryNotFoundException on deleteAllOptionsAndMappings");
            logger.error(SecSignIDCommonStaticAccessor.getStackTraceOfError((Exception)((Object)e)));
        }
        catch (UserNotFoundException e) {
            logger.error("UserNotFoundException on deleteAllOptionsAndMappings");
            logger.error(SecSignIDCommonStaticAccessor.getStackTraceOfError((Exception)((Object)e)));
        }
    }

    @Override
    public String getAllOptionsAsString() {
        StringBuilder answer = new StringBuilder();
        answer.append("com.secsign.idserverurl : " + SecSignIDCommonStaticAccessor.getSecSignIdServerUrl() + "%0A");
        answer.append("com.secsign.usefallback : " + Boolean.valueOf(SecSignIDCommonStaticAccessor.getUseFallback()) + "%0A");
        answer.append("com.secsign.idserverurl.fallback : " + SecSignIDCommonStaticAccessor.getFallbackSecSignIdServerUrl() + "%0A");
        answer.append("com.secsign.companyname : " + SecSignIDCommonStaticAccessor.getCompanyName() + "%0A");
        answer.append("com.secsign.servicename : " + SecSignIDCommonStaticAccessor.getServiceName() + "%0A");
        answer.append("com.secsign.cachedbaseurl : " + this.getBaseUrl() + "%0A");
        answer.append("com.secsign.userestore : " + Boolean.valueOf(SecSignIDCommonStaticAccessor.getUseRestore()) + "%0A");
        answer.append("com.secsign.noaccesspass : " + Boolean.valueOf(SecSignIDCommonStaticAccessor.getNoAccessPass()) + "%0A");
        answer.append("com.secsign.hidepasswordlesslink : " + Boolean.valueOf(SecSignIDCommonStaticAccessor.getHidePasswordlessLink()) + "%0A");
        answer.append("com.secsign.resetcrowd : " + Boolean.valueOf(SecSignIDCommonStaticAccessor.getResetOnCrowd()) + "%0A");
        answer.append("com.secsign.crowdurl : " + SecSignIDCommonStaticAccessor.getCrowdBaseUrl() + "%0A");
        answer.append("com.secsign.groups.created : " + Boolean.valueOf(SecSignIDCommonStaticAccessor.getGroupsCreated()) + "%0A");
        answer.append("com.secsign.inform.admin : " + Boolean.valueOf(SecSignIDCommonStaticAccessor.getInformAdmin()) + "%0A");
        answer.append("com.secsign.inform.group : " + SecSignIDCommonStaticAccessor.getInformGroup() + "%0A");
        answer.append("com.secsign.observe.group : " + SecSignIDCommonStaticAccessor.getObserveGroup() + "%0A");
        answer.append("com.secsign.inform.user : " + Boolean.valueOf(SecSignIDCommonStaticAccessor.getInformUser()) + "%0A");
        answer.append("com.secsign.autofillusername : " + Boolean.valueOf(SecSignIDCommonStaticAccessor.getAutoFillUsername()) + "%0A");
        answer.append("com.secsign.autofillusernamecompany : " + Boolean.valueOf(SecSignIDCommonStaticAccessor.getAutoFillUsernameCompany()) + "%0A");
        answer.append("com.secsign.autofillmail : " + Boolean.valueOf(SecSignIDCommonStaticAccessor.getAutoFillMail()) + "%0A");
        answer.append("com.secsign.autofillpattern : " + Boolean.valueOf(SecSignIDCommonStaticAccessor.getAutoFillPattern()) + "%0A");
        answer.append("com.secsign.autofillpatternpattern : " + SecSignIDCommonStaticAccessor.getAutoFillPatternPattern() + "%0A");
        answer.append("com.secsign.allow.user.create : " + Boolean.valueOf(SecSignIDCommonStaticAccessor.getAllowUserCreate()) + "%0A");
        answer.append("com.secsign.allow.user.existing : " + Boolean.valueOf(SecSignIDCommonStaticAccessor.getAllowUserExisting()) + "%0A");
        answer.append("com.secsign.basicauth : " + Boolean.valueOf(SecSignIDCommonStaticAccessor.isBasicAuthDisabled()) + "%0A");
        answer.append("com.secsign.accesstoken : " + Boolean.valueOf(SecSignIDCommonStaticAccessor.isAccessTokenDisabled()) + "%0A");
        answer.append("com.secsign.whitelist : " + Boolean.valueOf(SecSignIDCommonStaticAccessor.getWhiteList().toString()) + "%0A");
        answer.append("com.secsign.safezone : " + Boolean.valueOf(SecSignIDCommonStaticAccessor.getSafeZone()) + "%0A");
        answer.append("com.secsign.safezonerange : " + SecSignIDCommonStaticAccessor.getIPRanges() + "%0A");
        answer.append("com.secsign.userchange : " + Boolean.valueOf(SecSignIDCommonStaticAccessor.getUserChange()) + "%0A");
        answer.append("com.secsign.customlogin : " + Boolean.valueOf(SecSignIDCommonStaticAccessor.getCustomLogin()) + "%0A");
        answer.append("com.secsign.logincolor : " + SecSignIDCommonStaticAccessor.getLoginColor() + "%0A");
        answer.append("com.secsign.crowdnewlogin : " + Boolean.valueOf(SecSignIDCommonStaticAccessor.getUseNewCrowdLogin()) + "%0A");
        answer.append("com.secsign.logintitle : " + SecSignIDCommonStaticAccessor.getLoginTitle() + "%0A");
        answer.append("com.secsign.loginsubtitle : " + SecSignIDCommonStaticAccessor.getLoginSubtitle() + "%0A");
        answer.append("com.secsign.customlogo : " + SecSignIDCommonStaticAccessor.getCustomLogo() + "%0A");
        answer.append("com.secsign.sessiontimeout : " + Boolean.valueOf(SecSignIDCommonStaticAccessor.getSessionTimeoutEnabled()) + "%0A");
        answer.append("com.secsign.sessiontimeout.duration : " + Integer.valueOf(SecSignIDCommonStaticAccessor.getSessionTimeoutDuration()) + "%0A");
        answer.append("com.secsign.trustdevice : " + Boolean.valueOf(SecSignIDCommonStaticAccessor.getTrustDeviceEnabled()) + "%0A");
        answer.append("com.secsign.trustdevice.duration : " + Integer.valueOf(SecSignIDCommonStaticAccessor.getTrustDeviceDuration()) + "%0A");
        answer.append("com.secsign.synchid : " + Boolean.valueOf(SecSignIDCommonStaticAccessor.getTrustDeviceEnabled()) + "%0A");
        answer.append("com.secsign.synchwrite : " + Integer.valueOf(SecSignIDCommonStaticAccessor.getTrustDeviceDuration()) + "%0A");
        answer.append("com.secsign.secsign.enabled : " + Boolean.valueOf(SecSignIDCommonStaticAccessor.getTwoStepAuthEnabled()) + "%0A");
        answer.append("com.secsign.fido.enabled : " + Boolean.valueOf(SecSignIDCommonStaticAccessor.getFidoAuthEnabled()) + "%0A");
        answer.append("com.secsign.totp.enabled : " + Boolean.valueOf(SecSignIDCommonStaticAccessor.getTotpAuthEnabled()) + "%0A");
        answer.append("com.secsign.mailotp.enabled : " + Boolean.valueOf(SecSignIDCommonStaticAccessor.getMailotpAuthEnabled()) + "%0A");
        answer.append("com.secsign.passwordless.enabled : " + Boolean.valueOf(SecSignIDCommonStaticAccessor.getPasswordlessAuthEnabled()) + "%0A");
        if (this.getApplication().equals("Crowd")) {
            answer.append("com.secsign.localenable : " + Boolean.valueOf(SecSignIDCommonStaticAccessor.getLocalEnable()) + "%0A");
            answer.append("com.secsign.ldapenable : " + Boolean.valueOf(SecSignIDCommonStaticAccessor.getLDAPEnable()) + "%0A");
            answer.append("com.secsign.ldapattr : " + SecSignIDCommonStaticAccessor.getLDAPSecSignIDAttr() + "%0A");
            answer.append("com.secsign.writeldap : " + Boolean.valueOf(SecSignIDCommonStaticAccessor.getWriteLDAPEnable()) + "%0A");
        }
        if (this.getApplication().equals("Jira")) {
            answer.append("com.secsign.servicedesk.2fa : " + Boolean.valueOf(SecSignIDCommonStaticAccessor.getServiceDesk2FA()) + "%0A");
            answer.append("com.secsign.servicedeskgroup : " + SecSignIDCommonStaticAccessor.getServiceDeskGroups() + "%0A");
            answer.append("com.secsign.servicedesk : " + Boolean.valueOf(SecSignIDCommonStaticAccessor.getServiceDesk()) + "%0A");
        }
        if (this.getApplication().equals("Bitbucket")) {
            answer.append("com.secsign.gitaccess.2fa.enabled : " + SecSignIDCommonStaticAccessor.getGitAccessSecuredBy2FA() + "%0A");
            answer.append("com.secsign.gitaccess.enabled.for.group : " + Boolean.valueOf(SecSignIDCommonStaticAccessor.getGitAccessEnabledForGroups()) + "%0A");
            answer.append("com.secsign.gitaccess.ipsafezone.enabled : " + Boolean.valueOf(SecSignIDCommonStaticAccessor.getGitAccessIPSafeZoneEnabled()) + "%0A");
            answer.append("com.secsign.gitaccess.new2fa.required.after.hours : " + SecSignIDCommonStaticAccessor.getGitAccessNew2FARequiredAfterHours() + "%0A");
            answer.append("com.secsign.gitaccess.protect.read.commands : " + Boolean.valueOf(SecSignIDCommonStaticAccessor.getGitAccessProtectReadAccessBy2FA()) + "%0A");
        }
        answer.append("Used directories: {");
        List<Directory> dirs = this.getAllDirectories();
        for (Directory directory : dirs) {
            answer.append(directory.getType().name() + ",");
        }
        answer.append("}%0A");
        return answer.toString();
    }

    @Override
    public User getUserForKeyFirst(String userKey) throws OperationFailedException {
        List<Directory> dirs = this.getAllDirectories();
        for (Directory directory : dirs) {
            try {
                com.atlassian.crowd.model.user.User userFound = SecSignIDStaticAccessor.getDirectoryManager().findUserByName(directory.getId().longValue(), userKey);
                return userFound;
            }
            catch (UserNotFoundException userNotFoundException) {
            }
            catch (DirectoryNotFoundException directoryNotFoundException) {
            }
        }
        return null;
    }

    @Override
    public User getUserForKey(String userKey, long dirid) throws DirectoryNotFoundException, OperationFailedException, com.atlassian.crowd.exception.runtime.UserNotFoundException {
        return this.getEmbeddedUserForUsername(userKey);
    }

    private User getEmbeddedUserForUsername(String userKey) {
        List dirs = SecSignIDStaticAccessor.getDirectoryManager().findAllDirectories();
        for (Directory directory : dirs) {
            try {
                com.atlassian.crowd.model.user.User user = SecSignIDStaticAccessor.getDirectoryManager().findUserByName(directory.getId().longValue(), userKey);
                if (user == null) continue;
                return user;
            }
            catch (com.atlassian.crowd.exception.runtime.UserNotFoundException userNotFoundException) {
            }
            catch (UserNotFoundException userNotFoundException) {
            }
            catch (DirectoryNotFoundException directoryNotFoundException) {
            }
            catch (OperationFailedException operationFailedException) {
            }
        }
        return null;
    }

    @Override
    public String getUserKeyForUsername(String username) {
        return username;
    }

    @Override
    public String getApplication() {
        return "Bamboo";
    }

    @Override
    public List<String> getGroups(int page, long dirid) throws DirectoryNotFoundException, OperationFailedException {
        int userPerPage = 10;
        List<String> groups = new ArrayList<String>();
        LinkedHashSet _searchGroupSet = new LinkedHashSet();
        EntityQuery query = QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.group()).startingAt((page - 1) * userPerPage).returningAtMost(userPerPage);
        _searchGroupSet.addAll(SecSignIDStaticAccessor.getDirectoryManager().searchGroups(dirid, query));
        groups.addAll(_searchGroupSet);
        groups = SecSignIDMappingUtils.fixGroupListForDirIDAndEscape(groups, dirid);
        return groups;
    }

    @Override
    public int getPagesGroup(long dirid) throws DirectoryNotFoundException, OperationFailedException {
        int userPerPage = 10;
        EntityQuery query = QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.group()).startingAt(0).returningAtMost(-1);
        int fullSize = SecSignIDStaticAccessor.getDirectoryManager().searchGroups(dirid, query).size();
        if (fullSize % userPerPage == 0) {
            return fullSize / userPerPage;
        }
        return fullSize / userPerPage + 1;
    }

    @Override
    public String getVersion() {
        return String.valueOf(SecSignIDStaticAccessor.getPluginAccessor().getPlugin("com.secsign.secsignid-bamboo").getPluginInformation().getVersion());
    }

    @Override
    public void deleteLocalMappings() throws DirectoryPermissionException, OperationFailedException, InvalidAuthenticationException, ApplicationPermissionException {
        if (!SecSignIDCommonStaticAccessor.isSynchronizableWrite()) {
            SecSignIDMappingExtractor.deleteLocalMappings();
        }
    }

    @Override
    public List<User> getUsersByGroup(long dirid, String groupName, int page) throws DirectoryNotFoundException, OperationFailedException {
        int userPerPage = 10;
        ArrayList<User> result = new ArrayList<User>();
        com.atlassian.user.Group group = SecSignIDStaticAccessor.getBambooUserManager().getGroup(groupName);
        List memberStrings = SecSignIDStaticAccessor.getBambooUserManager().getMemberNamesAsList(group);
        if (!memberStrings.isEmpty()) {
            List subList = memberStrings.size() > page * userPerPage ? memberStrings.subList((page - 1) * userPerPage, page * userPerPage) : memberStrings.subList((page - 1) * userPerPage, memberStrings.size());
            for (String string : subList) {
                result.add(this.getEmbeddedUserForUsername(string));
            }
        }
        return result;
    }

    @Override
    public List<User> getUsersBySearchKey(String _searchKey) throws DirectoryNotFoundException, OperationFailedException {
        int userPerPage = 10;
        ArrayList<Object> _searchUsers = new ArrayList();
        HashMap<String, User> _searchUsersSet = new HashMap<String, User>();
        List<Directory> dirs = this.getAllDirectories();
        if (SecSignIDCommonStaticAccessor.isSynchronizable()) {
            EntityQuery query = QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user()).with((SearchRestriction)Restriction.on((Property)UserTermKeys.USERNAME).containing((Object)_searchKey)).startingAt(0).returningAtMost(-1);
            EntityQuery query2 = QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user()).with((SearchRestriction)Restriction.on((Property)PropertyUtils.ofTypeString((String)"secsignid")).containing((Object)_searchKey)).startingAt(0).returningAtMost(-1);
            for (Directory dir : dirs) {
                List foundUsers = SecSignIDStaticAccessor.getDirectoryManager().searchUsers(dir.getId().longValue(), query);
                for (User user : foundUsers) {
                    if (_searchUsersSet.containsKey(this.getUserKeyForUsername(user.getName()))) continue;
                    _searchUsersSet.put(this.getUserKeyForUsername(user.getName()), user);
                }
                foundUsers = SecSignIDStaticAccessor.getDirectoryManager().searchUsers(dir.getId().longValue(), query2);
                for (User user : foundUsers) {
                    if (_searchUsersSet.containsKey(this.getUserKeyForUsername(user.getName()))) continue;
                    _searchUsersSet.put(this.getUserKeyForUsername(user.getName()), user);
                }
            }
        } else {
            EntityQuery query = QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user()).with((SearchRestriction)Restriction.on((Property)UserTermKeys.USERNAME).containing((Object)_searchKey)).startingAt(0).returningAtMost(-1);
            for (Directory dir : dirs) {
                List<User> foundUsers = SecSignIDStaticAccessor.getDirectoryManager().searchUsers(dir.getId().longValue(), query);
                for (User user : foundUsers) {
                    if (_searchUsersSet.containsKey(this.getUserKeyForUsername(user.getName()))) continue;
                    _searchUsersSet.put(this.getUserKeyForUsername(user.getName()), user);
                }
                foundUsers = SecSignIDUsersActiveObject.findUsersForKey(_searchKey);
                for (User user : foundUsers) {
                    if (_searchUsersSet.containsKey(this.getUserKeyForUsername(user.getName()))) continue;
                    _searchUsersSet.put(this.getUserKeyForUsername(user.getName()), user);
                }
            }
        }
        if ((_searchUsers = new ArrayList(_searchUsersSet.values())).size() != 0) {
            Collections.sort(_searchUsers, new Comparator<User>(){

                @Override
                public int compare(User user1, User user2) {
                    if (user1 == null) {
                        return 1;
                    }
                    if (user2 == null) {
                        return -1;
                    }
                    return user1.getName().toLowerCase().compareTo(user2.getName().toLowerCase());
                }
            });
        }
        return _searchUsers;
    }

    public String getServiceName() {
        String serviceName = null;
        PluginSettings globalPluginSettings = SecSignIDCommonStaticAccessor.getPluginSettingsFactory().createGlobalSettings();
        Object value = globalPluginSettings.get("com.secsign.servicename");
        if (value != null) {
            serviceName = value.toString();
        }
        if (serviceName == null || serviceName.length() < 1) {
            return SecSignIDCommonStaticAccessor.getCompanyName() + " JIRA";
        }
        return serviceName;
    }

    @Override
    public long getPagesForGroup(long _chosenDir, String _groupName) throws DirectoryNotFoundException, OperationFailedException {
        int userPerPage = 10;
        int res = 0;
        com.atlassian.user.Group group = SecSignIDStaticAccessor.getBambooUserManager().getGroup(_groupName);
        List memberStrings = SecSignIDStaticAccessor.getBambooUserManager().getMemberNamesAsList(group);
        res = memberStrings.size();
        if (res % userPerPage != 0) {
            return res / userPerPage + 1;
        }
        return res / userPerPage;
    }

    @Override
    public boolean isChangeable(User user) {
        return true;
    }

    @Override
    public void updateAllMappings(boolean synchronizable, boolean synchwrite) throws DirectoryPermissionException, OperationFailedException, ApplicationPermissionException, InvalidAuthenticationException, DirectoryNotFoundException, GroupNotFoundException, UserNotFoundException {
        block3: {
            Map<String, String[]> secSignIdMapping;
            block2: {
                List<User> allUsers = SecSignIDMappingExtractor.getAllUsers();
                secSignIdMapping = this.getSecSignIDMappingForUsers(allUsers);
                if (!synchronizable || !synchwrite) break block2;
                SecSignIDUsersActiveObject.deleteAllMappings();
                for (Map.Entry<String, String[]> entry : secSignIdMapping.entrySet()) {
                    String fullKey = entry.getKey();
                    int dividerIndex = fullKey.indexOf(":");
                    String diridString = fullKey.substring(dividerIndex + 1);
                    long dirID = Long.parseLong(diridString);
                    String userKey = fullKey.substring(0, dividerIndex);
                    SecSignIDMappingExtractor.saveSecSignIDForUserKey(userKey, dirID, SecSignIDMappingUtils.getSecSignIdString(entry.getValue()));
                }
                break block3;
            }
            if (synchronizable) break block3;
            SecSignIDMappingExtractor.deleteLocalMappings();
            for (Map.Entry<String, String[]> entry : secSignIdMapping.entrySet()) {
                String fullKey = entry.getKey();
                int dividerIndex = fullKey.indexOf(":");
                String diridString = fullKey.substring(dividerIndex + 1);
                long dirID = Long.parseLong(diridString);
                String userKey = fullKey.substring(0, dividerIndex);
                SecSignIDUsersActiveObject.saveSecSignIDForUserKey(userKey, dirID, SecSignIDMappingUtils.getSecSignIdString(entry.getValue()));
            }
        }
    }

    @Override
    public String getUsernameForUserKey(String userKey) {
        return userKey;
    }

    @Override
    public String getUserProfileLink(User appUser, String baseUrl) {
        if (appUser != null) {
            return this.getBaseUrl() + "/admin/user/viewUser.action?username=" + appUser.getName();
        }
        return "#";
    }

    @Override
    public String getBaseUrl() {
        AdministrationConfiguration adminConfig = (AdministrationConfiguration)ContainerManager.getComponent((String)"administrationConfiguration");
        return adminConfig.getBaseUrl();
    }

    @Override
    public String getEmailForUserKey(String username, long dirid) throws com.atlassian.crowd.exception.runtime.UserNotFoundException, ApplicationNotFoundException, OperationFailedException, DirectoryNotFoundException {
        User user = this.getEmbeddedUserForUsername(username);
        return user.getEmailAddress();
    }

    @Override
    public User getUserCurrentlyLoggedIn() {
        if (SecSignIDStaticAccessor.getBambooAuthenticationContext().getUser() != null) {
            String userKey = SecSignIDStaticAccessor.getBambooAuthenticationContext().getUser().getName();
            return this.getEmbeddedUserForUsername(userKey);
        }
        return null;
    }

    @Override
    public Boolean canWrite() {
        return Boolean.TRUE;
    }

    @Override
    public HashMap<String, Object> getAuthenticatorContextMap(HttpServletRequest httpServletReq) {
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("req", httpServletReq);
        String returnUrl = httpServletReq.getParameter("returnUrl");
        if (returnUrl == null || returnUrl.length() < 1) {
            returnUrl = httpServletReq.getParameter("os_destination");
        }
        context.put("returnUrl", returnUrl);
        context.put("os_destination", returnUrl);
        context.put("originalurl", returnUrl);
        return context;
    }

    protected SecSignIDUserPwdPair extractUserPasswordPair(HttpServletRequest httpServletReq) {
        String userName = httpServletReq.getParameter("os_username");
        String password = httpServletReq.getParameter("os_password");
        boolean persistent = Boolean.getBoolean(httpServletReq.getParameter("os_cookie"));
        if (userName == null && password == null) {
            userName = httpServletReq.getParameter("secsign_os_username");
            password = httpServletReq.getParameter("secsign_os_password");
        }
        if (userName != null) {
            userName = userName.toLowerCase();
        }
        return new SecSignIDUserPwdPair(userName, password, persistent);
    }

    @Override
    public String loginWithUsernameAndPassword(HttpServletRequest request, HttpServletResponse response, ServletContext servletContext) {
        SecSignIDPasswordLoginFilter passwordLoginFilter = new SecSignIDPasswordLoginFilter();
        passwordLoginFilter.setServletContext(servletContext);
        return passwordLoginFilter.login(request, response);
    }

    private String getUserNameFromRequest(HttpServletRequest request) {
        if (request == null) {
            return null;
        }
        String username = request.getParameter("secsign_os_username");
        if (username == null) {
            if (request.getParameter("username") != null) {
                username = request.getParameter("username").trim();
                logger.warn("Got username from parameter 'username' but expected to be parameter 'secsign_os_username'. Request contains parameter: " + SecSignIDMappingUtils.toString(request.getParameterMap()));
            } else {
                logger.error("Could not get username from parameter 'secsign_os_username'. Request contains parameter: " + SecSignIDMappingUtils.toString(request.getParameterMap()));
            }
        } else {
            username = username.trim();
        }
        return username;
    }

    @Override
    public String checkLoginWithUsernameAndPassword(HttpServletRequest request, HttpServletResponse httpServletResponse, ServletContext servletContext) {
        SecSignIDPasswordLoginFilter passwordLoginFilter = new SecSignIDPasswordLoginFilter();
        passwordLoginFilter.setServletContext(servletContext);
        try {
            boolean checkSuccess = passwordLoginFilter.checkLogin(request, httpServletResponse);
            if (checkSuccess) {
                return "success";
            }
            return "error";
        }
        catch (AuthenticatorException e) {
            logger.error("AuthenticatorException on checkLogin for checkLoginWithUsernameAndPassword");
            return "error";
        }
    }

    @Override
    public boolean checkForElevatedSecurityCheck(HttpServletRequest httpServletReq, HttpServletResponse httpServletResp) {
        return BambooElevatedSecurityGuard.isElevatedSecurityRequired((ServletRequest)httpServletReq);
    }

    @Override
    public void prepareContextForCaptcha(HttpServletRequest request, HashMap<String, Object> context) {
        try {
            ImageCaptchaService captchaService = IMAGE_CAPTCHA_SERVICE.get();
            if (captchaService == null) {
                logger.error("Bamboo ImageCaptchaService is null. Cannot display Captcha");
                return;
            }
            String atlToken = request.getParameter("atl_token");
            BufferedImage image = captchaService.getImageChallengeForID(atlToken);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            Base64OutputStream base64OutputStream = new Base64OutputStream((OutputStream)baos);
            ImageIO.write((RenderedImage)image, "png", (OutputStream)base64OutputStream);
            String img = baos.toString("UTF-8");
            context.put("imageBamboo", img);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public String getLoginReason(HttpServletRequest httpServletReq, HttpServletResponse httpServletResp, ServletContext servletContext) {
        return "error";
    }

    @Override
    public void loginUserWithoutPassword(HttpServletRequest request, HttpServletResponse response, User user) {
        BambooUserManager bum = SecSignIDStaticAccessor.getBambooUserManager();
        BambooPermissionManager bpm = SecSignIDStaticAccessor.getBambooPermissionManager();
        logger.info("logged in user '" + user.getName() + "' is admin: " + bpm.isAdmin(user.getName()) + " sys-adim: " + bpm.isSystemAdmin(user.getName()));
        Pager groups = bum.getGroups();
        for (com.atlassian.user.Group g : groups) {
            logger.debug("group: " + g.getName() + " : " + bum.getMemberNamesAsList(g));
        }
        HttpSession session = request.getSession();
        session.setAttribute("seraph_secsignid_authenticator_user", (Object)user);
        session.setAttribute("seraph_defaultauthenticator_user", (Object)user);
        session.setAttribute("seraph_defaultauthenticator_logged_out_user", null);
        try {
            if (RestCrowdHttpAuthenticationFactory.getAuthenticator() != null) {
                RestCrowdHttpAuthenticationFactory.getAuthenticator().authenticateWithoutValidatingPassword(request, response, user.getName());
            }
        }
        catch (Throwable ex) {
            logger.trace("Error calling RestCrowdHttpAuthenticationFactory.getAuthenticator().authenticate(...);", ex);
        }
    }

    @Override
    public void sendRedirect(HttpServletRequest httpServletReq, HttpServletResponse httpServletResp) throws IOException {
        String returnUrl = httpServletReq.getParameter("returnUrl");
        String osDestination = httpServletReq.getParameter("os_destination");
        if (returnUrl != null && !returnUrl.equals("userlogin!default.action")) {
            if (returnUrl.startsWith(SecSignIDAuthenticationFilter.getBambooBaseUrl())) {
                httpServletResp.sendRedirect(returnUrl);
            } else {
                httpServletResp.sendRedirect(SecSignIDAuthenticationFilter.getBambooBaseUrl() + returnUrl);
            }
        } else if (osDestination != null && !osDestination.equals("userlogin")) {
            if (osDestination.startsWith(SecSignIDAuthenticationFilter.getBambooBaseUrl())) {
                httpServletResp.sendRedirect(osDestination);
            } else {
                httpServletResp.sendRedirect(SecSignIDAuthenticationFilter.getBambooBaseUrl() + osDestination);
            }
        } else {
            httpServletResp.sendRedirect(SecSignIDAuthenticationFilter.getBambooBaseUrl());
        }
    }

    @Override
    public boolean isUserAdmin(User userToTest) {
        return SecSignIDStaticAccessor.getBambooPermissionManager().isAdmin(userToTest.getName());
    }

    @Override
    public void deleteAllSettingsForNewAuthentication() {
        PluginSettings globalPluginSettings = SecSignIDStaticAccessor.getPluginSettingsFactory().createGlobalSettings();
        globalPluginSettings.remove("com.secsign.companyname");
        globalPluginSettings.remove("com.secsign.customlogin");
        globalPluginSettings.remove("com.secsign.basicauth");
        globalPluginSettings.remove("com.secsign.idserverurl.fallback");
        globalPluginSettings.remove("com.secsign.autofillusername");
        globalPluginSettings.remove("com.secsign.firststart");
        globalPluginSettings.remove("com.secsign.idserverurl");
        globalPluginSettings.remove("com.secsign.pinuser");
        globalPluginSettings.remove("com.secsign.pinpassword");
        globalPluginSettings.remove("com.secsign.logincolor");
        globalPluginSettings.remove("com.secsign.crowdnewlogin");
        globalPluginSettings.remove("com.secsign.sessiontimeout");
        globalPluginSettings.remove("com.secsign.sessiontimeout.duration");
        globalPluginSettings.remove("com.secsign.customlogo");
        globalPluginSettings.remove("com.secsign.logintitle");
        globalPluginSettings.remove("com.secsign.loginsubtitle");
        globalPluginSettings.remove("com.secsign.iOSUrl");
        globalPluginSettings.remove("com.secsign.androidUrl");
        globalPluginSettings.remove("com.secsign.windowsUrl");
        globalPluginSettings.remove("com.secsign.macOSUrl");
        globalPluginSettings.remove("com.secsign.noaccesspass");
        globalPluginSettings.remove("com.secsign.safezone");
        globalPluginSettings.remove("com.secsign.safezonerange");
        globalPluginSettings.remove("com.secsign.servicedesk");
        globalPluginSettings.remove("com.secsign.servicename");
        globalPluginSettings.remove("com.secsign.synchid");
        globalPluginSettings.remove("com.secsign.synchwrite");
        globalPluginSettings.remove("com.secsign.userchange");
        globalPluginSettings.remove("com.secsign.twofa");
        globalPluginSettings.remove("com.secsign.twostep");
        globalPluginSettings.remove("com.secsign.twostepmail");
        try {
            SecSignIDMappingExtractor.deleteLocalMappings();
        }
        catch (DirectoryPermissionException directoryPermissionException) {
        }
        catch (OperationFailedException operationFailedException) {
        }
        catch (InvalidAuthenticationException e) {
            e.printStackTrace();
        }
        catch (ApplicationPermissionException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void createGroupsWithSettings() throws InvalidGroupException, DirectoryPermissionException, DirectoryNotFoundException, OperationFailedException, GroupNotFoundException, ApplicationPermissionException, InvalidAuthenticationException {
        List dirs = SecSignIDStaticAccessor.getDirectoryManager().findAllDirectories();
        for (Directory directory : dirs) {
            GroupTemplate passwordlessTemplate = new GroupTemplate("PasswordlessAllowed");
            passwordlessTemplate.setDirectoryId(directory.getId().longValue());
            GroupTemplate twostepTemplate = new GroupTemplate("2SASecSignIDAllowed");
            twostepTemplate.setDirectoryId(directory.getId().longValue());
            GroupTemplate mailotpTemplate = new GroupTemplate("2SAMailOTPAllowed");
            mailotpTemplate.setDirectoryId(directory.getId().longValue());
            GroupTemplate totpTemplate = new GroupTemplate("2SATOTPAllowed");
            totpTemplate.setDirectoryId(directory.getId().longValue());
            GroupTemplate fidoTemplate = new GroupTemplate("2SAFIDOAllowed");
            fidoTemplate.setDirectoryId(directory.getId().longValue());
            try {
                SecSignIDStaticAccessor.getDirectoryManager().findGroupByName(directory.getId().longValue(), passwordlessTemplate.getName());
            }
            catch (GroupNotFoundException e) {
                SecSignIDStaticAccessor.getDirectoryManager().addGroup(directory.getId().longValue(), passwordlessTemplate);
            }
            try {
                SecSignIDStaticAccessor.getDirectoryManager().findGroupByName(directory.getId().longValue(), twostepTemplate.getName());
            }
            catch (GroupNotFoundException e) {
                SecSignIDStaticAccessor.getDirectoryManager().addGroup(directory.getId().longValue(), twostepTemplate);
            }
            try {
                SecSignIDStaticAccessor.getDirectoryManager().findGroupByName(directory.getId().longValue(), mailotpTemplate.getName());
            }
            catch (GroupNotFoundException e) {
                SecSignIDStaticAccessor.getDirectoryManager().addGroup(directory.getId().longValue(), mailotpTemplate);
            }
            try {
                SecSignIDStaticAccessor.getDirectoryManager().findGroupByName(directory.getId().longValue(), totpTemplate.getName());
            }
            catch (GroupNotFoundException e) {
                SecSignIDStaticAccessor.getDirectoryManager().addGroup(directory.getId().longValue(), totpTemplate);
            }
            try {
                SecSignIDStaticAccessor.getDirectoryManager().findGroupByName(directory.getId().longValue(), fidoTemplate.getName());
            }
            catch (GroupNotFoundException e) {
                SecSignIDStaticAccessor.getDirectoryManager().addGroup(directory.getId().longValue(), fidoTemplate);
            }
            HashMap<String, SecSignID2FASettings> mapping = new HashMap<String, SecSignID2FASettings>();
            SecSignID2FASettings forPasswordless = new SecSignID2FASettings("010000");
            SecSignID2FASettings forTwoStep = new SecSignID2FASettings("001000");
            SecSignID2FASettings forMailOTP = new SecSignID2FASettings("000100");
            SecSignID2FASettings forTOTP = new SecSignID2FASettings("000010");
            SecSignID2FASettings forFIDO = new SecSignID2FASettings("000001");
            mapping.put("PasswordlessAllowed".toLowerCase() + ";" + directory.getId(), forPasswordless);
            mapping.put("2SASecSignIDAllowed".toLowerCase() + ";" + directory.getId(), forTwoStep);
            mapping.put("2SAMailOTPAllowed".toLowerCase() + ";" + directory.getId(), forMailOTP);
            mapping.put("2SATOTPAllowed".toLowerCase() + ";" + directory.getId(), forTOTP);
            mapping.put("2SAFIDOAllowed".toLowerCase() + ";" + directory.getId(), forFIDO);
            this.save2FAGroupMappings(mapping);
            this.logGroup2FAChangeToAuditLog("PasswordlessAllowed", directory.getId(), false, true, false, false, false, false, this.getBaseUrl());
            if (SecSignIDCommonStaticAccessor.getInformAdmin()) {
                this.mail2FAChangeOfGroupToInformGroup("PasswordlessAllowed", directory.getId(), false, true, false, false, false, false, this.getUserCurrentlyLoggedIn().getName(), this.getUserCurrentlyLoggedIn().getDirectoryId());
            }
            this.logGroup2FAChangeToAuditLog("2SASecSignIDAllowed", directory.getId(), false, false, true, false, false, false, this.getBaseUrl());
            if (SecSignIDCommonStaticAccessor.getInformAdmin()) {
                this.mail2FAChangeOfGroupToInformGroup("2SASecSignIDAllowed", directory.getId(), false, false, true, false, false, false, this.getUserCurrentlyLoggedIn().getName(), this.getUserCurrentlyLoggedIn().getDirectoryId());
            }
            this.logGroup2FAChangeToAuditLog("2SAMailOTPAllowed", directory.getId(), false, false, false, true, false, false, this.getBaseUrl());
            if (SecSignIDCommonStaticAccessor.getInformAdmin()) {
                this.mail2FAChangeOfGroupToInformGroup("2SAMailOTPAllowed", directory.getId(), false, false, false, true, false, false, this.getUserCurrentlyLoggedIn().getName(), this.getUserCurrentlyLoggedIn().getDirectoryId());
            }
            this.logGroup2FAChangeToAuditLog("2SATOTPAllowed", directory.getId(), false, false, false, false, true, false, this.getBaseUrl());
            if (SecSignIDCommonStaticAccessor.getInformAdmin()) {
                this.mail2FAChangeOfGroupToInformGroup("2SATOTPAllowed", directory.getId(), false, false, false, false, true, false, this.getUserCurrentlyLoggedIn().getName(), this.getUserCurrentlyLoggedIn().getDirectoryId());
            }
            this.logGroup2FAChangeToAuditLog("2SAFIDOAllowed", directory.getId(), false, false, false, false, false, true, this.getBaseUrl());
            if (!SecSignIDCommonStaticAccessor.getInformAdmin()) continue;
            this.mail2FAChangeOfGroupToInformGroup("2SAFIDOAllowed", directory.getId(), false, false, false, false, false, true, this.getUserCurrentlyLoggedIn().getName(), this.getUserCurrentlyLoggedIn().getDirectoryId());
        }
    }

    @Override
    public List<String> findGroupsForTerm(String searchTerm) throws DirectoryNotFoundException, OperationFailedException {
        ArrayList<String> result = new ArrayList<String>();
        DirectoryManager localDirectoryManager = SecSignIDStaticAccessor.getDirectoryManager();
        List dirs = localDirectoryManager.findAllDirectories();
        for (Directory directory : dirs) {
            EntityQuery query = QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.group()).with((SearchRestriction)Restriction.on((Property)GroupTermKeys.NAME).containing((Object)searchTerm)).startingAt(0).returningAtMost(11);
            List groups = localDirectoryManager.searchGroups(directory.getId().longValue(), query);
            result.addAll(SecSignIDMappingUtils.fixGroupListForDirIDAndEscape(groups, directory.getId()));
        }
        return result;
    }

    @Override
    public int findPageForGroup(String groupName, long _chosenDir) throws DirectoryNotFoundException, OperationFailedException {
        List groups;
        DirectoryManager localDirectoryManager = SecSignIDStaticAccessor.getDirectoryManager();
        List dirs = localDirectoryManager.findAllDirectories();
        int page = 1;
        do {
            EntityQuery query = QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.group()).startingAt((page - 1) * 10).returningAtMost(10);
            groups = localDirectoryManager.searchGroups(_chosenDir, query);
            for (String foundGroups : groups) {
                if (!foundGroups.toLowerCase().equals(groupName)) continue;
                return page;
            }
            ++page;
        } while (groups.size() == 10);
        return 0;
    }

    public void recreateQRCodes() throws DirectoryNotFoundException, OperationFailedException, ApplicationPermissionException, InvalidAuthenticationException, DirectoryPermissionException, SecSignIDRESTException {
    }

    @Override
    public Set<String> getAllUserGroupsMappingKeys() {
        DirectoryManager localDirectoryManager = SecSignIDStaticAccessor.getDirectoryManager();
        List dirs = localDirectoryManager.findAllDirectories();
        LinkedHashSet<String> _groupNames = new LinkedHashSet<String>();
        if (dirs != null) {
            for (Directory directory : dirs) {
                if (!directory.isActive()) continue;
                EntityQuery query = QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.group()).returningAtMost(-1);
                try {
                    List groups = localDirectoryManager.searchGroups(directory.getId().longValue(), query);
                    for (String groupName : groups) {
                        _groupNames.add(groupName.toLowerCase().replace(" ", "___") + ";" + directory.getId());
                    }
                }
                catch (Exception e) {
                    logger.debug("Could not get user groups for directory with ID " + directory.getId() + ". Skip directory and use next one. (" + e.getMessage() + ")");
                }
            }
        } else {
            logger.warn("Did not get a list of directories.");
        }
        return _groupNames;
    }

    @Override
    public List<String> getGroupMappingKeysForUserKey(String userKey, long dirid) throws OperationFailedException {
        ArrayList<String> result = new ArrayList<String>();
        MembershipQuery query = QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.group()).parentsOf(EntityDescriptor.user()).withName(this.getUsernameForUserKey(userKey)).returningAtMost(-1);
        ArrayList<String> groups = new ArrayList();
        try {
            groups = SecSignIDStaticAccessor.getDirectoryManager().searchNestedGroupRelationships(dirid, query);
        }
        catch (DirectoryNotFoundException e) {
            e.printStackTrace();
        }
        result.addAll(SecSignIDMappingUtils.fixGroupListForDirIDAndEscape(groups, dirid));
        return result;
    }

    @Override
    public String getGroupLink(String groupName, long dirid) {
        return this.getBaseUrl() + "/admin/group/editGroup.action?groupName=" + groupName;
    }

    @Override
    public void logAutomaticUserChangeToAuditLog(String userKey, long dirid, String secSignID, String ip) {
        AuditLogService auditService = SecSignIDStaticAccessor.getAuditLogService();
        AuditLogMessage entry = new AuditLogMessage();
    }

    @Override
    public void logChangeSecSignIDToAuditLog(String userKey, long dirid, String secSignID, String ip) {
        AuditLogService auditService = SecSignIDStaticAccessor.getAuditLogService();
        try {
            User changed = this.getUserForKey(userKey, dirid);
            auditService.log(SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.audit.admin.changed.secsignid", new Serializable[]{secSignID}) + " <a target=\"_blank\" href=" + this.getUserProfileLink(changed, this.getBaseUrl()) + ">" + userKey + "<a>", "", secSignID, null);
        }
        catch (com.atlassian.crowd.exception.runtime.UserNotFoundException e) {
            logger.error("UserNotFoundException on logChangeSecSignIDToAuditLog");
        }
        catch (DirectoryNotFoundException e) {
            logger.error("DirectoryNotFoundException on logChangeSecSignIDToAuditLog");
        }
        catch (OperationFailedException e) {
            logger.error("OperationFailedException on logChangeSecSignIDToAuditLog");
        }
    }

    @Override
    public void logActivateTOTP(String userKey, long dirid, String ip) {
        AuditLogService auditService = SecSignIDStaticAccessor.getAuditLogService();
        try {
            auditService.log(SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.mail.changed.totp.activated"));
        }
        catch (com.atlassian.crowd.exception.runtime.UserNotFoundException e) {
            logger.error("UserNotFoundException on logActivateTOTP");
        }
    }

    @Override
    public void logActivateFIDO(String userKey, long dirid, String ip) {
        AuditLogService auditService = SecSignIDStaticAccessor.getAuditLogService();
        try {
            auditService.log(SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.mail.changed.fido.activated"));
        }
        catch (com.atlassian.crowd.exception.runtime.UserNotFoundException e) {
            logger.error("UserNotFoundException on logActivateFIDO");
        }
    }

    @Override
    public void logActivateSecSignID(String userKey, long dirid, String ip) {
        AuditLogService auditService = SecSignIDStaticAccessor.getAuditLogService();
        try {
            auditService.log(SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.mail.changed.secsignid.activated"));
        }
        catch (com.atlassian.crowd.exception.runtime.UserNotFoundException e) {
            logger.error("UserNotFoundException on logActivateSecSignID");
        }
    }

    @Override
    public void logActivateMailOTP(String userKey, long dirid, String ip) {
        AuditLogService auditService = SecSignIDStaticAccessor.getAuditLogService();
        try {
            auditService.log(SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.mail.changed.mailotp.activated"));
        }
        catch (com.atlassian.crowd.exception.runtime.UserNotFoundException e) {
            logger.error("UserNotFoundException on logActivateMailOTP");
        }
    }

    @Override
    public void logGroup2FAChangeToAuditLog(String groupname, long dirid, boolean newValuePwdAllowed, boolean newValuePasswordless, boolean newValueTwoStep, boolean newValueMailOTP, boolean newValueTOTP, boolean newValueFIDO, String ip) {
        AuditLogService auditService = SecSignIDStaticAccessor.getAuditLogService();
        try {
            auditService.log(SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.audit.admin.changed.2fa", new Serializable[]{this.getAllowedStringForBoolean(newValuePwdAllowed), this.getAllowedStringForBoolean(newValuePasswordless), this.getAllowedStringForBoolean(newValueTwoStep), this.getAllowedStringForBoolean(newValueMailOTP), this.getAllowedStringForBoolean(newValueTOTP), this.getAllowedStringForBoolean(newValueFIDO)}) + " <a target=\"_blank\" href=" + this.getGroupLink(groupname, dirid) + ">" + groupname + "<a>", "", "techmo3", null);
        }
        catch (com.atlassian.crowd.exception.runtime.UserNotFoundException e) {
            logger.error("UserNotFoundException on logActivateMailOTP");
        }
    }

    @Override
    public void logChangeSettingToAuditLog(String settingName, String newValue, String oldValue, String ip) {
        if (oldValue.length() > 30) {
            oldValue = oldValue.substring(0, 30);
        }
        if (newValue.length() > 30) {
            newValue = newValue.substring(0, 30);
        }
        AuditLogService auditService = SecSignIDStaticAccessor.getAuditLogService();
        try {
            auditService.log(SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.audit.admin.changed.setting", new Serializable[]{settingName, oldValue, newValue}));
        }
        catch (com.atlassian.crowd.exception.runtime.UserNotFoundException e) {
            logger.error("UserNotFoundException on logActivateMailOTP");
        }
    }

    @Override
    public void mailChangeSecSignIDToInformGroup(String userKey, long diridChanged, String changedByUserKey, long changedByDirid, String secSignID) throws OperationFailedException {
        try {
            User user = this.getUserForKey(userKey, diridChanged);
            User changedBy = this.getUserForKey(changedByUserKey, changedByDirid);
            String informGroupString = SecSignIDCommonStaticAccessor.getInformGroup();
            if (informGroupString != null && !informGroupString.equals("")) {
                String[] mappingKeysToInform;
                for (String mappingKey : mappingKeysToInform = informGroupString.split(",")) {
                    String groupname = SecSignIDMappingUtils.getGroupNameFromGroupMappingKey(mappingKey);
                    long dirid = SecSignIDMappingUtils.getDirIDFromGroupMappingKey(mappingKey);
                    try {
                        Collection<String> usernames = this.findGroupMembersUsernames(dirid, groupname);
                        for (String string : usernames) {
                            User userToInform = this.getUserForKey(string, dirid);
                            String email = userToInform.getEmailAddress();
                            Email mailObject = new Email(email);
                            mailObject.setSubject(SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.mail.your.details.changed.topic"));
                            mailObject.setBody(this.getChangeMailForUserToInform(user, changedBy, userToInform, secSignID));
                            SecSignIDStaticAccessor.getMailConfigurationService().getMailServer().send(mailObject);
                        }
                    }
                    catch (DirectoryNotFoundException directoryNotFoundException) {
                    }
                    catch (MailException e) {
                        logger.error("MailException on mailChangeSecSignIDToInformGroup: " + e.getLocalizedMessage());
                    }
                    catch (UnauthorisedException e) {
                        logger.error("UnauthorisedException on mailChangeSecSignIDToInformGroup: " + e.getLocalizedMessage());
                    }
                    catch (NotFoundException e) {
                        logger.error("NotFoundException on mailChangeSecSignIDToInformGroup: " + e.getLocalizedMessage());
                    }
                }
            }
        }
        catch (DirectoryNotFoundException e) {
            logger.error("DirectoryNotFoundException on mailChangeSecSignIDToInformGroup");
        }
        catch (OperationFailedException e) {
            logger.error("OperationFailedException on mailChangeSecSignIDToInformGroup");
        }
        catch (com.atlassian.crowd.exception.runtime.UserNotFoundException e) {
            logger.error("UserNotFoundException on mailChangeSecSignIDToInformGroup");
        }
    }

    @Override
    public void mail2FAChangeToGroupMembers(String groupnameChanged, long diridChanged) {
        try {
            Set<String> usernamesOfGroup = this.getUsernamesForGroupname(groupnameChanged + ";" + diridChanged);
            for (String username : usernamesOfGroup) {
                try {
                    User user = this.getUserForKey(username, diridChanged);
                    SecSignID2FASettings settings = this.get2FASettingsFromUserKey(this.getUserKeyForUsername(username), user.getDirectoryId());
                    boolean pwdAllowed = settings.getPwdAllowed().equals(SecSignIDCommonConstants.AuthIsAllowed);
                    boolean passwordlessAllowed = settings.getPasswordlessAllowed().equals(SecSignIDCommonConstants.AuthIsAllowed);
                    boolean twostepAllowed = settings.getTwoStepAllowed().equals(SecSignIDCommonConstants.AuthIsAllowed);
                    boolean mailotpAllowed = settings.getMailOtpAllowed().equals(SecSignIDCommonConstants.AuthIsAllowed);
                    boolean totpAllowed = settings.getTotpAllowed().equals(SecSignIDCommonConstants.AuthIsAllowed);
                    boolean fidoAllowed = settings.getFidoAllowed().equals(SecSignIDCommonConstants.AuthIsAllowed);
                    String email = user.getEmailAddress();
                    Email mailObject = new Email(email);
                    mailObject.setSubject(SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.mail.your.2fa.changed.topic"));
                    mailObject.setBody(this.getChange2FAMailForUser(user, pwdAllowed, passwordlessAllowed, twostepAllowed, mailotpAllowed, totpAllowed, fidoAllowed));
                    SecSignIDStaticAccessor.getMailConfigurationService().getMailServer().send(mailObject);
                }
                catch (ApplicationPermissionException e) {
                    logger.error("ApplicationPermissionException on mail2FAChangeToGroupMembers");
                }
                catch (InvalidAuthenticationException e) {
                    logger.error("InvalidAuthenticationException on mail2FAChangeToGroupMembers");
                }
                catch (MailException e) {
                    logger.error("MailException on mail2FAChangeToGroupMembers: " + e.getLocalizedMessage());
                }
                catch (UnauthorisedException e) {
                    logger.error("UnauthorisedException on mail2FAChangeToGroupMembers: " + e.getLocalizedMessage());
                }
                catch (NotFoundException e) {
                    logger.error("NotFoundException on mail2FAChangeToGroupMembers: " + e.getLocalizedMessage());
                }
            }
        }
        catch (DirectoryNotFoundException e) {
            logger.error("DirectoryNotFoundException on mail2FAChangeToGroupMembers");
        }
        catch (OperationFailedException e) {
            logger.error("OperationFailedException on mail2FAChangeToGroupMembers");
        }
    }

    @Override
    public void mail2FAChangeOfGroupToInformGroup(String groupnameChanged, long diridChanged, boolean newValuePwdAllowed, boolean newValuePasswordless, boolean newValueTwoStep, boolean newValueMailOTP, boolean newValueTOTP, boolean newValueFIDO, String changedByUserKey, long changedByDirid) {
        try {
            User changedBy = this.getUserForKey(changedByUserKey, changedByDirid);
            String informGroupString = SecSignIDCommonStaticAccessor.getInformGroup();
            if (informGroupString != null && !informGroupString.equals("")) {
                String[] mappingKeysToInform;
                for (String mappingKey : mappingKeysToInform = informGroupString.split(",")) {
                    String groupname = SecSignIDMappingUtils.getGroupNameFromGroupMappingKey(mappingKey);
                    long dirid = SecSignIDMappingUtils.getDirIDFromGroupMappingKey(mappingKey);
                    Collection<String> usernames = this.findGroupMembersUsernames(dirid, groupname);
                    for (String userNameToInform : usernames) {
                        User user = this.getUserForKey(userNameToInform, dirid);
                        String email = user.getEmailAddress();
                        Email mailObject = new Email(email);
                        mailObject.setSubject(SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.mail.your.2fa.changed.topic"));
                        mailObject.setBody(this.getChange2FAMailForGroupToInform(user, changedBy, groupnameChanged, newValuePwdAllowed, newValuePasswordless, newValueTwoStep, newValueMailOTP, newValueTOTP, newValueFIDO));
                        SecSignIDStaticAccessor.getMailConfigurationService().getMailServer().send(mailObject);
                    }
                }
            }
        }
        catch (DirectoryNotFoundException e) {
            logger.error("DirectoryNotFoundException on mail2FAChangeOfGroupToInformGroup");
        }
        catch (OperationFailedException e) {
            logger.error("OperationFailedException on mail2FAChangeOfGroupToInformGroup");
        }
        catch (com.atlassian.crowd.exception.runtime.UserNotFoundException e) {
            logger.error("UserNotFoundException on mail2FAChangeOfGroupToInformGroup");
        }
        catch (MailException e) {
            logger.error("MailException on mail2FAChangeOfGroupToInformGroup: " + e.getLocalizedMessage());
        }
        catch (UnauthorisedException e) {
            logger.error("UnauthorisedException on mail2FAChangeOfGroupToInformGroup: " + e.getLocalizedMessage());
        }
        catch (NotFoundException e) {
            logger.error("NotFoundException on mail2FAChangeOfGroupToInformGroup: " + e.getLocalizedMessage());
        }
    }

    @Override
    public void mailChangeSecSignIDToUser(String userKey, long dirid, String changedByUserKey, long changedByDirid, String secSignID) throws OperationFailedException {
        try {
            User user = this.getUserForKey(userKey, dirid);
            User changedBy = this.getUserForKey(changedByUserKey, changedByDirid);
            String email = user.getEmailAddress();
            Email mailObject = new Email(email);
            mailObject.setSubject(SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.mail.your.details.changed.topic"));
            mailObject.setBody(this.getChangeMailForSecSignIDToUser(user, changedBy, secSignID));
            SecSignIDStaticAccessor.getMailConfigurationService().getMailServer().send(mailObject);
        }
        catch (DirectoryNotFoundException e) {
            logger.error("DirectoryNotFoundException on mailChangeSecSignIDToUser");
        }
        catch (OperationFailedException e) {
            logger.error("OperationFailedException on mailChangeSecSignIDToUser");
        }
        catch (com.atlassian.crowd.exception.runtime.UserNotFoundException e) {
            logger.error("UserNotFoundException on mailChangeSecSignIDToUser");
        }
        catch (MailException e) {
            logger.error("MailException on mailChangeSecSignIDToUser: " + e.getLocalizedMessage());
        }
        catch (UnauthorisedException e) {
            logger.error("UnauthorisedException on mailChangeSecSignIDToUser: " + e.getLocalizedMessage());
        }
        catch (NotFoundException e) {
            logger.error("NotFoundException on mailChangeSecSignIDToUser: " + e.getLocalizedMessage());
        }
    }

    @Override
    public void mailActivateTOTPToUser(String userKey, long dirid) throws OperationFailedException {
        try {
            User user = this.getUserForKey(userKey, dirid);
            String email = user.getEmailAddress();
            Email mailObject = new Email(email);
            mailObject.setSubject(SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.mail.your.details.changed.topic"));
            mailObject.setBody(this.getChangeMailForTOTPToUser(user));
            SecSignIDStaticAccessor.getMailConfigurationService().getMailServer().send(mailObject);
        }
        catch (DirectoryNotFoundException e) {
            logger.error("DirectoryNotFoundException on mailActivateTOTPToUser");
        }
        catch (OperationFailedException e) {
            logger.error("OperationFailedException on mailActivateTOTPToUser");
        }
        catch (com.atlassian.crowd.exception.runtime.UserNotFoundException e) {
            logger.error("UserNotFoundException on mailActivateTOTPToUser");
        }
        catch (MailException e) {
            logger.error("MailException on mailActivateTOTPToUser: " + e.getLocalizedMessage());
        }
        catch (UnauthorisedException e) {
            logger.error("UnauthorisedException on mailActivateTOTPToUser: " + e.getLocalizedMessage());
        }
        catch (NotFoundException e) {
            logger.error("NotFoundException on mailActivateTOTPToUser: " + e.getLocalizedMessage());
        }
    }

    @Override
    public void mailActivateFIDOToUser(String userKey, long dirid) throws OperationFailedException {
        try {
            User user = this.getUserForKey(userKey, dirid);
            String email = user.getEmailAddress();
            Email mailObject = new Email(email);
            mailObject.setSubject(SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.mail.your.details.changed.topic"));
            mailObject.setBody(this.getChangeMailForFIDOToUser(user));
            SecSignIDStaticAccessor.getMailConfigurationService().getMailServer().send(mailObject);
        }
        catch (DirectoryNotFoundException e) {
            logger.error("DirectoryNotFoundException on mailActivateFIDOToUser");
        }
        catch (OperationFailedException e) {
            logger.error("OperationFailedException on mailActivateFIDOToUser");
        }
        catch (com.atlassian.crowd.exception.runtime.UserNotFoundException e) {
            logger.error("UserNotFoundException on mailActivateFIDOToUser");
        }
        catch (MailException e) {
            logger.error("MailException on mailActivateFIDOToUser: " + e.getLocalizedMessage());
        }
        catch (UnauthorisedException e) {
            logger.error("UnauthorisedException on mailActivateFIDOToUser: " + e.getLocalizedMessage());
        }
        catch (NotFoundException e) {
            logger.error("NotFoundException on mailActivateFIDOToUser: " + e.getLocalizedMessage());
        }
    }

    @Override
    public void mailActivateSecSignIDToUser(String userKey, long dirid) throws OperationFailedException {
        try {
            User user = this.getUserForKey(userKey, dirid);
            String email = user.getEmailAddress();
            Email mailObject = new Email(email);
            mailObject.setSubject(SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.mail.your.details.changed.topic"));
            mailObject.setBody(this.getChangeMailForSecSignIDToUser(user));
            SecSignIDStaticAccessor.getMailConfigurationService().getMailServer().send(mailObject);
        }
        catch (DirectoryNotFoundException e) {
            logger.error("DirectoryNotFoundException on mailActivateSecSignIDToUser");
        }
        catch (OperationFailedException e) {
            logger.error("OperationFailedException on mailActivateSecSignIDToUser");
        }
        catch (com.atlassian.crowd.exception.runtime.UserNotFoundException e) {
            logger.error("UserNotFoundException on mailActivateSecSignIDToUser");
        }
        catch (MailException e) {
            logger.error("MailException on mailActivateSecSignIDToUser: " + e.getLocalizedMessage());
        }
        catch (UnauthorisedException e) {
            logger.error("UnauthorisedException on mailActivateSecSignIDToUser: " + e.getLocalizedMessage());
        }
        catch (NotFoundException e) {
            logger.error("NotFoundException on mailActivateSecSignIDToUser: " + e.getLocalizedMessage());
        }
    }

    @Override
    public void mailActivateMailOTPToUser(String userKey, long dirid) throws OperationFailedException {
        try {
            User user = this.getUserForKey(userKey, dirid);
            String email = user.getEmailAddress();
            Email mailObject = new Email(email);
            mailObject.setSubject(SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.mail.your.details.changed.topic"));
            mailObject.setBody(this.getChangeMailForMailOTPToUser(user));
            SecSignIDStaticAccessor.getMailConfigurationService().getMailServer().send(mailObject);
        }
        catch (DirectoryNotFoundException e) {
            logger.error("DirectoryNotFoundException on mailActivateMailOTPToUser");
        }
        catch (OperationFailedException e) {
            logger.error("OperationFailedException on mailActivateMailOTPToUser");
        }
        catch (com.atlassian.crowd.exception.runtime.UserNotFoundException e) {
            logger.error("UserNotFoundException on mailActivateMailOTPToUser");
        }
        catch (MailException e) {
            logger.error("MailException on mailActivateMailOTPToUser: " + e.getLocalizedMessage());
        }
        catch (UnauthorisedException e) {
            logger.error("UnauthorisedException on mailActivateMailOTPToUser: " + e.getLocalizedMessage());
        }
        catch (NotFoundException e) {
            logger.error("NotFoundException on mailActivateMailOTPToUser: " + e.getLocalizedMessage());
        }
    }

    @Override
    public void mailActivateTOTPToInformGroup(String userKey, long dirid) throws OperationFailedException {
        try {
            User changedUser = this.getUserForKey(userKey, dirid);
            String informGroupString = SecSignIDCommonStaticAccessor.getInformGroup();
            if (informGroupString != null && !informGroupString.equals("")) {
                String[] mappingKeysToInform;
                for (String mappingKey : mappingKeysToInform = informGroupString.split(",")) {
                    String groupname = SecSignIDMappingUtils.getGroupNameFromGroupMappingKey(mappingKey);
                    long diridToInform = SecSignIDMappingUtils.getDirIDFromGroupMappingKey(mappingKey);
                    Collection<String> usernames = this.findGroupMembersUsernames(diridToInform, groupname);
                    for (String userNameToInform : usernames) {
                        User user = this.getUserForKey(userNameToInform, diridToInform);
                        String email = user.getEmailAddress();
                        Email mailObject = new Email(email);
                        mailObject.setSubject(SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.mail.your.details.changed.topic"));
                        mailObject.setBody(this.getChangeMailForTOTPToGroup(changedUser, user));
                        SecSignIDStaticAccessor.getMailConfigurationService().getMailServer().send(mailObject);
                    }
                }
            }
        }
        catch (DirectoryNotFoundException e) {
            logger.error("DirectoryNotFoundException on mailActivateTOTPToInformGroup");
        }
        catch (OperationFailedException e) {
            logger.error("OperationFailedException on mailActivateTOTPToInformGroup");
        }
        catch (com.atlassian.crowd.exception.runtime.UserNotFoundException e) {
            logger.error("UserNotFoundException on mailActivateTOTPToInformGroup");
        }
        catch (MailException e) {
            logger.error("MailException on mailActivateTOTPToInformGroup: " + e.getLocalizedMessage());
        }
        catch (UnauthorisedException e) {
            logger.error("UnauthorisedException on mailActivateTOTPToInformGroup: " + e.getLocalizedMessage());
        }
        catch (NotFoundException e) {
            logger.error("NotFoundException on mailActivateTOTPToInformGroup: " + e.getLocalizedMessage());
        }
    }

    @Override
    public void mailActivateFIDOToInformGroup(String userKey, long dirid) throws OperationFailedException {
        try {
            User changedUser = this.getUserForKey(userKey, dirid);
            String informGroupString = SecSignIDCommonStaticAccessor.getInformGroup();
            if (informGroupString != null && !informGroupString.equals("")) {
                String[] mappingKeysToInform;
                for (String mappingKey : mappingKeysToInform = informGroupString.split(",")) {
                    String groupname = SecSignIDMappingUtils.getGroupNameFromGroupMappingKey(mappingKey);
                    long diridToInform = SecSignIDMappingUtils.getDirIDFromGroupMappingKey(mappingKey);
                    Collection<String> usernames = this.findGroupMembersUsernames(diridToInform, groupname);
                    for (String userNameToInform : usernames) {
                        User user = this.getUserForKey(userNameToInform, diridToInform);
                        String email = user.getEmailAddress();
                        Email mailObject = new Email(email);
                        mailObject.setSubject(SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.mail.your.details.changed.topic"));
                        mailObject.setBody(this.getChangeMailForFIDOToGroup(changedUser, user));
                        SecSignIDStaticAccessor.getMailConfigurationService().getMailServer().send(mailObject);
                    }
                }
            }
        }
        catch (DirectoryNotFoundException e) {
            logger.error("DirectoryNotFoundException on mailActivateFIDOToInformGroup");
        }
        catch (OperationFailedException e) {
            logger.error("OperationFailedException on mailActivateFIDOToInformGroup");
        }
        catch (com.atlassian.crowd.exception.runtime.UserNotFoundException e) {
            logger.error("UserNotFoundException on mailActivateFIDOToInformGroup");
        }
        catch (MailException e) {
            logger.error("MailException on mailActivateFIDOToInformGroup: " + e.getLocalizedMessage());
        }
        catch (UnauthorisedException e) {
            logger.error("UnauthorisedException on mailActivateFIDOToInformGroup: " + e.getLocalizedMessage());
        }
        catch (NotFoundException e) {
            logger.error("NotFoundException on mailActivateFIDOToInformGroup: " + e.getLocalizedMessage());
        }
    }

    @Override
    public void mailActivateSecSignIDToInformGroup(String userKey, long dirid) throws OperationFailedException {
        try {
            User changedUser = this.getUserForKey(userKey, dirid);
            String informGroupString = SecSignIDCommonStaticAccessor.getInformGroup();
            if (informGroupString != null && !informGroupString.equals("")) {
                String[] mappingKeysToInform;
                for (String mappingKey : mappingKeysToInform = informGroupString.split(",")) {
                    String groupname = SecSignIDMappingUtils.getGroupNameFromGroupMappingKey(mappingKey);
                    long diridToInform = SecSignIDMappingUtils.getDirIDFromGroupMappingKey(mappingKey);
                    Collection<String> usernames = this.findGroupMembersUsernames(diridToInform, groupname);
                    for (String userNameToInform : usernames) {
                        User user = this.getUserForKey(userNameToInform, diridToInform);
                        String email = user.getEmailAddress();
                        Email mailObject = new Email(email);
                        mailObject.setSubject(SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.mail.your.details.changed.topic"));
                        mailObject.setBody(this.getChangeMailForSecSignIDToGroup(changedUser, user));
                        SecSignIDStaticAccessor.getMailConfigurationService().getMailServer().send(mailObject);
                    }
                }
            }
        }
        catch (DirectoryNotFoundException e) {
            logger.error("DirectoryNotFoundException on mailActivateSecSignIDToInformGroup");
        }
        catch (OperationFailedException e) {
            logger.error("OperationFailedException on mailActivateSecSignIDToInformGroup");
        }
        catch (com.atlassian.crowd.exception.runtime.UserNotFoundException e) {
            logger.error("UserNotFoundException on mailActivateSecSignIDToInformGroup");
        }
        catch (MailException e) {
            logger.error("MailException on mailActivateSecSignIDToInformGroup: " + e.getLocalizedMessage());
        }
        catch (UnauthorisedException e) {
            logger.error("UnauthorisedException on mailActivateSecSignIDToInformGroup: " + e.getLocalizedMessage());
        }
        catch (NotFoundException e) {
            logger.error("NotFoundException on mailActivateSecSignIDToInformGroup: " + e.getLocalizedMessage());
        }
    }

    @Override
    public void mailActivateMailOTPToInformGroup(String userKey, long dirid) throws OperationFailedException {
        try {
            User changedUser = this.getUserForKey(userKey, dirid);
            String informGroupString = SecSignIDCommonStaticAccessor.getInformGroup();
            if (informGroupString != null && !informGroupString.equals("")) {
                String[] mappingKeysToInform;
                for (String mappingKey : mappingKeysToInform = informGroupString.split(",")) {
                    String groupname = SecSignIDMappingUtils.getGroupNameFromGroupMappingKey(mappingKey);
                    long diridToInform = SecSignIDMappingUtils.getDirIDFromGroupMappingKey(mappingKey);
                    Collection<String> usernames = this.findGroupMembersUsernames(diridToInform, groupname);
                    for (String userNameToInform : usernames) {
                        User user = this.getUserForKey(userNameToInform, diridToInform);
                        String email = user.getEmailAddress();
                        Email mailObject = new Email(email);
                        mailObject.setSubject(SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.mail.your.details.changed.topic"));
                        mailObject.setBody(this.getChangeMailForMailOTPToGroup(changedUser, user));
                        SecSignIDStaticAccessor.getMailConfigurationService().getMailServer().send(mailObject);
                    }
                }
            }
        }
        catch (DirectoryNotFoundException e) {
            logger.error("DirectoryNotFoundException on mailActivateMailOTPToInformGroup");
        }
        catch (OperationFailedException e) {
            logger.error("OperationFailedException on mailActivateMailOTPToInformGroup");
        }
        catch (com.atlassian.crowd.exception.runtime.UserNotFoundException e) {
            logger.error("UserNotFoundException on mailActivateMailOTPToInformGroup");
        }
        catch (MailException e) {
            logger.error("MailException on mailActivateMailOTPToInformGroup: " + e.getLocalizedMessage());
        }
        catch (UnauthorisedException e) {
            logger.error("UnauthorisedException on mailActivateMailOTPToInformGroup: " + e.getLocalizedMessage());
        }
        catch (NotFoundException e) {
            logger.error("NotFoundException on mailActivateMailOTPToInformGroup: " + e.getLocalizedMessage());
        }
    }

    @Override
    public void mailChangeSettingToInformGroup(String settingName, String newValue, String oldValue, String changedByUserKey, long changedByDirid) {
        try {
            User changedBy = this.getUserForKey(changedByUserKey, changedByDirid);
            String informGroupString = SecSignIDCommonStaticAccessor.getInformGroup();
            if (informGroupString != null && !informGroupString.equals("")) {
                String[] mappingKeysToInform;
                for (String mappingKey : mappingKeysToInform = informGroupString.split(",")) {
                    String groupname = SecSignIDMappingUtils.getGroupNameFromGroupMappingKey(mappingKey);
                    long diridToInform = SecSignIDMappingUtils.getDirIDFromGroupMappingKey(mappingKey);
                    Collection<String> usernames = this.findGroupMembersUsernames(diridToInform, groupname);
                    for (String userNameToInform : usernames) {
                        User user = this.getUserForKey(userNameToInform, diridToInform);
                        String email = user.getEmailAddress();
                        Email mailObject = new Email(email);
                        mailObject.setSubject(SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.mail.settings.changed.topic"));
                        mailObject.setBody(this.getChangeMailForChangeSettingsToGroup(changedBy, user, settingName, newValue, oldValue));
                        SecSignIDStaticAccessor.getMailConfigurationService().getMailServer().send(mailObject);
                    }
                }
            }
        }
        catch (DirectoryNotFoundException e) {
            logger.error("DirectoryNotFoundException on mailChangeSettingToInformGroup");
        }
        catch (OperationFailedException e) {
            logger.error("OperationFailedException on mailChangeSettingToInformGroup");
        }
        catch (com.atlassian.crowd.exception.runtime.UserNotFoundException e) {
            logger.error("UserNotFoundException on mailChangeSettingToInformGroup");
        }
        catch (MailException e) {
            logger.error("MailException on mailChangeSettingToInformGroup: " + e.getLocalizedMessage());
        }
        catch (UnauthorisedException e) {
            logger.error("UnauthorisedException on mailChangeSettingToInformGroup: " + e.getLocalizedMessage());
        }
        catch (NotFoundException e) {
            logger.error("NotFoundException on mailChangeSettingToInformGroup: " + e.getLocalizedMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void changeToOneAttribute() throws OperationFailedException, InvalidAuthenticationException, ApplicationPermissionException, DirectoryPermissionException {
        if (SecSignIDCommonStaticAccessor.isSynchronizable()) {
            List<Directory> dirs = this.getAllDirectories();
            for (Directory directory : dirs) {
                Object restriction2;
                TermRestriction restriction1;
                CrowdClient client;
                try {
                    List<String> fixedGroups;
                    block33: {
                        HashSet allGroupsWithAttributes = new HashSet();
                        if (directory.getType().equals((Object)DirectoryType.CROWD)) {
                            client = this.getCrowdClientForDir(directory);
                            if (client != null) {
                                restriction1 = new TermRestriction(PropertyUtils.ofTypeString((String)"pwdallowed"), MatchMode.CONTAINS, (Object)"");
                                restriction2 = new TermRestriction(PropertyUtils.ofTypeString((String)"passwordlessallowed"), MatchMode.CONTAINS, (Object)"");
                                TermRestriction restriction3 = new TermRestriction(PropertyUtils.ofTypeString((String)"twostepallowed"), MatchMode.CONTAINS, (Object)"");
                                TermRestriction restriction4 = new TermRestriction(PropertyUtils.ofTypeString((String)"mailotpallowed"), MatchMode.CONTAINS, (Object)"");
                                TermRestriction restriction5 = new TermRestriction(PropertyUtils.ofTypeString((String)"totpallowed"), MatchMode.CONTAINS, (Object)"");
                                allGroupsWithAttributes.addAll(client.searchGroupNames((SearchRestriction)restriction1, 0, -1));
                                allGroupsWithAttributes.addAll(client.searchGroupNames((SearchRestriction)restriction2, 0, -1));
                                allGroupsWithAttributes.addAll(client.searchGroupNames((SearchRestriction)restriction3, 0, -1));
                                allGroupsWithAttributes.addAll(client.searchGroupNames((SearchRestriction)restriction4, 0, -1));
                                allGroupsWithAttributes.addAll(client.searchGroupNames((SearchRestriction)restriction5, 0, -1));
                                ArrayList<String> arrayList = new ArrayList<String>(allGroupsWithAttributes);
                                fixedGroups = SecSignIDMappingUtils.fixGroupListForDirIDAndEscape(arrayList, directory.getId());
                                for (String groupMappingKey : fixedGroups) {
                                    String groupname = SecSignIDMappingUtils.getGroupNameFromGroupMappingKey(groupMappingKey);
                                    com.atlassian.crowd.model.group.GroupWithAttributes groupWithAttributes = client.getGroupWithAttributes(groupname);
                                    String value = groupWithAttributes.getValue("secsign.twofa");
                                    if (value == null || value.equals("")) continue;
                                    fixedGroups.remove(groupMappingKey);
                                }
                                break block33;
                            } else {
                                logger.debug("No CrowdClient created, so cannot get mapping");
                                continue;
                            }
                        }
                        if (directory.getType().equals((Object)DirectoryType.INTERNAL)) {
                            EntityQuery query1 = QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.group()).with((SearchRestriction)Restriction.on((Property)PropertyUtils.ofTypeString((String)"pwdallowed")).containing((Object)"")).startingAt(0).returningAtMost(-1);
                            EntityQuery query2 = QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.group()).with((SearchRestriction)Restriction.on((Property)PropertyUtils.ofTypeString((String)"passwordlessallowed")).containing((Object)"")).startingAt(0).returningAtMost(-1);
                            EntityQuery query3 = QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.group()).with((SearchRestriction)Restriction.on((Property)PropertyUtils.ofTypeString((String)"twostepallowed")).containing((Object)"")).startingAt(0).returningAtMost(-1);
                            EntityQuery query4 = QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.group()).with((SearchRestriction)Restriction.on((Property)PropertyUtils.ofTypeString((String)"mailotpallowed")).containing((Object)"")).startingAt(0).returningAtMost(-1);
                            EntityQuery query5 = QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.group()).with((SearchRestriction)Restriction.on((Property)PropertyUtils.ofTypeString((String)"totpallowed")).containing((Object)"")).startingAt(0).returningAtMost(-1);
                            allGroupsWithAttributes.addAll(SecSignIDStaticAccessor.getDirectoryManager().searchGroups(directory.getId().longValue(), query1));
                            allGroupsWithAttributes.addAll(SecSignIDStaticAccessor.getDirectoryManager().searchGroups(directory.getId().longValue(), query2));
                            allGroupsWithAttributes.addAll(SecSignIDStaticAccessor.getDirectoryManager().searchGroups(directory.getId().longValue(), query3));
                            allGroupsWithAttributes.addAll(SecSignIDStaticAccessor.getDirectoryManager().searchGroups(directory.getId().longValue(), query4));
                            allGroupsWithAttributes.addAll(SecSignIDStaticAccessor.getDirectoryManager().searchGroups(directory.getId().longValue(), query5));
                            ArrayList<String> arrayList = new ArrayList<String>(allGroupsWithAttributes);
                            fixedGroups = SecSignIDMappingUtils.fixGroupListForDirIDAndEscape(arrayList, directory.getId());
                            for (String groupMappingKey : fixedGroups) {
                                String groupname = SecSignIDMappingUtils.getGroupNameFromGroupMappingKey(groupMappingKey);
                                long dirid = SecSignIDMappingUtils.getDirIDFromGroupMappingKey(groupMappingKey);
                                com.atlassian.crowd.model.group.GroupWithAttributes groupWithAttributes = SecSignIDStaticAccessor.getDirectoryManager().findGroupWithAttributesByName(dirid, groupname);
                                String value = groupWithAttributes.getValue("secsign.twofa");
                                if (value == null || value.equals("")) continue;
                                fixedGroups.remove(groupMappingKey);
                            }
                        } else {
                            logger.debug("Dir is not Crowd nor internal, so cannot get mapping");
                            continue;
                        }
                    }
                    HashMap<String, String> pwdlessMappings = this.getPasswordlessGroupMappings(fixedGroups);
                    HashMap<String, String> twostepMappings = this.getTwoStepGroupMappings(fixedGroups);
                    HashMap<String, String> mailotpMappings = this.getMailOTPGroupMappings(fixedGroups);
                    HashMap<String, String> totpMappings = this.getTOTPGroupMappings(fixedGroups);
                    for (String groupMappingKey : fixedGroups) {
                        try {
                            boolean pwdless = pwdlessMappings.get(groupMappingKey).equals("activate");
                            boolean twoStep = twostepMappings.get(groupMappingKey).equals("activate");
                            boolean mailOTP = mailotpMappings.get(groupMappingKey).equals("activate");
                            boolean totp = ((String)totpMappings.get(groupMappingKey)).equals("activate");
                            SecSignID2FASettings settings = new SecSignID2FASettings();
                            if (pwdless) {
                                settings.setPasswordlessAllowed(SecSignIDCommonConstants.AuthIsAllowed);
                            }
                            if (twoStep) {
                                settings.setTwoStepAllowed(SecSignIDCommonConstants.AuthIsAllowed);
                            }
                            if (mailOTP) {
                                settings.setMailOtpAllowed(SecSignIDCommonConstants.AuthIsAllowed);
                            }
                            if (totp) {
                                settings.setTotpAllowed(SecSignIDCommonConstants.AuthIsAllowed);
                            }
                            HashMap<String, SecSignID2FASettings> mappingToSave = new HashMap<String, SecSignID2FASettings>();
                            mappingToSave.put(groupMappingKey, settings);
                            this.save2FAGroupMappings(mappingToSave);
                        }
                        catch (GroupNotFoundException e) {
                            logger.error("GroupNotFoundException on save2FAGroupMappings in changeToOneAttribute for group: " + groupMappingKey);
                        }
                    }
                }
                catch (DirectoryNotFoundException e) {
                    logger.error("DirectoryNotFoundException on save2FAGroupMappings in changeToOneAttribute for dir: " + directory.getId());
                }
                catch (GroupNotFoundException e) {
                    logger.error("GroupNotFoundException on save2FAGroupMappings in changeToOneAttribute for dir: " + directory.getId());
                }
                try {
                    HashSet allUserWithActivated;
                    block34: {
                        allUserWithActivated = new HashSet();
                        if (directory.getType().equals((Object)DirectoryType.CROWD)) {
                            client = this.getCrowdClientForDir(directory);
                            if (client != null) {
                                restriction1 = new TermRestriction(PropertyUtils.ofTypeString((String)"mailotpactive"), MatchMode.CONTAINS, (Object)"");
                                restriction2 = new TermRestriction(PropertyUtils.ofTypeString((String)"usedtotpbefore"), MatchMode.CONTAINS, (Object)"");
                                allUserWithActivated.addAll(client.searchUsers((SearchRestriction)restriction1, 0, -1));
                                allUserWithActivated.addAll(client.searchUsers((SearchRestriction)restriction2, 0, -1));
                                for (User user : allUserWithActivated) {
                                    UserWithAttributes userWithAttributes = client.getUserWithAttributes(user.getName());
                                    String value = userWithAttributes.getValue("secsign.activated");
                                    if (value == null || value.equals("")) continue;
                                    allUserWithActivated.remove(user);
                                }
                                break block34;
                            } else {
                                logger.debug("No CrowdClient created, so cannot get mapping");
                                continue;
                            }
                        }
                        if (directory.getType().equals((Object)DirectoryType.INTERNAL)) {
                            EntityQuery queryForUser1 = QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user()).with((SearchRestriction)Restriction.on((Property)PropertyUtils.ofTypeString((String)"mailotpactive")).containing((Object)"")).startingAt(0).returningAtMost(-1);
                            EntityQuery queryForUser2 = QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user()).with((SearchRestriction)Restriction.on((Property)PropertyUtils.ofTypeString((String)"usedtotpbefore")).containing((Object)"")).startingAt(0).returningAtMost(-1);
                            allUserWithActivated.addAll(SecSignIDStaticAccessor.getDirectoryManager().searchUsers(directory.getId().longValue(), queryForUser1));
                            allUserWithActivated.addAll(SecSignIDStaticAccessor.getDirectoryManager().searchUsers(directory.getId().longValue(), queryForUser2));
                            for (User user : allUserWithActivated) {
                                UserWithAttributes userWithAttributes = SecSignIDStaticAccessor.getDirectoryManager().findUserWithAttributesByName(directory.getId().longValue(), user.getName());
                                String value = userWithAttributes.getValue("secsign.activated");
                                if (value == null || value.equals("")) continue;
                                allUserWithActivated.remove(user);
                            }
                        } else {
                            logger.debug("Dir is not Crowd nor internal, so cannot get mapping");
                            continue;
                        }
                    }
                    for (User user : allUserWithActivated) {
                        boolean mailOTPActive = SecSignIDMappingExtractor.getMailOTPActiveForUserKey(this.getUserKeyForUsername(user.getName()), directory.getId());
                        boolean totpActive = SecSignIDMappingExtractor.getTOTPActiveForUserKey(this.getUserKeyForUsername(user.getName()), directory.getId());
                        String secsignid = this.getSecSignIdStringForApplicationUserKey(user.getName(), user.getDirectoryId());
                        SecSignID2FAActivatedSettings activatedsettings = new SecSignID2FAActivatedSettings();
                        if (secsignid != null && !secsignid.equals("")) {
                            activatedsettings.setTwoStepActive(true);
                        }
                        if (mailOTPActive) {
                            activatedsettings.setMailOtpActive(true);
                        }
                        if (totpActive) {
                            activatedsettings.setTotpActive(true);
                        }
                        this.save2FAActivatedSettingsForUserKey(this.getUserKeyForUsername(user.getName()), directory.getId(), activatedsettings);
                    }
                }
                catch (DirectoryNotFoundException e) {
                    logger.error("DirectoryNotFoundException on updating ActivatedSettings");
                }
                catch (UserNotFoundException e) {
                    logger.error("UserNotFoundException on updating ActivatedSettings");
                }
            }
        }
    }

    @Override
    public DirectoryManager getDirectoryManager() {
        return SecSignIDStaticAccessor.getDirectoryManager();
    }

    @Override
    public Directory getDirectory(long dirid) throws OperationFailedException, DirectoryNotFoundException {
        return SecSignIDStaticAccessor.getDirectoryManager().findDirectoryById(dirid);
    }

    @Override
    public void storeUserAttributes(long dirid, String userKey, HashMap<String, Set<String>> attrMap) throws DirectoryPermissionException, OperationFailedException, UserNotFoundException, DirectoryNotFoundException, InvalidAuthenticationException, ApplicationPermissionException {
        Directory directory = this.getDirectory(dirid);
        if (directory.getType().equals((Object)DirectoryType.CROWD)) {
            CrowdClient client = this.getCrowdClientForDir(directory);
            client.storeUserAttributes(userKey, attrMap);
        } else if (directory.getType().equals((Object)DirectoryType.INTERNAL)) {
            SecSignIDStaticAccessor.getDirectoryManager().storeUserAttributes(dirid, userKey, attrMap);
        }
    }

    @Override
    public void removeUserAttributes(long dirid, String userKey, String attributeKey) throws com.atlassian.crowd.exception.runtime.UserNotFoundException, com.atlassian.crowd.exception.runtime.UserNotFoundException, DirectoryNotFoundException, DirectoryPermissionException, OperationFailedException, InvalidAuthenticationException, ApplicationPermissionException, UserNotFoundException {
        Directory directory = this.getDirectory(dirid);
        if (directory.getType().equals((Object)DirectoryType.CROWD)) {
            CrowdClient client = this.getCrowdClientForDir(directory);
            client.removeUserAttributes(userKey, attributeKey);
        } else if (directory.getType().equals((Object)DirectoryType.INTERNAL)) {
            SecSignIDStaticAccessor.getDirectoryManager().removeUserAttributes(dirid, userKey, attributeKey);
        }
    }

    @Override
    public List<User> searchUsers(long dirid, EntityQuery<User> query) throws OperationFailedException, DirectoryNotFoundException, InvalidAuthenticationException, ApplicationPermissionException {
        Directory directory = this.getDirectory(dirid);
        if (directory.getType().equals((Object)DirectoryType.CROWD)) {
            CrowdClient client = this.getCrowdClientForDir(directory);
            List modelUsers = client.searchUsers(query.getSearchRestriction(), 0, -1);
            return ConversionUtils.toEmbeddedUsers((List)modelUsers);
        }
        if (directory.getType().equals((Object)DirectoryType.INTERNAL)) {
            return SecSignIDStaticAccessor.getDirectoryManager().searchUsers(dirid, query);
        }
        return Collections.emptyList();
    }

    @Override
    public List<String> searchUserStrings(long dirid, EntityQuery<String> query) throws OperationFailedException, DirectoryNotFoundException, InvalidAuthenticationException, ApplicationPermissionException {
        Directory directory = this.getDirectory(dirid);
        if (directory.getType().equals((Object)DirectoryType.CROWD)) {
            CrowdClient client = this.getCrowdClientForDir(directory);
            return client.searchUserNames(query.getSearchRestriction(), 0, -1);
        }
        if (directory.getType().equals((Object)DirectoryType.INTERNAL)) {
            return SecSignIDStaticAccessor.getDirectoryManager().searchGroups(dirid, query);
        }
        return Collections.emptyList();
    }

    @Override
    public List<String> searchGroups(long dirid, EntityQuery<String> query) throws OperationFailedException, DirectoryNotFoundException, InvalidAuthenticationException, ApplicationPermissionException {
        Directory directory = this.getDirectory(dirid);
        if (directory.getType().equals((Object)DirectoryType.CROWD)) {
            CrowdClient client = this.getCrowdClientForDir(directory);
            return client.searchGroupNames(query.getSearchRestriction(), 0, -1);
        }
        if (directory.getType().equals((Object)DirectoryType.INTERNAL)) {
            return SecSignIDStaticAccessor.getDirectoryManager().searchGroups(dirid, query);
        }
        return Collections.emptyList();
    }

    @Override
    public GroupWithAttributes findGroupWithAttributesByName(long dirid, String groupName) throws GroupNotFoundException, DirectoryNotFoundException, OperationFailedException, InvalidAuthenticationException, ApplicationPermissionException {
        Directory directory = this.getDirectory(dirid);
        if (directory.getType().equals((Object)DirectoryType.CROWD)) {
            CrowdClient client = this.getCrowdClientForDir(directory);
            return ConversionUtils.toEmbeddedGroupWithAttributes((com.atlassian.crowd.model.group.GroupWithAttributes)client.getGroupWithAttributes(groupName));
        }
        if (directory.getType().equals((Object)DirectoryType.INTERNAL)) {
            return ConversionUtils.toEmbeddedGroupWithAttributes((com.atlassian.crowd.model.group.GroupWithAttributes)SecSignIDStaticAccessor.getDirectoryManager().findGroupWithAttributesByName(dirid, groupName));
        }
        return null;
    }

    @Override
    public void storeGroupAttributes(long dirid, String groupName, HashMap<String, Set<String>> attrMap) throws DirectoryPermissionException, OperationFailedException, GroupNotFoundException, DirectoryNotFoundException, InvalidAuthenticationException, ApplicationPermissionException {
        Directory directory = this.getDirectory(dirid);
        if (directory.getType().equals((Object)DirectoryType.CROWD)) {
            CrowdClient client = this.getCrowdClientForDir(directory);
            client.storeGroupAttributes(groupName, attrMap);
        } else if (directory.getType().equals((Object)DirectoryType.INTERNAL)) {
            SecSignIDStaticAccessor.getDirectoryManager().storeGroupAttributes(dirid, groupName, attrMap);
        }
    }

    @Override
    public void removeGroupAttributes(long dirid, String groupName, String attributeKey) throws DirectoryPermissionException, OperationFailedException, GroupNotFoundException, DirectoryNotFoundException, InvalidAuthenticationException, ApplicationPermissionException {
        Directory directory = this.getDirectory(dirid);
        if (directory.getType().equals((Object)DirectoryType.CROWD)) {
            CrowdClient client = this.getCrowdClientForDir(directory);
            client.removeGroupAttributes(groupName, attributeKey);
        } else if (directory.getType().equals((Object)DirectoryType.INTERNAL)) {
            SecSignIDStaticAccessor.getDirectoryManager().removeGroupAttributes(dirid, groupName, attributeKey);
        }
    }

    @Override
    public void resetAllFIDO() throws DirectoryNotFoundException, OperationFailedException, InvalidAuthenticationException, ApplicationPermissionException {
        if (SecSignIDCommonStaticAccessor.isSynchronizable()) {
            SecSignIDMappingExtractor.resetAllFIDO();
        } else {
            SecSignIDUsersActiveObject.resetAllFIDO();
        }
    }

    @Override
    public CrowdClient getCrowdClientForDir(Directory dir) {
        String applicationName = dir.getValue("application.name");
        String applicationPassword = dir.getValue("application.password");
        String crowdURL = dir.getValue("crowd.server.url");
        logger.debug("Application Name for Crowd is: " + applicationName);
        logger.debug("Crowd Url for Crowd is: " + crowdURL);
        if (applicationName != null && applicationPassword != null && crowdURL != null) {
            logger.debug("Try to create CrowdClient");
            CrowdClient client = new RestCrowdClientFactory().newInstance(crowdURL, applicationName, applicationPassword);
            logger.debug("CrowdClient created");
            return client;
        }
        logger.error("One mandatory field for CrowdClient is null -> not create Client");
        return null;
    }

    @Deprecated
    private HashMap<String, String> getTOTPGroupMappings(List<String> groupNames) throws OperationFailedException, InvalidAuthenticationException, ApplicationPermissionException {
        HashMap<String, String> result = new HashMap<String, String>();
        for (String string : groupNames) {
            String groupname = SecSignIDMappingUtils.getGroupNameFromGroupMappingKey(string);
            long dirid = SecSignIDMappingUtils.getDirIDFromGroupMappingKey(string);
            if (!SecSignIDCommonStaticAccessor.isSynchronizable()) continue;
            result.putAll(SecSignIDMappingExtractor.getTOTPMappingsForGroup(groupname, dirid));
        }
        return result;
    }

    @Deprecated
    private HashMap<String, String> getMailOTPGroupMappings(List<String> groupNames) throws OperationFailedException, InvalidAuthenticationException, ApplicationPermissionException {
        HashMap<String, String> result = new HashMap<String, String>();
        for (String string : groupNames) {
            String groupname = SecSignIDMappingUtils.getGroupNameFromGroupMappingKey(string);
            long dirid = SecSignIDMappingUtils.getDirIDFromGroupMappingKey(string);
            if (!SecSignIDCommonStaticAccessor.isSynchronizable()) continue;
            result.putAll(SecSignIDMappingExtractor.getMailOTPMappingsForGroup(groupname, dirid));
        }
        return result;
    }

    @Deprecated
    private HashMap<String, String> getTwoStepGroupMappings(List<String> groupNames) throws OperationFailedException, InvalidAuthenticationException, ApplicationPermissionException {
        HashMap<String, String> result = new HashMap<String, String>();
        for (String string : groupNames) {
            String groupname = SecSignIDMappingUtils.getGroupNameFromGroupMappingKey(string);
            long dirid = SecSignIDMappingUtils.getDirIDFromGroupMappingKey(string);
            if (!SecSignIDCommonStaticAccessor.isSynchronizable()) continue;
            result.putAll(SecSignIDMappingExtractor.getTwoStepMappingsForGroup(groupname, dirid));
        }
        return result;
    }

    @Deprecated
    private HashMap<String, String> getPasswordlessGroupMappings(List<String> groupNames) throws OperationFailedException, InvalidAuthenticationException, ApplicationPermissionException {
        HashMap<String, String> result = new HashMap<String, String>();
        for (String string : groupNames) {
            String groupname = SecSignIDMappingUtils.getGroupNameFromGroupMappingKey(string);
            long dirid = SecSignIDMappingUtils.getDirIDFromGroupMappingKey(string);
            if (!SecSignIDCommonStaticAccessor.isSynchronizable()) continue;
            result.putAll(SecSignIDMappingExtractor.getPasswordlessMappingsForGroup(groupname, dirid));
        }
        return result;
    }

    private HashMap<String, SecSignID2FASettings> get2FAGroupMappings(List<String> groupNames) throws OperationFailedException, InvalidAuthenticationException, ApplicationPermissionException {
        HashMap<String, SecSignID2FASettings> result = new HashMap<String, SecSignID2FASettings>();
        for (String string : groupNames) {
            String groupname = SecSignIDMappingUtils.getGroupNameFromGroupMappingKey(string);
            long dirid = SecSignIDMappingUtils.getDirIDFromGroupMappingKey(string);
            if (SecSignIDCommonStaticAccessor.isSynchronizable()) {
                result.putAll(SecSignIDMappingExtractor.get2FAGroupMappingsForGroup(groupname, dirid));
                continue;
            }
            result.putAll(SecSignIDUsersActiveObject.get2FAGroupMappingsForGroup(groupname, dirid));
        }
        return result;
    }

    @Override
    public void sendRedirectForNotAuthed(HttpServletRequest httpServletReq, HttpServletResponse httpServletResp) throws IOException {
        String returnURL = httpServletReq.getRequestURI();
        returnURL = returnURL.replace(httpServletReq.getContextPath(), "");
        httpServletResp.sendRedirect(this.getBaseUrl() + "/plugins/servlet/secsignid" + "?" + "returnUrl" + "=" + returnURL);
    }

    @Override
    public void addUserToPasswordless(String userKey, long dirid) throws com.atlassian.crowd.exception.runtime.UserNotFoundException, GroupNotFoundException, DirectoryPermissionException, DirectoryNotFoundException, OperationFailedException, ReadOnlyGroupException, UserNotFoundException {
        User user = this.getUserForKey(userKey, dirid);
        try {
            SecSignIDStaticAccessor.getDirectoryManager().addUserToGroup(user.getDirectoryId(), user.getName(), "PasswordlessAllowed");
        }
        catch (MembershipAlreadyExistsException membershipAlreadyExistsException) {
            // empty catch block
        }
    }

    @Override
    public void addUserToTwoStep(String userKey, long dirid) throws com.atlassian.crowd.exception.runtime.UserNotFoundException, GroupNotFoundException, DirectoryPermissionException, DirectoryNotFoundException, OperationFailedException, ReadOnlyGroupException, UserNotFoundException {
        User user = this.getUserForKey(userKey, dirid);
        try {
            SecSignIDStaticAccessor.getDirectoryManager().addUserToGroup(user.getDirectoryId(), user.getName(), "2SASecSignIDAllowed");
        }
        catch (MembershipAlreadyExistsException membershipAlreadyExistsException) {
            // empty catch block
        }
    }

    @Override
    public void addUserToMailOTP(String userKey, long dirid) throws com.atlassian.crowd.exception.runtime.UserNotFoundException, GroupNotFoundException, DirectoryPermissionException, DirectoryNotFoundException, OperationFailedException, ReadOnlyGroupException, UserNotFoundException {
        User user = this.getUserForKey(userKey, dirid);
        try {
            SecSignIDStaticAccessor.getDirectoryManager().addUserToGroup(user.getDirectoryId(), user.getName(), "2SAMailOTPAllowed");
        }
        catch (MembershipAlreadyExistsException membershipAlreadyExistsException) {
            // empty catch block
        }
    }

    @Override
    public void addUserToTOTP(String userKey, long dirid) throws com.atlassian.crowd.exception.runtime.UserNotFoundException, GroupNotFoundException, DirectoryPermissionException, DirectoryNotFoundException, OperationFailedException, ReadOnlyGroupException, UserNotFoundException {
        User user = this.getUserForKey(userKey, dirid);
        try {
            SecSignIDStaticAccessor.getDirectoryManager().addUserToGroup(user.getDirectoryId(), user.getName(), "2SATOTPAllowed");
        }
        catch (MembershipAlreadyExistsException membershipAlreadyExistsException) {
            // empty catch block
        }
    }

    @Override
    public void addUserToFIDO(String userKey, long dirid) throws com.atlassian.crowd.exception.runtime.UserNotFoundException, GroupNotFoundException, DirectoryPermissionException, DirectoryNotFoundException, OperationFailedException, ReadOnlyGroupException, UserNotFoundException {
        User user = this.getUserForKey(userKey, dirid);
        try {
            SecSignIDStaticAccessor.getDirectoryManager().addUserToGroup(user.getDirectoryId(), user.getName(), "2SAFIDOAllowed");
        }
        catch (MembershipAlreadyExistsException membershipAlreadyExistsException) {
            // empty catch block
        }
    }

    @Override
    public String getGroupLinkToAdd(String groupName, long dirid) {
        return this.getBaseUrl() + "/admin/group/editGroup.action?groupName=" + groupName;
    }

    @Override
    public List<User> searchUsers(EntityQuery<User> query) throws OperationFailedException, DirectoryNotFoundException, InvalidAuthenticationException, ApplicationPermissionException {
        ArrayList<User> result = new ArrayList<User>();
        List<Directory> dirs = this.getAllDirectories();
        for (Directory dir : dirs) {
            Directory directory = this.getDirectory(dir.getId());
            if (directory.getType().equals((Object)DirectoryType.CROWD)) {
                CrowdClient client = this.getCrowdClientForDir(directory);
                List modelUsers = client.searchUsers(query.getSearchRestriction(), 0, -1);
                result.addAll(ConversionUtils.toEmbeddedUsers((List)modelUsers));
                continue;
            }
            if (!directory.getType().equals((Object)DirectoryType.INTERNAL)) continue;
            result.addAll(SecSignIDStaticAccessor.getDirectoryManager().searchUsers(dir.getId().longValue(), query));
        }
        return result;
    }

    @Override
    public String getUPMLink() {
        return this.getBaseUrl() + "/plugins/servlet/upm";
    }

    @Override
    public boolean checkGroupExists(String groupName, long dirid) throws OperationFailedException {
        try {
            SecSignIDStaticAccessor.getDirectoryManager().findGroupByName(dirid, groupName);
            return true;
        }
        catch (GroupNotFoundException e) {
            return false;
        }
        catch (DirectoryNotFoundException e) {
            return false;
        }
    }

    @Override
    public void addUserToGroup(String username, String groupName) throws UserNotFoundException, GroupNotFoundException, DirectoryPermissionException, DirectoryNotFoundException, OperationFailedException, ReadOnlyGroupException {
        String userKey = this.getUserKeyForUsername(username);
        User user = this.getUserForKeyFirst(userKey);
        try {
            SecSignIDStaticAccessor.getDirectoryManager().addUserToGroup(user.getDirectoryId(), user.getName(), groupName);
        }
        catch (MembershipAlreadyExistsException membershipAlreadyExistsException) {
            // empty catch block
        }
    }

    @Override
    protected Set<String> getUsernamesForGroupname(String groupToAdd) throws DirectoryNotFoundException, OperationFailedException {
        LinkedHashSet<String> _searchUsersSet = new LinkedHashSet<String>();
        if (groupToAdd.contains(";")) {
            String group = SecSignIDMappingUtils.getGroupNameFromGroupMappingKey(groupToAdd);
            long dirid = SecSignIDMappingUtils.getDirIDFromGroupMappingKey(groupToAdd);
            _searchUsersSet.addAll(this.findGroupMembersUsernames(dirid, group));
            return _searchUsersSet;
        }
        List<Directory> directories = this.getAllDirectories();
        for (Directory dir : directories) {
            _searchUsersSet.addAll(this.findGroupMembersUsernames(dir.getId(), groupToAdd));
        }
        return _searchUsersSet;
    }

    @Override
    public String getUserNameForProfile(Map<String, Object> context) {
        return (String)context.get("name");
    }

    @Override
    public void changeToDirID() {
        final ActiveObjects ao = SecSignIDStaticAccessor.getActiveObjects();
        HashMap secSignIdMappings = new HashMap();
        logger.debug("changeToDirID in ActiveObjects called");
        if (ao != null) {
            ao.executeInTransaction((TransactionCallback)new TransactionCallback<SecSignIDUsers>(){

                public SecSignIDUsers doInTransaction() {
                    for (SecSignIDUsers secSignIdUserPair : (SecSignIDUsers[])ao.find(SecSignIDUsers.class)) {
                        User user;
                        String key = secSignIdUserPair.getBambooUserName();
                        logger.debug("Found secsign mapping with username " + key);
                        if (key.contains(":")) continue;
                        logger.debug("Change mapping with username " + key);
                        try {
                            user = SecSignIDDataAccessor.this.getUserForKeyFirst(key);
                        }
                        catch (OperationFailedException e) {
                            continue;
                        }
                        if (user != null) {
                            String mappingKey = SecSignIDDataAccessor.this.getUserKeyForUsername(user.getName()) + ":" + user.getDirectoryId();
                            logger.debug("New mapping key for user is " + mappingKey);
                            secSignIdUserPair.setBambooUserName(mappingKey);
                            secSignIdUserPair.save();
                            continue;
                        }
                        logger.debug("Mapping deleted for user " + key);
                        ao.delete(new RawEntity[]{secSignIdUserPair});
                    }
                    return null;
                }
            });
            ao.executeInTransaction((TransactionCallback)new TransactionCallback<SecSignIDGroup>(){

                public SecSignIDGroup doInTransaction() {
                    block4: for (SecSignIDGroup secSignIDGroup : (SecSignIDGroup[])ao.find(SecSignIDGroup.class)) {
                        String key = secSignIDGroup.getGroupName();
                        logger.debug("Found group mapping with groupname " + key);
                        if (key.contains(";")) continue;
                        logger.debug("Change mapping with groupname " + key);
                        List dirs = SecSignIDStaticAccessor.getDirectoryManager().findAllDirectories();
                        for (Directory directory : dirs) {
                            try {
                                Group group = SecSignIDStaticAccessor.getDirectoryManager().findGroupByName(directory.getId().longValue(), key);
                                logger.debug("New mapping key for group is  " + group.getName().toLowerCase().replace(" ", "___") + ";" + group.getDirectoryId());
                                secSignIDGroup.setGroupName(group.getName().toLowerCase().replace(" ", "___") + ";" + group.getDirectoryId());
                                secSignIDGroup.save();
                                continue block4;
                            }
                            catch (GroupNotFoundException e) {
                            }
                            catch (DirectoryNotFoundException e) {
                            }
                            catch (OperationFailedException e) {
                                logger.error("OperationFailedException on changeToDirID");
                            }
                        }
                    }
                    return null;
                }
            });
        }
        logger.debug("Change done");
    }

    @Override
    public void checkGroupsCreated() {
        List<Directory> dirs = this.getAllDirectories();
        for (Directory directory : dirs) {
            try {
                SecSignIDStaticAccessor.getDirectoryManager().findGroupByName(directory.getId().longValue(), "PasswordlessAllowed");
                SecSignIDStaticAccessor.getDirectoryManager().findGroupByName(directory.getId().longValue(), "2SAFIDOAllowed");
                SecSignIDStaticAccessor.getDirectoryManager().findGroupByName(directory.getId().longValue(), "2SAMailOTPAllowed");
                SecSignIDStaticAccessor.getDirectoryManager().findGroupByName(directory.getId().longValue(), "2SATOTPAllowed");
                SecSignIDStaticAccessor.getDirectoryManager().findGroupByName(directory.getId().longValue(), "2SASecSignIDAllowed");
            }
            catch (GroupNotFoundException e) {
                SecSignIDCommonStaticAccessor.saveGroupsCreated(false);
                return;
            }
            catch (DirectoryNotFoundException e) {
            }
            catch (OperationFailedException e) {
                logger.error(SecSignIDCommonStaticAccessor.getStackTraceOfError((Exception)((Object)e)));
                logger.error("OperationFailedException on checkGroupsCreated for dir " + directory.getName() + " (" + directory.getId() + ")");
                SecSignIDCommonStaticAccessor.saveGroupsCreated(false);
                return;
            }
        }
        SecSignIDCommonStaticAccessor.saveGroupsCreated(true);
    }

    @Override
    public boolean logoutUser(HttpServletRequest httpServletReq, HttpServletResponse httpServletResp) {
        Authenticator authenticator = SecurityConfigFactory.getInstance().getAuthenticator();
        try {
            authenticator.logout(httpServletReq, httpServletResp);
        }
        catch (AuthenticatorException e) {
            return false;
        }
        return true;
    }

    private class SecSignIDUserPwdPair {
        final String userName;
        final String password;
        final boolean persistent;

        public SecSignIDUserPwdPair(String user, String password, boolean persistent) {
            this.userName = user;
            this.password = password;
            this.persistent = persistent;
        }

        public String toString() {
            return "(user: " + this.userName + ",pwd: " + this.password + ", pers: " + this.persistent + ")";
        }
    }
}

