/*
 * Decompiled with CFR 0.152.
 */
package com.secsign.atlassian.common.servlet;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.exception.ApplicationPermissionException;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.exception.InvalidAuthenticationException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.exception.UserNotFoundException;
import com.atlassian.crowd.manager.directory.DirectoryPermissionException;
import com.secsign.atlassian.common.accessor.SecSignIDCommonStaticAccessor;
import com.secsign.atlassian.common.data.SecSignIDTrustDeviceToken;
import com.secsign.atlassian.common.interfaces.SecSignIDDataAccessor;
import java.io.IOException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecSignIDUpdateProfileServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(SecSignIDUpdateProfileServlet.class);
    private final SecSignIDDataAccessor dataAccessor;

    public SecSignIDUpdateProfileServlet(SecSignIDDataAccessor dataAccessor) {
        this.dataAccessor = dataAccessor;
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) {
        if (request.getParameter("secsignid-trust-device-change") != null) {
            this.saveChangesForTrustDevice(request, response);
            return;
        }
    }

    private void saveChangesForTrustDevice(HttpServletRequest request, HttpServletResponse response) {
        User user = this.dataAccessor.getUserCurrentlyLoggedIn();
        if (user == null) {
            this.sendResponse(response, false);
            return;
        }
        String userKey = this.dataAccessor.getUserKeyForUsername(user.getName());
        if (userKey == null) {
            this.sendResponse(response, false);
            return;
        }
        String type = request.getParameter("type");
        if (type.equals("current")) {
            SecSignIDTrustDeviceToken token = this.getTrustDeviceTokenFromRequest(userKey, user.getDirectoryId(), request);
            if (token == null) {
                this.sendResponse(response, false);
                return;
            }
            try {
                this.dataAccessor.removeTrustDeviceToken(userKey, user.getDirectoryId(), token);
            }
            catch (UserNotFoundException e) {
                logger.error("UserNotFoundException on saveChangesForTrustDevice");
                logger.error(SecSignIDCommonStaticAccessor.getStackTraceOfError((Exception)((Object)e)));
                this.sendResponse(response, false);
                return;
            }
            catch (OperationFailedException e) {
                logger.error("OperationFailedException on saveChangesForTrustDevice");
                logger.error(SecSignIDCommonStaticAccessor.getStackTraceOfError((Exception)((Object)e)));
                this.sendResponse(response, false);
                return;
            }
            catch (DirectoryNotFoundException e) {
                logger.error("DirectoryNotFoundException on saveChangesForTrustDevice");
                logger.error(SecSignIDCommonStaticAccessor.getStackTraceOfError((Exception)((Object)e)));
                this.sendResponse(response, false);
                return;
            }
            catch (InvalidAuthenticationException e) {
                logger.error("InvalidAuthenticationException on saveChangesForTrustDevice");
                logger.error(SecSignIDCommonStaticAccessor.getStackTraceOfError((Exception)((Object)e)));
                this.sendResponse(response, false);
                return;
            }
            catch (ApplicationPermissionException e) {
                logger.error("InvalidAuthenticationException on saveChangesForTrustDevice");
                logger.error(SecSignIDCommonStaticAccessor.getStackTraceOfError((Exception)((Object)e)));
                this.sendResponse(response, false);
                return;
            }
            catch (DirectoryPermissionException e) {
                logger.error("DirectoryPermissionException on saveChangesForTrustDevice");
                logger.error(SecSignIDCommonStaticAccessor.getStackTraceOfError((Exception)((Object)e)));
                this.sendResponse(response, false);
                return;
            }
        }
        if (type.equals("all")) {
            try {
                this.dataAccessor.removeAllTrustDeviceTokens(userKey, user.getDirectoryId());
            }
            catch (UserNotFoundException e) {
                logger.error("UserNotFoundException on saveChangesForTrustDevice for all");
                logger.error(SecSignIDCommonStaticAccessor.getStackTraceOfError((Exception)((Object)e)));
                this.sendResponse(response, false);
                return;
            }
            catch (OperationFailedException e) {
                logger.error("OperationFailedException on saveChangesForTrustDevice for all");
                logger.error(SecSignIDCommonStaticAccessor.getStackTraceOfError((Exception)((Object)e)));
                this.sendResponse(response, false);
                return;
            }
            catch (DirectoryNotFoundException e) {
                logger.error("DirectoryNotFoundException on saveChangesForTrustDevice for all");
                logger.error(SecSignIDCommonStaticAccessor.getStackTraceOfError((Exception)((Object)e)));
                this.sendResponse(response, false);
                return;
            }
            catch (InvalidAuthenticationException e) {
                logger.error("InvalidAuthenticationException on saveChangesForTrustDevice for all");
                logger.error(SecSignIDCommonStaticAccessor.getStackTraceOfError((Exception)((Object)e)));
                this.sendResponse(response, false);
                return;
            }
            catch (ApplicationPermissionException e) {
                logger.error("InvalidAuthenticationException on saveChangesForTrustDevice for all");
                logger.error(SecSignIDCommonStaticAccessor.getStackTraceOfError((Exception)((Object)e)));
                this.sendResponse(response, false);
                return;
            }
            catch (DirectoryPermissionException e) {
                logger.error("DirectoryPermissionException on saveChangesForTrustDevice for all");
                logger.error(SecSignIDCommonStaticAccessor.getStackTraceOfError((Exception)((Object)e)));
                this.sendResponse(response, false);
                return;
            }
        }
        this.sendResponse(response, true);
    }

    private void sendResponse(HttpServletResponse response, boolean success) {
        try {
            JSONObject answerObject = new JSONObject();
            answerObject.put("success", success);
            response.setContentType("application/json");
            response.getWriter().write(answerObject.toString());
        }
        catch (JSONException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    private SecSignIDTrustDeviceToken getTrustDeviceTokenFromRequest(String userKey, long dirId, HttpServletRequest request) {
        Cookie[] cookies = request.getCookies();
        if (cookies == null) {
            return null;
        }
        String tokenValue = null;
        for (Cookie cookie : cookies) {
            if (!cookie.getName().equals("secsignid_trustdevicetoken_" + this.dataAccessor.getApplication().toLowerCase())) continue;
            tokenValue = cookie.getValue();
            break;
        }
        if (tokenValue == null) {
            return null;
        }
        String userAgent = request.getHeader("User-Agent");
        if (userAgent == null || userAgent.equals("")) {
            userAgent = "empty";
        }
        try {
            return this.dataAccessor.getTrustDeviceToken(userKey, dirId, tokenValue, userAgent);
        }
        catch (UserNotFoundException e) {
            logger.error("UserNotFoundException on getTrustDeviceTokenFromRequest");
            logger.error(SecSignIDCommonStaticAccessor.getStackTraceOfError((Exception)((Object)e)));
        }
        catch (OperationFailedException e) {
            logger.error("OperationFailedException on getTrustDeviceTokenFromRequest");
            logger.error(SecSignIDCommonStaticAccessor.getStackTraceOfError((Exception)((Object)e)));
        }
        catch (DirectoryNotFoundException e) {
            logger.error("DirectoryNotFoundException on getTrustDeviceTokenFromRequest");
            logger.error(SecSignIDCommonStaticAccessor.getStackTraceOfError((Exception)((Object)e)));
        }
        catch (InvalidAuthenticationException e) {
            logger.error("InvalidAuthenticationException on getTrustDeviceTokenFromRequest");
            logger.error(SecSignIDCommonStaticAccessor.getStackTraceOfError((Exception)((Object)e)));
        }
        catch (ApplicationPermissionException e) {
            logger.error("InvalidAuthenticationException on getTrustDeviceTokenFromRequest");
            logger.error(SecSignIDCommonStaticAccessor.getStackTraceOfError((Exception)((Object)e)));
        }
        catch (DirectoryPermissionException e) {
            logger.error("DirectoryPermissionException on getTrustDeviceTokenFromRequest");
            logger.error(SecSignIDCommonStaticAccessor.getStackTraceOfError((Exception)((Object)e)));
        }
        return null;
    }
}

