/*
 * Decompiled with CFR 0.152.
 */
package com.secsign.atlassian.common.rest;

import com.secsign.atlassian.common.data.SecSignIDServerVersion;
import com.secsign.atlassian.common.rest.SecSignIDRESTException;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecSignIDRESTServerInfoResponse {
    private static final Logger logger = LoggerFactory.getLogger(SecSignIDRESTServerInfoResponse.class);
    private final SecSignIDServerVersion version;

    public static SecSignIDRESTServerInfoResponse fromJson(String json) throws JSONException, SecSignIDRESTException {
        JSONObject rootObject = new JSONObject(json);
        int majorVersion = rootObject.optInt("majorVersion", -1);
        if (majorVersion == -1) {
            logger.debug("Key 'majorVersion' not found");
            throw new SecSignIDRESTException("Key 'majorVersion' not found");
        }
        int minorVersion = rootObject.optInt("minorVersion", -1);
        if (minorVersion == -1) {
            logger.debug("Key 'minorVersion' not found");
            throw new SecSignIDRESTException("Key 'minorVersion' not found");
        }
        int patchVersion = rootObject.optInt("patchVersion", -1);
        if (patchVersion == -1) {
            logger.debug("Key 'patchVersion' not found");
            throw new SecSignIDRESTException("Key 'patchVersion' not found");
        }
        SecSignIDServerVersion version = new SecSignIDServerVersion(majorVersion, minorVersion, patchVersion);
        return new SecSignIDRESTServerInfoResponse(version);
    }

    public SecSignIDRESTServerInfoResponse(SecSignIDServerVersion version) {
        this.version = version;
    }

    public SecSignIDServerVersion getVersion() {
        return this.version;
    }
}

