/*
 * Decompiled with CFR 0.152.
 */
package com.secsign.atlassian.common.rest;

import com.secsign.atlassian.common.rest.SecSignIDRESTException;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecSignIDRESTCreateAuthSessionResponse {
    private static final Logger logger = LoggerFactory.getLogger(SecSignIDRESTCreateAuthSessionResponse.class);
    public static final SecSignIDRESTCreateAuthSessionResponse FROZEN = new SecSignIDRESTCreateAuthSessionResponse(0L, null, null, true);
    private final long authSessionId;
    private final String authSessionIconData;
    private final String secSignId;
    private final boolean frozen;

    public static SecSignIDRESTCreateAuthSessionResponse fromJson(String json) throws JSONException, SecSignIDRESTException {
        JSONObject rootObject = new JSONObject(json);
        long authSessionId = rootObject.optLong("authsessionid", -1L);
        if (authSessionId == -1L) {
            logger.debug("Key 'authsessionid' not found");
            throw new SecSignIDRESTException("Key 'authsessionid' not found");
        }
        String authSessionIconData = rootObject.optString("authsessionicondata", null);
        String secSignId = rootObject.optString("secsignid", null);
        if (secSignId == null) {
            logger.debug("Key 'secsignid' not found");
            throw new SecSignIDRESTException("Key 'secsignid' not found");
        }
        return new SecSignIDRESTCreateAuthSessionResponse(authSessionId, authSessionIconData, secSignId, false);
    }

    private SecSignIDRESTCreateAuthSessionResponse(long authSessionId, String authSessionIconData, String secSignId, boolean frozen) {
        this.authSessionId = authSessionId;
        this.authSessionIconData = authSessionIconData;
        this.secSignId = secSignId;
        this.frozen = frozen;
    }

    public long getAuthSessionId() {
        return this.authSessionId;
    }

    public String getAuthSessionIconData() {
        return this.authSessionIconData;
    }

    public String getSecSignId() {
        return this.secSignId;
    }

    public boolean getFrozen() {
        return this.frozen;
    }
}

