/*
 * Decompiled with CFR 0.152.
 */
package com.secsign.atlassian.common.crypto;

import com.secsign.atlassian.common.crypto.SHA256;

public final class SHA256HMAC {
    private SHA256 sha256 = new SHA256();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getDigest(byte[] text, byte[] key) {
        int blockLen = this.sha256.getBlockLen();
        byte[] k_ipad = new byte[blockLen];
        byte[] k_opad = new byte[blockLen];
        SHA256 sHA256 = this.sha256;
        synchronized (sHA256) {
            if (key.length > blockLen) {
                this.sha256.init();
                this.sha256.update(key);
                byte[] tk = this.sha256.digest();
                key = tk;
            }
            System.arraycopy(key, 0, k_ipad, 0, key.length);
            System.arraycopy(key, 0, k_opad, 0, key.length);
            int i = 0;
            while (i < blockLen) {
                int n = i;
                k_ipad[n] = (byte)(k_ipad[n] ^ 0x36);
                int n2 = i++;
                k_opad[n2] = (byte)(k_opad[n2] ^ 0x5C);
            }
            this.sha256.init();
            this.sha256.update(k_ipad);
            this.sha256.update(text);
            byte[] digest = this.sha256.digest();
            this.sha256.init();
            this.sha256.update(k_opad);
            this.sha256.update(digest);
            byte[] ret = this.sha256.digest();
            return ret;
        }
    }

    public int getDigestLen() {
        return this.sha256.getDigestLen();
    }
}

