/*
 * Decompiled with CFR 0.152.
 */
package com.secsign.atlassian.common.crypto;

import com.secsign.atlassian.common.crypto.AES;
import java.io.IOException;
import java.io.OutputStream;

public class CBCDecryptOutputStream
extends OutputStream {
    private int blockSize;
    private byte[] outputBlock;
    private byte[] cipherTextBlock;
    private byte[] previousCipherTextBlock;
    private int cipherTextOffset = 0;
    private OutputStream outStream;
    private AES aes;
    private boolean initVectorRead = false;

    protected CBCDecryptOutputStream(OutputStream outStream, AES aes) {
        this.outStream = outStream;
        this.aes = aes;
        this.blockSize = aes.getBlockSize();
        this.outputBlock = new byte[this.blockSize];
        this.cipherTextBlock = new byte[this.blockSize];
        this.previousCipherTextBlock = new byte[this.blockSize];
        this.cipherTextOffset = 0;
    }

    @Override
    public void write(int b) throws IOException {
        this.flush();
        this.cipherTextBlock[this.cipherTextOffset] = (byte)(b & 0xFF);
        ++this.cipherTextOffset;
    }

    @Override
    public void write(byte[] b, int startOffset, int len) throws IOException {
        int bytesToCopy;
        int offset = startOffset;
        for (int bytesLeft = len; bytesLeft > 0; bytesLeft -= bytesToCopy) {
            this.flush();
            bytesToCopy = Math.min(bytesLeft, this.blockSize - this.cipherTextOffset);
            System.arraycopy(b, offset, this.cipherTextBlock, this.cipherTextOffset, bytesToCopy);
            offset += bytesToCopy;
            this.cipherTextOffset += bytesToCopy;
        }
    }

    private void close(boolean evaluatePadCount) throws IOException {
        if (this.cipherTextOffset != this.blockSize) {
            throw new IOException("CBCDecrytOutputStream can only be closed after a multiple of blockSize has been written.");
        }
        this.outputBlock = this.blockDecryptCBC(this.cipherTextBlock);
        int lastBlockSize = this.blockSize;
        if (evaluatePadCount) {
            int padCount = this.outputBlock[this.blockSize - 1] & 0xFF;
            if (padCount > this.blockSize) {
                throw new IOException("Illegal CBC pad count = " + padCount + ". Incorrect key/password?");
            }
            lastBlockSize -= padCount;
        }
        this.outStream.write(this.outputBlock, 0, lastBlockSize);
    }

    @Override
    public void close() throws IOException {
        this.close(true);
    }

    private byte[] blockDecryptCBC(byte[] ciphTextBlock) {
        byte[] paddedPlainTextBlock = new byte[this.blockSize];
        byte[] plainTextXorBlock = this.aes.blockDecrypt(ciphTextBlock);
        for (int j = 0; j < this.blockSize; ++j) {
            paddedPlainTextBlock[j] = (byte)(plainTextXorBlock[j] ^ this.previousCipherTextBlock[j]);
        }
        System.arraycopy(ciphTextBlock, 0, this.previousCipherTextBlock, 0, this.blockSize);
        return paddedPlainTextBlock;
    }

    @Override
    public void flush() throws IOException {
        if (this.cipherTextOffset >= this.blockSize) {
            if (!this.initVectorRead) {
                System.arraycopy(this.cipherTextBlock, 0, this.previousCipherTextBlock, 0, this.blockSize);
                this.initVectorRead = true;
            } else {
                this.outputBlock = this.blockDecryptCBC(this.cipherTextBlock);
                this.outStream.write(this.outputBlock);
            }
            this.cipherTextOffset = 0;
        }
    }
}

