/*
 * Decompiled with CFR 0.152.
 */
package com.secsign.atlassian.common.ao;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.exception.UserNotFoundException;
import com.atlassian.sal.api.transaction.TransactionCallback;
import com.secsign.atlassian.common.accessor.SecSignIDCommonStaticAccessor;
import com.secsign.atlassian.common.ao.SecSignFIDOG;
import com.secsign.atlassian.common.ao.SecSignIDAOWrapper;
import com.secsign.atlassian.common.ao.SecSignIDCIPs;
import com.secsign.atlassian.common.ao.SecSignIDCLoginOptions;
import com.secsign.atlassian.common.ao.SecSignIDCLoginTokens;
import com.secsign.atlassian.common.ao.SecSignIDCQR;
import com.secsign.atlassian.common.ao.SecSignIDCTrustDeviceTokens;
import com.secsign.atlassian.common.ao.SecSignIDCUsers;
import com.secsign.atlassian.common.ao.SecSignIDGPattern;
import com.secsign.atlassian.common.ao.SecSignIDGroup;
import com.secsign.atlassian.common.ao.SecSignIDSession;
import com.secsign.atlassian.common.ao.SecSignMailOTPG;
import com.secsign.atlassian.common.ao.SecSignPwdlessG;
import com.secsign.atlassian.common.ao.SecSignTOTPG;
import com.secsign.atlassian.common.ao.SecSignTwoStepG;
import com.secsign.atlassian.common.data.SecSignID2FAActivatedSettings;
import com.secsign.atlassian.common.data.SecSignID2FASettings;
import com.secsign.atlassian.common.data.SecSignIDTrustDeviceToken;
import com.secsign.atlassian.common.rest.SecSignIDRESTDevicesResponse;
import com.secsign.atlassian.common.rest.SecSignIDRESTException;
import com.secsign.atlassian.common.rest.SecSignIDServerRESTConnector;
import com.secsign.atlassian.common.util.SecSignIDCommonConstants;
import com.secsign.atlassian.common.util.SecSignIDMappingUtils;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import net.java.ao.ActiveObjectsException;
import net.java.ao.DBParam;
import net.java.ao.Query;
import net.java.ao.RawEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecSignIDUsersActiveObject {
    private static final Logger logger = LoggerFactory.getLogger(SecSignIDUsersActiveObject.class);

    public static void deleteLocalMappings() {
        final ActiveObjects ao = SecSignIDAOWrapper.getActiveObjects();
        if (ao == null) {
            return;
        }
        ao.executeInTransaction((TransactionCallback)new TransactionCallback<Boolean>(){

            public Boolean doInTransaction() {
                SecSignIDCQR[] users7;
                SecSignIDSession[] users6;
                SecSignIDCLoginTokens[] users5;
                SecSignIDCLoginOptions[] users4;
                SecSignIDCIPs[] users3;
                SecSignIDCUsers[] users2;
                for (SecSignIDCUsers secSignIDUsers : users2 = (SecSignIDCUsers[])ao.find(SecSignIDCUsers.class)) {
                    ao.delete(new RawEntity[]{secSignIDUsers});
                }
                for (SecSignIDCIPs secSignIDUsers : users3 = (SecSignIDCIPs[])ao.find(SecSignIDCIPs.class)) {
                    ao.delete(new RawEntity[]{secSignIDUsers});
                }
                for (SecSignIDCLoginOptions secSignIDUsers : users4 = (SecSignIDCLoginOptions[])ao.find(SecSignIDCLoginOptions.class)) {
                    ao.delete(new RawEntity[]{secSignIDUsers});
                }
                for (SecSignIDCLoginTokens secSignIDUsers : users5 = (SecSignIDCLoginTokens[])ao.find(SecSignIDCLoginTokens.class)) {
                    ao.delete(new RawEntity[]{secSignIDUsers});
                }
                for (SecSignIDSession secSignIDUsers : users6 = (SecSignIDSession[])ao.find(SecSignIDSession.class)) {
                    ao.delete(new RawEntity[]{secSignIDUsers});
                }
                for (SecSignIDCQR secSignIDUsers : users7 = (SecSignIDCQR[])ao.find(SecSignIDCQR.class)) {
                    ao.delete(new RawEntity[]{secSignIDUsers});
                }
                return Boolean.TRUE;
            }
        });
    }

    public static String getMappingKeyForSecSignId(String secSignId) {
        if (secSignId == null) {
            return null;
        }
        HashMap<String, String[]> mappings = SecSignIDUsersActiveObject.getMappingsContainingSecSignID(secSignId);
        try {
            logger.debug(String.format("%-15s %s   %s", "confluenceUserName", "<>", "secSignIds"));
            logger.debug(String.format("%-15s %s   %s", "------------", "  ", "----------"));
        }
        catch (IllegalArgumentException ex) {
            logger.debug("jiraUserName <> secSignIds");
        }
        for (String mappingKey : mappings.keySet()) {
            String[] secSignIds = mappings.get(mappingKey);
            try {
                logger.debug(String.format("  %-13s %s   %s", mappingKey, "<>", SecSignIDMappingUtils.getSecSignIdString(secSignIds)));
            }
            catch (IllegalArgumentException ex) {
                logger.debug(mappingKey + "<>" + SecSignIDMappingUtils.getSecSignIdString(secSignIds));
            }
            if (secSignIds == null || secSignIds.length <= 0) continue;
            for (int i = 0; i < secSignIds.length; ++i) {
                secSignIds[i] = secSignIds[i].trim();
                if (!secSignIds[i].equalsIgnoreCase(secSignId)) continue;
                return mappingKey;
            }
        }
        return null;
    }

    public static String getSecSignIdStringForApplicationUserKey(final String userKey, final long dirid) {
        final ActiveObjects ao = SecSignIDAOWrapper.getActiveObjects();
        if (ao == null) {
            logger.error("Cannot get secsign ids for an application user. AO instance is null.");
            return null;
        }
        if (userKey == null) {
            logger.error("Cannot get secsign ids for an application user. Application user name is null.");
            return null;
        }
        logger.debug("Get secsign ids for application user '" + userKey + "'");
        String secSignId = (String)ao.executeInTransaction((TransactionCallback)new TransactionCallback<String>(){

            public String doInTransaction() {
                SecSignIDCUsers secSignIdUserPair = (SecSignIDCUsers)ao.get(SecSignIDCUsers.class, (Object)(userKey + ":" + dirid));
                if (secSignIdUserPair != null) {
                    return secSignIdUserPair.getSecSignId();
                }
                return null;
            }
        });
        logger.debug("Found " + secSignId + " secsign ids for application user '" + userKey + "'");
        return secSignId;
    }

    public static Object[] checkDuplicates(String secsignid, String username, long dirid) {
        Object[] result = new Object[3];
        String duplicateUserMappingKey = SecSignIDUsersActiveObject.getMappingKeyForSecSignIdNotSame(secsignid, username, dirid);
        if (duplicateUserMappingKey != null && !duplicateUserMappingKey.equals("")) {
            int index = duplicateUserMappingKey.indexOf(":");
            String diridString = duplicateUserMappingKey.substring(index + 1);
            String userKeyFound = duplicateUserMappingKey.substring(0, index);
            result[0] = Boolean.TRUE;
            result[1] = diridString;
            result[2] = userKeyFound;
            return result;
        }
        result[0] = Boolean.FALSE;
        result[1] = null;
        return result;
    }

    public static Object[] checkDuplicates(String secsignid) {
        Object[] result = new Object[3];
        String duplicateUserMappingKey = SecSignIDUsersActiveObject.getMappingKeyForSecSignId(secsignid);
        if (duplicateUserMappingKey != null && !duplicateUserMappingKey.equals("")) {
            int index = duplicateUserMappingKey.indexOf(":");
            String diridString = duplicateUserMappingKey.substring(index + 1);
            String userKeyFound = duplicateUserMappingKey.substring(0, index);
            result[0] = Boolean.TRUE;
            result[1] = diridString;
            result[2] = userKeyFound;
            return result;
        }
        result[0] = Boolean.FALSE;
        result[1] = null;
        return result;
    }

    private static String getMappingKeyForSecSignIdNotSame(String secSignId, String userKey, long dirid) {
        if (secSignId == null) {
            return null;
        }
        HashMap<String, String[]> mappings = SecSignIDUsersActiveObject.getMappingsContainingSecSignID(secSignId);
        try {
            logger.debug(String.format("%-15s %s   %s", "jiraUserName", "<>", "secSignIds"));
            logger.debug(String.format("%-15s %s   %s", "------------", "  ", "----------"));
        }
        catch (IllegalArgumentException ex) {
            logger.debug("jiraUserName <> secSignIds");
        }
        for (String mappingKey : mappings.keySet()) {
            String[] secSignIds = mappings.get(mappingKey);
            try {
                logger.debug(String.format("  %-13s %s   %s", mappingKey, "<>", SecSignIDMappingUtils.getSecSignIdString(secSignIds)));
            }
            catch (IllegalArgumentException ex) {
                logger.debug(mappingKey + "<>" + SecSignIDMappingUtils.getSecSignIdString(secSignIds));
            }
            if (secSignIds == null || secSignIds.length <= 0) continue;
            for (int i = 0; i < secSignIds.length; ++i) {
                secSignIds[i] = secSignIds[i].trim();
                if (!secSignIds[i].equalsIgnoreCase(secSignId) || mappingKey.equals(userKey + ":" + dirid)) continue;
                return mappingKey;
            }
        }
        return null;
    }

    public static void saveSecSignIDForUserKey(final String userKey, final long dirid, final String secSignID) {
        final ActiveObjects ao = SecSignIDAOWrapper.getActiveObjects();
        if (ao == null) {
            return;
        }
        ao.executeInTransaction((TransactionCallback)new TransactionCallback<SecSignIDCUsers>(){

            public SecSignIDCUsers doInTransaction() {
                String jiraUserKey = userKey;
                String secSignIdStr = secSignID;
                SecSignIDCUsers secSignIdUserPair = (SecSignIDCUsers)ao.get(SecSignIDCUsers.class, (Object)(jiraUserKey + ":" + dirid));
                if (secSignIdUserPair == null) {
                    if (!secSignIdStr.equals("")) {
                        secSignIdUserPair = (SecSignIDCUsers)ao.create(SecSignIDCUsers.class, new DBParam[]{new DBParam("USER_NAME", (Object)(jiraUserKey + ":" + dirid)), new DBParam("SEC_SIGN_ID", (Object)secSignIdStr)});
                    }
                } else {
                    secSignIdUserPair.setUserName(jiraUserKey + ":" + dirid);
                    secSignIdUserPair.setSecSignId(secSignIdStr);
                }
                secSignIdUserPair.save();
                return null;
            }
        });
    }

    public static HashMap<String, String[]> getSecSignIdUserMappings(final List<User> userList) {
        final ActiveObjects ao = SecSignIDAOWrapper.getActiveObjects();
        final HashMap<String, String[]> secSignIdMappings = new HashMap<String, String[]>();
        if (ao != null) {
            try {
                ao.executeInTransaction((TransactionCallback)new TransactionCallback<SecSignIDCUsers>(){

                    public SecSignIDCUsers doInTransaction() {
                        for (User user : userList) {
                            for (SecSignIDCUsers secSignIdUserPair : (SecSignIDCUsers[])ao.find(SecSignIDCUsers.class, Query.select().where("LOWER(USER_NAME) = ?", new Object[]{SecSignIDCommonStaticAccessor.getSecSignIDDataAccessor().getUserKeyForUsername(user.getName()) + ":" + user.getDirectoryId()}))) {
                                String secSignIdsStr = secSignIdUserPair.getSecSignId();
                                secSignIdMappings.put(secSignIdUserPair.getUserName(), SecSignIDMappingUtils.getArrayOfSecSignIds(secSignIdsStr));
                            }
                        }
                        return null;
                    }
                });
            }
            catch (ActiveObjectsException e) {
                ao.executeInTransaction((TransactionCallback)new TransactionCallback<SecSignIDCUsers>(){

                    public SecSignIDCUsers doInTransaction() {
                        for (User user : userList) {
                            for (SecSignIDCUsers secSignIdUserPair : (SecSignIDCUsers[])ao.find(SecSignIDCUsers.class, Query.select().where("LOWER(\"USER_NAME\") = ?", new Object[]{SecSignIDCommonStaticAccessor.getSecSignIDDataAccessor().getUserKeyForUsername(user.getName()) + ":" + user.getDirectoryId()}))) {
                                String secSignIdsStr = secSignIdUserPair.getSecSignId();
                                secSignIdMappings.put(secSignIdUserPair.getUserName(), SecSignIDMappingUtils.getArrayOfSecSignIds(secSignIdsStr));
                            }
                        }
                        return null;
                    }
                });
            }
        }
        return secSignIdMappings;
    }

    public static String getMethodToActivate(String userKey, long dirId) {
        final String mappingKey = userKey.toLowerCase() + ":" + dirId;
        final ActiveObjects ao = SecSignIDAOWrapper.getActiveObjects();
        if (ao == null) {
            return null;
        }
        String method = (String)ao.executeInTransaction((TransactionCallback)new TransactionCallback<String>(){

            public String doInTransaction() {
                SecSignIDCLoginOptions options = (SecSignIDCLoginOptions)ao.get(SecSignIDCLoginOptions.class, (Object)mappingKey);
                if (options != null) {
                    return options.getMethodToActivate();
                }
                return null;
            }
        });
        return method;
    }

    public static void saveMethodToActivate(String userKey, long dirId, final String method) {
        final String mappingKey = userKey.toLowerCase() + ":" + dirId;
        final ActiveObjects ao = SecSignIDAOWrapper.getActiveObjects();
        if (ao == null) {
            return;
        }
        ao.executeInTransaction((TransactionCallback)new TransactionCallback<Void>(){

            public Void doInTransaction() {
                SecSignIDCLoginOptions options = (SecSignIDCLoginOptions)ao.get(SecSignIDCLoginOptions.class, (Object)mappingKey);
                if (options == null) {
                    options = (SecSignIDCLoginOptions)ao.create(SecSignIDCLoginOptions.class, new DBParam[]{new DBParam("USER_NAME", (Object)mappingKey), new DBParam("METHOD_TO_ACTIVATE", (Object)method)});
                } else {
                    options.setMethodToActivate(method);
                }
                options.save();
                return null;
            }
        });
    }

    public static String getLastMethodUsed(String userKey, long dirId) {
        final String mappingKey = userKey.toLowerCase() + ":" + dirId;
        final ActiveObjects ao = SecSignIDAOWrapper.getActiveObjects();
        if (ao == null) {
            return null;
        }
        String method = (String)ao.executeInTransaction((TransactionCallback)new TransactionCallback<String>(){

            public String doInTransaction() {
                SecSignIDCLoginOptions options = (SecSignIDCLoginOptions)ao.get(SecSignIDCLoginOptions.class, (Object)mappingKey);
                if (options != null) {
                    return options.getLastMethodUsed();
                }
                return null;
            }
        });
        return method;
    }

    public static void saveLastMethodUsed(String userKey, long dirId, final String method) {
        final String mappingKey = userKey.toLowerCase() + ":" + dirId;
        final ActiveObjects ao = SecSignIDAOWrapper.getActiveObjects();
        if (ao == null) {
            return;
        }
        ao.executeInTransaction((TransactionCallback)new TransactionCallback<Void>(){

            public Void doInTransaction() {
                SecSignIDCLoginOptions options = (SecSignIDCLoginOptions)ao.get(SecSignIDCLoginOptions.class, (Object)mappingKey);
                if (options == null) {
                    options = (SecSignIDCLoginOptions)ao.create(SecSignIDCLoginOptions.class, new DBParam[]{new DBParam("USER_NAME", (Object)mappingKey), new DBParam("LAST_METHOD_USED", (Object)method)});
                } else {
                    options.setLastMethodUsed(method);
                }
                options.save();
                return null;
            }
        });
    }

    private static String generateRandomTokenAsBase64() {
        byte[] token = new byte[32];
        SecureRandom random = new SecureRandom();
        random.nextBytes(token);
        return Base64.getEncoder().encodeToString(token);
    }

    public static SecSignIDTrustDeviceToken createTrustDeviceToken(String userKey, long dirId, final String userAgent) {
        final String mappingKey = userKey + ":" + dirId;
        final ActiveObjects ao = SecSignIDAOWrapper.getActiveObjects();
        if (ao == null) {
            return null;
        }
        SecSignIDTrustDeviceToken token = (SecSignIDTrustDeviceToken)ao.executeInTransaction((TransactionCallback)new TransactionCallback<SecSignIDTrustDeviceToken>(){

            public SecSignIDTrustDeviceToken doInTransaction() {
                String tokenValue = SecSignIDUsersActiveObject.generateRandomTokenAsBase64();
                long creation = System.currentTimeMillis();
                SecSignIDTrustDeviceToken tokenToCreate = new SecSignIDTrustDeviceToken(tokenValue, userAgent, creation);
                SecSignIDCTrustDeviceTokens tokens = (SecSignIDCTrustDeviceTokens)ao.create(SecSignIDCTrustDeviceTokens.class, new DBParam[]{new DBParam("ID", (Object)tokenValue), new DBParam("USER_NAME", (Object)mappingKey), new DBParam("USER_AGENT", (Object)userAgent), new DBParam("CREATION", (Object)creation)});
                tokens.save();
                return tokenToCreate;
            }
        });
        return token;
    }

    public static void removeTrustDeviceToken(String userKey, long dirId, final SecSignIDTrustDeviceToken token) {
        final String mappingKey = userKey + ":" + dirId;
        final ActiveObjects ao = SecSignIDAOWrapper.getActiveObjects();
        if (ao == null) {
            return;
        }
        ao.executeInTransaction((TransactionCallback)new TransactionCallback<Void>(){

            public Void doInTransaction() {
                RawEntity[] tokens = (SecSignIDCTrustDeviceTokens[])ao.find(SecSignIDCTrustDeviceTokens.class, Query.select().where("ID = ? AND USER_NAME = ? AND CREATION = ?", new Object[]{token.getToken(), mappingKey, token.getCreation()}).limit(1));
                ao.delete(tokens);
                return null;
            }
        });
    }

    public static SecSignIDTrustDeviceToken getTrustDeviceToken(String userKey, long dirId, final String tokenValue, final String userAgent) {
        final String username = userKey + ":" + dirId;
        final ActiveObjects ao = SecSignIDAOWrapper.getActiveObjects();
        if (ao == null) {
            return null;
        }
        SecSignIDTrustDeviceToken token = (SecSignIDTrustDeviceToken)ao.executeInTransaction((TransactionCallback)new TransactionCallback<SecSignIDTrustDeviceToken>(){

            public SecSignIDTrustDeviceToken doInTransaction() {
                ArrayList<RawEntity> tokens = new ArrayList<RawEntity>(Arrays.asList(ao.find(SecSignIDCTrustDeviceTokens.class, Query.select().where("ID = ? AND USER_NAME = ? AND USER_AGENT = ?", new Object[]{tokenValue, username, userAgent}).limit(1))));
                SecSignIDUsersActiveObject.removeExpiredTrustDeviceTokens(tokens);
                if (tokens.size() != 0) {
                    SecSignIDCTrustDeviceTokens foundToken = (SecSignIDCTrustDeviceTokens)tokens.get(0);
                    return new SecSignIDTrustDeviceToken(foundToken.getId(), userAgent, foundToken.getCreation());
                }
                return null;
            }
        });
        return token;
    }

    public static List<SecSignIDTrustDeviceToken> getAllTrustDeviceTokens(String userKey, long dirId) {
        final String username = userKey + ":" + dirId;
        final ActiveObjects ao = SecSignIDAOWrapper.getActiveObjects();
        if (ao == null) {
            return null;
        }
        List allTokens = (List)ao.executeInTransaction((TransactionCallback)new TransactionCallback<List<SecSignIDTrustDeviceToken>>(){

            public List<SecSignIDTrustDeviceToken> doInTransaction() {
                ArrayList<RawEntity> tokens = new ArrayList<RawEntity>(Arrays.asList(ao.find(SecSignIDCTrustDeviceTokens.class, Query.select().where("USER_NAME = ?", new Object[]{username}))));
                SecSignIDUsersActiveObject.removeExpiredTrustDeviceTokens(tokens);
                ArrayList<SecSignIDTrustDeviceToken> tokensToReturn = new ArrayList<SecSignIDTrustDeviceToken>();
                for (SecSignIDCTrustDeviceTokens secSignIDCTrustDeviceTokens : tokens) {
                    SecSignIDTrustDeviceToken returnToken = new SecSignIDTrustDeviceToken(secSignIDCTrustDeviceTokens.getId(), secSignIDCTrustDeviceTokens.getUserAgent(), secSignIDCTrustDeviceTokens.getCreation());
                    tokensToReturn.add(returnToken);
                }
                return tokensToReturn;
            }
        });
        return allTokens;
    }

    public static void removeAllTrustDeviceTokens(String userKey, long dirId) {
        final String username = userKey + ":" + dirId;
        final ActiveObjects ao = SecSignIDAOWrapper.getActiveObjects();
        if (ao == null) {
            return;
        }
        ao.executeInTransaction((TransactionCallback)new TransactionCallback<Void>(){

            public Void doInTransaction() {
                RawEntity[] tokens = (SecSignIDCTrustDeviceTokens[])ao.find(SecSignIDCTrustDeviceTokens.class, Query.select().where("USER_NAME = ?", new Object[]{username}));
                ao.delete(tokens);
                return null;
            }
        });
    }

    private static void removeExpiredTrustDeviceTokens(ArrayList<SecSignIDCTrustDeviceTokens> tokens) {
        ActiveObjects ao = SecSignIDAOWrapper.getActiveObjects();
        if (ao == null) {
            return;
        }
        long expirationDuration = (long)SecSignIDCommonStaticAccessor.getTrustDeviceDuration() * 24L * 60L * 60L * 1000L;
        long now = System.currentTimeMillis();
        Iterator<SecSignIDCTrustDeviceTokens> iterator = tokens.iterator();
        while (iterator.hasNext()) {
            SecSignIDCTrustDeviceTokens token = iterator.next();
            long expiration = token.getCreation() + expirationDuration;
            if (now < expiration) continue;
            ao.delete(new RawEntity[]{token});
            iterator.remove();
        }
    }

    public static void save2FAGroupMappings(final HashMap<String, SecSignID2FASettings> groupMappings) {
        final ActiveObjects ao = SecSignIDAOWrapper.getActiveObjects();
        if (ao == null) {
            return;
        }
        ao.executeInTransaction((TransactionCallback)new TransactionCallback<SecSignIDCUsers>(){

            public SecSignIDCUsers doInTransaction() {
                Set groupKeys = groupMappings.keySet();
                for (String groupName : groupKeys) {
                    SecSignFIDOG fidoPair;
                    SecSignTOTPG totpPair;
                    SecSignMailOTPG mailOTPPair;
                    SecSignTwoStepG twostepPair;
                    SecSignPwdlessG passwordlessPair;
                    SecSignIDGroup secSignIdUserPair;
                    SecSignID2FASettings value = (SecSignID2FASettings)groupMappings.get(groupName);
                    String toSave = "deactivate";
                    if (value.getPwdAllowed().equals(SecSignIDCommonConstants.AuthIsAllowed)) {
                        toSave = "activate";
                    }
                    if ((secSignIdUserPair = (SecSignIDGroup)ao.get(SecSignIDGroup.class, (Object)groupName)) == null) {
                        secSignIdUserPair = (SecSignIDGroup)ao.create(SecSignIDGroup.class, new DBParam[]{new DBParam("GROUP_NAME", (Object)groupName), new DBParam("VALUE", (Object)toSave)});
                    } else {
                        secSignIdUserPair.setGroupName(groupName);
                        secSignIdUserPair.setValue(toSave);
                    }
                    secSignIdUserPair.save();
                    toSave = "deactivate";
                    if (value.getPasswordlessAllowed().equals(SecSignIDCommonConstants.AuthIsAllowed)) {
                        toSave = "activate";
                    }
                    if ((passwordlessPair = (SecSignPwdlessG)ao.get(SecSignPwdlessG.class, (Object)groupName)) == null) {
                        passwordlessPair = (SecSignPwdlessG)ao.create(SecSignPwdlessG.class, new DBParam[]{new DBParam("GROUP_NAME", (Object)groupName), new DBParam("VALUE", (Object)toSave)});
                    } else {
                        passwordlessPair.setGroupName(groupName);
                        passwordlessPair.setValue(toSave);
                    }
                    passwordlessPair.save();
                    toSave = "deactivate";
                    if (value.getTwoStepAllowed().equals(SecSignIDCommonConstants.AuthIsAllowed)) {
                        toSave = "activate";
                    }
                    if ((twostepPair = (SecSignTwoStepG)ao.get(SecSignTwoStepG.class, (Object)groupName)) == null) {
                        twostepPair = (SecSignTwoStepG)ao.create(SecSignTwoStepG.class, new DBParam[]{new DBParam("GROUP_NAME", (Object)groupName), new DBParam("VALUE", (Object)toSave)});
                    } else {
                        twostepPair.setGroupName(groupName);
                        twostepPair.setValue(toSave);
                    }
                    twostepPair.save();
                    toSave = "deactivate";
                    if (value.getMailOtpAllowed().equals(SecSignIDCommonConstants.AuthIsAllowed)) {
                        toSave = "activate";
                    }
                    if ((mailOTPPair = (SecSignMailOTPG)ao.get(SecSignMailOTPG.class, (Object)groupName)) == null) {
                        mailOTPPair = (SecSignMailOTPG)ao.create(SecSignMailOTPG.class, new DBParam[]{new DBParam("GROUP_NAME", (Object)groupName), new DBParam("VALUE", (Object)toSave)});
                    } else {
                        mailOTPPair.setGroupName(groupName);
                        mailOTPPair.setValue(toSave);
                    }
                    mailOTPPair.save();
                    toSave = "deactivate";
                    if (value.getTotpAllowed().equals(SecSignIDCommonConstants.AuthIsAllowed)) {
                        toSave = "activate";
                    }
                    if ((totpPair = (SecSignTOTPG)ao.get(SecSignTOTPG.class, (Object)groupName)) == null) {
                        totpPair = (SecSignTOTPG)ao.create(SecSignTOTPG.class, new DBParam[]{new DBParam("GROUP_NAME", (Object)groupName), new DBParam("VALUE", (Object)toSave)});
                    } else {
                        totpPair.setGroupName(groupName);
                        totpPair.setValue(toSave);
                    }
                    totpPair.save();
                    toSave = "deactivate";
                    if (value.getFidoAllowed().equals(SecSignIDCommonConstants.AuthIsAllowed)) {
                        toSave = "activate";
                    }
                    if ((fidoPair = (SecSignFIDOG)ao.get(SecSignFIDOG.class, (Object)groupName)) == null) {
                        fidoPair = (SecSignFIDOG)ao.create(SecSignFIDOG.class, new DBParam[]{new DBParam("GROUP_NAME", (Object)groupName), new DBParam("VALUE", (Object)toSave)});
                    } else {
                        fidoPair.setGroupName(groupName);
                        fidoPair.setValue(toSave);
                    }
                    fidoPair.save();
                }
                return null;
            }
        });
    }

    public static void resetAllFIDO() {
        final ActiveObjects ao = SecSignIDAOWrapper.getActiveObjects();
        if (ao == null) {
            return;
        }
        ao.executeInTransaction((TransactionCallback)new TransactionCallback<Void>(){

            public Void doInTransaction() {
                SecSignIDCLoginOptions[] optionsList;
                for (SecSignIDCLoginOptions options : optionsList = (SecSignIDCLoginOptions[])ao.find(SecSignIDCLoginOptions.class, Query.select().where("FIDOACTIVE = ?", new Object[]{Boolean.TRUE}))) {
                    options.setFIDOActive(Boolean.FALSE);
                    options.save();
                }
                return null;
            }
        });
    }

    public static void save2FAActivatedSettingsForUserKey(String userKey, long directoryID, final SecSignID2FAActivatedSettings settings) {
        final String mappingKey = userKey.toLowerCase() + ":" + directoryID;
        final ActiveObjects ao = SecSignIDAOWrapper.getActiveObjects();
        if (ao == null) {
            return;
        }
        String secSignIdsString = SecSignIDUsersActiveObject.getSecSignIdStringForApplicationUserKey(userKey, directoryID);
        String[] secSignIds = SecSignIDMappingUtils.getArrayOfSecSignIds(secSignIdsString);
        if (secSignIds != null && secSignIds.length > 0) {
            try {
                SecSignIDRESTDevicesResponse devicesResponse = SecSignIDServerRESTConnector.getDevicesOfSecSignID(secSignIds[0]);
                if (devicesResponse.getDeviceCount() > 0) {
                    settings.setTwoStepActive(true);
                }
            }
            catch (SecSignIDRESTException e) {
                logger.error("Couldn't set two step to active.");
                logger.error(e.getMessage());
            }
        }
        ao.executeInTransaction((TransactionCallback)new TransactionCallback<Void>(){

            public Void doInTransaction() {
                SecSignIDCLoginOptions options = (SecSignIDCLoginOptions)ao.get(SecSignIDCLoginOptions.class, (Object)mappingKey);
                if (options == null) {
                    options = (SecSignIDCLoginOptions)ao.create(SecSignIDCLoginOptions.class, new DBParam[]{new DBParam("USER_NAME", (Object)mappingKey), new DBParam("SEC_SIGN_IDACTIVE", (Object)settings.isTwoStepActive()), new DBParam("TOTPACTIVE", (Object)settings.isTotpActive()), new DBParam("FIDOACTIVE", (Object)settings.isFidoActive()), new DBParam("MAIL_OTPACTIVE", (Object)settings.isMailOtpActive())});
                } else {
                    options.setSecSignIDActive(settings.isTwoStepActive());
                    options.setTOTPActive(settings.isTotpActive());
                    options.setFIDOActive(settings.isFidoActive());
                    options.setMailOTPActive(settings.isMailOtpActive());
                }
                options.save();
                return null;
            }
        });
    }

    public static Map<String, SecSignID2FASettings> get2FAGroupMappingsForGroup(final String groupname, final long dirid) {
        final ActiveObjects ao = SecSignIDAOWrapper.getActiveObjects();
        final HashMap<String, SecSignID2FASettings> mappings = new HashMap<String, SecSignID2FASettings>();
        if (ao == null) {
            return mappings;
        }
        ao.executeInTransaction((TransactionCallback)new TransactionCallback<SecSignTOTPG>(){

            public SecSignTOTPG doInTransaction() {
                String value;
                SecSignID2FASettings result = new SecSignID2FASettings();
                SecSignMailOTPG mailOTPPair = (SecSignMailOTPG)ao.get(SecSignMailOTPG.class, (Object)(groupname.toLowerCase().replace(" ", "___") + ";" + dirid));
                SecSignTwoStepG twoStepPair = (SecSignTwoStepG)ao.get(SecSignTwoStepG.class, (Object)(groupname.toLowerCase().replace(" ", "___") + ";" + dirid));
                SecSignPwdlessG pwdlessPair = (SecSignPwdlessG)ao.get(SecSignPwdlessG.class, (Object)(groupname.toLowerCase().replace(" ", "___") + ";" + dirid));
                SecSignTOTPG totpPair = (SecSignTOTPG)ao.get(SecSignTOTPG.class, (Object)(groupname.toLowerCase().replace(" ", "___") + ";" + dirid));
                SecSignFIDOG fidoPair = (SecSignFIDOG)ao.get(SecSignFIDOG.class, (Object)(groupname.toLowerCase().replace(" ", "___") + ";" + dirid));
                if (mailOTPPair != null && (value = mailOTPPair.getValue()) != null && !value.equals("") && value.equals("activate")) {
                    result.setMailOtpAllowed(SecSignIDCommonConstants.AuthIsAllowed);
                }
                if (twoStepPair != null && (value = twoStepPair.getValue()) != null && !value.equals("") && value.equals("activate")) {
                    result.setTwoStepAllowed(SecSignIDCommonConstants.AuthIsAllowed);
                }
                if (pwdlessPair != null && (value = pwdlessPair.getValue()) != null && !value.equals("") && value.equals("activate")) {
                    result.setPasswordlessAllowed(SecSignIDCommonConstants.AuthIsAllowed);
                }
                if (totpPair != null && (value = totpPair.getValue()) != null && !value.equals("") && value.equals("activate")) {
                    result.setTotpAllowed(SecSignIDCommonConstants.AuthIsAllowed);
                }
                if (fidoPair != null && (value = fidoPair.getValue()) != null && !value.equals("") && value.equals("activate")) {
                    result.setFidoAllowed(SecSignIDCommonConstants.AuthIsAllowed);
                }
                mappings.put(groupname.toLowerCase().replace(" ", "___") + ";" + dirid, result);
                return null;
            }
        });
        return mappings;
    }

    public static SecSignID2FAActivatedSettings get2FAActivatedSettingsFromUserKey(String userKey, long directoryID) {
        final String mappingKey = userKey.toLowerCase() + ":" + directoryID;
        final ActiveObjects ao = SecSignIDAOWrapper.getActiveObjects();
        final SecSignID2FAActivatedSettings result = new SecSignID2FAActivatedSettings();
        if (ao == null) {
            return result;
        }
        ao.executeInTransaction((TransactionCallback)new TransactionCallback<SecSignIDCLoginOptions>(){

            public SecSignIDCLoginOptions doInTransaction() {
                SecSignIDCLoginOptions options = (SecSignIDCLoginOptions)ao.get(SecSignIDCLoginOptions.class, (Object)mappingKey);
                if (options != null) {
                    if (options.getSecSignIDActive() != null && options.getSecSignIDActive().booleanValue()) {
                        result.setTwoStepActive(true);
                    }
                    if (options.getTOTPActive() != null && options.getTOTPActive().booleanValue()) {
                        result.setTotpActive(true);
                    }
                    if (options.getFIDOActive() != null && options.getFIDOActive().booleanValue()) {
                        result.setFidoActive(true);
                    }
                    if (options.getMailOTPActive() != null && options.getMailOTPActive().booleanValue()) {
                        result.setMailOtpActive(true);
                    }
                }
                return null;
            }
        });
        return result;
    }

    public static List<User> findUsersForKey(final String key) {
        final ActiveObjects ao = SecSignIDAOWrapper.getActiveObjects();
        final ArrayList<User> result = new ArrayList<User>();
        if (ao != null) {
            ao.executeInTransaction((TransactionCallback)new TransactionCallback<SecSignIDCUsers>(){

                public SecSignIDCUsers doInTransaction() {
                    try {
                        ao.executeInTransaction((TransactionCallback)new TransactionCallback<SecSignIDCUsers>(){

                            public SecSignIDCUsers doInTransaction() {
                                for (SecSignIDCUsers secSignIdUserPair : (SecSignIDCUsers[])ao.find(SecSignIDCUsers.class, Query.select().where("LOWER(SEC_SIGN_ID) LIKE ?", new Object[]{"%" + key.toLowerCase() + "%"}))) {
                                    String secSignIdsStr = secSignIdUserPair.getSecSignId();
                                    if (!secSignIdsStr.toLowerCase().contains(key.toLowerCase())) continue;
                                    String mappingKey = secSignIdUserPair.getUserName();
                                    long dirid = SecSignIDMappingUtils.getDirIDFromMappingKey(mappingKey);
                                    String userKey = SecSignIDMappingUtils.getUserKeyFromMappingKey(mappingKey);
                                    try {
                                        result.add(SecSignIDCommonStaticAccessor.getSecSignIDDataAccessor().getUserForKey(userKey, dirid));
                                    }
                                    catch (DirectoryNotFoundException e) {
                                        logger.debug("DirectoryNotFoundException on findUsersForKey");
                                    }
                                    catch (OperationFailedException e) {
                                        logger.debug("OperationFailed on findUsersForKey");
                                    }
                                    catch (UserNotFoundException e) {
                                        logger.debug("UserNotFoundException on findUsersForKey");
                                    }
                                }
                                return null;
                            }
                        });
                    }
                    catch (ActiveObjectsException e) {
                        ao.executeInTransaction((TransactionCallback)new TransactionCallback<SecSignIDCUsers>(){

                            public SecSignIDCUsers doInTransaction() {
                                for (SecSignIDCUsers secSignIdUserPair : (SecSignIDCUsers[])ao.find(SecSignIDCUsers.class, Query.select().where("LOWER(\"SEC_SIGN_ID\") LIKE ?", new Object[]{"%" + key.toLowerCase() + "%"}))) {
                                    String secSignIdsStr = secSignIdUserPair.getSecSignId();
                                    if (!secSignIdsStr.toLowerCase().contains(key.toLowerCase())) continue;
                                    String mappingKey = secSignIdUserPair.getUserName();
                                    long dirid = SecSignIDMappingUtils.getDirIDFromMappingKey(mappingKey);
                                    String userKey = SecSignIDMappingUtils.getUserKeyFromMappingKey(mappingKey);
                                    try {
                                        result.add(SecSignIDCommonStaticAccessor.getSecSignIDDataAccessor().getUserForKey(userKey, dirid));
                                    }
                                    catch (DirectoryNotFoundException e1) {
                                        logger.debug("DirectoryNotFoundException on findUsersForKey");
                                    }
                                    catch (OperationFailedException e1) {
                                        logger.debug("OperationFailed on findUsersForKey");
                                    }
                                    catch (UserNotFoundException e1) {
                                        logger.debug("UserNotFoundException on findUsersForKey");
                                    }
                                }
                                return null;
                            }
                        });
                    }
                    return null;
                }
            });
        }
        return result;
    }

    public static TreeMap<String, String> getIPMappings() {
        final ActiveObjects ao = SecSignIDAOWrapper.getActiveObjects();
        final TreeMap<String, String> ipMappings = new TreeMap<String, String>(new Comparator<String>(){

            @Override
            public int compare(String s1, String s2) {
                return s1.substring(0, s1.indexOf(":")).compareToIgnoreCase(s2.substring(0, s2.indexOf(":")));
            }
        });
        if (ao != null) {
            ao.executeInTransaction((TransactionCallback)new TransactionCallback<SecSignIDCIPs>(){

                public SecSignIDCIPs doInTransaction() {
                    for (SecSignIDCIPs secSignIdIPPair : (SecSignIDCIPs[])ao.find(SecSignIDCIPs.class)) {
                        ipMappings.put(secSignIdIPPair.getUserName(), secSignIdIPPair.getIP());
                    }
                    return null;
                }
            });
        }
        return ipMappings;
    }

    public static void addIPToMapping(final String userKey, final long dirid, final String ip) {
        final ActiveObjects ao = SecSignIDAOWrapper.getActiveObjects();
        if (ao == null) {
            return;
        }
        ao.executeInTransaction((TransactionCallback)new TransactionCallback<SecSignIDCUsers>(){

            public SecSignIDCUsers doInTransaction() {
                SecSignIDCIPs secSignIdIPPair = (SecSignIDCIPs)ao.get(SecSignIDCIPs.class, (Object)(userKey + ":" + dirid));
                if (secSignIdIPPair == null) {
                    secSignIdIPPair = (SecSignIDCIPs)ao.create(SecSignIDCIPs.class, new DBParam[]{new DBParam("USER_NAME", (Object)(userKey + ":" + dirid)), new DBParam("IP", (Object)ip)});
                } else {
                    secSignIdIPPair.setUserName(userKey + ":" + dirid);
                    secSignIdIPPair.setIP(ip);
                }
                secSignIdIPPair.save();
                return null;
            }
        });
    }

    public static Boolean deleteAllMappings() {
        final ActiveObjects ao = SecSignIDAOWrapper.getActiveObjects();
        if (ao == null) {
            return Boolean.FALSE;
        }
        return (Boolean)ao.executeInTransaction((TransactionCallback)new TransactionCallback<Boolean>(){

            public Boolean doInTransaction() {
                SecSignIDCLoginOptions[] options;
                SecSignIDCUsers[] users;
                for (SecSignIDCUsers secSignIDUsers : users = (SecSignIDCUsers[])ao.find(SecSignIDCUsers.class)) {
                    ao.delete(new RawEntity[]{secSignIDUsers});
                }
                for (SecSignIDCLoginOptions secSignIDLoginOption : options = (SecSignIDCLoginOptions[])ao.find(SecSignIDCLoginOptions.class)) {
                    ao.delete(new RawEntity[]{secSignIDLoginOption});
                }
                return Boolean.TRUE;
            }
        });
    }

    public static void checkDataIntegrityInvoked() {
        final ActiveObjects ao = SecSignIDAOWrapper.getActiveObjects();
        ArrayList result = new ArrayList();
        if (ao != null) {
            ao.executeInTransaction((TransactionCallback)new TransactionCallback<SecSignIDCUsers>(){

                public SecSignIDCUsers doInTransaction() {
                    for (SecSignIDCUsers secSignIdUserPair : (SecSignIDCUsers[])ao.find(SecSignIDCUsers.class)) {
                        String secSignIdsStr = secSignIdUserPair.getSecSignId();
                        String mappingKey = secSignIdUserPair.getUserName();
                        if (mappingKey.contains(":")) {
                            String userKey = SecSignIDMappingUtils.getUserKeyFromMappingKey(mappingKey);
                            long dirid = SecSignIDMappingUtils.getDirIDFromMappingKey(mappingKey);
                            try {
                                SecSignIDCommonStaticAccessor.getSecSignIDDataAccessor().getUserForKey(userKey, dirid);
                            }
                            catch (UserNotFoundException e) {
                                ao.delete(new RawEntity[]{secSignIdUserPair});
                                logger.warn("User not found for " + mappingKey + ", Entry deleted");
                            }
                            catch (DirectoryNotFoundException e) {
                                ao.delete(new RawEntity[]{secSignIdUserPair});
                                logger.warn("Directory not found for " + mappingKey + ", Entry deleted");
                            }
                            catch (OperationFailedException e) {
                                logger.error("OperationFailedException on checkDataIntegrityInvoked for " + mappingKey);
                            }
                            continue;
                        }
                        try {
                            User user = SecSignIDCommonStaticAccessor.getSecSignIDDataAccessor().getUserForKeyFirst(mappingKey);
                            if (user != null) {
                                SecSignIDCUsers[] objectsFound = (SecSignIDCUsers[])ao.find(SecSignIDCUsers.class, mappingKey + ":" + user.getDirectoryId(), new Object[0]);
                                if (objectsFound.length > 0) {
                                    ao.delete(new RawEntity[]{secSignIdUserPair});
                                    continue;
                                }
                                SecSignIDCUsers newPair = (SecSignIDCUsers)ao.create(SecSignIDCUsers.class, new DBParam[]{new DBParam("USER_NAME", (Object)(mappingKey + ":" + user.getDirectoryId())), new DBParam("SEC_SIGN_ID", (Object)secSignIdsStr)});
                                ao.delete(new RawEntity[]{secSignIdUserPair});
                                continue;
                            }
                            String userKey = SecSignIDCommonStaticAccessor.getSecSignIDDataAccessor().getUserKeyForUsername(mappingKey);
                            User userWithUsername = SecSignIDCommonStaticAccessor.getSecSignIDDataAccessor().getUserForKeyFirst(userKey);
                            if (userWithUsername != null) {
                                SecSignIDCUsers[] objectsFound = (SecSignIDCUsers[])ao.find(SecSignIDCUsers.class, userKey + ":" + userWithUsername.getDirectoryId(), new Object[0]);
                                if (objectsFound.length > 0) {
                                    ao.delete(new RawEntity[]{secSignIdUserPair});
                                } else {
                                    SecSignIDCUsers newPair = (SecSignIDCUsers)ao.create(SecSignIDCUsers.class, new DBParam[]{new DBParam("USER_NAME", (Object)(userKey + ":" + userWithUsername.getDirectoryId())), new DBParam("SEC_SIGN_ID", (Object)secSignIdsStr)});
                                    ao.delete(new RawEntity[]{secSignIdUserPair});
                                }
                            }
                            ao.delete(new RawEntity[]{secSignIdUserPair});
                        }
                        catch (OperationFailedException e) {
                            logger.error("OperationFailedException on checkDataIntegrityInvoked for " + mappingKey);
                        }
                    }
                    return null;
                }
            });
        }
    }

    public static void deleteAllGroup2FASettings() {
        final ActiveObjects ao = SecSignIDAOWrapper.getActiveObjects();
        if (ao == null) {
            return;
        }
        ao.executeInTransaction((TransactionCallback)new TransactionCallback<Boolean>(){

            public Boolean doInTransaction() {
                SecSignTwoStepG[] groups6;
                SecSignTOTPG[] groups5;
                SecSignPwdlessG[] groups4;
                SecSignMailOTPG[] groups3;
                SecSignIDGroup[] groups2;
                SecSignIDGPattern[] groups;
                for (SecSignIDGPattern group : groups = (SecSignIDGPattern[])ao.find(SecSignIDGPattern.class)) {
                    ao.delete(new RawEntity[]{group});
                }
                for (SecSignIDGroup group : groups2 = (SecSignIDGroup[])ao.find(SecSignIDGroup.class)) {
                    ao.delete(new RawEntity[]{group});
                }
                for (SecSignMailOTPG group : groups3 = (SecSignMailOTPG[])ao.find(SecSignMailOTPG.class)) {
                    ao.delete(new RawEntity[]{group});
                }
                for (SecSignPwdlessG group : groups4 = (SecSignPwdlessG[])ao.find(SecSignPwdlessG.class)) {
                    ao.delete(new RawEntity[]{group});
                }
                for (SecSignTOTPG group : groups5 = (SecSignTOTPG[])ao.find(SecSignTOTPG.class)) {
                    ao.delete(new RawEntity[]{group});
                }
                for (SecSignTwoStepG group : groups6 = (SecSignTwoStepG[])ao.find(SecSignTwoStepG.class)) {
                    ao.delete(new RawEntity[]{group});
                }
                return Boolean.TRUE;
            }
        });
    }

    public static HashMap<String, SecSignID2FASettings> getGroupMappingsWithOptions() {
        final ActiveObjects ao = SecSignIDAOWrapper.getActiveObjects();
        final HashMap<String, SecSignID2FASettings> mappings = new HashMap<String, SecSignID2FASettings>();
        if (ao == null) {
            return mappings;
        }
        ao.executeInTransaction((TransactionCallback)new TransactionCallback<SecSignTOTPG>(){

            public SecSignTOTPG doInTransaction() {
                SecSignID2FASettings value;
                String groupName;
                SecSignMailOTPG[] mailOTPPairs = (SecSignMailOTPG[])ao.find(SecSignMailOTPG.class, "VALUE=?", new Object[]{"activate"});
                SecSignTwoStepG[] twoStepPairs = (SecSignTwoStepG[])ao.find(SecSignTwoStepG.class, "VALUE=?", new Object[]{"activate"});
                SecSignPwdlessG[] pwdlessPairs = (SecSignPwdlessG[])ao.find(SecSignPwdlessG.class, "VALUE=?", new Object[]{"activate"});
                SecSignTOTPG[] totpPairs = (SecSignTOTPG[])ao.find(SecSignTOTPG.class, "VALUE=?", new Object[]{"activate"});
                SecSignFIDOG[] fidoPairs = (SecSignFIDOG[])ao.find(SecSignFIDOG.class, "VALUE=?", new Object[]{"activate"});
                if (SecSignIDCommonStaticAccessor.getMailotpAuthEnabled()) {
                    for (SecSignMailOTPG secSignMailOTPG : mailOTPPairs) {
                        groupName = secSignMailOTPG.getGroupName();
                        if (mappings.get(groupName) != null) {
                            value = (SecSignID2FASettings)mappings.get(groupName);
                            value.setMailOtpAllowed(SecSignIDCommonConstants.AuthIsAllowed);
                            mappings.put(groupName, value);
                            continue;
                        }
                        value = new SecSignID2FASettings();
                        value.setMailOtpAllowed(SecSignIDCommonConstants.AuthIsAllowed);
                        mappings.put(groupName, value);
                    }
                }
                if (SecSignIDCommonStaticAccessor.getTwoStepAuthEnabled()) {
                    for (SecSignTwoStepG secSignTwoStepG : twoStepPairs) {
                        groupName = secSignTwoStepG.getGroupName();
                        if (mappings.get(groupName) != null) {
                            value = (SecSignID2FASettings)mappings.get(groupName);
                            value.setTwoStepAllowed(SecSignIDCommonConstants.AuthIsAllowed);
                            mappings.put(groupName, value);
                            continue;
                        }
                        value = new SecSignID2FASettings();
                        value.setTwoStepAllowed(SecSignIDCommonConstants.AuthIsAllowed);
                        mappings.put(groupName, value);
                    }
                }
                if (SecSignIDCommonStaticAccessor.getPasswordlessAuthEnabled()) {
                    for (SecSignPwdlessG secSignPwdlessG : pwdlessPairs) {
                        groupName = secSignPwdlessG.getGroupName();
                        if (mappings.get(groupName) != null) {
                            value = (SecSignID2FASettings)mappings.get(groupName);
                            value.setPasswordlessAllowed(SecSignIDCommonConstants.AuthIsAllowed);
                            mappings.put(groupName, value);
                            continue;
                        }
                        value = new SecSignID2FASettings();
                        value.setPasswordlessAllowed(SecSignIDCommonConstants.AuthIsAllowed);
                        mappings.put(groupName, value);
                    }
                }
                if (SecSignIDCommonStaticAccessor.getTotpAuthEnabled()) {
                    for (SecSignTOTPG secSignTOTPG : totpPairs) {
                        groupName = secSignTOTPG.getGroupName();
                        if (mappings.get(groupName) != null) {
                            value = (SecSignID2FASettings)mappings.get(groupName);
                            value.setTotpAllowed(SecSignIDCommonConstants.AuthIsAllowed);
                            mappings.put(groupName, value);
                            continue;
                        }
                        value = new SecSignID2FASettings();
                        value.setTotpAllowed(SecSignIDCommonConstants.AuthIsAllowed);
                        mappings.put(groupName, value);
                    }
                }
                if (SecSignIDCommonStaticAccessor.getFidoAuthEnabled()) {
                    for (SecSignFIDOG secSignFIDOG : fidoPairs) {
                        groupName = secSignFIDOG.getGroupName();
                        if (mappings.get(groupName) != null) {
                            value = (SecSignID2FASettings)mappings.get(groupName);
                            value.setFidoAllowed(SecSignIDCommonConstants.AuthIsAllowed);
                            mappings.put(groupName, value);
                            continue;
                        }
                        value = new SecSignID2FASettings();
                        value.setFidoAllowed(SecSignIDCommonConstants.AuthIsAllowed);
                        mappings.put(groupName, value);
                    }
                }
                return null;
            }
        });
        return mappings;
    }

    private static HashMap<String, String[]> getMappingsContainingSecSignID(final String secSignID) {
        final ActiveObjects ao = SecSignIDAOWrapper.getActiveObjects();
        final HashMap<String, String[]> secSignIdMappings = new HashMap<String, String[]>();
        if (ao != null) {
            try {
                ao.executeInTransaction((TransactionCallback)new TransactionCallback<SecSignIDCUsers>(){

                    public SecSignIDCUsers doInTransaction() {
                        for (SecSignIDCUsers secSignIdUserPair : (SecSignIDCUsers[])ao.find(SecSignIDCUsers.class, Query.select().where("LOWER(SEC_SIGN_ID) = ?", new Object[]{secSignID.toLowerCase()}))) {
                            String secSignIdsStr = secSignIdUserPair.getSecSignId();
                            secSignIdMappings.put(secSignIdUserPair.getUserName(), SecSignIDMappingUtils.getArrayOfSecSignIds(secSignIdsStr));
                        }
                        return null;
                    }
                });
            }
            catch (ActiveObjectsException e) {
                ao.executeInTransaction((TransactionCallback)new TransactionCallback<SecSignIDCUsers>(){

                    public SecSignIDCUsers doInTransaction() {
                        for (SecSignIDCUsers secSignIdUserPair : (SecSignIDCUsers[])ao.find(SecSignIDCUsers.class, Query.select().where("LOWER(\"SEC_SIGN_ID\") = ?", new Object[]{secSignID.toLowerCase()}))) {
                            String secSignIdsStr = secSignIdUserPair.getSecSignId();
                            secSignIdMappings.put(secSignIdUserPair.getUserName(), SecSignIDMappingUtils.getArrayOfSecSignIds(secSignIdsStr));
                        }
                        return null;
                    }
                });
            }
        }
        return secSignIdMappings;
    }
}

