/*
 * Decompiled with CFR 0.152.
 */
package com.secsign.atlassian.common.accessor.directories;

import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.GroupWithAttributes;
import com.atlassian.crowd.exception.ApplicationPermissionException;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.exception.GroupNotFoundException;
import com.atlassian.crowd.exception.InvalidAuthenticationException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.exception.UserNotFoundException;
import com.atlassian.crowd.manager.directory.DirectoryPermissionException;
import com.atlassian.crowd.model.user.UserWithAttributes;
import com.secsign.atlassian.common.accessor.SecSignIDCommonStaticAccessor;
import com.secsign.atlassian.common.data.SecSignID2FASettings;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DirectoryWrapper {
    private static final Logger logger = LoggerFactory.getLogger(DirectoryWrapper.class);
    private final Directory directory;

    public DirectoryWrapper(Directory directory) {
        this.directory = directory;
    }

    public Directory getDirectory() {
        return this.directory;
    }

    public long getDirectoryId() {
        return this.directory.getId();
    }

    public void storeUserAttributes(String userKey, HashMap<String, Set<String>> attributeMap) throws InvalidAuthenticationException, DirectoryPermissionException, OperationFailedException, UserNotFoundException, DirectoryNotFoundException, ApplicationPermissionException {
        for (String key : attributeMap.keySet()) {
            Set<String> values = attributeMap.get(key);
            if (values == null || values.size() == 0) {
                this.removeUserAttribute(userKey, key);
                continue;
            }
            boolean allValuesEmpty = true;
            for (String value : values) {
                if (value == null || value.length() == 0) continue;
                allValuesEmpty = false;
                break;
            }
            if (allValuesEmpty) {
                this.removeUserAttribute(userKey, key);
                continue;
            }
            HashMap<String, Set<String>> singleAttributeMap = new HashMap<String, Set<String>>();
            singleAttributeMap.put(key, values);
            this.storeUserAttributesUnsafe(userKey, singleAttributeMap);
        }
    }

    public void storeUserAttributeForKey(String userKey, String key, String value) throws InvalidAuthenticationException, DirectoryPermissionException, OperationFailedException, UserNotFoundException, DirectoryNotFoundException, ApplicationPermissionException {
        if (value == null || value.length() == 0) {
            this.removeUserAttribute(userKey, key);
            return;
        }
        HashMap<String, Set<String>> singleAttributeMap = new HashMap<String, Set<String>>();
        HashSet<String> valueSet = new HashSet<String>();
        valueSet.add(value);
        singleAttributeMap.put(key, valueSet);
        this.storeUserAttributesUnsafe(userKey, singleAttributeMap);
    }

    public void storeGroupAttributeForKey(String groupName, String key, String value) throws GroupNotFoundException, InvalidAuthenticationException, OperationFailedException, DirectoryNotFoundException, DirectoryPermissionException, ApplicationPermissionException {
        if (value == null || value.length() == 0) {
            this.removeGroupAttribute(groupName, key);
            return;
        }
        HashMap<String, Set<String>> singleAttributeMap = new HashMap<String, Set<String>>();
        HashSet<String> valueSet = new HashSet<String>();
        valueSet.add(value);
        singleAttributeMap.put(key, valueSet);
        this.storeGroupAttributesUnsafe(groupName, singleAttributeMap);
    }

    public void storeUserAttributeSetForKey(String userKey, String key, Set<String> values) throws InvalidAuthenticationException, DirectoryPermissionException, OperationFailedException, UserNotFoundException, DirectoryNotFoundException, ApplicationPermissionException {
        if (this.isAttributeSetEmpty(values)) {
            this.removeUserAttribute(userKey, key);
            return;
        }
        HashMap<String, Set<String>> singleAttributeMap = new HashMap<String, Set<String>>();
        singleAttributeMap.put(key, values);
        this.storeUserAttributesUnsafe(userKey, singleAttributeMap);
    }

    public void removeUserAttribute(String userKey, String attributeKey) throws InvalidAuthenticationException, DirectoryPermissionException, OperationFailedException, UserNotFoundException, DirectoryNotFoundException, ApplicationPermissionException {
        HashMap<String, Set<String>> attributeMap = new HashMap<String, Set<String>>();
        HashSet<String> entries = new HashSet<String>();
        entries.add("SECSIGN_NULL");
        attributeMap.put(attributeKey, entries);
        this.storeUserAttributesUnsafe(userKey, attributeMap);
    }

    public void removeGroupAttribute(String groupName, String attributeKey) throws InvalidAuthenticationException, GroupNotFoundException, OperationFailedException, DirectoryNotFoundException, DirectoryPermissionException, ApplicationPermissionException {
        HashMap<String, Set<String>> attributeMap = new HashMap<String, Set<String>>();
        HashSet<String> entries = new HashSet<String>();
        entries.add("SECSIGN_NULL");
        attributeMap.put(attributeKey, entries);
        this.storeGroupAttributesUnsafe(groupName, attributeMap);
    }

    public String getUserAttribute(String userKey, String keyOfValue) throws OperationFailedException, InvalidAuthenticationException, ApplicationPermissionException {
        String attributeValue = null;
        try {
            String username = SecSignIDCommonStaticAccessor.getSecSignIDDataAccessor().getUsernameForUserKey(userKey);
            UserWithAttributes userWithAttributes = this.findUserWithAttributesByName(username);
            attributeValue = userWithAttributes.getValue(keyOfValue);
            if (this.isAttributeEmpty(attributeValue)) {
                attributeValue = null;
            }
            logger.debug("Got value for key: " + keyOfValue + " for userKey " + userKey + ":" + attributeValue);
            return attributeValue;
        }
        catch (UserNotFoundException e) {
            logger.error("UserNotFoundException on getUserAttribute");
        }
        catch (DirectoryNotFoundException e) {
            logger.error("DirectoryNotFoundException on getUserAttribute");
        }
        return attributeValue;
    }

    public Set<String> getUserAttributeSet(String userKey, String keyOfValue) throws OperationFailedException, InvalidAuthenticationException, ApplicationPermissionException {
        Set attributeValue = null;
        try {
            String username = SecSignIDCommonStaticAccessor.getSecSignIDDataAccessor().getUsernameForUserKey(userKey);
            UserWithAttributes userWithAttributes = this.findUserWithAttributesByName(username);
            attributeValue = userWithAttributes.getValues(keyOfValue);
            if (this.isAttributeSetEmpty(attributeValue)) {
                attributeValue = null;
            }
            logger.debug("Got value for key: " + keyOfValue + " for userKey " + userKey + ":" + attributeValue);
            return attributeValue;
        }
        catch (UserNotFoundException e) {
            logger.error("UserNotFoundException on getUserAttribute");
        }
        catch (DirectoryNotFoundException e) {
            logger.error("DirectoryNotFoundException on getUserAttribute");
        }
        return attributeValue;
    }

    public String getGroupAttribute(String groupName, String keyOfValue) throws InvalidAuthenticationException, ApplicationPermissionException, OperationFailedException {
        String attributeValue = null;
        try {
            GroupWithAttributes groupWithAttributes = this.findGroupWithAttributesByName(groupName);
            attributeValue = groupWithAttributes.getValue(keyOfValue);
            if (this.isAttributeEmpty(attributeValue)) {
                attributeValue = null;
            }
            logger.debug("Got value for key: " + keyOfValue + " for groupName " + groupName + ":" + attributeValue);
            return attributeValue;
        }
        catch (GroupNotFoundException e) {
            logger.error("GroupNotFoundException on getGroupAttribute");
        }
        catch (DirectoryNotFoundException e) {
            logger.error("DirectoryNotFoundException on getGroupAttribute");
        }
        return attributeValue;
    }

    protected boolean isAttributeEmpty(String attributeValue) {
        return attributeValue == null || attributeValue.length() == 0 || attributeValue.equalsIgnoreCase("SECSIGN_NULL");
    }

    protected boolean isAttributeSetEmpty(Set<String> attributeValues) {
        return attributeValues == null || attributeValues.size() == 0 || attributeValues.toArray()[0].equals("SECSIGN_NULL");
    }

    public abstract UserWithAttributes findUserWithAttributesByName(String var1) throws DirectoryNotFoundException, UserNotFoundException, OperationFailedException, InvalidAuthenticationException, ApplicationPermissionException;

    protected abstract void storeUserAttributesUnsafe(String var1, HashMap<String, Set<String>> var2) throws UserNotFoundException, OperationFailedException, DirectoryNotFoundException, DirectoryPermissionException, InvalidAuthenticationException, ApplicationPermissionException;

    public abstract GroupWithAttributes findGroupWithAttributesByName(String var1) throws GroupNotFoundException, DirectoryNotFoundException, OperationFailedException, InvalidAuthenticationException, ApplicationPermissionException;

    public abstract void storeGroupAttributesUnsafe(String var1, HashMap<String, Set<String>> var2) throws OperationFailedException, GroupNotFoundException, DirectoryNotFoundException, DirectoryPermissionException, InvalidAuthenticationException, ApplicationPermissionException;

    public abstract HashMap<String, SecSignID2FASettings> getGroupMappingsWithOptions() throws OperationFailedException, InvalidAuthenticationException, ApplicationPermissionException, DirectoryNotFoundException;

    public void deleteAllUser2FASettings() throws OperationFailedException, InvalidAuthenticationException, ApplicationPermissionException, UserNotFoundException, DirectoryPermissionException, DirectoryNotFoundException {
        this.deleteAllUserAttributesWithKey("secsign.activated");
    }

    public void deleteAllGroup2FASettings() throws GroupNotFoundException, InvalidAuthenticationException, OperationFailedException, DirectoryNotFoundException, DirectoryPermissionException, ApplicationPermissionException {
        this.deleteAllGroupAttributesWithKey("secsign.twofa");
    }

    public abstract void deleteAllUserAttributesWithKey(String var1) throws OperationFailedException, InvalidAuthenticationException, ApplicationPermissionException, DirectoryNotFoundException, DirectoryPermissionException, UserNotFoundException;

    public abstract void deleteAllGroupAttributesWithKey(String var1) throws OperationFailedException, InvalidAuthenticationException, ApplicationPermissionException, GroupNotFoundException, DirectoryNotFoundException, DirectoryPermissionException;

    public abstract List<String> findUsersWithAttributeMatchesValue(String var1, String var2) throws OperationFailedException, InvalidAuthenticationException, ApplicationPermissionException, DirectoryNotFoundException;

    public abstract List<String> getActivatedFIDOMappings() throws OperationFailedException, InvalidAuthenticationException, ApplicationPermissionException, DirectoryNotFoundException;
}

