/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.usersync.util;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import de.resolution.atlasuser.api.user.AtlasUser;
import de.resolution.atlasuser.api.user.AtlasUserResult;
import de.resolution.commons.util.JSONUtil;
import de.resolution.usersync.spi.ConnectorConfiguration;
import de.resolution.usersync.util.KeyValue;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class UserSyncUtils {
    private static final ObjectMapper objectMapper = new ObjectMapper();

    private UserSyncUtils() {
    }

    public static boolean checkSuccess(@Nullable AtlasUserResult atlasUserResult) {
        return atlasUserResult != null && atlasUserResult.getOperation() != AtlasUserResult.Operation.FAILED;
    }

    public static List<String> filterForRequiredGroups(Map<String, String> loadedGroups, List<Pattern> requiredGroupNamePatterns) {
        ArrayList<String> ret = new ArrayList<String>();
        for (Map.Entry<String, String> currentGroupEntry : loadedGroups.entrySet()) {
            if (!requiredGroupNamePatterns.stream().anyMatch(pattern -> pattern.matcher((CharSequence)currentGroupEntry.getValue()).matches())) continue;
            ret.add(currentGroupEntry.getKey());
        }
        return ret;
    }

    public static String addUniqueId(String configurationJson, String uniqueId) {
        try {
            ObjectNode configurationNode = (ObjectNode)objectMapper.readTree(configurationJson);
            configurationNode.set("uniqueId", objectMapper.valueToTree((Object)uniqueId));
            return objectMapper.writeValueAsString((Object)configurationNode);
        }
        catch (IOException e) {
            throw new JSONUtil.JsonSerializationFailedException((Throwable)e);
        }
    }

    @Nonnull
    public static List<KeyValue> asKeyValueList(@Nonnull Map<String, String> dataMap) {
        ArrayList<KeyValue> ret = new ArrayList<KeyValue>(dataMap.size());
        dataMap.forEach((key, value) -> ret.add(new KeyValue((String)key, (String)value)));
        return ret;
    }

    public static boolean mappingWithTargetNameExists(@Nonnull ConnectorConfiguration config, @Nonnull String targetName) {
        return config.getAttributeTransformationConfigs().stream().filter(Objects::nonNull).filter(attributeTransformationConfig -> attributeTransformationConfig.getTarget() != null).filter(attributeTransformationConfig -> attributeTransformationConfig.getTarget().getName() != null).filter(attributeTransformationConfig -> attributeTransformationConfig.getTarget().getName().equals(targetName)).collect(Collectors.toSet()).size() == 1;
    }

    @Nullable
    public static String readForeignId(@Nonnull AtlasUser atlasUser) {
        return atlasUser.get("azure_ID").orElse(atlasUser.get("okta_ID").orElse(atlasUser.get("gsuite_ID").orElse(atlasUser.get("id").orElse(atlasUser.get("onelogin_ID").orElse(atlasUser.get("Unique_ID").orElse(null))))));
    }

    static {
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }
}

