/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.usersync.spi;

import de.resolution.atlasuser.impl.AttributeIndex;
import de.resolution.commons.data.MapStructuredData;
import de.resolution.commons.validate.api.ValidationResult;
import de.resolution.retransform.api.AttributeTransformer;
import de.resolution.retransform.api.TransformationFailedException;
import de.resolution.retransform.frontend.TargetTypeMap;
import de.resolution.usersync.api.ConnectorGroup;
import de.resolution.usersync.api.IdentifierForSingleUserSync;
import de.resolution.usersync.api.SyncFunction;
import de.resolution.usersync.api.SyncSingleUserResult;
import de.resolution.usersync.api.SyncStatus;
import de.resolution.usersync.api.SyncStatusFacade;
import de.resolution.usersync.api.SyncUserResult;
import de.resolution.usersync.api.cleanup.CleanupDecider;
import de.resolution.usersync.api.exception.GeneralSyncException;
import de.resolution.usersync.api.exception.UserFindFailedException;
import de.resolution.usersync.impl.requiredgroups.RequiredGroupCheckerHolder;
import de.resolution.usersync.rest.entities.ConnectionTestResultEntity;
import de.resolution.usersync.spi.ConnectorConfiguration;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public interface Connector<T extends ConnectorConfiguration> {
    @Nonnull
    public String getName();

    @Nonnull
    public String getUniqueId();

    public long getLastUpdated();

    @Nonnull
    public T getConfiguration();

    @Nonnull
    public Map<String, AttributeTransformer> getAttributeTransformerMap();

    @Nonnull
    public ConnectorConfiguration getSanitizedConfiguration();

    @Nonnull
    public Class<T> getConfigurationClass();

    public void sync(@Nonnull SyncFunction var1, @Nonnull SyncStatus var2);

    @Nonnull
    public SyncSingleUserResult syncSingleUser(@Nonnull String var1, @Nullable MapStructuredData var2, @Nullable Map<String, Set<String>> var3, @Nullable String var4, boolean var5);

    @Nullable
    public MapStructuredData loadUserAttributesFromBackend(@Nonnull String var1, MapStructuredData var2) throws TransformationFailedException, UserFindFailedException;

    @Nullable
    public String getAuthorizationCodeUrl();

    @Nonnull
    public String getTypeDisplayName();

    @Nonnull
    public List<String> getConnectorAttributes();

    @Nonnull
    public SyncUserResult syncUser(@Nullable MapStructuredData var1, @Nullable MapStructuredData var2, @Nullable AttributeIndex var3, @Nullable Map<String, ? extends Collection<String>> var4, long var5, boolean var7, boolean var8) throws TransformationFailedException, UserFindFailedException;

    @Nonnull
    public SyncUserResult syncUser(@Nullable MapStructuredData var1, @Nullable MapStructuredData var2, @Nullable AttributeIndex var3, @Nullable Map<String, ? extends Collection<String>> var4, @Nullable String var5, long var6, boolean var8, boolean var9) throws TransformationFailedException, UserFindFailedException;

    @Nonnull
    public TargetTypeMap getAttributeMappingTemplates();

    public boolean isAllowCustomAttributeMapping();

    public boolean isAllowSelectingFindByAttribute();

    public boolean isAllowCustomConnectorAttributes();

    public boolean isSelectableGroupAttribute();

    public boolean isAllowGroupConfiguration();

    public boolean isSelectableDirectory();

    public boolean isAllowCreatingNewDirectory();

    public boolean isIncludeAllDirectories();

    public boolean isReadOnly();

    public boolean isCanSync();

    public boolean isCanSyncSingleUser();

    public boolean isCanBeScheduled();

    public boolean isEditable();

    public boolean isCleanupConfigurable();

    public boolean isCanCopyUsers();

    public boolean isCanHaveRequiredGroups();

    public boolean isCanUseRequiredConnectorGroupsGroovy();

    public boolean isCanFetchRequiredConnectorGroups();

    public boolean isCanUseRequiredConnectorGroupsServerFilter();

    public boolean isCanGenerateSyncResult();

    @Nonnull
    public RequiredGroupCheckerHolder getRequiredGroupCheckerHolder();

    public boolean isHasProvisioningSettings();

    public boolean isApplyTransformations();

    @Nonnull
    public String getAttributeNameForSingleUserSearch();

    @Nonnull
    public Optional<String> getConnectorStorageValue(@Nonnull String var1);

    public void setConnectorStorageValue(@Nonnull String var1, @Nonnull String var2);

    public boolean removeConnectorStorageValue(@Nonnull String var1);

    @Nonnull
    public Map<String, String> getAllConnectorStorageValues();

    public boolean isAuthorizationRequired();

    public boolean isNew();

    public boolean isValid();

    public ValidationResult checkIdentifierForSingleUserSync(IdentifierForSingleUserSync var1, @Nonnull ValidationResult var2);

    public boolean isCanOverrideDefaultConnectTimeoutForOkHttp();

    public CleanupDecider getCleanupDecider();

    public Set<ConnectorGroup> fetchRequiredConnectorGroups(@Nonnull RequiredGroupCheckerHolder var1, @Nonnull SyncStatusFacade var2) throws GeneralSyncException;

    @Nonnull
    public List<ConnectionTestResultEntity.EndpointResult> doConnectionTest();
}

