/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.usersync.spi;

import de.resolution.commons.util.StringUtil;
import de.resolution.commons.validate.api.ValidationResult;
import de.resolution.usersync.api.ConnectorService;
import de.resolution.usersync.api.exception.ConnectorFactoryAlreadyRegisteredException;
import de.resolution.usersync.impl.PlatformSpecificConfigDefaultsProvider;
import de.resolution.usersync.spi.AbstractHTTPConnectorFactory;
import de.resolution.usersync.spi.AbstractOAuthConnector;
import de.resolution.usersync.spi.OAuthConnectorConfiguration;
import jakarta.annotation.Nonnull;

public abstract class AbstractOAuthConnectorFactory<T extends AbstractOAuthConnector<C>, C extends OAuthConnectorConfiguration>
extends AbstractHTTPConnectorFactory<T, C> {
    protected AbstractOAuthConnectorFactory(ConnectorService connectorService, PlatformSpecificConfigDefaultsProvider platformSpecificConfigDefaultsProvider) throws ConnectorFactoryAlreadyRegisteredException {
        super(connectorService, platformSpecificConfigDefaultsProvider);
    }

    @Override
    @Nonnull
    public ValidationResult validate(@Nonnull C config) {
        ValidationResult validationResult = super.validate(config);
        if (StringUtil.isNullOrEmpty((String)config.getClientId())) {
            validationResult.add("clientId", "You must enter a client id");
        }
        if (StringUtil.isNullOrEmpty((String)config.getClientSecret())) {
            validationResult.add("clientSecret", "You must enter the client secret");
        }
        return validationResult;
    }
}

