/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.usersync.spi;

import de.resolution.commons.validate.api.ValidationResult;
import de.resolution.usersync.api.ConnectorService;
import de.resolution.usersync.api.exception.ConnectorFactoryAlreadyRegisteredException;
import de.resolution.usersync.impl.PlatformSpecificConfigDefaultsProvider;
import de.resolution.usersync.spi.AbstractConnectorFactory;
import de.resolution.usersync.spi.AbstractHTTPConnector;
import de.resolution.usersync.spi.HTTPConnectorConfiguration;
import jakarta.annotation.Nonnull;
import okhttp3.logging.HttpLoggingInterceptor;

public abstract class AbstractHTTPConnectorFactory<T extends AbstractHTTPConnector<C>, C extends HTTPConnectorConfiguration>
extends AbstractConnectorFactory<T, C> {
    protected AbstractHTTPConnectorFactory(ConnectorService connectorService, PlatformSpecificConfigDefaultsProvider platformSpecificConfigDefaultsProvider) throws ConnectorFactoryAlreadyRegisteredException {
        super(connectorService, platformSpecificConfigDefaultsProvider);
    }

    @Override
    @Nonnull
    public ValidationResult validate(@Nonnull C config) {
        ValidationResult validationResult = super.validate(config);
        if (config.getConnectTimeout() < 0) {
            validationResult.add("connectTimeout", "Connect timeout must not be negative.", null);
        }
        if (config.getReadTimeout() < 0) {
            validationResult.add("readTimeout", "Read timeout must not be negative.", null);
        }
        if (config.getHttpLogLevel() != HttpLoggingInterceptor.Level.NONE) {
            validationResult.addWarning("Additional HTTP logging is enabled. This could lead to a lot of debug messages in the application's log file. Please enable this option only if you're actively debugging networking issues.");
        }
        return validationResult;
    }
}

