/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.usersync.spi;

import de.resolution.atlasuser.api.user.AtlasUserAdapter;
import de.resolution.reconfigure.privilege.PrivilegeCheckerImpl;
import de.resolution.retransform.config.AttributeTransformationConfig;
import de.resolution.retransform.config.Source;
import de.resolution.retransform.config.Target;
import de.resolution.usersync.api.cleanup.CleanupBehaviour;
import de.resolution.usersync.spi.ConnectorConfiguration;
import jakarta.annotation.Nonnull;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractConnectorConfigurationImpl
implements ConnectorConfiguration {
    public static final int NEWEST_VERSION = 2;
    public static final AttributeTransformationConfig GROUP_TRANSFORMATION = new AttributeTransformationConfig(Source.createSingle((String)"GROUPS"), new Target(Target.Type.SYSTEM, "ATTR_GROUPS"), false, true);
    @Nonnull
    private String uniqueId = UUID.randomUUID().toString();
    @Nonnull
    private String name = "";
    @Nonnull
    private List<AttributeTransformationConfig> attributeTransformationConfigs = this.createDefaultAttributeTransformationConfigs();
    @Nonnull
    protected CleanupBehaviour cleanupBehaviour = CleanupBehaviour.DISABLE;
    @Nonnull
    private List<String> requiredConnectorGroups = Collections.emptyList();
    @Nonnull
    private List<String> requiredGroups = Collections.emptyList();
    @Nonnull
    private List<String> groupsToAssignAlways = Collections.emptyList();
    @Nonnull
    private List<String> groupsToAssignNever = Collections.emptyList();
    @Nonnull
    private List<String> groupsToKeep = Collections.emptyList();
    @Nonnull
    private List<String> groupsToAssignFilter = Collections.emptyList();
    @Nonnull
    private String cronExpression = "0 0 2 * * ?";
    @Nonnull
    private String findByAttributeName = this.getDefaultFindByAttributeName();
    @Nonnull
    private AtlasUserAdapter.CopyBehaviour copyBehaviour = AtlasUserAdapter.CopyBehaviour.COPY;
    @Nonnull
    private AttributeTransformationConfig disableNotFoundUserLookupTransformation = AttributeTransformationConfig.create((String)"identifier");
    @Nonnull
    private String disableNotFoundUserLookupAttribute = "ATTR_NAME";
    private boolean useGroovyCleanupDecider = false;
    private boolean removeAllGroupAssignmentsOnCleanup = false;
    private List<String> groupsOrRegexNotBeRemoved = new ArrayList<String>();
    private String groovyCleanupDeciderCode = "boolean shouldCleanup(AtlasUser atlasUser, long syncStartedAtTimestamp) {\n    return timestamp(atlasUser) < syncStartedAtTimestamp\n}";
    private boolean dropUnmatchedGroups;
    private long directoryId;
    private boolean scheduled;
    private boolean overrideReadOnlyDirectoryCheck = false;
    private boolean syncEnabled = true;
    private boolean disableNotFoundUser = false;
    private boolean trackMemoryUsage = false;
    private boolean ignoreRequiredConnectorGroupsOnSingleUserSync = false;
    private boolean useRequiredConnectorGroupsGroovy = false;
    private boolean useRequiredConnectorGroupsServerFilter = false;
    private String requiredConnectorGroupsGroovy = "boolean isRequiredGroup(StructuredData groupData) {\n    return false\n}";
    private String requiredConnectorGroupsCustomServerFilter;
    private int version = 2;
    private int initialVersion = 2;
    private int resultsToKeep = 5;
    private int slowdownDelayInMs = 0;
    @Nonnull
    private PrivilegeCheckerImpl.Role syncSingleUserRestPermission = PrivilegeCheckerImpl.Role.SYSADMIN;

    protected AbstractConnectorConfigurationImpl() {
    }

    protected AbstractConnectorConfigurationImpl(@Nonnull ConnectorConfiguration other) {
        this.setUniqueId(other.getUniqueId());
        this.setName(other.getName());
        this.setAttributeTransformationConfigs(other.getAttributeTransformationConfigs());
        this.setCleanupBehaviour(other.getCleanupBehaviour());
        this.setRequiredGroups(other.getRequiredGroups());
        this.setRequiredConnectorGroups(other.getRequiredConnectorGroups());
        this.setGroupsToAssignAlways(other.getGroupsToAssignAlways());
        this.setGroupsToAssignNever(other.getGroupsToAssignNever());
        this.setGroupsToKeep(other.getGroupsToKeep());
        this.setGroupsToAssignFilter(other.getGroupsToAssignFilter());
        this.setCronExpression(other.getCronExpression());
        this.setFindByAttributeName(other.getFindByAttributeName());
        this.setCopyBehaviour(other.getCopyBehaviour());
        this.setDropUnmatchedGroups(other.isDropUnmatchedGroups());
        this.setDirectoryId(other.getDirectoryId());
        this.setScheduled(other.isScheduled());
        this.setResultsToKeep(other.getResultsToKeep());
        this.setVersion(other.getVersion());
        this.setInitialVersion(other.getInitialVersion());
        this.setOverrideReadOnlyDirectoryCheck(other.isOverrideReadOnlyDirectoryCheck());
        this.setSyncEnabled(other.isSyncEnabled());
        this.setDisableNotFoundUser(other.isDisableNotFoundUser());
        this.setDisableNotFoundLookupTransformation(other.getDisableNotFoundLookupTransformation());
        this.setDisableNotFoundUserLookupAttribute(other.getDisableNotFoundUserLookupAttribute());
        this.setIgnoreRequiredConnectorGroupsOnSingleUserSync(other.isIgnoreRequiredConnectorGroupsOnSingleUserSync());
        this.setUseGroovyCleanupDecider(other.isUseGroovyCleanupDecider());
        this.setGroovyCleanupDeciderCode(other.getGroovyCleanupDeciderCode());
        this.setUseRequiredConnectorGroupsGroovy(other.isUseRequiredConnectorGroupsGroovy());
        this.setRequiredConnectorGroupsGroovy(other.getRequiredConnectorGroupsGroovy());
        this.setTrackMemoryUsage(other.isTrackMemoryUsage());
        this.setRemoveAllGroupAssignmentsOnCleanup(other.isRemoveAllGroupAssignmentsOnCleanup());
        this.setUseRequiredConnectorGroupsServerFilter(other.isUseRequiredConnectorGroupsServerFilter());
        this.setRequiredConnectorGroupsServerFilter(other.getRequiredConnectorGroupsServerFilter());
        this.setGroupsOrRegexNotBeRemoved(other.getGroupsOrRegexNotBeRemoved());
        this.setSlowdownDelayInMs(other.getSlowdownDelayInMs());
        this.setSyncSingleUserRestPermission(other.getSyncSingleUserRestPermission());
    }

    public void setUniqueId(String uniqueId) {
        if (uniqueId != null) {
            this.uniqueId = uniqueId;
        }
    }

    @Override
    public void setName(String name) {
        if (name != null) {
            this.name = name;
        }
    }

    public void setAttributeTransformationConfigs(List<AttributeTransformationConfig> attributeTransformationConfigs) {
        this.attributeTransformationConfigs = new ArrayList<AttributeTransformationConfig>(attributeTransformationConfigs);
    }

    @Override
    public void setCleanupBehaviour(@Nonnull CleanupBehaviour cleanupBehaviour) {
        this.cleanupBehaviour = cleanupBehaviour;
    }

    public void setRequiredGroups(List<String> requiredGroups) {
        if (requiredGroups != null) {
            this.requiredGroups = requiredGroups;
        }
    }

    public void setGroupsToAssignAlways(List<String> groupsToAssignAlways) {
        if (groupsToAssignAlways != null) {
            this.groupsToAssignAlways = new ArrayList<String>(groupsToAssignAlways);
        }
    }

    public void setGroupsToAssignNever(List<String> groupsToAssignNever) {
        if (groupsToAssignNever != null) {
            this.groupsToAssignNever = new ArrayList<String>(groupsToAssignNever);
        }
    }

    public void setGroupsToKeep(List<String> groupsToKeep) {
        if (groupsToKeep != null) {
            this.groupsToKeep = new ArrayList<String>(groupsToKeep);
        }
    }

    public void setGroupsToAssignFilter(List<String> groupsToAssignFilter) {
        if (groupsToAssignFilter != null) {
            this.groupsToAssignFilter = new ArrayList<String>(groupsToAssignFilter);
        }
    }

    public void setCronExpression(String cronExpression) {
        if (cronExpression != null) {
            this.cronExpression = cronExpression;
        }
    }

    public void setFindByAttributeName(String findByAttributeName) {
        if (findByAttributeName != null) {
            this.findByAttributeName = findByAttributeName;
        }
    }

    public void setCopyBehaviour(AtlasUserAdapter.CopyBehaviour copyBehaviour) {
        if (copyBehaviour != null) {
            this.copyBehaviour = copyBehaviour;
        }
    }

    public void setDropUnmatchedGroups(boolean dropUnmatchedGroups) {
        this.dropUnmatchedGroups = dropUnmatchedGroups;
    }

    @Override
    public void setDirectoryId(long directoryId) {
        this.directoryId = directoryId;
    }

    public void setScheduled(boolean scheduled) {
        this.scheduled = scheduled;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public void setInitialVersion(int initialVersion) {
        this.initialVersion = initialVersion;
    }

    @Override
    @Nonnull
    public List<String> getRequiredConnectorGroups() {
        return this.requiredConnectorGroups;
    }

    @Override
    @Nullable
    public String getRequiredConnectorGroupsGroovy() {
        return this.requiredConnectorGroupsGroovy;
    }

    public void setRequiredConnectorGroupsGroovy(@Nullable String requiredConnectorGroupsGroovy) {
        this.requiredConnectorGroupsGroovy = requiredConnectorGroupsGroovy;
    }

    @Override
    public boolean isUseRequiredConnectorGroupsGroovy() {
        return this.useRequiredConnectorGroupsGroovy;
    }

    public void setUseRequiredConnectorGroupsGroovy(boolean useRequiredConnectorGroupsGroovy) {
        this.useRequiredConnectorGroupsGroovy = useRequiredConnectorGroupsGroovy;
    }

    @Override
    public boolean isUseRequiredConnectorGroupsServerFilter() {
        return this.useRequiredConnectorGroupsServerFilter;
    }

    public void setUseRequiredConnectorGroupsServerFilter(boolean useRequiredConnectorGroupsServerFilter) {
        this.useRequiredConnectorGroupsServerFilter = useRequiredConnectorGroupsServerFilter;
    }

    @Override
    @Nullable
    public String getRequiredConnectorGroupsServerFilter() {
        return this.requiredConnectorGroupsCustomServerFilter;
    }

    public void setRequiredConnectorGroupsServerFilter(String requiredConnectorGroupsServerFilter) {
        this.requiredConnectorGroupsCustomServerFilter = requiredConnectorGroupsServerFilter;
    }

    public void setRequiredConnectorGroups(List<String> requiredConnectorGroups) {
        this.requiredConnectorGroups = requiredConnectorGroups == null ? Collections.emptyList() : requiredConnectorGroups;
    }

    @Override
    public boolean isOverrideReadOnlyDirectoryCheck() {
        return this.overrideReadOnlyDirectoryCheck;
    }

    public void setOverrideReadOnlyDirectoryCheck(boolean overrideReadOnlyDirectoryCheck) {
        this.overrideReadOnlyDirectoryCheck = overrideReadOnlyDirectoryCheck;
    }

    @Override
    @Nonnull
    public String getUniqueId() {
        return this.uniqueId;
    }

    @Override
    @Nonnull
    public String getName() {
        return this.name;
    }

    @Override
    public long getDirectoryId() {
        return this.directoryId;
    }

    @Override
    @Nonnull
    public List<AttributeTransformationConfig> getAttributeTransformationConfigs() {
        return this.attributeTransformationConfigs;
    }

    @Override
    @Nonnull
    public CleanupBehaviour getCleanupBehaviour() {
        return this.cleanupBehaviour;
    }

    @Override
    @Nonnull
    public String getCronExpression() {
        return this.cronExpression;
    }

    @Override
    public boolean isScheduled() {
        return this.scheduled;
    }

    @Override
    @Nonnull
    public AtlasUserAdapter.CopyBehaviour getCopyBehaviour() {
        return this.copyBehaviour;
    }

    @Override
    @Nonnull
    public String getFindByAttributeName() {
        return this.findByAttributeName;
    }

    @Override
    public boolean isDropUnmatchedGroups() {
        return this.dropUnmatchedGroups;
    }

    @Override
    @Nonnull
    public List<String> getRequiredGroups() {
        return this.requiredGroups;
    }

    @Override
    @Nonnull
    public List<String> getGroupsToAssignAlways() {
        return this.groupsToAssignAlways;
    }

    @Override
    @Nonnull
    public List<String> getGroupsToAssignNever() {
        return this.groupsToAssignNever;
    }

    @Override
    @Nonnull
    public List<String> getGroupsToAssignFilter() {
        return this.groupsToAssignFilter;
    }

    @Override
    @Nonnull
    public List<String> getGroupsToKeep() {
        return this.groupsToKeep;
    }

    @Override
    public int getVersion() {
        return this.version;
    }

    @Override
    public int getInitialVersion() {
        return this.initialVersion;
    }

    @Override
    public int getResultsToKeep() {
        return this.resultsToKeep;
    }

    public void setResultsToKeep(int resultsToKeep) {
        this.resultsToKeep = resultsToKeep;
    }

    @Override
    public boolean isSyncEnabled() {
        return this.syncEnabled;
    }

    public void setSyncEnabled(boolean syncEnabled) {
        this.syncEnabled = syncEnabled;
    }

    @Override
    public boolean isDisableNotFoundUser() {
        return this.disableNotFoundUser;
    }

    public void setDisableNotFoundUser(boolean disableNotFoundUser) {
        this.disableNotFoundUser = disableNotFoundUser;
    }

    @Override
    public AttributeTransformationConfig getDisableNotFoundLookupTransformation() {
        return this.disableNotFoundUserLookupTransformation;
    }

    public void setDisableNotFoundLookupTransformation(@Nonnull AttributeTransformationConfig disableNotFoundUserLookupTransformation) {
        this.disableNotFoundUserLookupTransformation = disableNotFoundUserLookupTransformation;
    }

    @Override
    @Nonnull
    public String getDisableNotFoundUserLookupAttribute() {
        return this.disableNotFoundUserLookupAttribute;
    }

    public void setDisableNotFoundUserLookupAttribute(@Nonnull String disableNotFoundUserLookupAttribute) {
        this.disableNotFoundUserLookupAttribute = disableNotFoundUserLookupAttribute;
    }

    @Override
    public boolean isIgnoreRequiredConnectorGroupsOnSingleUserSync() {
        return this.ignoreRequiredConnectorGroupsOnSingleUserSync;
    }

    public void setIgnoreRequiredConnectorGroupsOnSingleUserSync(boolean ignoreRequiredConnectorGroupsOnSingleUserSync) {
        this.ignoreRequiredConnectorGroupsOnSingleUserSync = ignoreRequiredConnectorGroupsOnSingleUserSync;
    }

    @Override
    public boolean isUseGroovyCleanupDecider() {
        return this.useGroovyCleanupDecider;
    }

    public void setUseGroovyCleanupDecider(boolean useGroovyCleanupDecider) {
        this.useGroovyCleanupDecider = useGroovyCleanupDecider;
    }

    @Override
    public boolean isRemoveAllGroupAssignmentsOnCleanup() {
        return this.removeAllGroupAssignmentsOnCleanup;
    }

    @Override
    public List<String> getGroupsOrRegexNotBeRemoved() {
        return this.groupsOrRegexNotBeRemoved;
    }

    public void setGroupsOrRegexNotBeRemoved(List<String> groupsOrRegexNotBeRemoved) {
        this.groupsOrRegexNotBeRemoved = groupsOrRegexNotBeRemoved;
    }

    @Override
    public void setRemoveAllGroupAssignmentsOnCleanup(boolean removeAllGroupAssignmentsOnCleanup) {
        this.removeAllGroupAssignmentsOnCleanup = removeAllGroupAssignmentsOnCleanup;
    }

    @Override
    @Nullable
    public String getGroovyCleanupDeciderCode() {
        return this.groovyCleanupDeciderCode;
    }

    public void setGroovyCleanupDeciderCode(String groovyCleanupDeciderCode) {
        this.groovyCleanupDeciderCode = groovyCleanupDeciderCode;
    }

    @Override
    public boolean isTrackMemoryUsage() {
        return this.trackMemoryUsage;
    }

    public void setTrackMemoryUsage(boolean trackMemoryUsage) {
        this.trackMemoryUsage = trackMemoryUsage;
    }

    @Override
    public int getSlowdownDelayInMs() {
        return this.slowdownDelayInMs;
    }

    public void setSlowdownDelayInMs(int slowdownDelayInMs) {
        this.slowdownDelayInMs = slowdownDelayInMs;
    }

    @Override
    @Nonnull
    public PrivilegeCheckerImpl.Role getSyncSingleUserRestPermission() {
        return this.syncSingleUserRestPermission;
    }

    public void setSyncSingleUserRestPermission(@Nonnull PrivilegeCheckerImpl.Role syncSingleUserRestPermission) {
        this.syncSingleUserRestPermission = syncSingleUserRestPermission;
    }
}

