/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.usersync.rest.entities;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import de.resolution.commons.task.api.Task;
import de.resolution.usersync.api.ConnectorSupportInformation;
import de.resolution.usersync.api.SyncStatus;
import de.resolution.usersync.api.SyncUserResult;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Collection;
import java.util.List;

@JsonAutoDetect
@JsonPropertyOrder(value={"status", "statusMessage", "result", "addedCount", "resultCount", "notModifiedCount", "failedCount", "updatedCount", "deletedCount", "filteredCount", "messages", "clusterNode", "connectorUID", "lastModified", "created", "duration", "id", "resultMessage", "resultFilePath", "syncUserResults", "connectorSupportInformation"})
public class SyncStatusEntity {
    private final SyncStatus syncStatus;
    private Collection<SyncUserResult> syncUserResults = null;
    @Nullable
    private String resultMessage = null;
    @Nullable
    private ConnectorSupportInformation connectorSupportInformation = null;

    public SyncStatusEntity(SyncStatus syncStatus) {
        this.syncStatus = syncStatus;
    }

    public SyncStatusEntity(@Nonnull SyncStatus syncStatus, @Nonnull Collection<SyncUserResult> syncUserResults, @Nullable String resultMessage) {
        this.syncStatus = syncStatus;
        this.syncUserResults = syncUserResults;
        this.resultMessage = resultMessage;
    }

    public SyncStatusEntity(@Nonnull SyncStatus syncStatus, @Nonnull Collection<SyncUserResult> syncUserResults, @Nullable String resultMessage, @Nullable ConnectorSupportInformation supportInformation) {
        this(syncStatus, syncUserResults, resultMessage);
        this.connectorSupportInformation = supportInformation;
    }

    @Nonnull
    public Task.Status getStatus() {
        return this.syncStatus.getStatus();
    }

    public SyncStatus.Result getSyncStatusResult() {
        return this.syncStatus.getSyncStatusResult();
    }

    public List<String> getMessages() {
        return this.syncStatus.getMessages();
    }

    public String getConnectorUID() {
        return this.syncStatus.getConnectorUID();
    }

    public int getId() {
        return this.syncStatus.getId();
    }

    public String getClusterNode() {
        return this.syncStatus.getClusterNode();
    }

    public int getAddedCount() {
        return this.syncStatus.getAddedCount();
    }

    public int getUpdatedCount() {
        return this.syncStatus.getUpdatedCount();
    }

    public int getDeletedCount() {
        return this.syncStatus.getDeletedCount();
    }

    public int getFilteredCount() {
        return this.syncStatus.getFilteredCount();
    }

    public int getNotModifiedCount() {
        return this.syncStatus.getNotModifiedCount();
    }

    public int getFailedCount() {
        return this.syncStatus.getFailedCount();
    }

    public String getCreated() {
        return this.syncStatus.getCreated();
    }

    public String getLastModified() {
        return this.syncStatus.getLastModified();
    }

    public long getDuration() {
        return this.syncStatus.getDuration();
    }

    public int getResultCount() {
        return this.syncStatus.getResultCount();
    }

    public Collection<SyncUserResult> getSyncUserResults() {
        return this.syncUserResults;
    }

    @Nullable
    public String getResultMessage() {
        return this.resultMessage;
    }

    public String getResultFilePath() {
        return this.syncStatus.getResultFilePath();
    }

    public String getSyncStatusMessage() {
        return this.syncStatus.getStatusMessage();
    }

    public boolean isSimulate() {
        return this.syncStatus.isSimulate();
    }

    public boolean isScheduled() {
        return this.syncStatus.isScheduled();
    }

    @Nullable
    public ConnectorSupportInformation getConnectorSupportInformation() {
        return this.connectorSupportInformation;
    }

    @JsonProperty(value="_self")
    public String getSelfLink() {
        return "/syncstatus/" + this.getId();
    }
}

