/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.usersync.rest.entities;

import com.fasterxml.jackson.annotation.JsonProperty;
import de.resolution.atlasuser.api.user.AtlasUserResult;
import de.resolution.commons.util.CollectionUtil;
import de.resolution.commons.util.StringUtil;
import de.resolution.usersync.util.KeyValue;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class SyncStatusDiffResultEntity {
    private final List<DiffEntry> diff;
    private final List<KeyValue> resultingUser;
    private final List<KeyValue> initialUser;
    private final List<KeyValue> inputUser;
    private final String messages;
    private final AtlasUserResult.ErrorType errorType;

    public SyncStatusDiffResultEntity(@Nullable List<DiffEntry> diff, @Nullable List<KeyValue> resultingUser, @Nullable List<KeyValue> initialUser, @Nullable List<KeyValue> inputUser, @Nullable String messages, @Nullable AtlasUserResult.ErrorType errorType) {
        this.diff = CollectionUtil.isNullOrEmpty(diff) ? Collections.emptyList() : diff;
        this.resultingUser = CollectionUtil.isNullOrEmpty(resultingUser) ? Collections.emptyList() : resultingUser;
        this.initialUser = CollectionUtil.isNullOrEmpty(initialUser) ? Collections.emptyList() : initialUser;
        this.inputUser = CollectionUtil.isNullOrEmpty(inputUser) ? Collections.emptyList() : inputUser;
        this.messages = StringUtil.isNullOrEmpty((String)messages) ? "" : messages;
        this.errorType = errorType != null ? errorType : AtlasUserResult.ErrorType.NONE;
    }

    @JsonProperty(value="diff")
    @Nonnull
    public List<DiffEntry> getDiff() {
        return this.diff;
    }

    @JsonProperty(value="resultingUser")
    @Nonnull
    public List<KeyValue> getResultingUser() {
        return this.resultingUser;
    }

    @JsonProperty(value="initialUser")
    @Nonnull
    public List<KeyValue> getInitialUser() {
        return this.initialUser;
    }

    @JsonProperty(value="inputUser")
    @Nonnull
    public List<KeyValue> getInputUser() {
        return this.inputUser;
    }

    @JsonProperty(value="messages")
    public String getMessages() {
        return this.messages;
    }

    @JsonProperty(value="errorType")
    public AtlasUserResult.ErrorType getErrorType() {
        return this.errorType;
    }

    public static class DiffEntry {
        private final String key;
        private final String old;
        private final String newValue;
        private final String operation;
        private final String style;
        private final boolean isMultiValue;
        private final String addedValues;
        private final String removedValues;
        private final String unchangedValues;
        private final String downloadResults;

        public DiffEntry(@Nonnull String key, @Nonnull String old, @Nonnull String newValue, @Nonnull String operation, @Nonnull String style, boolean isMultiValue, @Nonnull String addedValues, @Nonnull String removedValues, @Nonnull String unchangedValues, @Nonnull String downloadResults) {
            this.key = key;
            this.old = old;
            this.newValue = newValue;
            this.operation = operation;
            this.style = style;
            this.isMultiValue = isMultiValue;
            this.addedValues = addedValues;
            this.removedValues = removedValues;
            this.unchangedValues = unchangedValues;
            this.downloadResults = downloadResults;
        }

        @JsonProperty(value="key")
        @Nonnull
        public String getKey() {
            return this.key;
        }

        @JsonProperty(value="old")
        @Nonnull
        public String getOld() {
            return this.old;
        }

        @JsonProperty(value="new")
        @Nonnull
        public String getNewValue() {
            return this.newValue;
        }

        @JsonProperty(value="op")
        @Nonnull
        public String getOperation() {
            return this.operation;
        }

        @JsonProperty(value="style")
        @Nonnull
        public String getStyle() {
            return this.style;
        }

        @JsonProperty(value="isMultiValue")
        public boolean isMultiValue() {
            return this.isMultiValue;
        }

        @JsonProperty(value="addedValues")
        @Nonnull
        public String getAddedValues() {
            return this.addedValues;
        }

        @JsonProperty(value="removedValues")
        @Nonnull
        public String getRemovedValues() {
            return this.removedValues;
        }

        @JsonProperty(value="unchangedValues")
        @Nonnull
        public String getUnchangedValues() {
            return this.unchangedValues;
        }

        @JsonProperty(value="downloadResults")
        @Nonnull
        public String getDownloadResults() {
            return this.downloadResults;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DiffEntry diffEntry = (DiffEntry)o;
            return this.isMultiValue == diffEntry.isMultiValue && Objects.equals(this.key, diffEntry.key) && Objects.equals(this.old, diffEntry.old) && Objects.equals(this.newValue, diffEntry.newValue) && Objects.equals(this.operation, diffEntry.operation) && Objects.equals(this.style, diffEntry.style) && Objects.equals(this.addedValues, diffEntry.addedValues) && Objects.equals(this.removedValues, diffEntry.removedValues) && Objects.equals(this.unchangedValues, diffEntry.unchangedValues) && Objects.equals(this.downloadResults, diffEntry.downloadResults);
        }

        public int hashCode() {
            return Objects.hash(this.key, this.old, this.newValue, this.operation, this.style, this.isMultiValue, this.addedValues, this.removedValues, this.unchangedValues, this.downloadResults);
        }
    }
}

